local assets=
{
	Asset("ANIM", "anim/hkdart.zip"),
	Asset("ANIM", "anim/swap_hkdart_pipe.zip"),
	Asset("ATLAS", "images/inventoryimages/hkdart.xml")
}

local prefabs = 
{
    "impact",
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_hkdart_pipe", "swap_blowdart_pipe")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_object")
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function ReturnToOwner(inst, owner)
    if owner then
		if owner.components.inventory then
            if inst.components.equippable and not owner.components.inventory:GetEquippedItem(inst.components.equippable.equipslot) then
				owner.components.inventory:Equip(inst)
			else
				owner.components.inventory:GiveItem(inst)
			end
		end
    end
end

local function onhit(inst, owner)
    local impactfx = SpawnPrefab("impact") 
	if owner and not (inst.components.finiteuses and inst.components.finiteuses:GetUses() < 1) then
    ReturnToOwner(inst, owner)
	end
	--if impactfx and attacker then
	    --local follower = impactfx.entity:AddFollower()
	    --follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        --impactfx:FacePoint(attacker.Transform:GetWorldPosition())
    --end
end

local function onthrown(inst, data)
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
end

local function common()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("blow_dart")
    anim:SetBuild("hkdart")
    
    inst:AddTag("blowdart")
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetRange(15, 20)
    
    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(80)
    inst.components.projectile:SetOnHitFn(onhit)
    inst:ListenForEvent("onthrown", onthrown)
    -------
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/hkdart.xml"
	
	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(3)
    inst.components.finiteuses:SetUses(3)
	 inst.components.finiteuses:SetOnFinished( onfinished )
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    inst.components.equippable.equipstack = true
    
    return inst
end

local function pipeequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_hkdart_pipe", "swap_blowdart_pipe")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
end

local function pipethrown(inst, owner)
    inst.AnimState:PlayAnimation("dart_pipe")
	owner.components.sanity:DoDelta(-7)
end

local function pipe()
    local inst = common()

    inst.AnimState:PlayAnimation("idle_pipe")

    inst.components.equippable:SetOnEquip(pipeequip)
    inst.components.weapon:SetDamage(TUNING.PIPE_DART_DAMAGE*1.5)
    inst.components.projectile:SetOnThrownFn(pipethrown)
    
    return inst
end

return Prefab( "common/inventory/hkdart", pipe, assets, prefabs)