/*
 * Decompiled with CFR 0.152.
 */
package de.vernideas.mc.common.ai;

import de.vernideas.mc.common.ai.StorableAI;
import de.vernideas.mc.common.util.TimePeriod;
import java.util.UUID;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;

public class GuardAI
extends EntityAIBase
implements StorableAI {
    private AttributeModifier goingHome = null;
    private final EntityLiving entity;
    private final ChunkCoordinates pos;
    private final float roamDist;
    private final double roamDistSq;
    private final float pathSearchDist;
    private final double pathSearchDistSq;
    private final TimePeriod guardPeriod;
    private final boolean shouldExitTransport;
    public GuardState state;
    public int cooldownTicks;

    public static GuardAI createFromNBT(EntityLiving living, NBTTagCompound data) {
        int posX = data.func_74762_e("PosX");
        int posY = data.func_74762_e("PosY");
        int posZ = data.func_74762_e("PosZ");
        int startTime = data.func_74762_e("GuardStartTime");
        int endTime = data.func_74762_e("GuardEndTime");
        GuardAI ai = new GuardAI(living, new ChunkCoordinates(posX, posY, posZ), data.func_74760_g("RoamDist"), data.func_74760_g("PathSearchDist"), new TimePeriod(startTime, endTime), data.func_74767_n("ShouldExitTransport"));
        try {
            ai.state = GuardState.valueOf(data.func_74779_i("State"));
        }
        catch (Exception e) {
            ai.state = GuardState.IDLE;
        }
        ai.cooldownTicks = data.func_74762_e("CooldownTicks");
        return ai;
    }

    public GuardAI(EntityLiving owner, ChunkCoordinates position, float roamingDistance, float pathSearchDistance, TimePeriod guardingPeriod, boolean leaveTransports) {
        if (null == owner) {
            throw new IllegalArgumentException("Missing required argument: entity");
        }
        this.entity = owner;
        this.pos = null == position ? new ChunkCoordinates(MathHelper.func_76128_c((double)(this.entity.field_70165_t + 0.5)), MathHelper.func_76128_c((double)this.entity.field_70163_u), MathHelper.func_76128_c((double)(this.entity.field_70161_v + 0.5))) : position;
        this.roamDist = Math.max(roamingDistance, 1.0f);
        this.roamDistSq = (double)this.roamDist * (double)this.roamDist;
        this.pathSearchDist = Math.max(pathSearchDistance, roamingDistance + 1.0f);
        this.pathSearchDistSq = (double)this.pathSearchDist * (double)this.pathSearchDist;
        this.guardPeriod = null == guardingPeriod ? TimePeriod.fullDay : guardingPeriod;
        this.shouldExitTransport = leaveTransports;
        this.state = GuardState.IDLE;
        this.cooldownTicks = 0;
        this.func_75248_a(3);
        this.goingHome = new AttributeModifier(UUID.fromString("4454b0d8-75ef-4689-8fce-daab60a7e1b0"), "Vernideas:GoingHome", (double)pathSearchDistance / 16.0 - 1.0, 2);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("PosX", this.pos.field_71574_a);
        data.func_74768_a("PosY", this.pos.field_71572_b);
        data.func_74768_a("PosZ", this.pos.field_71573_c);
        data.func_74776_a("RoamDist", this.roamDist);
        data.func_74776_a("PathSearchDist", this.pathSearchDist);
        data.func_74768_a("GuardStartTime", this.guardPeriod.startTick);
        data.func_74768_a("GuardEndTime", this.guardPeriod.endTick);
        data.func_74757_a("ShouldExitTransport", this.shouldExitTransport);
        data.func_74778_a("State", this.state.name());
        data.func_74768_a("CooldownTicks", this.cooldownTicks);
    }

    public boolean func_75250_a() {
        if (null == this.entity || this.entity.field_70128_L) {
            return false;
        }
        if (this.entity instanceof EntityAgeable && ((EntityAgeable)this.entity).func_70874_b() < 0) {
            return false;
        }
        if (this.guardPeriod != TimePeriod.fullDay && !this.guardPeriod.contains((int)(this.entity.field_70170_p.func_72820_D() % 24000L))) {
            return false;
        }
        if (null != this.entity.field_70154_o && !this.shouldExitTransport) {
            return false;
        }
        double distanceToGuardPointSq = this.entity.func_70092_e((double)this.pos.field_71574_a + 0.5, (double)this.pos.field_71572_b, (double)this.pos.field_71573_c + 0.5);
        return distanceToGuardPointSq > this.roamDistSq && distanceToGuardPointSq <= this.pathSearchDistSq;
    }

    public void func_75249_e() {
        this.state = GuardState.RUNNING;
        this.entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111124_b(this.goingHome);
        this.entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(this.goingHome);
        double speed = this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        this.entity.func_70661_as().func_75492_a((double)this.pos.field_71574_a + 0.5, (double)this.pos.field_71572_b, (double)this.pos.field_71573_c + 0.5, speed);
    }

    public boolean func_75253_b() {
        switch (this.state) {
            case RUNNING: {
                if (this.entity.func_70661_as().func_75500_f() || this.entity.func_70092_e((double)this.pos.field_71574_a + 0.5, (double)this.pos.field_71572_b, (double)this.pos.field_71573_c + 0.5) < this.roamDistSq / 2.0) {
                    this.state = GuardState.COOLDOWN;
                    return true;
                }
            }
            case COOLDOWN: {
                if (this.cooldownTicks < 300) {
                    ++this.cooldownTicks;
                    return true;
                }
                this.cooldownTicks = 0;
                this.state = GuardState.IDLE;
                return false;
            }
        }
        return false;
    }

    public void func_75246_d() {
        super.func_75246_d();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.state = GuardState.IDLE;
        this.entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111124_b(this.goingHome);
    }

    static enum GuardState {
        IDLE,
        RUNNING,
        COOLDOWN;

    }
}

