/*
 * Decompiled with CFR 0.152.
 */
package de.vernideas.mc.common.ai;

import de.vernideas.mc.common.ai.StorableAI;
import de.vernideas.mc.common.ai.StorableAIBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;

public final class StorableAIRegistry {
    private static final Map<String, StorableAIBuilder<?>> builderMap = new HashMap();
    private static final Map<Class<?>, StorableAIBuilder<?>> classMap = new HashMap();
    private static final StorableAIBuilder nullBuilder = new NullAIBuilder();

    public static <T extends EntityAIBase> void registerBuilder(StorableAIBuilder<T> builder) {
        builderMap.put(builder.getRoutineName(), builder);
        classMap.put(builder.getType(), builder);
    }

    public static <T extends EntityAIBase> StorableAIBuilder<T> getBuilder(String id) {
        StorableAIBuilder<?> builder = builderMap.get(id);
        return null == builder ? nullBuilder : builder;
    }

    public static <T extends EntityAIBase> StorableAIBuilder<T> getBuilder(Class<T> clazz) {
        StorableAIBuilder<?> builder = classMap.get(clazz);
        return null == builder ? nullBuilder : builder;
    }

    public static <T extends EntityAIBase> StorableAIBuilder<T> getBuilder(T classInstance) {
        StorableAIBuilder<?> builder = classMap.get(classInstance.getClass());
        return null == builder ? nullBuilder : builder;
    }

    private static class NullAIBuilder
    implements StorableAIBuilder<NullAI> {
        private NullAIBuilder() {
        }

        @Override
        public NullAI createFromNBT(EntityLiving living, NBTTagCompound data) {
            return null;
        }

        @Override
        public Class<NullAI> getType() {
            return NullAI.class;
        }

        @Override
        public String getRoutineName() {
            return "Vernideas:NULL";
        }
    }

    private static class NullAI
    extends EntityAIBase
    implements StorableAI {
        private NullAI() {
        }

        @Override
        public void writeToNBT(NBTTagCompound data) {
        }

        public boolean func_75250_a() {
            return false;
        }
    }
}

