﻿CooWorkApp.directive('datepick', ['cooConfig', 'g', function (cooConfig, g) {
    return function (scope, element, attributes) {
        element = $(element[0]); // Get the element as a jQuery element    

        element.datePicker({ startDate: '1996-01-01' });
        
    }
}]);



CooWorkApp.directive('editorc', ['cooConfig', 'g', function (cooConfig, g) {
    return function (scope, element, attributes) {
        element = $(element[0]); // Get the element as a jQuery element
        element.jqte();

    }
}]);



CooWorkApp.directive('editor', ['cooConfig', 'g', function (cooConfig, g) {
    return {
        require: "ngModel",
        link: function (scope, element, attr, ngModel) {

            scope.$watch(function () {
                return ngModel.$modelValue;
            }, function (modelValue) {               

                element = $(element[0]);
                element.jqte();
                element.jqteVal(modelValue);
            });
        }
    }
}]);



CooWorkApp.directive('attachment', ['cooConfig', 'g', function (cooConfig, g) {
    return {
        require: "ngModel",
        link: function (scope, element, attr, ngModel) {

            scope.$watch(function () {
                return ngModel.$modelValue;
            }, function (modelValue) {
                element = $(element[0]);                

                g.dragFile(modelValue.p.ID, scope.indexId, modelValue.p.categoryId);               
            });
        }
    }
}]);


CooWorkApp.directive('attachmentdata', ['cooConfig', 'g','rest', function (cooConfig, g,rest) {
    return function (scope, element, attributes) {
        element = $(element[0]); // Get the element as a jQuery element

        var fs = require('fs');
        var rq = require('request');

        var pageId = attributes.pageid;
        var categoryId = attributes.categoryid;


        var holder = element[0];// document.getElementById("__img0");
        holder.ondragover = function () { $("#__img0").addClass("draghover"); return false; };
        holder.ondragend = function () { $("#__img0").removeClass("draghover"); return false; };
        holder.ondrop = function (e) {
            e.preventDefault();

            var cElements = g.userPatternFilterByPage(pageId);

            if (cElements.length == 0) cElements = g.patternFilterByPage(pageId);


            if (e.dataTransfer.files.length > 0) {
                var formData = {
                    // Pass a simple key-value pair
                    key: cooConfig.configObj.uploadKey,
                    itemId: 0,
                    cateId: categoryId,
                    // Pass data via Streams
                    my_file: fs.createReadStream(e.dataTransfer.files[0].path)
                    // Pass multiple values /w an Array              
                };





                $.when(g.postFile(formData)).done(function (obj) {

                    console.log(obj);
                    var etor = {
                        cateId: categoryId,
                        pageId: pageId,
                        aid: obj.ID
                    };

                    $.when(rest.import(etor)).done(function (data) {

                        console.log(data);
                        $("#importb tr:nth-child(n+2)").remove();

                        $(data).each(function (i, item) {
                            var tr = '<tr>';
                            tr += '<td> <input  type="checkbox"  name="mainCheckBox"></td>';
                            $(cElements).each(function (j, p) {

                                var v = item['__c' + p.ID] == undefined ? "" : item['__c' + p.ID];

                                tr += '<td ><div contenteditable="true" name="__c' + p.ID + '" >' + v + '</div></td>';

                            });

                            tr += '</tr>';
                            $("#importb").append(tr);
                        });


                        scope.$apply();
                    });
                });
            }
        };



    }
}]);




CooWorkApp.directive('attachments', ['cooConfig', 'g', function (cooConfig, g) {
    return {
        require: "ngModel",
        link: function (scope, element, attr, ngModel) {
            scope.$watch(function () {
                return ngModel.$modelValue;
            }, function (modelValue) {
                element = $(element[0]);

                g.multiDragFile(modelValue.p.ID, scope.indexId, modelValue.p.categoryId);
            });
        }
    }
}]);







CooWorkApp.directive('multiselectdropdown', ['cooConfig', 'g','rest', function (cooConfig, g,rest) {
    return function (scope, element, attributes) {

        element = $(element[0]); // Get the element as a jQuery element

        // Below setup the dropdown:

        var source = [];
        var sls = [];
        var tid = attributes.name;
        var type = attributes.type;

   

        switch (type)
        {
            case '_sys_group':
                var gid = attributes.pageid;
                var gpat = g.patternFilterByPage(gid);
                $.each(gpat, function (index, item) {
                    var o = { label: '请选择', value: '' };

                    var o1 = { label: '请选择', value: '' };
                    var o2 = { label: '请选择', value: '' };
                    var o3 = { label: '请选择', value: '' };
                    var o4 = { label: '请选择', value: '' };
                    var o5 = { label: '请选择', value: '' };
                    switch (item.pTypeId) {
                        case 2:
                        case 5:
                        case 12:
                        case 13:
                            o.label = item.pName;
                            o.value = item.ID;
                            sls.push(o);
                            break;
                        case 6:
                            o1.label = item.pName + '(年)';
                            o1.value = item.ID + '_1';
                            sls.push(o1);
                            o2.label = item.pName + '(季)';
                            o2.value = item.ID + '_2';
                            sls.push(o2);
                            o3.label = item.pName + '(月)';
                            o3.value = item.ID + '_3';
                            sls.push(o3);
                            o4.label = item.pName + '(周)';
                            o4.value = item.ID + '_4';
                            sls.push(o4);
                            o5.label = item.pName + '(日)';
                            o5.value = item.ID + '_5';
                            sls.push(o5);                                    
                            break;
               
                    }             
                });
                break;
           
            case '_sys_order':
                var oid = attributes.pageid;
                var opat = g.patternFilterByPage(oid);
                sls.push({ label: '请选择', value: '' });
                $.each(opat, function (index, item) {
                    var o = { label: '请选择', value: '' };
                    var o1 = { label: '请选择', value: '' };
                    var o2 = { label: '请选择', value: '' };
                    var o3 = { label: '请选择', value: '' };
                    var o4 = { label: '请选择', value: '' };
                    var o5 = { label: '请选择', value: '' };
                    switch (item.pTypeId) {
                        case 2:
                        case 3:
                        case 4:
                        case 5:
                        case 12:
                        case 13:
                            o.label = item.pName;
                            o.value = item.ID;
                            sls.push(o);
                            break;
                        case 6:
                            o1.label = item.pName + '(年)';
                            o1.value = item.ID + '_1';
                            sls.push(o1);
                            o2.label = item.pName + '(季)';
                            o2.value = item.ID + '_2';
                            sls.push(o2);
                            o3.label = item.pName + '(月)';
                            o3.value = item.ID + '_3';
                            sls.push(o3);
                            o4.label = item.pName + '(周)';
                            o4.value = item.ID + '_4';
                            sls.push(o4);
                            o5.label = item.pName + '(日)';
                            o5.value = item.ID + '_5';
                            sls.push(o5);
                            break;      

                    }
                });
                break;
            case '_sys_calculate':
                var cid = attributes.pageid;
                var cpat = g.patternFilterByPage(cid);
                $.each(cpat, function (index, item) {
                    var o = { label: '请选择', value: '' };
                    switch (item.pTypeId) {                        
                        case 3:
                        case 4:
                            o.label = item.pName;
                            o.value = item.ID;
                            sls.push(o);
                            break;
                    }
                });
                break;
            case 'order':
                var pageId = attributes.pageid;
                var p12 = g.pageFilter(12, pageId);
                if (p12.length > 0) {
                    var patternSort = g.patternFilterByPage(p12[0].ID);

                    var o = { label: '请选择', value: '' };
                    sls.push(o);

                    $(patternSort).each(function (j, m) {

                        var op = { label: 'u>' + m.pName, value: '__c' + m.ID + 'x1' };
                        var op2 = { label: 'd>' + m.pName, value: '__c' + m.ID + 'x2' };
                        sls.push(op);
                        sls.push(op2);
                    });
                }
                break;     
            case 'user':

                tid = tid.replace(/\D/ig, '');
                source = g.statusFilterByPattern(tid);
                if (source.length > 0) {
                    var users = g.userFilterByRoleId(source[0].statusName);

                    $(users).each(function (i, item) {
                        var op = { label: item.XingMing, value: item.UserId };
                        sls.push(op);
                    });
                }

                break;
            case 'data':
                tid = tid.replace(/\D/ig, '');
                source = g.statusFilterByPattern(tid);

                $(source).each(function (i, item) {
                    var op = { label: item.statusName, value: item.ID };
                    sls.push(op);
                });
            case 'element':          
                tid = tid.replace(/\D/ig, '');
                source = g.userPatternFilterByPage(tid);
                $(source).each(function (i, item) {
                    var op = { label: item.pName, value: item.ID };
                    sls.push(op);
                });
            
                break;
            case 'element2':
                tid = tid.replace(/\D/ig, '');
                source = g.patternFilterByPage(tid);
                $(source).each(function (i, item) {
                    var op = { label: item.pName, value: item.ID };
                    sls.push(op);
                });

                break;

        } ;

     

        element.multiselect({
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true
        });

        if (sls.length>0)   element.multiselect('dataprovider', sls);

        if (attributes.val)
        {
            var vv = attributes.val.split(',');
         
            element.multiselect('select', vv);
        }


    }

}]);
