CooWorkApp.config(function ($routeProvider,$controllerProvider,cooConfig) {

    CooWorkApp.registerCtrl = $controllerProvider.register;


    $routeProvider
        .when('/', {
            templateUrl: 'tmpl/center.html',
            controller: 'centerController',
            resolve: {
                CooWorkApp: function ($q, $timeout, $http, $location, $rootScope, cooConfig) {
                    // Initialize a new promise
                    var deferred = $q.defer();
                    // Make an AJAX call to check if the user is logged in
                    // Authenticated
                    if (cooConfig.configObj.isLogin||cooConfig.configObj.isAutoLogin) {                   
                        $timeout(deferred.resolve, 0);
                    }
                        // Not Authenticated
                    else {
                        $rootScope.message = 'You need to log in.';
                        $timeout(function () { deferred.reject(); }, 0);
                        $location.url('/login');
                    }
                    return deferred.promise;
                }
            }
        }).when('/movie/:id', {
            templateUrl: 'tmpl/movie.html',
            controller: 'movieDetailsController'
        }).when('/login', {
            templateUrl: 'tmpl/login.html',
            controller: 'rController'        
        })
        .when('/password', {
            templateUrl: 'tmpl/password.html',
            controller: 'passwordController'
        })

        .when('/center', {
            templateUrl: 'tmpl/center.html',
            controller: 'centerController'
        }).when('/list/:categoryId/page/:pageId', {
            templateUrl: 'tmpl/list.html',
            controller: 'listController'
        }).when('/list/:categoryId/page_:pageId', {
            templateUrl: function (urlattr) {
                return 'custom/' + cooConfig.configObj.companyId + '/list_' + urlattr.pageId + '.html';
            }
        }).when('/create/:categoryId/page/:pageId', {
            templateUrl: 'tmpl/create.html',
            controller: 'createController'
        }).when('/create/:categoryId/page_:pageId', {
            templateUrl: function (urlattr) {
                return 'custom/' + cooConfig.configObj.companyId + '/create_' + urlattr.pageId + '.html';
            }
        }).when('/complexcreate/:categoryId/page/:pageId', {
            templateUrl: 'tmpl/complexcreate.html',
            controller: 'complexcreateController'
        }).when('/complexcreate/:categoryId/page_:pageId', {
            templateUrl: function (urlattr) {
                return 'custom/' + cooConfig.configObj.companyId + '/complexcreate_' + urlattr.pageId + '.html';
            }            
        }).when('/import/:categoryId/page/:pageId', {
            templateUrl: 'tmpl/import.html',
            controller: 'importController'
        }).when('/import/:categoryId/page_:pageId', {
            templateUrl: function (urlattr) {
                return 'custom/' + cooConfig.configObj.companyId + '/import_' + urlattr.pageId + '.html';
            }   
        }).when('/report/:categoryId/page/:pageId', {
            templateUrl: 'tmpl/report.html',
            controller: 'reportController'
        })
        .when('/report/:categoryId/page_:pageId', {
            templateUrl: function (urlattr) {
                return 'custom/' + cooConfig.configObj.companyId + '/report_' + urlattr.pageId + '.html';
            }
        })
        .when('/edit/:categoryId/page/:pageId/i/:itemId', {
            templateUrl: 'tmpl/edit.html',
            controller: 'editController'
        })
        .when('/edit/:categoryId/page_:pageId/i/:itemId', {
            templateUrl: function (urlattr) {
                return 'custom/' + cooConfig.configObj.companyId + '/edit_' + urlattr.pageId + '.html';
            }
        })

        .when('/view/:categoryId/page/:pageId/i/:itemId', {
              templateUrl: 'tmpl/view.html',
              controller: 'editController'
          })
        .when('/view/:categoryId/page_:pageId/i/:itemId', {
            templateUrl: function (urlattr) {
                return 'custom/' + cooConfig.configObj.companyId + '/view_' + urlattr.pageId + '.html';
            }
        })


        .when('/bookings', {
            templateUrl: 'tmpl/bookings.html',
            controller: 'bookingDetailsController'
        }).when('/bookTickets/:id', {
            templateUrl: 'tmpl/bookTickets.html',
            controller: 'bookTicketsController'
        })



        .when('/admin/category', {
            templateUrl: 'tmpl/admin/category.html',
            controller: 'admincategory'
        })
        .when('/admin/categoryauth', {
            templateUrl: 'tmpl/admin/categoryauth.html',
            controller: 'admincategoryauth'
        })
         .when('/admin/pattern', {
             templateUrl: 'tmpl/admin/pattern.html',
             controller: 'adminpattern'
         })
        .when('/admin/pattern/:categoryId', {
            templateUrl: 'tmpl/admin/pattern.html',
            controller: 'adminpattern'
        })

        .when('/admin/auth', {
            templateUrl: 'tmpl/admin/auth.html',
            controller: 'adminauth'
        })
        .when('/admin/auth/:categoryId', {
            templateUrl: 'tmpl/admin/auth.html',
            controller: 'adminauth'
        })
         .when('/admin/columnauth', {
             templateUrl: 'tmpl/admin/columnauth.html',
             controller: 'admincolumnauth'
          })
        .when('/admin/columnauth/:categoryId', {
            templateUrl: 'tmpl/admin/columnauth.html',
            controller: 'admincolumnauth'
        })
        .when('/admin/page', {
            templateUrl: 'tmpl/admin/page.html',
            controller: 'adminpage'
        })
        .when('/admin/page/:categoryId', {
            templateUrl: 'tmpl/admin/page.html',
            controller: 'adminpage'
        })
         .when('/admin/pageauth', {
             templateUrl: 'tmpl/admin/pageauth.html',
             controller: 'adminpageauth'
         })
        .when('/admin/pageauth/:categoryId', {
            templateUrl: 'tmpl/admin/pageauth.html',
            controller: 'adminpageauth'
        })

        .when('/admin/element', {
            templateUrl: 'tmpl/admin/element.html',
            controller: 'adminelement'
         })
        .when('/admin/element/:categoryId/:pageId', {
            templateUrl: 'tmpl/admin/element.html',
            controller: 'adminelement'
        })
         .when('/admin/event', {
             templateUrl: 'tmpl/admin/event.html',
             controller: 'adminevent'
         })
        .when('/admin/event/:categoryId/:pageId', {
            templateUrl: 'tmpl/admin/event.html',
            controller: 'adminevent'
        })
        .when('/admin/status', {
            templateUrl: 'tmpl/admin/status.html',
            controller: 'adminstatus'
        })
         .when('/admin/status/:categoryId/:patternId', {
             templateUrl: 'tmpl/admin/status.html',
             controller: 'adminstatus'
         })
        .when('/admin/status/:categoryId/:patternId?parentId=:parentId', {
            templateUrl: 'tmpl/admin/status.html',
            controller: 'adminstatus'
        })
         .when('/admin/statusMap/:categoryId/:patternId', {
             templateUrl: 'tmpl/admin/statusMap.html',
             controller: 'adminstatusmap'
         })
        .when('/admin/statusMap', {
            templateUrl: 'tmpl/admin/statusMap.html',
            controller: 'adminstatusmap'
        })
        .when('/admin/tag', {
            templateUrl: 'tmpl/admin/tag.html',
            controller: 'admintag'
        })
        .when('/admin/tag/:categoryId', {
            templateUrl: 'tmpl/admin/tag.html',
            controller: 'admintag'
        })
        .when('/admin/role', {
            templateUrl: 'tmpl/admin/role.html',
            controller: 'adminrole'
        })
        .when('/admin/user', {
            templateUrl: 'tmpl/admin/user.html',
            controller: 'adminuser'
        })
        .when('/admin/template', {
             templateUrl: 'tmpl/admin/templatefile.html',
             controller: 'admintemplate'
        })
        .when('/admin/join', {
              templateUrl: 'tmpl/admin/join.html',
              controller: 'adminjoin'
          })
        .when('/admin/join/:categoryId', {
            templateUrl: 'tmpl/admin/join.html',
            controller: 'adminjoin'
        })

         .when('/admin/workflow', {
             templateUrl: 'tmpl/admin/workflow.html',
             controller: 'adminworkflow'
         })
        .when('/admin/workflow/:categoryId', {
            templateUrl: 'tmpl/admin/workflow.html',
            controller: 'adminworkflow'
        })

        .otherwise({
            redirectTo: '/'
        });
});


//categoryauth