﻿CooWorkApp.factory('rest', function (cooConfig,login,ngDialog) {

    var rest = {};

    function remoteAction(etor, url) {
        var dtd = $.Deferred();

        $("#ajax").html("<img src='css/ajax1.gif' />");

        $.ajax({
            url: cooConfig.configObj.url + url,
            type: "post",
            data: JSON.stringify(etor),
            dataType: "json",
            contentType: "application/json;charset=utf-8",
            success: function (data) {

                $("#ajax").html("");
                var reg = /true/ig;

                if (reg.test(data)) {
                    dtd.resolve(true);
                }
                else {
                    dtd.resolve(false);
                }
            },
            error: function (jqXHR, exception) {
                console.log(exception);
            }
        });

        return dtd.promise();

    }



    function remoteData(etor,url)
    {
        var dtd = $.Deferred();

        $.ajax({
            url: cooConfig.configObj.url + url,
            type: "post",
            data: JSON.stringify(etor),
            dataType: "json",
            contentType: "application/json;charset=utf-8",
            success: function (data) {


                dtd.resolve(data);
                // window.location.href = data;
                //window.open(data, '', '');

                //console.log(data);
                // $("#user").html(JSON.stringify(data));            

            },
            error: function (jqXHR, exception) {
                console.log(exception);
            }
        });
        return dtd.promise();
    }


    rest.import = function (etor) {
        return remoteData(etor, 'bulkcreate/node');
    };


    rest.setup = function (url) {
        return remoteAction('',url)
    };


    rest.uniqueCheck = function (etor) {

        var dtd = $.Deferred();

        var data = $.ajax({
            url: cooConfig.configObj.url + 'ajax/checkunique',
            type: "post",
            data: JSON.stringify(etor),
            dataType: "json",
            async: false,
            contentType: "application/json;charset=utf-8",

        }).responseText;       
 
        dtd.resolve(data);
        return dtd.promise();
    };

    rest.changePassword = function (etor) {
        return remoteData(etor, 'account/ChangePassword');
    };


    rest.print = function (etor) {
        return remoteData(etor, 'pview/print');
    };


    rest.edit = function (etor) {
        return remoteData(etor, 'e/editupdate');
    };

    rest.create = function (etor) {
        return remoteData(etor, 'e/createupdate');
    };

    rest.complexUpdate = function (etor) {
        return remoteAction(etor, 'e/complexupdate');
    };

    rest.bulkCreate = function (etor) {
        return remoteAction(etor, 'e/bulkcreate');
    };

    //admin/cacheupdate?key=WorkFlow

    rest.updateCache = function (etor) {
        return remoteAction(etor, 'admin/cacheupdate');
    };

    rest.export = function (etor) {
        return remoteData(etor, 'exportdata/nodeexcel');         
    };

    rest.datalog = function (etor) {
        return remoteData(etor, 'log/data');
    };

    rest.workflowlog = function (etor) {
        return remoteData(etor, 'log/workflow');
    };


    rest.report = function (etor) {
        return remoteData(etor, 'report/node');
    };

    rest.logOff = function () {
        return remoteData('', 'account/logOff');
    };



    rest.detail = function (pageId, itemId) {
        var dtd = $.Deferred();
        var etor =
         {
             pageId: pageId,
             itemId: itemId
         };

        return remoteData(etor, 'detail/ajx');
         
    };


    rest.delFile = function (cateId,attachmentId) {
        var etor = { cateId: cateId, attachmentId: attachmentId };

        return remoteAction(etor,'file/jdel');

    };



    rest.search = function (categoryId, pageId, searchConditions, indx, size) {

        var dtd = $.Deferred();
        var etor =
         {
             companyId: cooConfig.configObj.companyId,
             cid: categoryId,
             id: pageId,
             lsc: searchConditions,
             iindex: indx,
             isize: size
         };

        $.ajax({
            url: cooConfig.configObj.url + 'list/ajxlist',
            type: "post",
            data: JSON.stringify(etor),
            dataType: "json",
            contentType: "application/json;charset=utf-8",
            success: function (data) { 

                dtd.resolve(data);

            },
            error: function (jqXHR, exception) {
                console.log('search error ' + exception);
            }
        });

        return dtd.promise();
    }

    rest.updateWorkFlow = function (etor) {

        var dtd = $.Deferred();


        $("#ajax").html("<img src='css/ajax1.gif' />");

        $.ajax({
            url: cooConfig.configObj.url + 'list/updateworkflow',
            type: "post",
            data: JSON.stringify(etor),
            dataType: "json",
            contentType: "application/json;charset=utf-8",
            success: function (data) {

                $("#ajax").html("");
                var reg = /true/ig;    

                if (reg.test(data)) {
                    dtd.resolve(true);
                }
                else {
                    dtd.resolve(false);
                }
            },
            error: function (jqXHR, exception) {
                console.log(exception);
            }
        });

        return dtd.promise();

    };


    rest.updateStatus = function (etor) {
        return remoteAction(etor, 'list/updatestatus');         
    };
    
    rest.fakeDel = function (etor) {
        return remoteAction(etor, 'list/fakedel');

    };


    rest.adminDel = function (etor) {
      return  remoteAction(etor, 'list/admindel');
    };



    rest.adminAdapter = function (etor) {
        return remoteAction(etor, 'admin/' + cooConfig.configObj.companyId + '/adapter');
    };

    rest.adminAdapterPattern = function (etor) {
        return remoteAction(etor, 'admin/' + cooConfig.configObj.companyId + '/adapterpattern');

    };



    rest.adminAdapterString = function (etor) {
        return remoteAction(etor, 'admin/' + cooConfig.configObj.companyId + '/adapterstring');
    };


    rest.adminList = function (etor) {
        return remoteData(etor, 'admin/' + cooConfig.configObj.companyId + '/list');
    };






    return rest;
});