/*********************************************************************
*               SEGGER MICROCONTROLLER GmbH & Co KG                  *
*       Solutions for real time microcontroller applications         *
**********************************************************************
*                                                                    *
*       (c) 1995 - 2008  SEGGER Microcontroller GmbH & Co KG         *
*                                                                    *
*       www.segger.com     Support: support@segger.com               *
*                                                                    *
**********************************************************************
*                                                                    *
*       embOS * Real time operating system for microcontrollers      *
*                                                                    *
*                                                                    *
*       Please note:                                                 *
*                                                                    *
*       Knowledge of this file may under no circumstances            *
*       be used to write a similar product or a real-time            *
*       operating system for in-house use.                           *
*                                                                    *
*       Thank you for your fairness !                                *
*                                                                    *
**********************************************************************
*                                                                    *
*       embOS version: 3.60d                                         *
*                                                                    *
**********************************************************************

----------------------------------------------------------------------
File    : BSP.c
Purpose : BSP for STM32F103 (MB525)
--------  END-OF-HEADER  ---------------------------------------------
*/

#define BSP_C
#include "BSP.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/

/****** SFRs used for LED-Port **************************************/

/****** Assign LEDs to Ports ****************************************/
#define _LED0_BIT  (6)
#define _LED1_BIT  (7)
#define _LED2_BIT  (8)
#define _LED3_BIT  (9)
#define _LED_MASK_ALL ((1uL << _LED0_BIT) | (1uL << _LED1_BIT) | (1uL << _LED2_BIT) | (1uL << _LED3_BIT) )

#define _GPIO_PC0_BASE_ADDR        (0x40011000)
#define _LED_PORT_BASE_ADDR        (_GPIO_PC0_BASE_ADDR)
#define GPIOC_CRL                  *(volatile unsigned int*)(_LED_PORT_BASE_ADDR)
#define GPIOC_CRH                  *(volatile unsigned int*)(_LED_PORT_BASE_ADDR + 0x04)
#define GPIOC_ODR                  *(volatile unsigned int*)(_LED_PORT_BASE_ADDR + 0x0C)
#define GPIOC_BSRR                 *(volatile unsigned int*)(_LED_PORT_BASE_ADDR + 0x10)
#define GPIOC_BRR                  *(volatile unsigned int*)(_LED_PORT_BASE_ADDR + 0x14)
#define _SYSCTRL_RCC_APB2          *(volatile unsigned int*)(0x40021018)
#define _SYSCTRL_LEDPORT_BIT       (4)

/*********************************************************************
*
*       Global functions
*
**********************************************************************
*/

/*********************************************************************
*
*       BSP_Init()
*/
void BSP_Init(void) {
  _SYSCTRL_RCC_APB2 |= (1 << _SYSCTRL_LEDPORT_BIT);
  GPIOC_CRL = 0x33444444;
  GPIOC_CRH = 0x33444444;
  GPIOC_BRR |= _LED_MASK_ALL;   // disable leds
}

/*********************************************************************
*
*       LED switching routines
*       LEDs are switched on with low level on port lines
*/
void BSP_SetLED(int Index) {
  GPIOC_BSRR |= (1 << (_LED0_BIT + Index));             /* Switch on LED 0  */
}

void BSP_ClrLED(int Index) {
  GPIOC_BRR  |= (1 << (_LED0_BIT + Index));             /* Switch off LED 0 */
}

void BSP_ToggleLED(int Index) {
  if ((GPIOC_ODR & (1 << (_LED0_BIT + Index))) == 0) {  /* LED is switched off */
    BSP_SetLED(Index);
  } else {
    BSP_ClrLED(Index);
  }
}

/****** EOF *********************************************************/

