#**********************************************************************
#*               SEGGER MICROCONTROLLER GmbH GmbH & Co KG             *
#*       Solutions for real time microcontroller applications         *
#**********************************************************************
#*                                                                    *
#*       (c) 1995 - 2007  SEGGER Microcontroller GmbH & Co KG         *
#*                                                                    *
#*       www.segger.com     Support: support@segger.com               *
#*                                                                    *
#**********************************************************************
#*                                                                    *
#*       embOS * Real time operating system for microcontrollers      *
#*                                                                    *
#*                                                                    *
#*       Please note:                                                 *
#*                                                                    *
#*       Knowledge of this file may under no circumstances            *
#*       be used to write a similar product or a real-time            *
#*       operating system for in-house use.                           *
#*                                                                    *
#*       Thank you for your fairness !                                *
#*                                                                    *
#**********************************************************************
#*                                                                    *
#*       embOS version: 3.52e                                         *
#*                                                                    *
#**********************************************************************
#
#----------------------------------------------------------------------
#File   : LPC2xxx_FLASH_JLink.gdb
#Purpose: GDB command file for NXP LPC2xxx series +
#                              J-Link (J-Link GDB Server)
#                              FLASH is mapped at 0x00000000
#-------- END-OF-HEADER -----------------------------------------------
#
# Connect to the J-Link gdb server
target remote localhost:2331
# Select flash device
monitor flash device = LPC2148
# Enable FlashDL and FlashBPs
monitor flash download = 1
monitor flash breakpoints = 1
# Set gdb server to little endian
monitor endian little
# Set speed to JTAG speed adaptive
monitor speed adaptive
# Reset the target
monitor reset 0
# Map at the first 64 bytes the internal flash
monitor long 0xE01FC040 = 0x00000001
break main
load
continue