#----------------------------------------------------------------------
#File   : STR912_FLASH_JLink.gdb
#Purpose: GDB command file for ST STR912  series +
#                              J-Link (J-Link GDB Server)
#                              Application runs in flash.
#-------- END-OF-HEADER -----------------------------------------------
#
# connect to the J-Link gdb server
target remote localhost:2331
# Select flash device
monitor flash device = STR912FAW47 
# Enable flash download and flash programming 
monitor flash download = 1
monitor flash breakpoints = 1
# Set gdb server to little endian
monitor endian little
# set speed to JTAG speed to adaptive: STR912 is an ARM966E-S
monitor speed adaptive
# reset the target
monitor reset 0
# Setup GDB for faster downloads
set remote memory-write-packet-size 1024
set remote memory-write-packet-size fixed
# Set a break at main() 
break main
# Load the ELF-file
load
# Let the application run to main()
continue