/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool;

import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.IMediaViewer;
import com.xuggle.mediatool.MediaReader;
import com.xuggle.mediatool.MediaViewer;
import com.xuggle.mediatool.MediaWriter;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class MediaToolExhaustiveTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final IMediaViewer.Mode mViewerMode = IMediaViewer.Mode.valueOf((String)System.getProperty(this.getClass().getName() + ".ViewerMode", IMediaViewer.Mode.DISABLED.name()));
    private final JNIMemoryManager.MemoryModel mModel;
    private final int mIterations;
    private final String mURL;
    private final boolean mDoWrite;
    private final boolean mDoViewer;

    @Parameterized.Parameters
    public static Collection<Object[]> getModels() {
        LinkedList<Object[]> retval = new LinkedList<Object[]>();
        boolean TEST_ALL = true;
        for (JNIMemoryManager.MemoryModel model : JNIMemoryManager.MemoryModel.values()) {
            for (boolean doWrite : new boolean[]{true, false}) {
                for (boolean doViewer : new boolean[]{true, false}) {
                    retval.add(new Object[]{model, "fixtures/testfile.flv", 1, doWrite, doViewer});
                }
            }
        }
        return retval;
    }

    public MediaToolExhaustiveTest(JNIMemoryManager.MemoryModel model, String url, int numIterations, boolean doWrite, boolean runViewer) {
        this.mURL = url;
        this.mIterations = numIterations;
        this.mModel = model;
        this.mDoWrite = doWrite;
        this.mDoViewer = runViewer;
        this.log.debug("url: {}; iterations: {}; model: {}; write: {}; view: {}", new Object[]{this.mURL, this.mIterations, this.mModel, this.mDoWrite, this.mDoViewer});
    }

    @Test
    public void processFile() {
        MediaToolExhaustiveTest.read(this.mModel, this.mURL, this.mIterations, this.mDoWrite, this.mDoViewer, this.mViewerMode);
        JNIMemoryManager.getMgr().flush();
    }

    public static void read(IMediaReader reader, int numIterations) {
    }

    public static void read(JNIMemoryManager.MemoryModel model, String url, int numIterations, boolean doWrite, boolean doViewer, IMediaViewer.Mode viewerMode) {
        JNIMemoryManager.setMemoryModel((JNIMemoryManager.MemoryModel)model);
        for (int i = 0; i < numIterations; ++i) {
            MediaReader reader = new MediaReader(url);
            MediaWriter writer = null;
            Assert.assertNotNull((Object)reader);
            if (doWrite) {
                String outURL = MediaToolExhaustiveTest.class.getName() + "_" + model + "_" + i + ".mov";
                writer = new MediaWriter(outURL, (IMediaReader)reader);
                reader.addListener((IMediaListener)writer);
            }
            if (doViewer) {
                MediaViewer viewer = new MediaViewer(viewerMode, true, 3);
                reader.addListener((IMediaListener)viewer);
            }
            while (reader.readPacket() == null) {
            }
        }
    }
}

