/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.io.FileProtocolHandler;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.ByteChannel;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class ContainerExhaustiveTest {
    private static final String TEST_FILE = "fixtures/testfile.flv";
    private static final int TEST_PACKETS = 7950;
    private static IContainer mContainer;

    @Parameterized.Parameters
    public static Collection<Object[]> getHandlersToTest() throws FileNotFoundException {
        LinkedList<Object[]> retval = new LinkedList<Object[]>();
        retval.add(new Object[]{new ITestSetup(){

            public IContainer setUp() throws FileNotFoundException {
                IContainer retval = IContainer.make();
                Assert.assertTrue((retval.open((InputStream)new FileInputStream(ContainerExhaustiveTest.TEST_FILE), null) >= 0 ? 1 : 0) != 0);
                return retval;
            }
        }});
        retval.add(new Object[]{new ITestSetup(){

            public IContainer setUp() throws FileNotFoundException {
                IContainer retval = IContainer.make();
                Assert.assertTrue((retval.open((ByteChannel)new FileInputStream(ContainerExhaustiveTest.TEST_FILE).getChannel(), IContainer.Type.READ, null) >= 0 ? 1 : 0) != 0);
                return retval;
            }
        }});
        retval.add(new Object[]{new ITestSetup(){

            public IContainer setUp() throws FileNotFoundException {
                IContainer retval = IContainer.make();
                Assert.assertTrue((retval.open(new RandomAccessFile(ContainerExhaustiveTest.TEST_FILE, "r"), IContainer.Type.READ, null) >= 0 ? 1 : 0) != 0);
                return retval;
            }
        }});
        retval.add(new Object[]{new ITestSetup(){

            public IContainer setUp() throws FileNotFoundException {
                IContainer retval = IContainer.make();
                Assert.assertTrue((retval.open(new DataInputStream(new FileInputStream(ContainerExhaustiveTest.TEST_FILE)), null) >= 0 ? 1 : 0) != 0);
                return retval;
            }
        }});
        retval.add(new Object[]{new ITestSetup(){

            public IContainer setUp() throws FileNotFoundException {
                IContainer retval = IContainer.make();
                Assert.assertTrue((String)"could not open container", (retval.open((IURLProtocolHandler)new FileProtocolHandler(ContainerExhaustiveTest.TEST_FILE), IContainer.Type.READ, null) >= 0 ? 1 : 0) != 0);
                return retval;
            }
        }});
        return retval;
    }

    public ContainerExhaustiveTest(ITestSetup setup) throws FileNotFoundException {
        mContainer = setup.setUp();
    }

    @Test
    public void testReadPackets() {
        long packetsRead = 0L;
        IPacket packet = IPacket.make();
        while (mContainer.readNextPacket(packet) >= 0) {
            if (!packet.isComplete()) continue;
            ++packetsRead;
        }
        Assert.assertEquals((String)"got unexpected number of packets in file", (long)7950L, (long)packetsRead);
        mContainer.close();
    }

    private static interface ITestSetup {
        public IContainer setUp() throws FileNotFoundException;
    }
}

