/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterruptingExhaustiveTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    @Ignore
    public void testXugglerSupportInterruptions() throws InterruptedException {
        final AtomicBoolean testStarted = new AtomicBoolean(false);
        final AtomicBoolean testPassed = new AtomicBoolean(false);
        final Object lock = new Object();
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IContainer container = IContainer.make();
                Object object = lock;
                synchronized (object) {
                    testStarted.set(true);
                    lock.notifyAll();
                }
                InterruptingExhaustiveTest.this.log.info("About to call blocking ffmpeg method");
                int retval = container.open("udp://127.0.0.1:12345/notvalid.flv?localport=28302", IContainer.Type.READ, null, true, false);
                InterruptingExhaustiveTest.this.log.info("ffmpeg method returned");
                if (Thread.interrupted()) {
                    InterruptingExhaustiveTest.this.log.info("thread was interrupted");
                    if (retval < 0) {
                        testPassed.set(true);
                    } else {
                        InterruptingExhaustiveTest.this.log.info("but test did not pass");
                    }
                }
            }
        }, "xuggler thread");
        Object object = lock;
        synchronized (object) {
            thread.start();
            while (!testStarted.get()) {
                this.log.info("waiting for start");
                lock.wait();
            }
        }
        Thread.sleep(500L);
        this.log.info("about to interrupt ffmpeg-calling thread");
        thread.interrupt();
        this.log.info("interrupted ffmpeg-calling thread");
        thread.join();
        Assert.assertTrue((String)"test did not pass", (boolean)testPassed.get());
    }

    @Test
    public void testInteruptStatusPreservedAccrossJNICalls() {
        IContainer container = IContainer.make();
        IURLProtocolHandler handler = new IURLProtocolHandler(){

            public int close() {
                return 0;
            }

            public boolean isStreamed(String url, int flags) {
                return true;
            }

            public int open(String url, int flags) {
                return 0;
            }

            public int read(byte[] buf, int size) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("doh");
            }

            public long seek(long offset, int whence) {
                return -1L;
            }

            public int write(byte[] buf, int size) {
                return size;
            }
        };
        Assert.assertTrue((!Thread.currentThread().isInterrupted() ? 1 : 0) != 0);
        Assert.assertTrue((container.open(handler, IContainer.Type.READ, null, true, false) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"thread interrupt not preserved from open", (boolean)Thread.currentThread().isInterrupted());
    }
}

