/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.ferry.JNIReference;
import com.xuggle.ferry.MemoryTestHelper;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.IMediaData;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IVideoPicture;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class MemoryAllocationExhaustiveTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean mSuccess;
    private static IVideoPicture mLeakedLargeFrame = null;
    private static Byte[] mLargeLeakedArray = null;

    @Parameterized.Parameters
    public static Collection<Object[]> getModels() {
        LinkedList<Object[]> retval = new LinkedList<Object[]>();
        boolean TEST_ALL = true;
        for (JNIMemoryManager.MemoryModel model : JNIMemoryManager.MemoryModel.values()) {
            retval.add(new Object[]{model});
        }
        return retval;
    }

    public MemoryAllocationExhaustiveTest(JNIMemoryManager.MemoryModel model) {
        this.log.debug("Testing model: {}", (Object)model);
        JNIMemoryManager.getMgr().flush();
        Assert.assertEquals((String)"objects already allocated?", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        JNIMemoryManager.setMemoryModel((JNIMemoryManager.MemoryModel)model);
    }

    @Before
    public void setUp() {
        this.log.debug("------ START ------");
        this.mSuccess = false;
    }

    @After
    public void tearDown() throws InterruptedException {
        JNIMemoryManager.getMgr().flush();
        this.log.debug("------ END (Success={}) ------", (Object)this.mSuccess);
    }

    @Test(timeout=300000L)
    public void testCorrectRefCounting() throws InterruptedException {
        this.log.debug("Testing {}", (Object)"testCorrectRefCounting");
        Assert.assertEquals((String)"objects already allocated?", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        this.log.trace("create a frame");
        IVideoPicture obj = IVideoPicture.make((IPixelFormat.Type)IPixelFormat.Type.YUV420P, (int)2000, (int)2000);
        this.log.trace("force frame data allocation");
        IBuffer buffer = obj.getData();
        buffer.delete();
        this.log.trace("copy frame reference");
        IVideoPicture copy = obj.copyReference();
        this.log.trace("do ref count check");
        Assert.assertEquals((long)2L, (long)copy.getCurrentRefCount());
        Assert.assertEquals((long)2L, (long)obj.getCurrentRefCount());
        this.log.trace("delete object");
        obj.delete();
        this.log.trace("do second ref count check");
        Assert.assertEquals((long)1L, (long)copy.getCurrentRefCount());
        copy.delete();
        Assert.assertEquals((String)"Looks like at least one object is pinned", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        this.mSuccess = true;
    }

    @Test(timeout=600000L)
    public void testExplicitDeletionWorks() throws InterruptedException {
        this.log.debug("Testing {}", (Object)"testExplicitDeletionWorks");
        Assert.assertEquals((String)"objects already allocated?", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        int numLoops = 100;
        for (int i = 0; i < numLoops; ++i) {
            IVideoPicture obj = IVideoPicture.make((IPixelFormat.Type)IPixelFormat.Type.YUV420P, (int)2000, (int)2000);
            Assert.assertNotNull((String)"could not allocate object", (Object)obj);
            IBuffer buffer = obj.getData();
            Assert.assertNotNull((String)"could not allocate underlying buffer", (Object)buffer);
            buffer.delete();
            obj.delete();
        }
        Assert.assertEquals((String)"objects already allocated?", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        this.mSuccess = true;
    }

    @Test(timeout=600000L)
    public void testImplicitReleasingWithNoExplicitGCWorks() throws InterruptedException {
        this.log.debug("Testing {}", (Object)"testImplicitReleasingWithNoExplicitGCWorks");
        JNIMemoryManager.MemoryModel model = JNIMemoryManager.getMemoryModel();
        if (model == JNIMemoryManager.MemoryModel.NATIVE_BUFFERS || model == JNIMemoryManager.MemoryModel.JAVA_DIRECT_BUFFERS) {
            this.log.debug("Skipping test; explicitly won't work with this model: {}", (Object)JNIMemoryManager.getMemoryModel());
            return;
        }
        Assert.assertEquals((String)"objects left over from prior test?", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        int numLoops = 1000;
        for (int i = 0; i < numLoops; ++i) {
            IVideoPicture obj = IVideoPicture.make((IPixelFormat.Type)IPixelFormat.Type.YUV420P, (int)2000, (int)2000);
            Assert.assertNotNull((String)"could not allocate frame", (Object)obj);
            Assert.assertNotNull((String)"could not allocate underlying data", (Object)obj.getData());
            obj = null;
        }
        this.log.debug("Test finished; cleaning up: {}", (Object)JNIMemoryManager.getMgr().getNumPinnedObjects());
        this.mSuccess = true;
    }

    @Test
    public void testLeakLargeFrame() throws InterruptedException {
        this.log.debug("Testing {}", (Object)"testLeakLargeFrame");
        this.log.trace("create a frame");
        IVideoPicture obj = IVideoPicture.make((IPixelFormat.Type)IPixelFormat.Type.YUV420P, (int)2000, (int)2000);
        Assert.assertNotNull((String)"could not allocate frame", (Object)obj);
        this.log.trace("force frame data allocation");
        Assert.assertNotNull((String)"could not allocate underlying data", (Object)obj.getData());
        this.log.trace("create java byte array for fun");
        Byte[] arrayToLeak = new Byte[1000000];
        Assert.assertNotNull((String)"could not allocate large array to leak", (Object)arrayToLeak);
        this.log.trace("leak java byte array");
        mLargeLeakedArray = arrayToLeak;
        MemoryAllocationExhaustiveTest.mLargeLeakedArray[0] = 0;
        this.log.trace("Deliberately leaking a large frame");
        mLeakedLargeFrame = obj;
        obj = null;
        this.log.trace("set the pts");
        mLeakedLargeFrame.setPts(0L);
        this.log.trace("try setting pixels");
        IPixelFormat.YUVColorComponent[] colors = new IPixelFormat.YUVColorComponent[]{IPixelFormat.YUVColorComponent.YUV_Y, IPixelFormat.YUVColorComponent.YUV_U, IPixelFormat.YUVColorComponent.YUV_V};
        for (int x = 100; x < 200; ++x) {
            for (int y = 100; y < 100; ++y) {
                for (IPixelFormat.YUVColorComponent c : colors) {
                    int val = 100;
                    IPixelFormat.setYUV420PPixel((IVideoPicture)mLeakedLargeFrame, (int)x, (int)y, (IPixelFormat.YUVColorComponent)c, (short)100);
                    Assert.assertEquals((long)100L, (long)IPixelFormat.getYUV420PPixel((IVideoPicture)mLeakedLargeFrame, (int)x, (int)y, (IPixelFormat.YUVColorComponent)c));
                }
            }
        }
        MemoryTestHelper.forceJavaHeapWeakReferenceClear();
        Assert.assertTrue((String)"Looks like we didn't leak the large frame????", (0L < JNIMemoryManager.getMgr().getNumPinnedObjects() ? 1 : 0) != 0);
        mLeakedLargeFrame = null;
        this.mSuccess = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testOutOfMemoryHelper(IMediaAllocator allocator) {
        String osName = System.getProperty("os.name", "Linux");
        if (osName != null && osName.length() > 0 && osName.startsWith("Mac")) {
            return;
        }
        class Tuple {
            private final ByteBuffer mBuffer;
            private final JNIReference mReference;

            public Tuple(ByteBuffer buffer, JNIReference reference) {
                this.mBuffer = buffer;
                this.mReference = reference;
            }

            public JNIReference getReference() {
                return this.mReference;
            }

            public ByteBuffer getBuffer() {
                return this.mBuffer;
            }
        }
        LinkedList<Tuple> leakyMedia = null;
        long bytesBeforeFailure = 0L;
        int i = 0;
        try {
            leakyMedia = new LinkedList<Tuple>();
            while (true) {
                Object var13_14;
                IBuffer buffer;
                IMediaData media;
                block17: {
                    block18: {
                        media = null;
                        buffer = null;
                        AtomicReference<Object> reference = new AtomicReference<Object>(null);
                        try {
                            media = allocator.getMedia();
                            buffer = media.getData();
                            if (buffer == null) {
                                this.log.debug("Could not get IBuffer");
                                throw new OutOfMemoryError();
                            }
                            ByteBuffer bBuf = buffer.getByteBuffer(0, media.getSize(), reference);
                            if (bBuf == null) {
                                this.log.debug("Could not get ByteBuffer");
                                throw new OutOfMemoryError();
                            }
                            int j = 0;
                            while (i < media.getSize()) {
                                bBuf.put(j, (byte)0);
                                ++i;
                            }
                            Tuple tuple = new Tuple(bBuf, reference.get());
                            leakyMedia.add(tuple);
                            Assert.assertNotNull((Object)tuple.getBuffer());
                            Assert.assertNotNull((Object)tuple.getReference());
                            if ((bytesBeforeFailure += (long)media.getSize()) <= 0L) break block17;
                            this.mSuccess = true;
                            var13_14 = null;
                            if (media == null) break block18;
                        }
                        catch (Throwable throwable) {
                            var13_14 = null;
                            if (media != null) {
                                media.delete();
                            }
                            if (buffer != null) {
                                buffer.delete();
                            }
                            if (i % 100 == 0) {
                                this.log.trace("iteration: {}; allocated {} bytes; pinned: {}; holding: {}", new Object[]{i, bytesBeforeFailure, JNIMemoryManager.getMgr().getNumPinnedObjects(), leakyMedia.size()});
                            }
                            ++i;
                            throw throwable;
                        }
                        media.delete();
                    }
                    if (buffer != null) {
                        buffer.delete();
                    }
                    if (i % 100 == 0) {
                        this.log.trace("iteration: {}; allocated {} bytes; pinned: {}; holding: {}", new Object[]{i, bytesBeforeFailure, JNIMemoryManager.getMgr().getNumPinnedObjects(), leakyMedia.size()});
                    }
                    ++i;
                    return;
                }
                var13_14 = null;
                if (media != null) {
                    media.delete();
                }
                if (buffer != null) {
                    buffer.delete();
                }
                if (i % 100 == 0) {
                    this.log.trace("iteration: {}; allocated {} bytes; pinned: {}; holding: {}", new Object[]{i, bytesBeforeFailure, JNIMemoryManager.getMgr().getNumPinnedObjects(), leakyMedia.size()});
                }
                ++i;
            }
        }
        catch (OutOfMemoryError e) {
            int size = leakyMedia.size();
            leakyMedia.clear();
            Assert.assertTrue((String)"didn't allocate anything", (size > 0 ? 1 : 0) != 0);
            this.log.debug("Bytes before failure: {}; Failure: {}", (Object)bytesBeforeFailure, (Object)e);
            this.mSuccess = true;
            return;
        }
    }

    @Test
    public void testOutOfMemoryIPacket() {
        IMediaAllocator allocator = new IMediaAllocator(){

            public IMediaData getMedia() {
                IPacket media = IPacket.make((int)0x100000);
                if (media == null) {
                    throw new OutOfMemoryError();
                }
                media.setComplete(true, 0x100000);
                return media;
            }
        };
        this.log.debug("Testing Packet Out Of Memory Handling");
        this.testOutOfMemoryHelper(allocator);
    }

    @Test
    public void testOutOfMemoryIAudioSamples() {
        IMediaAllocator allocator = new IMediaAllocator(){

            public IMediaData getMedia() {
                IAudioSamples media = IAudioSamples.make((long)0x100000L, (long)1L);
                if (media == null) {
                    throw new OutOfMemoryError();
                }
                media.setComplete(true, 0x100000L, 22050, 1, IAudioSamples.Format.FMT_S16, 0L);
                return media;
            }
        };
        this.log.debug("Testing Audio Samples Out Of Memory Handling");
        this.testOutOfMemoryHelper(allocator);
    }

    @Test
    public void testOutOfMemoryIVideoPicture() {
        IMediaAllocator allocator = new IMediaAllocator(){

            public IMediaData getMedia() {
                IVideoPicture media = IVideoPicture.make((IPixelFormat.Type)IPixelFormat.Type.YUV420P, (int)1024, (int)1024);
                if (media == null) {
                    throw new OutOfMemoryError();
                }
                media.setComplete(true, IPixelFormat.Type.YUV420P, 1024, 1024, 0L);
                return media;
            }
        };
        this.log.debug("Testing Video Picture Out Of Memory Handling");
        this.testOutOfMemoryHelper(allocator);
    }

    private static interface IMediaAllocator {
        public IMediaData getMedia();
    }
}

