/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.IMediaViewer;
import com.xuggle.mediatool.ToolFactory;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class MultiThreadedWritingExhaustiveTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int mThreads;
    private final int mTestNumber;
    private final JNIMemoryManager.MemoryModel mModel;

    @Parameterized.Parameters
    public static Collection<Object[]> getModels() {
        LinkedList<Object[]> retval = new LinkedList<Object[]>();
        int i = 0;
        for (JNIMemoryManager.MemoryModel model : JNIMemoryManager.MemoryModel.values()) {
            for (int j = 0; j < 5; ++j) {
                retval.add(new Object[]{model, 4 * (j + 1), i});
                ++i;
            }
        }
        return retval;
    }

    public MultiThreadedWritingExhaustiveTest(JNIMemoryManager.MemoryModel model, int numThreads, int testNo) {
        this.log.debug("Testing model: {}; Threads: {}", (Object)model, (Object)numThreads);
        this.mModel = model;
        this.mThreads = numThreads;
        this.mTestNumber = testNo;
        JNIMemoryManager.setMemoryModel((JNIMemoryManager.MemoryModel)model);
    }

    @Test(timeout=1800000L)
    public void testMultiThreadedTest() throws InterruptedException {
        int i;
        if (System.getProperty("os.name", "Linux").startsWith("Windows")) {
            return;
        }
        final boolean ADD_VIEWER = System.getProperty(MultiThreadedWritingExhaustiveTest.class.getName() + ".ShowVideo") != null;
        Thread[] threads = new Thread[this.mThreads];
        final int[] numPackets = new int[this.mThreads];
        final AtomicInteger uncaughtExceptions = new AtomicInteger();
        final AtomicReference<Object> lastUncaughtException = new AtomicReference<Object>(null);
        for (int i2 = 0; i2 < threads.length; ++i2) {
            final int index = i2;
            threads[index] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block11: {
                        IMediaReader reader = ToolFactory.makeReader((String)"fixtures/testfile_videoonly_20sec.flv");
                        reader.setBufferedImageTypeToGenerate(5);
                        reader.setAddDynamicStreams(false);
                        reader.setQueryMetaData(true);
                        if (ADD_VIEWER) {
                            IMediaViewer viewer = ToolFactory.makeViewer();
                            reader.addListener((IMediaListener)viewer);
                        }
                        reader.addListener((IMediaListener)ToolFactory.makeWriter((String)(MultiThreadedWritingExhaustiveTest.class.getName() + "_" + MultiThreadedWritingExhaustiveTest.this.mModel.toString() + "_" + MultiThreadedWritingExhaustiveTest.this.mTestNumber + "_" + index + ".flv"), (IMediaReader)reader));
                        while (reader.readPacket() == null) {
                            int n = index;
                            numPackets[n] = numPackets[n] + 1;
                        }
                        Object var4_4 = null;
                        try {
                            reader.close();
                        }
                        catch (RuntimeException e2) {
                            MultiThreadedWritingExhaustiveTest.this.log.debug("Got and ignoring: {}", (Throwable)e2);
                        }
                        MultiThreadedWritingExhaustiveTest.this.log.debug("thread exited with {} packets processed", (Object)numPackets[index]);
                        {
                            break block11;
                            catch (OutOfMemoryError e) {
                                MultiThreadedWritingExhaustiveTest.this.log.debug("Thread {} exited with memory exception WHICH IS OK: {}", (Object)index, (Object)e);
                                numPackets[index] = -1;
                                Object var4_5 = null;
                                try {
                                    reader.close();
                                }
                                catch (RuntimeException e2) {
                                    MultiThreadedWritingExhaustiveTest.this.log.debug("Got and ignoring: {}", (Throwable)e2);
                                }
                                MultiThreadedWritingExhaustiveTest.this.log.debug("thread exited with {} packets processed", (Object)numPackets[index]);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            try {
                                reader.close();
                            }
                            catch (RuntimeException e2) {
                                MultiThreadedWritingExhaustiveTest.this.log.debug("Got and ignoring: {}", (Throwable)e2);
                            }
                            MultiThreadedWritingExhaustiveTest.this.log.debug("thread exited with {} packets processed", (Object)numPackets[index]);
                            throw throwable;
                        }
                    }
                }
            }, "TestThread_" + index);
            threads[i2].setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread t, Throwable e) {
                    if (!(e instanceof OutOfMemoryError)) {
                        MultiThreadedWritingExhaustiveTest.this.log.debug("Uncaught exception leaked out of thread: {}; {}", (Object)e, (Object)t);
                        e.printStackTrace();
                        uncaughtExceptions.incrementAndGet();
                        lastUncaughtException.set(e);
                    } else {
                        numPackets[index] = -1;
                    }
                }
            });
            threads[i2].start();
        }
        int numSuccess = 0;
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        Assert.assertEquals((String)("got uncaught exception: " + lastUncaughtException.get()), (long)0L, (long)uncaughtExceptions.get());
        for (i = 0; i < threads.length; ++i) {
            if (numPackets[i] == -1) continue;
            Assert.assertEquals((long)1062L, (long)numPackets[i]);
            ++numSuccess;
        }
        this.log.debug("Test completed successfully: {} of {} threads ran without memory errors", (Object)numSuccess, (Object)this.mThreads);
    }
}

