/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.video;

import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Vector;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class ConverterFactoryExhaustiveTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int TEST_WIDTH = 100;
    private static final int TEST_HEIGHT = 100;
    private static final int TEST_ITERATIONS = 25;
    private final ConverterFactory.Type mConverterType;
    private final IPixelFormat.Type mPixelType;
    private JNIMemoryManager.MemoryModel mModel;
    private static final IPixelFormat.Type[] mIncludedPixelTypes = new IPixelFormat.Type[]{IPixelFormat.Type.ARGB, IPixelFormat.Type.BGR24, IPixelFormat.Type.YUV420P};

    @Parameterized.Parameters
    public static Collection<Object[]> converterTypes() {
        Vector<Object[]> parameters = new Vector<Object[]>();
        boolean TEST_ALL = true;
        for (JNIMemoryManager.MemoryModel model : JNIMemoryManager.MemoryModel.values()) {
            for (IPixelFormat.Type pixelType : mIncludedPixelTypes) {
                for (ConverterFactory.Type converterType : ConverterFactory.getRegisteredConverters()) {
                    Object[] tuple = new Object[]{model, converterType, pixelType};
                    parameters.add(tuple);
                }
            }
        }
        return parameters;
    }

    public ConverterFactoryExhaustiveTest(JNIMemoryManager.MemoryModel model, ConverterFactory.Type converterType, IPixelFormat.Type pixelType) {
        this.mConverterType = converterType;
        this.mPixelType = pixelType;
        this.mModel = model;
        JNIMemoryManager.setMemoryModel((JNIMemoryManager.MemoryModel)model);
    }

    @Test
    public void testImageToImageNoLeaks() {
        JNIMemoryManager.getMgr().flush();
        this.log.debug("testImageToImageNoLeaks; model: {}; converter type: {}; pixel type: {};", new Object[]{this.mModel, this.mConverterType, this.mPixelType});
        long start = System.nanoTime();
        for (int i = 0; i < 25; ++i) {
            Assert.assertEquals((String)"not all memory released", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
            this.helperImageToImageSolidColorWithResize();
            Assert.assertEquals((String)"not all memory released", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        }
        long end = System.nanoTime();
        long durationMillis = (end - start) / 1000000L;
        this.log.debug("testImageToImageNoLeaks; duration: {}", (Object)durationMillis);
    }

    @Test
    public void testPictureToPictureNoLeaks() {
        JNIMemoryManager.getMgr().flush();
        this.log.debug("testPictureToPictureNoLeaks; model: {}; converter type: {}; pixel type: {};", new Object[]{this.mModel, this.mConverterType, this.mPixelType});
        long start = System.nanoTime();
        for (int i = 0; i < 25; ++i) {
            Assert.assertEquals((String)"not all memory released", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
            this.helperPictureToPictureWithRotate();
            Assert.assertEquals((String)"not all memory released", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        }
        long end = System.nanoTime();
        long durationMillis = (end - start) / 1000000L;
        this.log.debug("testPictureToPictureNoLeaks; duration: {}", (Object)durationMillis);
    }

    public void helperPictureToPictureWithRotate() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        int size = 100;
        int black = Color.BLACK.getRGB();
        int white = Color.WHITE.getRGB();
        IConverter converter = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)this.mConverterType.getPictureType(), (int)size, (int)size);
        IVideoPicture picture = null;
        BufferedImage image1 = new BufferedImage(size, size, this.mConverterType.getImageType());
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                int color = x % 2 == 0 ? black : white;
                image1.setRGB(x, y, color);
            }
        }
        picture = converter.toPicture(image1, 0L);
        BufferedImage image2 = converter.toImage(picture);
        picture.delete();
        AffineTransform t = AffineTransform.getRotateInstance(1.5707963267948966, image2.getWidth() / 2, image2.getHeight() / 2);
        AffineTransformOp ato = new AffineTransformOp(t, 3);
        BufferedImage image3 = new BufferedImage(size, size, this.mConverterType.getImageType());
        image3 = ato.filter(image2, image3);
        picture = converter.toPicture(image3, 0L);
        BufferedImage image4 = converter.toImage(picture);
        picture.delete();
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                int pixel1 = y % 2 == 0 ? black : white;
                int pixel2 = image4.getRGB(x, y);
                String message = this.testPixels(this.mConverterType.getPictureType() == converter.getPictureType(), pixel1, pixel2, x, y, converter.getPictureType());
                Assert.assertNull((String)message, (Object)message);
            }
        }
        converter.delete();
    }

    public void helperImageToImageSolidColorWithResize() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        int w1 = 100;
        int h1 = 100;
        int w2 = 200;
        int h2 = 200;
        int gray = Color.GRAY.getRGB();
        IConverter converter1 = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)this.mPixelType, (int)w2, (int)h2, (int)w1, (int)h1);
        IConverter converter2 = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)this.mPixelType, (int)w2, (int)h2, (int)w2, (int)h2);
        BufferedImage image1 = new BufferedImage(w1, h1, this.mConverterType.getImageType());
        for (int x = 0; x < w1; ++x) {
            for (int y = 0; y < h1; ++y) {
                image1.setRGB(x, y, gray);
            }
        }
        IVideoPicture picture = converter1.toPicture(image1, 0L);
        BufferedImage image2 = converter2.toImage(picture);
        picture.delete();
        Assert.assertEquals((String)"image2 wrong width", (int)w2, (int)image2.getWidth());
        Assert.assertEquals((String)"image2 wrong height", (int)h2, (int)image2.getHeight());
        for (int x = 0; x < w1; ++x) {
            for (int y = 0; y < h1; ++y) {
                int pixel1 = image1.getRGB(x, y);
                int pixel2 = image2.getRGB(x * 2, y * 2);
                String message = this.testPixels(false, pixel1, pixel2, x, y, converter1.getPictureType());
                Assert.assertNull((String)message, (Object)message);
            }
        }
        converter1.delete();
        converter2.delete();
    }

    private String testPixels(boolean exact, int pixel1, int pixel2, int x, int y, IPixelFormat.Type pixelType) {
        String message = "Color value missmatch whith pixel type " + pixelType + ", converter " + this.mConverterType + ", at pixel (" + x + "," + y + ").  Value is " + pixel2 + " but should be " + pixel1 + ".";
        if (exact) {
            return pixel1 == pixel2 ? null : message;
        }
        int margin = 8;
        Color c1 = new Color(pixel1);
        Color c2 = new Color(pixel2);
        if (!(ConverterFactoryExhaustiveTest.closeEnough(c1.getRed(), c2.getRed(), margin) && ConverterFactoryExhaustiveTest.closeEnough(c1.getGreen(), c2.getGreen(), margin) && ConverterFactoryExhaustiveTest.closeEnough(c1.getBlue(), c2.getBlue(), margin))) {
            System.out.println("missmatch at: (" + x + "x" + y + ")");
            System.out.println("red:   " + c1.getRed() + " vs. " + c2.getRed());
            System.out.println("green: " + c1.getGreen() + " vs. " + c2.getGreen());
            System.out.println("blue:  " + c1.getBlue() + " vs. " + c2.getBlue());
            return message;
        }
        return null;
    }

    private static boolean closeEnough(int v1, int v2, int margin) {
        return Math.abs(v2 - v1) <= margin;
    }
}

