/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex;

import java.util.Arrays;
import jpcsp.Emulator;

public class GprState {
    public final int[] gpr = new int[32];

    public void reset() {
        Arrays.fill(this.gpr, 0);
    }

    public void resetAll() {
        Arrays.fill(this.gpr, 0);
    }

    public GprState() {
    }

    public void copy(GprState that) {
        System.arraycopy(that.gpr, 0, this.gpr, 0, this.gpr.length);
    }

    public GprState(GprState that) {
        System.arraycopy(that.gpr, 0, this.gpr, 0, this.gpr.length);
    }

    public void doUNK(String reason) {
        Emulator.log.error("Interpreter : " + reason);
    }

    public static final int extractBits(int x, int pos, int len) {
        return x >>> pos & ~(-1 << len);
    }

    public static final int insertBits(int x, int y, int lsb, int msb) {
        int mask = ~(-1 << msb - lsb + 1) << lsb;
        return x & ~mask | y << lsb & mask;
    }

    public static final int signExtend(int value) {
        return value << 16 >> 16;
    }

    public static final int signExtend8(int value) {
        return value << 24 >> 24;
    }

    public static final int zeroExtend(int value) {
        return value & 0xFFFF;
    }

    public static final int zeroExtend8(int value) {
        return value & 0xFF;
    }

    public static final int signedCompare(int i, int j) {
        return i < j ? 1 : 0;
    }

    public static final int unsignedCompare(long i, long j) {
        return (i & 0xFFFFFFFFL) < (j & 0xFFFFFFFFL) ? 1 : 0;
    }

    public final void doSLL(int rd, int rt, int sa) {
        if (rd != 0) {
            this.gpr[rd] = this.gpr[rt] << sa;
        }
    }

    public final void doSRL(int rd, int rt, int sa) {
        if (rd != 0) {
            this.gpr[rd] = this.gpr[rt] >>> sa;
        }
    }

    public final void doSRA(int rd, int rt, int sa) {
        if (rd != 0) {
            this.gpr[rd] = this.gpr[rt] >> sa;
        }
    }

    public final void doSLLV(int rd, int rt, int rs) {
        if (rd != 0) {
            this.gpr[rd] = this.gpr[rt] << (this.gpr[rs] & 0x1F);
        }
    }

    public final void doSRLV(int rd, int rt, int rs) {
        if (rd != 0) {
            this.gpr[rd] = this.gpr[rt] >>> (this.gpr[rs] & 0x1F);
        }
    }

    public final void doSRAV(int rd, int rt, int rs) {
        if (rd != 0) {
            this.gpr[rd] = this.gpr[rt] >> (this.gpr[rs] & 0x1F);
        }
    }

    public final void doADDU(int rd, int rs, int rt) {
        if (rd != 0) {
            this.gpr[rd] = this.gpr[rs] + this.gpr[rt];
        }
    }

    public final void doSUBU(int rd, int rs, int rt) {
        if (rd != 0) {
            this.gpr[rd] = this.gpr[rs] - this.gpr[rt];
        }
    }

    public final void doAND(int rd, int rs, int rt) {
        if (rd != 0) {
            this.gpr[rd] = this.gpr[rs] & this.gpr[rt];
        }
    }

    public final void doOR(int rd, int rs, int rt) {
        if (rd != 0) {
            this.gpr[rd] = this.gpr[rs] | this.gpr[rt];
        }
    }

    public final void doXOR(int rd, int rs, int rt) {
        if (rd != 0) {
            this.gpr[rd] = this.gpr[rs] ^ this.gpr[rt];
        }
    }

    public final void doNOR(int rd, int rs, int rt) {
        if (rd != 0) {
            this.gpr[rd] = ~(this.gpr[rs] | this.gpr[rt]);
        }
    }

    public final void doSLT(int rd, int rs, int rt) {
        if (rd != 0) {
            this.gpr[rd] = GprState.signedCompare(this.gpr[rs], this.gpr[rt]);
        }
    }

    public final void doSLTU(int rd, int rs, int rt) {
        if (rd != 0) {
            this.gpr[rd] = GprState.unsignedCompare(this.gpr[rs], this.gpr[rt]);
        }
    }

    public final void doADDIU(int rt, int rs, int simm16) {
        if (rt != 0) {
            this.gpr[rt] = this.gpr[rs] + simm16;
        }
    }

    public final void doSLTI(int rt, int rs, int simm16) {
        if (rt != 0) {
            this.gpr[rt] = GprState.signedCompare(this.gpr[rs], simm16);
        }
    }

    public final void doSLTIU(int rt, int rs, int simm16) {
        if (rt != 0) {
            this.gpr[rt] = GprState.unsignedCompare(this.gpr[rs], simm16);
        }
    }

    public final void doANDI(int rt, int rs, int uimm16) {
        if (rt != 0) {
            this.gpr[rt] = this.gpr[rs] & uimm16;
        }
    }

    public final void doORI(int rt, int rs, int uimm16) {
        if (rt != 0) {
            this.gpr[rt] = this.gpr[rs] | uimm16;
        }
    }

    public final void doXORI(int rt, int rs, int uimm16) {
        if (rt != 0) {
            this.gpr[rt] = this.gpr[rs] ^ uimm16;
        }
    }

    public final void doLUI(int rt, int uimm16) {
        if (rt != 0) {
            this.gpr[rt] = uimm16 << 16;
        }
    }

    public final void doROTR(int rd, int rt, int sa) {
        if (rd != 0) {
            this.gpr[rd] = Integer.rotateRight(this.gpr[rt], sa);
        }
    }

    public final void doROTRV(int rd, int rt, int rs) {
        if (rd != 0) {
            this.gpr[rd] = Integer.rotateRight(this.gpr[rt], this.gpr[rs]);
        }
    }

    public final void doMOVZ(int rd, int rs, int rt) {
        if (rd != 0 && this.gpr[rt] == 0) {
            this.gpr[rd] = this.gpr[rs];
        }
    }

    public final void doMOVN(int rd, int rs, int rt) {
        if (rd != 0 && this.gpr[rt] != 0) {
            this.gpr[rd] = this.gpr[rs];
        }
    }

    public final void doCLZ(int rd, int rs) {
        if (rd != 0) {
            this.gpr[rd] = Integer.numberOfLeadingZeros(this.gpr[rs]);
        }
    }

    public final void doCLO(int rd, int rs) {
        if (rd != 0) {
            this.gpr[rd] = Integer.numberOfLeadingZeros(~this.gpr[rs]);
        }
    }

    public final void doMAX(int rd, int rs, int rt) {
        if (rd != 0) {
            this.gpr[rd] = Math.max(this.gpr[rs], this.gpr[rt]);
        }
    }

    public final void doMIN(int rd, int rs, int rt) {
        if (rd != 0) {
            this.gpr[rd] = Math.min(this.gpr[rs], this.gpr[rt]);
        }
    }

    public final void doEXT(int rt, int rs, int lsb, int msbd) {
        if (rt != 0) {
            this.gpr[rt] = GprState.extractBits(this.gpr[rs], lsb, msbd + 1);
        }
    }

    public final void doINS(int rt, int rs, int lsb, int msb) {
        if (rt != 0) {
            this.gpr[rt] = GprState.insertBits(this.gpr[rt], this.gpr[rs], lsb, msb);
        }
    }

    public final void doWSBH(int rd, int rt) {
        if (rd != 0) {
            this.gpr[rd] = Integer.rotateRight(Integer.reverseBytes(this.gpr[rt]), 16);
        }
    }

    public final void doWSBW(int rd, int rt) {
        if (rd != 0) {
            this.gpr[rd] = Integer.reverseBytes(this.gpr[rt]);
        }
    }

    public final void doSEB(int rd, int rt) {
        if (rd != 0) {
            this.gpr[rd] = (byte)this.gpr[rt];
        }
    }

    public final void doBITREV(int rd, int rt) {
        if (rd != 0) {
            this.gpr[rd] = Integer.reverse(this.gpr[rt]);
        }
    }

    public final void doSEH(int rd, int rt) {
        if (rd != 0) {
            this.gpr[rd] = (short)this.gpr[rt];
        }
    }
}

