/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import jpcsp.Allegrex.compiler.ICompiler;
import jpcsp.Allegrex.compiler.IExecutable;
import org.apache.log4j.Logger;

public class CompilerClassLoader
extends ClassLoader {
    public static Logger log = Logger.getLogger("loader");
    private ICompiler compiler;

    public CompilerClassLoader(ICompiler compiler) {
        this.compiler = compiler;
    }

    public Class<?> defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    public Class<?> defineClass(byte[] b) {
        return this.defineClass(null, b, 0, b.length);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass == null && this.compiler != null) {
            IExecutable executable;
            if (log.isTraceEnabled()) {
                log.trace("ClassLoader creating class " + name);
            }
            if ((executable = this.compiler.compile(name)) != null) {
                loadedClass = executable.getClass();
            }
        }
        if (loadedClass == null) {
            loadedClass = super.findClass(name);
        }
        return loadedClass;
    }
}

