/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import jpcsp.Allegrex.compiler.ICompilerContext;
import jpcsp.ParameterReader;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class CompilerParameterReader
extends ParameterReader {
    private ICompilerContext compilerContext;
    private boolean hasErrorPointer = false;
    private int currentParameterIndex = 0;
    private int currentStackSize = 0;

    public CompilerParameterReader(ICompilerContext compilerContext) {
        super(null, null);
        this.compilerContext = compilerContext;
    }

    private void loadParameterIntAt(int index) {
        if (index >= 8) {
            this.compilerContext.memRead32(29, index - 8 << 2);
        } else {
            this.compilerContext.loadRegister(4 + index);
        }
    }

    private void loadParameterFloatAt(int index) {
        if (index >= 8) {
            throw new NotImplementedException();
        }
        this.compilerContext.loadFRegister(12 + index);
    }

    private void loadParameterLongAt(int index) {
        if (index % 2 != 0) {
            throw new RuntimeException("Parameter misalignment");
        }
        this.loadParameterIntAt(index);
        this.compilerContext.getMethodVisitor().visitInsn(133);
        this.compilerContext.getMethodVisitor().visitLdcInsn(0xFFFFFFFFL);
        this.compilerContext.getMethodVisitor().visitInsn(127);
        this.loadParameterIntAt(index + 1);
        this.compilerContext.getMethodVisitor().visitInsn(133);
        this.compilerContext.loadImm(32);
        this.compilerContext.getMethodVisitor().visitInsn(121);
        this.compilerContext.getMethodVisitor().visitInsn(97);
    }

    public void loadNextInt() {
        this.loadParameterIntAt(this.moveParameterIndex(1));
    }

    public void loadNextFloat() {
        this.loadParameterFloatAt(this.moveParameterIndexFloat(1));
    }

    public void loadNextLong() {
        this.loadParameterLongAt(this.moveParameterIndex(2));
    }

    public void popAllStack(int additionalCount) {
        int count;
        for (count = this.currentStackSize + additionalCount; count >= 2; count -= 2) {
            this.compilerContext.getMethodVisitor().visitInsn(88);
        }
        while (count > 0) {
            this.compilerContext.getMethodVisitor().visitInsn(87);
            --count;
        }
    }

    public boolean hasErrorPointer() {
        return this.hasErrorPointer;
    }

    public void setHasErrorPointer(boolean hasErrorPointer) {
        this.hasErrorPointer = hasErrorPointer;
    }

    public int getCurrentParameterIndex() {
        return this.currentParameterIndex;
    }

    public void incrementCurrentParameterIndex() {
        ++this.currentParameterIndex;
    }

    public void incrementCurrentStackSize(int size) {
        this.currentStackSize += size;
    }

    public void incrementCurrentStackSize() {
        this.incrementCurrentStackSize(1);
    }
}

