/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.Instructions;
import jpcsp.Allegrex.VfpuState;
import jpcsp.Allegrex.compiler.CodeBlock;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.IExecutable;
import jpcsp.Allegrex.compiler.Profiler;
import jpcsp.Allegrex.compiler.RuntimeSyncThread;
import jpcsp.Allegrex.compiler.RuntimeThread;
import jpcsp.Allegrex.compiler.StackPopException;
import jpcsp.Allegrex.compiler.StopThreadException;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SyscallHandler;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.State;
import jpcsp.hardware.Interrupts;
import jpcsp.memory.DebuggerMemory;
import jpcsp.memory.FastMemory;
import jpcsp.scheduler.Scheduler;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.CpuDurationStatistics;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class RuntimeContext {
    public static Logger log = Logger.getLogger("runtime");
    private static boolean compilerEnabled = true;
    public static int[] gpr;
    public static float[] fpr;
    public static VfpuState.VfpuValue[] vpr;
    public static int[] memoryInt;
    public static Processor processor;
    public static CpuState cpu;
    public static Memory memory;
    public static boolean enableDebugger;
    public static final String debuggerName = "syncDebugger";
    public static final boolean debugCodeBlockCalls = false;
    public static final String debugCodeBlockStart = "debugCodeBlockStart";
    public static final String debugCodeBlockEnd = "debugCodeBlockEnd";
    public static final boolean debugCodeInstruction = false;
    public static final String debugCodeInstructionName = "debugCodeInstruction";
    public static final boolean debugMemoryRead = false;
    public static final boolean debugMemoryWrite = false;
    public static final boolean debugMemoryReadWriteNoSP = true;
    public static final boolean enableInstructionTypeCounting = false;
    public static final String instructionTypeCount = "instructionTypeCount";
    public static final String logInfo = "logInfo";
    public static final String pauseEmuWithStatus = "pauseEmuWithStatus";
    public static final boolean enableLineNumbers = true;
    private static final int idleSleepMicros = 1000;
    private static final Map<Integer, CodeBlock> codeBlocks;
    private static final Map<SceKernelThreadInfo, RuntimeThread> threads;
    private static final Map<SceKernelThreadInfo, RuntimeThread> toBeStoppedThreads;
    private static final Map<SceKernelThreadInfo, RuntimeThread> alreadyStoppedThreads;
    private static final List<Thread> alreadySwitchedStoppedThreads;
    private static final Map<SceKernelThreadInfo, RuntimeThread> toBeDeletedThreads;
    public static volatile SceKernelThreadInfo currentThread;
    private static volatile RuntimeThread currentRuntimeThread;
    private static final Object waitForEnd;
    private static volatile Emulator emulator;
    private static volatile boolean isIdle;
    private static volatile boolean reset;
    public static CpuDurationStatistics idleDuration;
    private static Map<Common.Instruction, Integer> instructionTypeCounts;
    public static boolean enableDaemonThreadSync;
    public static final String syncName = "sync";
    public static volatile boolean wantSync;
    private static RuntimeSyncThread runtimeSyncThread;
    private static RuntimeThread syscallRuntimeThread;
    private static sceDisplay sceDisplayModule;

    private static void setCompilerEnabled(boolean enabled) {
        compilerEnabled = enabled;
    }

    public static boolean isCompilerEnabled() {
        return compilerEnabled;
    }

    public static void execute(Common.Instruction insn, int opcode) {
        insn.interpret(processor, opcode);
    }

    private static int jumpCall(int address, int returnAddress, boolean isJump) throws Exception {
        IExecutable executable = RuntimeContext.getExecutable(address);
        if (executable == null) {
            log.error("RuntimeContext.jumpCall - Cannot find executable");
            throw new RuntimeException("Cannot find executable");
        }
        int returnValue = executable.exec(returnAddress, returnAddress, isJump);
        return returnValue;
    }

    public static int jump(int address, int returnAddress, int alternativeReturnAddress) throws Exception {
        int returnValue;
        if (IntrManager.getInstance().isInsideInterrupt() || currentRuntimeThread == null) {
            returnValue = RuntimeContext.jumpCall(address, returnAddress, true);
        } else {
            int sp = RuntimeContext.cpu.gpr[29];
            if (log.isTraceEnabled()) {
                log.trace(String.format("RuntimeContext.jump sp=0x%08X, stack=%s", sp, currentRuntimeThread.getStackString()));
            }
            if (currentRuntimeThread.hasStackState(address, sp)) {
                StackPopException e = new StackPopException(address, sp);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("RuntimeContext.jump throwing %s, returnAddress=0x%08X, stack=%s", e.toString(), returnAddress, currentRuntimeThread.getStackString()));
                }
                throw e;
            }
            int previousSp = currentRuntimeThread.pushStackState(returnAddress, sp);
            while (true) {
                try {
                    returnValue = RuntimeContext.jumpCall(address, returnAddress, true);
                }
                catch (StackPopException e) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("RuntimeContext.jump catched %s, returnAddress=0x%08X, stack=%s", e.toString(), returnAddress, currentRuntimeThread.getStackString()));
                    }
                    if (e.getRa() == returnAddress || e.getRa() == alternativeReturnAddress) {
                        returnValue = e.getRa();
                        break;
                    }
                    currentRuntimeThread.popStackState(returnAddress, previousSp);
                    throw e;
                }
                if (returnValue == returnAddress || returnValue == alternativeReturnAddress) break;
                if (currentRuntimeThread.hasStackState(returnValue, RuntimeContext.cpu.gpr[29])) {
                    e = new StackPopException(returnValue, RuntimeContext.cpu.gpr[29]);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("RuntimeContext.jump throwing %s, returnAddress=0x%08X, stack=%s", e.toString(), returnAddress, currentRuntimeThread.getStackString()));
                    }
                    currentRuntimeThread.popStackState(returnAddress, previousSp);
                    throw e;
                }
                address = returnValue;
            }
            currentRuntimeThread.popStackState(returnAddress, previousSp);
        }
        return returnValue;
    }

    public static void call(int address, int returnAddress) throws Exception {
        int returnValue = RuntimeContext.jumpCall(address, returnAddress, false);
        if (returnValue != returnAddress) {
            log.error(String.format("RuntimeContext.call incorrect returnAddress 0x%08X - 0x%08X", returnValue, returnAddress));
        }
    }

    public static int executeInterpreter(int address, int returnAddress, int alternativeReturnAddress, boolean isJump) throws Exception {
        boolean interpret = true;
        RuntimeContext.cpu.pc = address;
        int returnValue = returnAddress;
        while (interpret) {
            int opcode = cpu.fetchOpcode();
            Common.Instruction insn = Decoder.instruction(opcode);
            insn.interpret(processor, opcode);
            if (insn.hasFlags(64)) {
                RuntimeContext.cpu.pc = RuntimeContext.jumpCall(RuntimeContext.cpu.pc, RuntimeContext.cpu.gpr[31], false);
                continue;
            }
            if (!insn.hasFlags(128) || RuntimeContext.cpu.pc != returnAddress && RuntimeContext.cpu.pc != alternativeReturnAddress) continue;
            interpret = false;
            returnValue = RuntimeContext.cpu.pc;
        }
        return returnValue;
    }

    public static void execute(int opcode) {
        Common.Instruction insn = Decoder.instruction(opcode);
        RuntimeContext.execute(insn, opcode);
    }

    public static void debugCodeBlockStart(int address, int returnAddress, int alternativeReturnAddress, boolean isJump) {
        if (log.isDebugEnabled()) {
            int syscallOpcode;
            Common.Instruction syscallInstruction;
            String comment = "";
            int syscallAddress = address + 4;
            if (Memory.isAddressGood(syscallAddress) && (syscallInstruction = Decoder.instruction(syscallOpcode = memory.read32(syscallAddress))) == Instructions.SYSCALL) {
                String syscallDisasm = syscallInstruction.disasm(syscallAddress, syscallOpcode);
                comment = syscallDisasm.substring(19);
            }
            log.debug(String.format("Starting CodeBlock 0x%08X%s, returnAddress=0x%08X, alternativeReturnAddress=0x%08X, isJump=%b", address, comment, returnAddress, alternativeReturnAddress, isJump));
        }
    }

    public static void debugCodeBlockEnd(int address, int returnAddress) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Returning from CodeBlock 0x%08X to 0x%08X", address, returnAddress));
        }
    }

    public static void debugCodeInstruction(int address, int opcode) {
        if (log.isTraceEnabled()) {
            RuntimeContext.cpu.pc = address;
            Common.Instruction insn = Decoder.instruction(opcode);
            char compileFlag = insn.hasFlags(1) ? (char)'I' : 'C';
            log.trace(String.format("Executing 0x%08X %c - %s", address, Character.valueOf(compileFlag), insn.disasm(address, opcode)));
        }
    }

    private static boolean initialise() {
        if (!compilerEnabled) {
            return false;
        }
        if (enableDaemonThreadSync && runtimeSyncThread == null) {
            runtimeSyncThread = new RuntimeSyncThread();
            runtimeSyncThread.setName("Sync Daemon");
            runtimeSyncThread.setDaemon(true);
            runtimeSyncThread.start();
        }
        memoryInt = (int[])((memory = Emulator.getMemory()) instanceof FastMemory ? ((FastMemory)memory).getAll() : null);
        enableDebugger = State.debugger != null || memory instanceof DebuggerMemory;
        Profiler.initialise();
        sceDisplayModule = Modules.sceDisplayModule;
        return true;
    }

    public static boolean canExecuteCallback(SceKernelThreadInfo callbackThread) {
        RuntimeThread currentRuntimeThread;
        if (!compilerEnabled) {
            return true;
        }
        if (callbackThread == null) {
            return true;
        }
        if (Modules.ThreadManForUserModule.isIdleThread(callbackThread)) {
            return true;
        }
        Thread currentThread = Thread.currentThread();
        return currentThread instanceof RuntimeThread && callbackThread == (currentRuntimeThread = (RuntimeThread)currentThread).getThreadInfo();
    }

    private static void checkPendingCallbacks() {
        Modules.ThreadManForUserModule.checkPendingCallbacks();
    }

    public static void executeCallback() {
        int pc = RuntimeContext.cpu.pc;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Start of Callback 0x%08X", pc));
        }
        RuntimeContext.switchRealThread(Modules.ThreadManForUserModule.getCurrentThread());
        IExecutable executable = RuntimeContext.getExecutable(pc);
        int newPc = 0;
        int returnAddress = RuntimeContext.cpu.gpr[31];
        boolean callbackExited = false;
        try {
            newPc = executable.exec(returnAddress, returnAddress, false);
        }
        catch (StopThreadException e) {
        }
        catch (Exception e) {
            log.error("Catched Throwable in executeCallback:", e);
            callbackExited = true;
        }
        RuntimeContext.cpu.pc = newPc;
        RuntimeContext.cpu.npc = newPc;
        if (log.isDebugEnabled()) {
            log.debug(String.format("End of Callback 0x%08X", pc));
        }
        if (RuntimeContext.cpu.pc == 0x8000030 || callbackExited) {
            Modules.ThreadManForUserModule.hleKernelExitCallback(Emulator.getProcessor());
            wantSync = true;
        }
        RuntimeContext.update();
    }

    private static void updateStaticVariables() {
        emulator = Emulator.getInstance();
        processor = Emulator.getProcessor();
        cpu = RuntimeContext.processor.cpu;
        if (cpu != null) {
            gpr = RuntimeContext.processor.cpu.gpr;
            fpr = RuntimeContext.processor.cpu.fpr;
            vpr = RuntimeContext.processor.cpu.vpr;
        }
    }

    public static void update() {
        SceKernelThreadInfo newThread;
        if (!compilerEnabled) {
            return;
        }
        RuntimeContext.updateStaticVariables();
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (!IntrManager.getInstance().isInsideInterrupt() && (newThread = threadMan.getCurrentThread()) != null && newThread != currentThread) {
            RuntimeContext.switchThread(newThread);
        }
    }

    private static void switchRealThread(SceKernelThreadInfo threadInfo) {
        RuntimeThread thread = threads.get(threadInfo);
        if (thread == null) {
            thread = new RuntimeThread(threadInfo);
            threads.put(threadInfo, thread);
            thread.start();
        }
        currentThread = threadInfo;
        currentRuntimeThread = thread;
        isIdle = false;
    }

    private static void switchThread(SceKernelThreadInfo threadInfo) {
        if (log.isDebugEnabled()) {
            String name = threadInfo == null ? "Idle" : threadInfo.name;
            if (currentThread == null) {
                log.debug("Switching to Thread " + name);
            } else {
                log.debug("Switching from Thread " + RuntimeContext.currentThread.name + " to " + name);
            }
        }
        if (threadInfo == null || Modules.ThreadManForUserModule.isIdleThread(threadInfo)) {
            isIdle = true;
            currentThread = null;
            currentRuntimeThread = null;
        } else if (toBeStoppedThreads.containsKey(threadInfo)) {
            isIdle = true;
            currentThread = null;
            currentRuntimeThread = null;
        } else {
            RuntimeContext.switchRealThread(threadInfo);
        }
    }

    private static void syncIdle() throws StopThreadException {
        if (isIdle) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            Scheduler scheduler = Emulator.getScheduler();
            log.debug("Starting Idle State...");
            idleDuration.start();
            while (isIdle) {
                long delay;
                RuntimeContext.checkStoppedThread();
                idleDuration.end();
                RuntimeContext.syncEmulator(true);
                idleDuration.start();
                RuntimeContext.syncPause();
                RuntimeContext.checkPendingCallbacks();
                scheduler.step();
                if (threadMan.isIdleThread(threadMan.getCurrentThread())) {
                    threadMan.checkCallbacks();
                    threadMan.hleRescheduleCurrentThread();
                }
                if (!isIdle || (delay = scheduler.getNextActionDelay(1000L)) <= 0L) continue;
                int intDelay = delay >= 1000L ? 1000 : (int)delay;
                Utilities.sleep(intDelay / 1000, intDelay % 1000);
            }
            idleDuration.end();
            log.debug("Ending Idle State");
        }
    }

    private static void syncThreadImmediately() throws StopThreadException {
        Thread currentThread = Thread.currentThread();
        if (currentRuntimeThread != null && currentThread != currentRuntimeThread && !alreadySwitchedStoppedThreads.contains(currentThread)) {
            currentRuntimeThread.continueRuntimeExecution();
            if (currentThread instanceof RuntimeThread) {
                RuntimeThread runtimeThread = (RuntimeThread)currentThread;
                if (!alreadyStoppedThreads.containsValue(runtimeThread)) {
                    log.debug("Waiting to be scheduled...");
                    runtimeThread.suspendRuntimeExecution();
                    log.debug("Scheduled, restarting...");
                    RuntimeContext.checkStoppedThread();
                    RuntimeContext.updateStaticVariables();
                } else {
                    alreadySwitchedStoppedThreads.add(currentThread);
                }
            }
        }
        RuntimeContext.checkPendingCallbacks();
    }

    private static void syncThread() throws StopThreadException {
        RuntimeContext.syncIdle();
        if (toBeDeletedThreads.containsValue(RuntimeContext.getRuntimeThread())) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        if (log.isDebugEnabled()) {
            log.debug("syncThread currentThread=" + currentThread.getName() + ", currentRuntimeThread=" + currentRuntimeThread.getName());
        }
        RuntimeContext.syncThreadImmediately();
    }

    private static RuntimeThread getRuntimeThread() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof RuntimeThread) {
            return (RuntimeThread)currentThread;
        }
        return null;
    }

    private static boolean isStoppedThread() {
        if (toBeStoppedThreads.isEmpty()) {
            return false;
        }
        RuntimeThread runtimeThread = RuntimeContext.getRuntimeThread();
        return runtimeThread != null && toBeStoppedThreads.containsValue(runtimeThread) && !alreadyStoppedThreads.containsValue(runtimeThread);
    }

    private static void checkStoppedThread() throws StopThreadException {
        if (RuntimeContext.isStoppedThread()) {
            throw new StopThreadException("Stopping Thread " + Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncPause() throws StopThreadException {
        if (Emulator.pause) {
            Emulator.getClock().pause();
            try {
                Emulator emulator = RuntimeContext.emulator;
                synchronized (emulator) {
                    while (Emulator.pause) {
                        RuntimeContext.checkStoppedThread();
                        RuntimeContext.emulator.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                Emulator.getClock().resume();
            }
        }
    }

    public static void syncDebugger(int pc) throws StopThreadException {
        RuntimeContext.processor.cpu.pc = pc;
        if (State.debugger != null) {
            RuntimeContext.syncDebugger();
            RuntimeContext.syncPause();
        } else if (Emulator.pause) {
            RuntimeContext.syncPause();
        }
    }

    private static void syncDebugger() {
        if (State.debugger != null) {
            State.debugger.step();
        }
    }

    private static void syncEmulator(boolean immediately) {
        if (log.isDebugEnabled()) {
            log.debug("syncEmulator immediately=" + immediately);
        }
        Modules.sceGe_userModule.step();
        Modules.sceDisplayModule.step(immediately);
    }

    private static void syncFast() {
        Modules.sceDisplayModule.step();
    }

    public static void sync() throws StopThreadException {
        do {
            wantSync = false;
            if (IntrManager.getInstance().isInsideInterrupt()) {
                RuntimeContext.syncFast();
                continue;
            }
            RuntimeContext.syncPause();
            Emulator.getScheduler().step();
            if (Interrupts.isInterruptsEnabled()) {
                Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
            }
            RuntimeContext.syncThread();
            RuntimeContext.syncEmulator(false);
            RuntimeContext.syncDebugger();
            RuntimeContext.syncPause();
            RuntimeContext.checkStoppedThread();
        } while (wantSync);
    }

    public static void preSyscall() throws StopThreadException {
        if (!IntrManager.getInstance().isInsideInterrupt()) {
            syscallRuntimeThread = RuntimeContext.getRuntimeThread();
            if (syscallRuntimeThread != null) {
                syscallRuntimeThread.setInSyscall(true);
            }
            RuntimeContext.checkStoppedThread();
            RuntimeContext.syncPause();
        }
    }

    public static void postSyscall() throws StopThreadException {
        if (IntrManager.getInstance().isInsideInterrupt()) {
            RuntimeContext.postSyscallFast();
        } else {
            RuntimeContext.checkStoppedThread();
            RuntimeContext.sync();
            if (syscallRuntimeThread != null) {
                syscallRuntimeThread.setInSyscall(false);
            }
        }
    }

    public static void postSyscallFast() {
        RuntimeContext.syncFast();
    }

    public static void syscallFast(int code) {
        SyscallHandler.syscall(code);
        RuntimeContext.postSyscallFast();
    }

    public static void syscall(int code) throws StopThreadException {
        RuntimeContext.preSyscall();
        SyscallHandler.syscall(code);
        RuntimeContext.postSyscall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runThread(RuntimeThread thread) {
        thread.setInSyscall(true);
        if (RuntimeContext.isStoppedThread()) {
            return;
        }
        thread.suspendRuntimeExecution();
        if (RuntimeContext.isStoppedThread()) {
            return;
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        IExecutable executable = RuntimeContext.getExecutable(RuntimeContext.processor.cpu.pc);
        thread.setInSyscall(false);
        try {
            RuntimeContext.updateStaticVariables();
            executable.exec(0x8000020, 0, false);
            threadMan.hleKernelExitThread(processor);
        }
        catch (StopThreadException e) {
        }
        catch (Throwable e) {
            log.error("Catched Throwable in RuntimeThread:", e);
            e.printStackTrace();
        }
        SceKernelThreadInfo threadInfo = thread.getThreadInfo();
        alreadyStoppedThreads.put(threadInfo, thread);
        if (log.isDebugEnabled()) {
            log.debug("End of Thread " + threadInfo.name + " - stopped");
        }
        thread.setInSyscall(true);
        threads.remove(threadInfo);
        toBeStoppedThreads.remove(threadInfo);
        toBeDeletedThreads.remove(threadInfo);
        if (!reset) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("End of Thread " + threadInfo.name + " - sync");
                }
                RuntimeContext.syncIdle();
                RuntimeContext.syncThreadImmediately();
            }
            catch (StopThreadException e) {
                // empty catch block
            }
        }
        alreadyStoppedThreads.remove(threadInfo);
        alreadySwitchedStoppedThreads.remove(thread);
        if (log.isDebugEnabled()) {
            log.debug("End of Thread " + thread.getName());
        }
        Object object = waitForEnd;
        synchronized (object) {
            waitForEnd.notify();
        }
    }

    public static CodeBlock addCodeBlock(int address, CodeBlock codeBlock) {
        return codeBlocks.put(address, codeBlock);
    }

    public static CodeBlock getCodeBlock(int address) {
        return codeBlocks.get(address);
    }

    public static boolean hasCodeBlock(int address) {
        return codeBlocks.containsKey(address);
    }

    public static Map<Integer, CodeBlock> getCodeBlocks() {
        return codeBlocks;
    }

    public static IExecutable getExecutable(int address) {
        CodeBlock codeBlock = codeBlocks.get(address);
        IExecutable executable = codeBlock == null ? Compiler.getInstance().compile(address) : codeBlock.getExecutable();
        return executable;
    }

    public static void start() {
        Settings.getInstance().registerSettingsListener("RuntimeContext", "emu.compiler", new CompilerEnabledSettingsListerner());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run() {
        if (Modules.ThreadManForUserModule.exitCalled) {
            return;
        }
        if (!RuntimeContext.initialise()) {
            compilerEnabled = false;
            return;
        }
        log.info("Using Compiler");
        while (!toBeStoppedThreads.isEmpty()) {
            RuntimeContext.wakeupToBeStoppedThreads();
            Utilities.sleep(1000);
        }
        reset = false;
        if (currentRuntimeThread == null) {
            try {
                RuntimeContext.syncIdle();
            }
            catch (StopThreadException e) {
                return;
            }
            if (currentRuntimeThread == null) {
                log.error("RuntimeContext.run: nothing to run!");
                Emulator.PauseEmuWithStatus(-1);
                return;
            }
        }
        RuntimeContext.update();
        if (RuntimeContext.processor.cpu.pc == 0) {
            Emulator.PauseEmuWithStatus(-1);
            return;
        }
        currentRuntimeThread.continueRuntimeExecution();
        while (!threads.isEmpty() && !reset) {
            Object object = waitForEnd;
            synchronized (object) {
                try {
                    waitForEnd.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        log.debug("End of run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RuntimeThread> wakeupToBeStoppedThreads() {
        LinkedList<RuntimeThread> threadList = new LinkedList<RuntimeThread>();
        Object object = toBeStoppedThreads;
        synchronized (object) {
            for (Map.Entry<SceKernelThreadInfo, RuntimeThread> entry : toBeStoppedThreads.entrySet()) {
                threadList.add(entry.getValue());
            }
        }
        for (RuntimeThread runtimeThread : threadList) {
            Thread.State threadState = runtimeThread.getState();
            log.debug("Thread " + runtimeThread.getName() + ", State=" + (Object)((Object)threadState));
            if (threadState == Thread.State.TERMINATED) {
                toBeStoppedThreads.remove(runtimeThread.getThreadInfo());
                continue;
            }
            if (threadState != Thread.State.WAITING) continue;
            runtimeThread.continueRuntimeExecution();
        }
        object = Emulator.getInstance();
        synchronized (object) {
            Emulator.getInstance().notifyAll();
        }
        return threadList;
    }

    public static void onThreadDeleted(SceKernelThreadInfo thread) {
        RuntimeThread runtimeThread = threads.get(thread);
        if (runtimeThread != null) {
            if (log.isDebugEnabled()) {
                log.debug("Deleting Thread " + thread.toString());
            }
            toBeStoppedThreads.put(thread, runtimeThread);
            if (runtimeThread.isInSyscall() && Thread.currentThread() != runtimeThread) {
                toBeDeletedThreads.put(thread, runtimeThread);
                log.debug("Continue Thread " + runtimeThread.getName());
                runtimeThread.continueRuntimeExecution();
            }
        }
    }

    public static void onThreadExit(SceKernelThreadInfo thread) {
        RuntimeThread runtimeThread = threads.get(thread);
        if (runtimeThread != null) {
            if (log.isDebugEnabled()) {
                log.debug("Exiting Thread " + thread.toString());
            }
            toBeStoppedThreads.put(thread, runtimeThread);
            threads.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopAllThreads() {
        Map<SceKernelThreadInfo, RuntimeThread> map = threads;
        synchronized (map) {
            toBeStoppedThreads.putAll(threads);
            threads.clear();
        }
        List<RuntimeThread> threadList = RuntimeContext.wakeupToBeStoppedThreads();
        boolean waitForThreads = true;
        while (waitForThreads) {
            waitForThreads = false;
            for (RuntimeThread runtimeThread : threadList) {
                if (runtimeThread.isInSyscall()) continue;
                waitForThreads = true;
                break;
            }
            if (!waitForThreads) continue;
            Utilities.sleep(1000);
        }
    }

    public static void exit() {
        if (compilerEnabled) {
            log.debug("RuntimeContext.exit");
            RuntimeContext.stopAllThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        if (compilerEnabled) {
            log.debug("RuntimeContext.reset");
            Compiler.getInstance().reset();
            codeBlocks.clear();
            currentThread = null;
            currentRuntimeThread = null;
            RuntimeContext.stopAllThreads();
            reset = true;
            Object object = waitForEnd;
            synchronized (object) {
                waitForEnd.notify();
            }
        }
    }

    public static void invalidateAll() {
        if (compilerEnabled) {
            log.debug("RuntimeContext.invalidateAll");
            codeBlocks.clear();
            Compiler.getInstance().invalidateAll();
        }
    }

    public static void invalidateRange(int addr, int size) {
        if (compilerEnabled) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("RuntimeContext.invalidateRange(addr=0x%08X, size=%d)", addr, size));
            }
            for (CodeBlock codeBlock : codeBlocks.values()) {
                if (codeBlock.getLowestAddress() >= addr && codeBlock.getLowestAddress() < addr + size) {
                    Compiler.getInstance().invalidateCodeBlock(codeBlock);
                    continue;
                }
                if (codeBlock.getHighestAddress() < addr || codeBlock.getHighestAddress() >= addr + size) continue;
                Compiler.getInstance().invalidateCodeBlock(codeBlock);
            }
        }
    }

    public static void instructionTypeCount(Common.Instruction insn, int opcode) {
        int count = 0;
        if (instructionTypeCounts.containsKey(insn)) {
            count = instructionTypeCounts.get(insn);
        }
        instructionTypeCounts.put(insn, ++count);
    }

    public static void pauseEmuWithStatus(int status) throws StopThreadException {
        Emulator.PauseEmuWithStatus(status);
        RuntimeContext.syncPause();
    }

    public static void logInfo(String message) {
        log.info(message);
    }

    public static boolean checkMemoryPointer(int address) {
        return Memory.isAddressGood(address) || Memory.isRawAddressGood(memory.normalizeAddress(address));
    }

    public static int checkMemoryRead32(int address, int pc) throws StopThreadException {
        int rawAddress = address & 0x3FFFFFFF;
        if (!Memory.isRawAddressGood(rawAddress)) {
            if (memory.read32AllowedInvalidAddress(rawAddress)) {
                rawAddress = 0;
            } else {
                int normalizedAddress = memory.normalizeAddress(address);
                if (Memory.isRawAddressGood(normalizedAddress)) {
                    rawAddress = normalizedAddress;
                } else {
                    RuntimeContext.processor.cpu.pc = pc;
                    memory.invalidMemoryAddress(address, "read32", 4);
                    RuntimeContext.syncPause();
                    rawAddress = 0;
                }
            }
        }
        return rawAddress;
    }

    public static int checkMemoryRead16(int address, int pc) throws StopThreadException {
        int rawAddress = address & 0x3FFFFFFF;
        if (!Memory.isRawAddressGood(rawAddress)) {
            int normalizedAddress = memory.normalizeAddress(address);
            if (Memory.isRawAddressGood(normalizedAddress)) {
                rawAddress = normalizedAddress;
            } else {
                RuntimeContext.processor.cpu.pc = pc;
                memory.invalidMemoryAddress(address, "read16", 4);
                RuntimeContext.syncPause();
                rawAddress = 0;
            }
        }
        return rawAddress;
    }

    public static int checkMemoryRead8(int address, int pc) throws StopThreadException {
        int rawAddress = address & 0x3FFFFFFF;
        if (!Memory.isRawAddressGood(rawAddress)) {
            int normalizedAddress = memory.normalizeAddress(address);
            if (Memory.isRawAddressGood(normalizedAddress)) {
                rawAddress = normalizedAddress;
            } else {
                RuntimeContext.processor.cpu.pc = pc;
                memory.invalidMemoryAddress(address, "read8", 4);
                RuntimeContext.syncPause();
                rawAddress = 0;
            }
        }
        return rawAddress;
    }

    public static int checkMemoryWrite32(int address, int pc) throws StopThreadException {
        int rawAddress = address & 0x3FFFFFFF;
        if (!Memory.isRawAddressGood(rawAddress)) {
            int normalizedAddress = memory.normalizeAddress(address);
            if (Memory.isRawAddressGood(normalizedAddress)) {
                rawAddress = normalizedAddress;
            } else {
                RuntimeContext.processor.cpu.pc = pc;
                memory.invalidMemoryAddress(address, "write32", 8);
                RuntimeContext.syncPause();
                rawAddress = 0;
            }
        }
        sceDisplayModule.write32(rawAddress);
        return rawAddress;
    }

    public static int checkMemoryWrite16(int address, int pc) throws StopThreadException {
        int rawAddress = address & 0x3FFFFFFF;
        if (!Memory.isRawAddressGood(rawAddress)) {
            int normalizedAddress = memory.normalizeAddress(address);
            if (Memory.isRawAddressGood(normalizedAddress)) {
                rawAddress = normalizedAddress;
            } else {
                RuntimeContext.processor.cpu.pc = pc;
                memory.invalidMemoryAddress(address, "write16", 8);
                RuntimeContext.syncPause();
                rawAddress = 0;
            }
        }
        sceDisplayModule.write16(rawAddress);
        return rawAddress;
    }

    public static int checkMemoryWrite8(int address, int pc) throws StopThreadException {
        int rawAddress = address & 0x3FFFFFFF;
        if (!Memory.isRawAddressGood(rawAddress)) {
            int normalizedAddress = memory.normalizeAddress(address);
            if (Memory.isRawAddressGood(normalizedAddress)) {
                rawAddress = normalizedAddress;
            } else {
                RuntimeContext.processor.cpu.pc = pc;
                memory.invalidMemoryAddress(address, "write8", 8);
                RuntimeContext.syncPause();
                rawAddress = 0;
            }
        }
        sceDisplayModule.write8(rawAddress);
        return rawAddress;
    }

    public static void debugMemoryReadWrite(int address, int value, int pc, boolean isRead, int width) {
        if (log.isTraceEnabled()) {
            StringBuilder message = new StringBuilder();
            message.append(String.format("0x%08X - ", pc));
            if (isRead) {
                message.append(String.format("read%d(0x%08X)=0x", width, address));
                if (width == 8) {
                    message.append(String.format("%02X", memory.read8(address)));
                } else if (width == 16) {
                    message.append(String.format("%04X", memory.read16(address)));
                } else if (width == 32) {
                    message.append(String.format("%08X (%f)", memory.read32(address), Float.valueOf(Float.intBitsToFloat(memory.read32(address)))));
                }
            } else {
                message.append(String.format("write%d(0x%08X, 0x", width, address));
                if (width == 8) {
                    message.append(String.format("%02X", value));
                } else if (width == 16) {
                    message.append(String.format("%04X", value));
                } else if (width == 32) {
                    message.append(String.format("%08X (%f)", value, Float.valueOf(Float.intBitsToFloat(value))));
                }
                message.append(")");
            }
            log.trace(message.toString());
        }
    }

    public static void onNextScheduleModified() {
        RuntimeContext.checkSync(false);
    }

    private static void checkSync(boolean sleep) {
        long delay = Emulator.getScheduler().getNextActionDelay(1000L);
        if (delay > 0L) {
            if (sleep) {
                int intDelay = (int)delay;
                Utilities.sleep(intDelay / 1000, intDelay % 1000);
            }
        } else if (wantSync) {
            if (sleep) {
                Utilities.sleep(1000);
            }
        } else {
            wantSync = true;
        }
    }

    public static boolean syncDaemonStep() {
        RuntimeContext.checkSync(true);
        return enableDaemonThreadSync;
    }

    public static void exitSyncDaemon() {
        runtimeSyncThread = null;
    }

    public static void setIsHomebrew(boolean isHomebrew) {
    }

    static {
        enableDebugger = true;
        codeBlocks = Collections.synchronizedMap(new HashMap());
        threads = Collections.synchronizedMap(new HashMap());
        toBeStoppedThreads = Collections.synchronizedMap(new HashMap());
        alreadyStoppedThreads = Collections.synchronizedMap(new HashMap());
        alreadySwitchedStoppedThreads = Collections.synchronizedList(new ArrayList());
        toBeDeletedThreads = Collections.synchronizedMap(new HashMap());
        currentThread = null;
        currentRuntimeThread = null;
        waitForEnd = new Object();
        isIdle = false;
        reset = false;
        idleDuration = new CpuDurationStatistics("Idle Time");
        instructionTypeCounts = Collections.synchronizedMap(new HashMap());
        enableDaemonThreadSync = true;
        wantSync = false;
        runtimeSyncThread = null;
    }

    private static class CompilerEnabledSettingsListerner
    extends AbstractBoolSettingsListener {
        private CompilerEnabledSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            RuntimeContext.setCompilerEnabled(value);
        }
    }
}

