/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Semaphore;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;

public class RuntimeThread
extends Thread {
    private Semaphore semaphore = new Semaphore(1);
    private SceKernelThreadInfo threadInfo;
    private boolean isInSyscall;
    private JumpState[] stack = new JumpState[0];
    private int stackIndex = -1;

    public RuntimeThread(SceKernelThreadInfo threadInfo) {
        this.threadInfo = threadInfo;
        threadInfo.javaThreadId = this.getId();
        this.isInSyscall = false;
        if (RuntimeContext.log.isDebugEnabled()) {
            this.setName(threadInfo.name + "_" + Integer.toHexString(threadInfo.uid));
        } else {
            this.setName(threadInfo.name);
        }
        this.suspendRuntimeExecution();
    }

    @Override
    public void run() {
        RuntimeContext.runThread(this);
        this.setInSyscall(true);
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean.isThreadCpuTimeEnabled()) {
            this.threadInfo.javaThreadCpuTimeNanos = threadMXBean.getCurrentThreadCpuTime();
        }
    }

    public void suspendRuntimeExecution() {
        boolean acquired = false;
        while (!acquired) {
            try {
                this.semaphore.acquire();
                acquired = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void continueRuntimeExecution() {
        this.semaphore.release();
    }

    public SceKernelThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    public boolean isInSyscall() {
        return this.isInSyscall;
    }

    public void setInSyscall(boolean isInSyscall) {
        this.isInSyscall = isInSyscall;
    }

    public int pushStackState(int ra, int sp) {
        for (int i = this.stackIndex; i >= 0; --i) {
            JumpState state = this.stack[i];
            if (state.ra != ra) continue;
            int previousSp = state.sp;
            state.sp = sp;
            return previousSp;
        }
        ++this.stackIndex;
        if (this.stackIndex == this.stack.length) {
            JumpState[] newStack = new JumpState[this.stack.length + 1];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            newStack[this.stack.length] = new JumpState();
            this.stack = newStack;
        }
        this.stack[this.stackIndex].setState(ra, sp);
        return 0;
    }

    public void popStackState(int ra, int previousSp) {
        if (previousSp != 0) {
            for (int i = this.stackIndex; i >= 0; --i) {
                JumpState state = this.stack[i];
                if (state.ra != ra) continue;
                state.sp = previousSp;
                return;
            }
        }
        --this.stackIndex;
    }

    public boolean hasStackState(int ra, int sp) {
        for (int i = this.stackIndex; i >= 0; --i) {
            JumpState state = this.stack[i];
            if (state.ra != ra) continue;
            return true;
        }
        return false;
    }

    public String getStackString() {
        StringBuilder result = new StringBuilder();
        for (int i = this.stackIndex; i >= 0; --i) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(this.stack[i].toString());
        }
        return result.toString();
    }

    public static class JumpState {
        public int ra;
        public int sp;

        public void setState(int ra, int sp) {
            this.ra = ra;
            this.sp = sp;
        }

        public String toString() {
            return String.format("(ra=0x%08X, sp=0x%08X)", this.ra, this.sp);
        }
    }
}

