/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.compiler.CodeBlock;
import jpcsp.Allegrex.compiler.CodeInstruction;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.nativeCode.INativeCodeSequence;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeSequence;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.util.Utilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NativeCodeManager {
    private static int defaultOpcodeMask = -1;
    private HashMap<Integer, List<NativeCodeSequence>> nativeCodeSequencesByFirstOpcode;
    private List<NativeCodeSequence> nativeCodeSequenceWithMaskInFirstOpcode;
    private HashMap<Integer, NativeCodeSequence> compiledNativeCodeBlocks = new HashMap();

    public NativeCodeManager(Element configuration) {
        this.nativeCodeSequencesByFirstOpcode = new HashMap();
        this.nativeCodeSequenceWithMaskInFirstOpcode = new LinkedList<NativeCodeSequence>();
        this.load(configuration);
    }

    public void reset() {
        this.compiledNativeCodeBlocks.clear();
    }

    private Class<INativeCodeSequence> getNativeCodeSequenceClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Compiler.log.error(e);
            return null;
        }
    }

    private String getContent(Node node) {
        if (node.hasChildNodes()) {
            return this.getContent(node.getChildNodes());
        }
        return node.getNodeValue();
    }

    private String getContent(NodeList nodeList) {
        if (nodeList == null || nodeList.getLength() <= 0) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            content.append(this.getContent(node));
        }
        return content.toString();
    }

    private void loadBeforeCodeInstructions(NativeCodeSequence nativeCodeSequence, String codeInstructions) {
        BufferedReader reader = new BufferedReader(new StringReader(codeInstructions));
        if (reader == null) {
            return;
        }
        Pattern codeInstructionPattern = Pattern.compile("\\s*(\\w+\\s*:?\\s*)?\\[(\\p{XDigit}+)\\].*");
        int opcodeGroup = 2;
        boolean address = false;
        block4: while (true) {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    try {
                        Matcher codeInstructionMatcher = codeInstructionPattern.matcher(line);
                        int opcode = 0;
                        opcode = codeInstructionMatcher.matches() ? Utilities.parseAddress(codeInstructionMatcher.group(2)) : Utilities.parseAddress(line.trim());
                        Common.Instruction insn = Decoder.instruction(opcode);
                        CodeInstruction codeInstruction = new CodeInstruction(0, opcode, insn, false, false, 0);
                        nativeCodeSequence.addBeforeCodeInstruction(codeInstruction);
                        continue block4;
                    }
                    catch (NumberFormatException e) {
                        Compiler.log.error(e);
                    }
                }
                break;
            }
            catch (IOException e) {
                Compiler.log.error(e);
                break;
            }
        }
    }

    private void loadNativeCodeOpcodes(NativeCodeSequence nativeCodeSequence, String codeInstructions) {
        BufferedReader reader = new BufferedReader(new StringReader(codeInstructions));
        if (reader == null) {
            return;
        }
        Pattern codeInstructionPattern = Pattern.compile("\\s*((\\w+)\\s*:?\\s*)?\\[(\\p{XDigit}+)(/(\\p{XDigit}+))?\\].*");
        int labelGroup = 2;
        int opcodeGroup = 3;
        int opcodeMaskGroup = 5;
        block4: while (true) {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    try {
                        Matcher codeInstructionMatcher = codeInstructionPattern.matcher(line);
                        int opcode = 0;
                        int mask = defaultOpcodeMask;
                        String label = null;
                        if (codeInstructionMatcher.matches()) {
                            opcode = Utilities.parseAddress(codeInstructionMatcher.group(3));
                            String opcodeMaskString = codeInstructionMatcher.group(5);
                            if (opcodeMaskString != null) {
                                mask = Utilities.parseAddress(opcodeMaskString);
                            }
                            label = codeInstructionMatcher.group(2);
                        } else {
                            opcode = Utilities.parseAddress(line.trim());
                        }
                        nativeCodeSequence.addOpcode(opcode, mask, label);
                        continue block4;
                    }
                    catch (NumberFormatException e) {
                        Compiler.log.error(e);
                    }
                }
                break;
            }
            catch (IOException e) {
                Compiler.log.error(e);
                break;
            }
        }
    }

    private void setParameter(NativeCodeSequence nativeCodeSequence, int parameter, String valueString) {
        String label;
        int labelIndex;
        int i;
        if (valueString == null || valueString.length() <= 0) {
            nativeCodeSequence.setParameter(parameter, 0, false);
            return;
        }
        for (i = 0; i < Common.gprNames.length; ++i) {
            if (!Common.gprNames[i].equals(valueString)) continue;
            nativeCodeSequence.setParameter(parameter, i, false);
            return;
        }
        for (i = 0; i < Common.fprNames.length; ++i) {
            if (!Common.fprNames[i].equals(valueString)) continue;
            nativeCodeSequence.setParameter(parameter, i, false);
            return;
        }
        if (valueString.startsWith("@") && (labelIndex = nativeCodeSequence.getLabelIndex(label = valueString.substring(1))) >= 0) {
            nativeCodeSequence.setParameter(parameter, labelIndex, true);
            return;
        }
        try {
            int value = valueString.startsWith("0x") ? Integer.parseInt(valueString.substring(2), 16) : Integer.parseInt(valueString);
            nativeCodeSequence.setParameter(parameter, value, false);
        }
        catch (NumberFormatException e) {
            Compiler.log.error(e);
        }
    }

    private void loadNativeCodeSequence(Element element) {
        String beforeCodeInstructions;
        String branchInstructionLabel;
        String methodName;
        String wholeCodeBlockString;
        String name = element.getAttribute("name");
        String className = this.getContent(element.getElementsByTagName("Class"));
        Class<INativeCodeSequence> nativeCodeSequenceClass = this.getNativeCodeSequenceClass(className);
        if (nativeCodeSequenceClass == null) {
            return;
        }
        NativeCodeSequence nativeCodeSequence = new NativeCodeSequence(name, nativeCodeSequenceClass);
        String isReturningString = this.getContent(element.getElementsByTagName("IsReturning"));
        if (isReturningString != null) {
            nativeCodeSequence.setReturning(Boolean.parseBoolean(isReturningString));
        }
        if ((wholeCodeBlockString = this.getContent(element.getElementsByTagName("WholeCodeBlock"))) != null) {
            nativeCodeSequence.setWholeCodeBlock(Boolean.parseBoolean(wholeCodeBlockString));
        }
        if ((methodName = this.getContent(element.getElementsByTagName("Method"))) != null) {
            nativeCodeSequence.setMethodName(methodName);
        }
        String codeInstructions = this.getContent(element.getElementsByTagName("CodeInstructions"));
        this.loadNativeCodeOpcodes(nativeCodeSequence, codeInstructions);
        String parametersList = this.getContent(element.getElementsByTagName("Parameters"));
        if (parametersList != null) {
            String[] parameters = parametersList.split(" *, *");
            for (int parameter = 0; parameters != null && parameter < parameters.length; ++parameter) {
                this.setParameter(nativeCodeSequence, parameter, parameters[parameter].trim());
            }
        }
        if ((branchInstructionLabel = this.getContent(element.getElementsByTagName("BranchInstruction"))) != null) {
            int branchInstructionOffset;
            if (branchInstructionLabel.startsWith("@")) {
                branchInstructionLabel = branchInstructionLabel.substring(1);
            }
            if ((branchInstructionOffset = nativeCodeSequence.getLabelIndex(branchInstructionLabel.trim())) >= 0) {
                nativeCodeSequence.setBranchInstruction(branchInstructionOffset);
            } else {
                Compiler.log.error(String.format("BranchInstruction: label '%s' not found", branchInstructionLabel));
            }
        }
        if ((beforeCodeInstructions = this.getContent(element.getElementsByTagName("BeforeCodeInstructions"))) != null) {
            this.loadBeforeCodeInstructions(nativeCodeSequence, beforeCodeInstructions);
        }
        this.addNativeCodeSequence(nativeCodeSequence);
    }

    private void load(Element configuration) {
        if (configuration == null) {
            return;
        }
        NodeList nativeCodeBlocks = configuration.getElementsByTagName("NativeCodeSequence");
        int n = nativeCodeBlocks.getLength();
        for (int i = 0; i < n; ++i) {
            Element nativeCodeSequence = (Element)nativeCodeBlocks.item(i);
            this.loadNativeCodeSequence(nativeCodeSequence);
        }
    }

    private void addNativeCodeSequence(NativeCodeSequence nativeCodeSequence) {
        if (nativeCodeSequence.getNumOpcodes() > 0) {
            int firstOpcodeMask = nativeCodeSequence.getFirstOpcodeMask();
            if (firstOpcodeMask == defaultOpcodeMask) {
                int firstOpcode = nativeCodeSequence.getFirstOpcode();
                if (!this.nativeCodeSequencesByFirstOpcode.containsKey(firstOpcode)) {
                    this.nativeCodeSequencesByFirstOpcode.put(firstOpcode, new LinkedList());
                }
                this.nativeCodeSequencesByFirstOpcode.get(firstOpcode).add(nativeCodeSequence);
            } else {
                this.nativeCodeSequenceWithMaskInFirstOpcode.add(nativeCodeSequence);
            }
        }
    }

    public void setCompiledNativeCodeBlock(int address, NativeCodeSequence nativeCodeBlock) {
        this.compiledNativeCodeBlocks.put(address, nativeCodeBlock);
    }

    public NativeCodeSequence getCompiledNativeCodeBlock(int address) {
        return this.compiledNativeCodeBlocks.get(address);
    }

    private boolean isNativeCodeSequence(NativeCodeSequence nativeCodeSequence, CodeInstruction codeInstruction, CodeBlock codeBlock) {
        int address = codeInstruction.getAddress();
        int numOpcodes = nativeCodeSequence.getNumOpcodes();
        if (nativeCodeSequence.isWholeCodeBlock()) {
            if (codeBlock.getStartAddress() != address) {
                return false;
            }
            if (codeBlock.getLength() != numOpcodes) {
                return false;
            }
        }
        IMemoryReader codeBlockReader = MemoryReader.getMemoryReader(address, 4);
        for (int i = 0; i < numOpcodes; ++i) {
            int opcode = codeBlockReader.readNext();
            if (nativeCodeSequence.isMatching(i, opcode)) continue;
            return false;
        }
        return true;
    }

    public NativeCodeSequence getNativeCodeSequence(CodeInstruction codeInstruction, CodeBlock codeBlock) {
        int firstOpcode = codeInstruction.getOpcode();
        if (this.nativeCodeSequencesByFirstOpcode.containsKey(firstOpcode)) {
            for (NativeCodeSequence nativeCodeSequence : this.nativeCodeSequencesByFirstOpcode.get(firstOpcode)) {
                if (!this.isNativeCodeSequence(nativeCodeSequence, codeInstruction, codeBlock)) continue;
                return nativeCodeSequence;
            }
        }
        for (NativeCodeSequence nativeCodeSequence : this.nativeCodeSequenceWithMaskInFirstOpcode) {
            if (!this.isNativeCodeSequence(nativeCodeSequence, codeInstruction, codeBlock)) continue;
            return nativeCodeSequence;
        }
        return null;
    }
}

