/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import jpcsp.HLE.Modules;
import jpcsp.hardware.Audio;
import jpcsp.settings.Settings;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;

public class Controller {
    public static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger("controller");
    private static Controller instance;
    public static final byte analogCenter = -128;
    private byte Lx = (byte)-128;
    private byte Ly = (byte)-128;
    private int Buttons = 0;
    private keyCode lastKey = keyCode.RELEASED;
    private net.java.games.input.Controller inputController;
    private HashMap<Component.Identifier, Integer> buttonComponents;
    private Component.Identifier analogXAxis = Component.Identifier.Axis.X;
    private Component.Identifier analogYAxis = Component.Identifier.Axis.Y;
    private Component.Identifier digitalXAxis = null;
    private Component.Identifier digitalYAxis = null;
    private Component.Identifier povArrows = Component.Identifier.Axis.POV;
    private static final float minimumDeadZone = 0.1f;
    private HashMap<keyCode, String> controllerComponents;
    private HashMap<Integer, keyCode> keys;

    protected Controller(net.java.games.input.Controller inputController) {
        this.inputController = inputController;
        this.keys = new HashMap(22);
        this.controllerComponents = new HashMap(22);
        this.loadKeyConfig();
        this.loadControllerConfig();
    }

    public static boolean isKeyboardController(net.java.games.input.Controller inputController) {
        return inputController == null || inputController.getType() == Controller.Type.KEYBOARD;
    }

    public static Controller getInstance() {
        if (instance == null) {
            int i;
            Logger.getLogger("net.java.games.input.DefaultControllerEnvironment").setLevel(Level.WARNING);
            ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
            net.java.games.input.Controller[] controllers = ce.getControllers();
            net.java.games.input.Controller inputController = null;
            String controllerName = Settings.getInstance().readString("controller.controllerName");
            int controllerNameIndex = Settings.getInstance().readInt("controller.controllerNameIndex", 0);
            if (controllerName != null) {
                for (i = 0; controllers != null && i < controllers.length; ++i) {
                    if (!controllerName.equals(controllers[i].getName())) continue;
                    inputController = controllers[i];
                    if (controllerNameIndex <= 0) break;
                    --controllerNameIndex;
                }
            }
            if (inputController == null) {
                for (i = 0; controllers != null && i < controllers.length; ++i) {
                    if (!Controller.isKeyboardController(controllers[i])) continue;
                    inputController = controllers[i];
                    break;
                }
            }
            if (inputController == null) {
                log.info(String.format("No KEYBOARD controller found", new Object[0]));
                for (i = 0; controllers != null && i < controllers.length; ++i) {
                    log.info(String.format("    Controller: '%s'", controllers[i].getName()));
                }
            } else {
                log.info(String.format("Using default controller '%s'", inputController.getName()));
            }
            instance = new Controller(inputController);
        }
        return instance;
    }

    public void setInputController(net.java.games.input.Controller inputController) {
        if (inputController != null) {
            log.info(String.format("Using controller '%s'", inputController.getName()));
        }
        this.inputController = inputController;
        this.onInputControllerChanged();
    }

    public net.java.games.input.Controller getInputController() {
        return this.inputController;
    }

    public void setInputControllerIndex(int index) {
        ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
        net.java.games.input.Controller[] controllers = ce.getControllers();
        if (controllers != null && index >= 0 && index < controllers.length) {
            this.setInputController(controllers[index]);
        }
    }

    public void loadKeyConfig() {
        this.loadKeyConfig(Settings.getInstance().loadKeys());
    }

    public void loadKeyConfig(HashMap<Integer, keyCode> newLayout) {
        this.keys.clear();
        this.keys.putAll(newLayout);
    }

    public void loadControllerConfig() {
        this.loadControllerConfig(Settings.getInstance().loadController());
    }

    public void loadControllerConfig(HashMap<keyCode, String> newLayout) {
        this.controllerComponents.clear();
        this.controllerComponents.putAll(newLayout);
        this.onInputControllerChanged();
    }

    private void onInputControllerChanged() {
        this.buttonComponents = new HashMap();
        for (Map.Entry<keyCode, String> entry : this.controllerComponents.entrySet()) {
            keyCode key = entry.getKey();
            String controllerName = entry.getValue();
            Component component = this.getControllerComponentByName(controllerName);
            if (component == null) continue;
            Component.Identifier identifier = component.getIdentifier();
            boolean isButton = identifier instanceof Component.Identifier.Button;
            boolean isAxis = identifier instanceof Component.Identifier.Axis;
            if (isButton) {
                int keyCode2 = -1;
                switch (key) {
                    case DOWN: {
                        keyCode2 = 64;
                        break;
                    }
                    case UP: {
                        keyCode2 = 16;
                        break;
                    }
                    case LEFT: {
                        keyCode2 = 128;
                        break;
                    }
                    case RIGHT: {
                        keyCode2 = 32;
                        break;
                    }
                    case TRIANGLE: {
                        keyCode2 = 4096;
                        break;
                    }
                    case SQUARE: {
                        keyCode2 = 32768;
                        break;
                    }
                    case CIRCLE: {
                        keyCode2 = 8192;
                        break;
                    }
                    case CROSS: {
                        keyCode2 = 16384;
                        break;
                    }
                    case L1: {
                        keyCode2 = 256;
                        break;
                    }
                    case R1: {
                        keyCode2 = 512;
                        break;
                    }
                    case START: {
                        keyCode2 = 8;
                        break;
                    }
                    case SELECT: {
                        keyCode2 = 1;
                        break;
                    }
                    case HOME: {
                        keyCode2 = 65536;
                        break;
                    }
                    case HOLD: {
                        keyCode2 = 131072;
                        break;
                    }
                    case VOLMIN: {
                        keyCode2 = 0x200000;
                        break;
                    }
                    case VOLPLUS: {
                        keyCode2 = 0x100000;
                        break;
                    }
                    case SCREEN: {
                        keyCode2 = 0x400000;
                        break;
                    }
                    case MUSIC: {
                        keyCode2 = 0x800000;
                    }
                }
                if (keyCode2 == -1) continue;
                this.buttonComponents.put(component.getIdentifier(), keyCode2);
                continue;
            }
            if (isAxis && identifier == Component.Identifier.Axis.POV) {
                this.povArrows = identifier;
                continue;
            }
            if (!isAxis) continue;
            switch (key) {
                case DOWN: 
                case UP: {
                    this.digitalYAxis = identifier;
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    this.digitalXAxis = identifier;
                    break;
                }
                case ANDOWN: 
                case ANUP: {
                    this.analogYAxis = identifier;
                    break;
                }
                case ANLEFT: 
                case ANRIGHT: {
                    this.analogXAxis = identifier;
                }
            }
        }
    }

    public void hleControllerPoll() {
        this.processSpecialKeys();
        this.pollController();
    }

    private void pollController() {
        if (this.inputController != null && this.inputController.poll()) {
            EventQueue eventQueue = this.inputController.getEventQueue();
            Event event = new Event();
            while (eventQueue.getNextEvent(event)) {
                Component component = event.getComponent();
                float value = event.getValue();
                this.processControllerEvent(component, value);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        keyCode key = this.keys.get(keyEvent.getKeyCode());
        if (key == null || key == this.lastKey) {
            return;
        }
        switch (key) {
            case DOWN: {
                this.Buttons |= 0x40;
                break;
            }
            case UP: {
                this.Buttons |= 0x10;
                break;
            }
            case LEFT: {
                this.Buttons |= 0x80;
                break;
            }
            case RIGHT: {
                this.Buttons |= 0x20;
                break;
            }
            case ANDOWN: {
                this.Ly = (byte)-1;
                break;
            }
            case ANUP: {
                this.Ly = 0;
                break;
            }
            case ANLEFT: {
                this.Lx = 0;
                break;
            }
            case ANRIGHT: {
                this.Lx = (byte)-1;
                break;
            }
            case TRIANGLE: {
                this.Buttons |= 0x1000;
                break;
            }
            case SQUARE: {
                this.Buttons |= 0x8000;
                break;
            }
            case CIRCLE: {
                this.Buttons |= 0x2000;
                break;
            }
            case CROSS: {
                this.Buttons |= 0x4000;
                break;
            }
            case L1: {
                this.Buttons |= 0x100;
                break;
            }
            case R1: {
                this.Buttons |= 0x200;
                break;
            }
            case START: {
                this.Buttons |= 8;
                break;
            }
            case SELECT: {
                this.Buttons |= 1;
                break;
            }
            case HOME: {
                this.Buttons |= 0x10000;
                break;
            }
            case HOLD: {
                this.Buttons |= 0x20000;
                break;
            }
            case VOLMIN: {
                this.Buttons |= 0x200000;
                break;
            }
            case VOLPLUS: {
                this.Buttons |= 0x100000;
                break;
            }
            case SCREEN: {
                this.Buttons |= 0x400000;
                break;
            }
            case MUSIC: {
                this.Buttons |= 0x800000;
                break;
            }
            default: {
                return;
            }
        }
        this.lastKey = key;
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyCode key = this.keys.get(keyEvent.getKeyCode());
        if (key == null) {
            return;
        }
        switch (key) {
            case DOWN: {
                this.Buttons &= 0xFFFFFFBF;
                break;
            }
            case UP: {
                this.Buttons &= 0xFFFFFFEF;
                break;
            }
            case LEFT: {
                this.Buttons &= 0xFFFFFF7F;
                break;
            }
            case RIGHT: {
                this.Buttons &= 0xFFFFFFDF;
                break;
            }
            case ANDOWN: {
                this.Ly = (byte)-128;
                break;
            }
            case ANUP: {
                this.Ly = (byte)-128;
                break;
            }
            case ANLEFT: {
                this.Lx = (byte)-128;
                break;
            }
            case ANRIGHT: {
                this.Lx = (byte)-128;
                break;
            }
            case TRIANGLE: {
                this.Buttons &= 0xFFFFEFFF;
                break;
            }
            case SQUARE: {
                this.Buttons &= 0xFFFF7FFF;
                break;
            }
            case CIRCLE: {
                this.Buttons &= 0xFFFFDFFF;
                break;
            }
            case CROSS: {
                this.Buttons &= 0xFFFFBFFF;
                break;
            }
            case L1: {
                this.Buttons &= 0xFFFFFEFF;
                break;
            }
            case R1: {
                this.Buttons &= 0xFFFFFDFF;
                break;
            }
            case START: {
                this.Buttons &= 0xFFFFFFF7;
                break;
            }
            case SELECT: {
                this.Buttons &= 0xFFFFFFFE;
                break;
            }
            case HOME: {
                this.Buttons &= 0xFFFEFFFF;
                break;
            }
            case HOLD: {
                this.Buttons &= 0xFFFDFFFF;
                break;
            }
            case VOLMIN: {
                this.Buttons &= 0xFFDFFFFF;
                break;
            }
            case VOLPLUS: {
                this.Buttons &= 0xFFEFFFFF;
                break;
            }
            case SCREEN: {
                this.Buttons &= 0xFFBFFFFF;
                break;
            }
            case MUSIC: {
                this.Buttons &= 0xFF7FFFFF;
                break;
            }
            default: {
                return;
            }
        }
        this.lastKey = keyCode.RELEASED;
    }

    private void processSpecialKeys() {
        if (this.isSpecialKeyPressed(keyCode.VOLMIN)) {
            Audio.setVolumeDown();
        } else if (this.isSpecialKeyPressed(keyCode.VOLPLUS)) {
            Audio.setVolumeUp();
        } else if (this.isSpecialKeyPressed(keyCode.HOME)) {
            this.Buttons &= 0xFFFEFFFF;
            int opt = JOptionPane.showOptionDialog(null, "Exit the current application?", "HOME", 0, 1, null, null, null);
            if (opt == 0) {
                Modules.LoadExecForUserModule.triggerExitCallback();
            }
        }
    }

    private boolean isSpecialKeyPressed(keyCode key) {
        boolean res = false;
        switch (key) {
            case HOME: {
                if ((this.Buttons & 0x10000) != 65536) break;
                res = true;
                break;
            }
            case HOLD: {
                if ((this.Buttons & 0x20000) != 131072) break;
                res = true;
                break;
            }
            case VOLMIN: {
                if ((this.Buttons & 0x200000) != 0x200000) break;
                res = true;
                break;
            }
            case VOLPLUS: {
                if ((this.Buttons & 0x100000) != 0x100000) break;
                res = true;
                break;
            }
            case SCREEN: {
                if ((this.Buttons & 0x400000) != 0x400000) break;
                res = true;
                break;
            }
            case MUSIC: {
                if ((this.Buttons & 0x800000) != 0x800000) break;
                res = true;
            }
        }
        return res;
    }

    private Component getControllerComponentByName(String name) {
        Component[] components = this.inputController.getComponents();
        if (components != null) {
            int i;
            for (i = 0; i < components.length; ++i) {
                if (!name.equals(components[i].getIdentifier().getName())) continue;
                return components[i];
            }
            for (i = 0; i < components.length; ++i) {
                if (!name.equals(components[i].getName())) continue;
                return components[i];
            }
        }
        return null;
    }

    public static float getDeadZone(Component component) {
        float deadZone = component.getDeadZone();
        if (deadZone < 0.1f) {
            deadZone = 0.1f;
        }
        return deadZone;
    }

    public static boolean isInDeadZone(Component component, float value) {
        return Math.abs(value) <= Controller.getDeadZone(component);
    }

    private void processControllerEvent(Component component, float value) {
        Integer button;
        Component.Identifier id = component.getIdentifier();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Controller Event on %s(%s): %f", component.getName(), id.getName(), Float.valueOf(value)));
        }
        if ((button = this.buttonComponents.get(id)) != null) {
            if (value == 0.0f) {
                this.Buttons &= ~button.intValue();
            } else if (value == 1.0f) {
                this.Buttons |= button.intValue();
            } else {
                log.warn(String.format("Unknown Controller Button Event on %s(%s): %f", component.getName(), id.getName(), Float.valueOf(value)));
            }
        } else if (id == this.analogXAxis) {
            this.Lx = Controller.isInDeadZone(component, value) ? (byte)-128 : (byte)(value * 127.0f + 128.0f);
        } else if (id == this.analogYAxis) {
            this.Ly = Controller.isInDeadZone(component, value) ? (byte)-128 : (byte)(value * 127.0f + 128.0f);
        } else if (id == this.digitalXAxis) {
            this.Buttons = Controller.isInDeadZone(component, value) ? (this.Buttons &= 0xFFFFFF5F) : (value < 0.0f ? (this.Buttons |= 0x80) : (this.Buttons |= 0x20));
        } else if (id == this.digitalYAxis) {
            this.Buttons = Controller.isInDeadZone(component, value) ? (this.Buttons &= 0xFFFFFFAF) : (value < 0.0f ? (this.Buttons |= 0x10) : (this.Buttons |= 0x40));
        } else if (id == this.povArrows) {
            if (value == 0.0f) {
                this.Buttons &= 0xFFFFFF0F;
            } else if (value == 0.25f) {
                this.Buttons |= 0x10;
            } else if (value == 0.5f) {
                this.Buttons |= 0x20;
            } else if (value == 0.75f) {
                this.Buttons |= 0x40;
            } else if (value == 1.0f) {
                this.Buttons |= 0x80;
            } else if (value == 0.875f) {
                this.Buttons |= 0xC0;
            } else if (value == 0.625f) {
                this.Buttons |= 0x60;
            } else if (value == 0.125f) {
                this.Buttons |= 0x90;
            } else if (value == 0.375f) {
                this.Buttons |= 0x30;
            } else {
                log.warn(String.format("Unknown Controller Arrows Event on %s(%s): %f", component.getName(), id.getName(), Float.valueOf(value)));
            }
        } else if (id instanceof Component.Identifier.Axis && (Controller.isInDeadZone(component, value) || id == Component.Identifier.Axis.Z || id == Component.Identifier.Axis.RZ)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Unknown Controller Event in DeadZone on %s(%s): %f", component.getName(), id.getName(), Float.valueOf(value)));
            }
        } else if (Controller.isKeyboardController(this.inputController)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Unknown Keyboard Controller Event on %s(%s): %f", component.getName(), id.getName(), Float.valueOf(value)));
            }
        } else if (log.isInfoEnabled()) {
            log.warn(String.format("Unknown Controller Event on %s(%s): %f", component.getName(), id.getName(), Float.valueOf(value)));
        }
    }

    public byte getLx() {
        return this.Lx;
    }

    public byte getLy() {
        return this.Ly;
    }

    public int getButtons() {
        return this.Buttons;
    }

    public static enum keyCode {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        ANUP,
        ANDOWN,
        ANLEFT,
        ANRIGHT,
        START,
        SELECT,
        TRIANGLE,
        SQUARE,
        CIRCLE,
        CROSS,
        L1,
        R1,
        HOME,
        HOLD,
        VOLMIN,
        VOLPLUS,
        SCREEN,
        MUSIC,
        RELEASED;

    }
}

