/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import jpcsp.Emulator;
import jpcsp.Memory;

public class CheatsGUI
extends JFrame
implements KeyListener {
    private static final long serialVersionUID = 6791588139795694296L;
    private JButton jButtonClear;
    private JRadioButton jRadioONOFF;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private String codeType = "";
    private boolean toggle = false;
    private static CheatsGUI instance;
    private Thread cheatsThread = null;

    public CheatsGUI(String type) {
        this.initComponents();
        this.setTitle("Cheats - " + type);
        this.codeType = type;
        instance = this;
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    private void initComponents() {
        this.jButtonClear = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jRadioONOFF = new JRadioButton();
        this.setTitle("Cheats");
        this.setResizable(false);
        this.jButtonClear.setText("Clear");
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsGUI.this.jButtonClearActionPerformed(evt);
            }
        });
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(true);
        this.jTextArea1.setFont(new Font("Monospaced", 1, 14));
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jTextArea1.getAccessibleContext().setAccessibleName("cheatPane");
        this.jRadioONOFF.setText("On/Off");
        this.jRadioONOFF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsGUI.this.jRadioONOFFActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioONOFF).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 63, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonClear, -2, 94, -2)).addComponent(this.jScrollPane1, -1, 314, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 229, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClear))).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jRadioONOFF))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public static CheatsGUI getInstance() {
        return instance;
    }

    public String getCodeType() {
        return this.codeType;
    }

    public boolean isON() {
        return this.toggle;
    }

    public boolean checkCWCheatFormat(String text) {
        return text.charAt(0) == '0' && text.charAt(1) == 'x' && text.charAt(11) == '0' && text.charAt(12) == 'x' && text.length() == 21;
    }

    public String[] getCodesList() {
        String text = this.jTextArea1.getText();
        String[] codes = text.split("\n");
        return codes;
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.jTextArea1.setText("");
    }

    private void jRadioONOFFActionPerformed(ActionEvent evt) {
        if (this.cheatsThread == null && !this.jTextArea1.getText().equals("")) {
            this.jTextArea1.setEditable(false);
            this.cheatsThread = new CheatsThread();
            this.cheatsThread.setPriority(1);
            this.cheatsThread.setName("HLECheatThread");
            this.cheatsThread.start();
        }
        if (!this.toggle) {
            this.jTextArea1.setEditable(false);
            this.cheatsThread.run();
            this.toggle = true;
        } else {
            this.jTextArea1.setEditable(true);
            Thread.yield();
            this.toggle = false;
        }
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }

    private static class CheatsThread
    extends Thread {
        @Override
        public void run() {
            Memory mem = Memory.getInstance();
            CheatsGUI cheats = CheatsGUI.getInstance();
            while (cheats.isON()) {
                if (!cheats.getCodeType().equals("CWCheat")) continue;
                String[] codes = cheats.getCodesList();
                int comm = 0;
                int arg = 0;
                for (int i = 0; i < codes.length; ++i) {
                    int a;
                    int stepAddr;
                    int maxAddr;
                    int dataAdd;
                    short tmp;
                    int data;
                    int addr;
                    comm = (int)Long.parseLong(codes[i].split(" ")[0].substring(2), 16);
                    arg = (int)Long.parseLong(codes[i].split(" ")[1].substring(2), 16);
                    if (comm >> 28 == 0) {
                        addr = 0x8800000 + comm;
                        if (!Memory.isAddressGood(addr)) continue;
                        mem.write8(addr, (byte)arg);
                        continue;
                    }
                    if (comm >> 28 == 1) {
                        addr = 0x8800000 + (comm - 0x10000000);
                        if (!Memory.isAddressGood(addr)) continue;
                        mem.write16(addr, (short)arg);
                        continue;
                    }
                    if (comm >> 28 == 2) {
                        addr = 0x8800000 + (comm - 0x20000000);
                        if (!Memory.isAddressGood(addr)) continue;
                        mem.write32(addr, arg);
                        continue;
                    }
                    if (comm >> 8 == 0x301000) {
                        addr = 0x8800000 + arg;
                        data = comm & 0xFF;
                        if (!Memory.isAddressGood(addr)) continue;
                        tmp = (short)(mem.read8(addr) + data);
                        mem.write8(addr, (byte)tmp);
                        continue;
                    }
                    if (comm >> 8 == 0x302000) {
                        addr = 0x8800000 + arg;
                        data = comm & 0xFF;
                        if (!Memory.isAddressGood(addr)) continue;
                        tmp = (byte)(mem.read8(addr) - data);
                        mem.write8(addr, (byte)tmp);
                        continue;
                    }
                    if (comm >> 16 == 12336) {
                        addr = 0x8800000 + arg;
                        data = comm & 0xFFFF;
                        if (!Memory.isAddressGood(addr)) continue;
                        tmp = (short)(mem.read16(addr) + data);
                        mem.write16(addr, tmp);
                        continue;
                    }
                    if (comm >> 16 == 12352) {
                        addr = 0x8800000 + arg;
                        data = comm & 0xFFFF;
                        if (!Memory.isAddressGood(addr)) continue;
                        tmp = (short)(mem.read16(addr) - data);
                        mem.write16(addr, tmp);
                        continue;
                    }
                    if (comm == 0x30500000) {
                        addr = 0x8800000 + arg;
                        data = (int)Long.parseLong(codes[i + 1].split(" ")[0].substring(2), 16);
                        if (!Memory.isAddressGood(addr)) continue;
                        tmp = (short)(mem.read32(addr) + data);
                        mem.write32(addr, tmp);
                        continue;
                    }
                    if (comm == 0x30600000) {
                        addr = 0x8800000 + arg;
                        data = (int)Long.parseLong(codes[i + 1].split(" ")[0].substring(2), 16);
                        if (!Memory.isAddressGood(addr)) continue;
                        tmp = (short)(mem.read32(addr) - data);
                        mem.write32(addr, tmp);
                        continue;
                    }
                    if (comm >> 28 == 7) {
                        short val2;
                        short val1;
                        addr = 0x8800000 + (comm - 0x70000000);
                        if (arg >> 16 == 0) {
                            if (!Memory.isAddressGood(addr)) continue;
                            val1 = (short)(arg & 0xFF);
                            val2 = (short)mem.read8(addr);
                            mem.write8(addr, (byte)(val1 | val2));
                            continue;
                        }
                        if (arg >> 16 == 2) {
                            if (!Memory.isAddressGood(addr)) continue;
                            val1 = (byte)(arg & 0xFF);
                            val2 = (byte)mem.read8(addr);
                            mem.write8(addr, (byte)(val1 & val2));
                            continue;
                        }
                        if (arg >> 16 == 4) {
                            if (!Memory.isAddressGood(addr)) continue;
                            val1 = (byte)(arg & 0xFF);
                            val2 = (byte)mem.read8(addr);
                            mem.write8(addr, (byte)(val1 ^ val2));
                            continue;
                        }
                        if (arg >> 16 == 1) {
                            if (!Memory.isAddressGood(addr)) continue;
                            val1 = (short)(arg & 0xFFFF);
                            val2 = (short)mem.read16(addr);
                            mem.write16(addr, (short)(val1 | val2));
                            continue;
                        }
                        if (arg >> 16 == 3) {
                            if (!Memory.isAddressGood(addr)) continue;
                            val1 = (short)(arg & 0xFFFF);
                            val2 = (short)mem.read16(addr);
                            mem.write16(addr, (short)(val1 & val2));
                            continue;
                        }
                        if (arg >> 16 != 5 || !Memory.isAddressGood(addr)) continue;
                        val1 = (short)(arg & 0xFFFF);
                        val2 = (short)mem.read16(addr);
                        mem.write16(addr, (short)(val1 ^ val2));
                        continue;
                    }
                    if (comm >> 28 == 5) {
                        int srcAddr = 0x8800000 + (comm - 0x50000000);
                        int destAddr = (int)Long.parseLong(codes[i + 1].split(" ")[0].substring(2), 16);
                        if (!Memory.isAddressGood(srcAddr) || !Memory.isAddressGood(destAddr)) continue;
                        mem.memcpy(destAddr, srcAddr, arg);
                        continue;
                    }
                    if (comm >> 28 == 4) {
                        addr = 0x8800000 + (comm - 0x40000000);
                        data = (int)Long.parseLong(codes[i + 1].split(" ")[0].substring(2), 16);
                        dataAdd = (int)Long.parseLong(codes[i + 1].split(" ")[1].substring(2), 16);
                        maxAddr = arg >> 16 & 0xFFFF;
                        stepAddr = (arg & 0xFFFF) * 4;
                        for (a = 0; a < maxAddr; ++a) {
                            if (Memory.isAddressGood(addr)) {
                                mem.write32(addr, data);
                            }
                            addr += stepAddr;
                            data += dataAdd;
                        }
                        continue;
                    }
                    if (comm >> 28 != 8) continue;
                    addr = 0x8800000 + (comm - 0x40000000);
                    data = (int)Long.parseLong(codes[i + 1].split(" ")[0].substring(2), 16);
                    dataAdd = (int)Long.parseLong(codes[i + 1].split(" ")[1].substring(2), 16);
                    maxAddr = arg >> 16 & 0xFFFF;
                    stepAddr = (arg & 0xFFFF) * 4;
                    for (a = 0; a < maxAddr; ++a) {
                        if (Memory.isAddressGood(addr)) {
                            if (data >> 16 == 4096) {
                                mem.write16(addr, (short)(data & 0xFFFF));
                            } else {
                                mem.write8(addr, (byte)(data & 0xFF));
                            }
                        }
                        addr += stepAddr;
                        data += dataAdd;
                    }
                }
            }
        }
    }
}

