/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jpcsp.Emulator;
import jpcsp.GUI.CancelButton;
import jpcsp.MainGUI;
import jpcsp.Resource;
import jpcsp.format.PBP;
import jpcsp.format.PSF;
import jpcsp.settings.Settings;

public class MemStickBrowser
extends JDialog {
    private static final long serialVersionUID = 7788144302296106541L;
    private JButton loadButton;
    private JTable table;
    private File[] programs;
    private ImageIcon[] icons;
    private PBP[] pbps;
    private PSF[] psfs;
    private File path;

    public MemStickBrowser(MainGUI arg0, File path) {
        super(arg0);
        this.path = path;
        this.setModal(true);
        this.setTitle(Resource.get("memstick"));
        this.setDefaultCloseOperation(2);
        this.table = new JTable(new MemStickTableModel(path), new MemStickTableColumnModel());
        this.table.setFillsViewportHeight(true);
        this.table.setRowHeight(80);
        this.table.setAutoResizeMode(1);
        this.table.setTableHeader(new JTableHeader(this.table.getColumnModel()));
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MemStickBrowser.this.loadButton.setEnabled(!((ListSelectionModel)e.getSource()).isSelectionEmpty());
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getClickCount() == 2 && arg0.getButton() == 1) {
                    MemStickBrowser.this.loadSelectedfile();
                }
            }
        });
        this.table.setFont(Settings.getInstance().getFont());
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.table.getColumnModel();
        for (int c = 0; c < this.table.getColumnCount() - 1; ++c) {
            TableColumn col = colModel.getColumn(c);
            int width = 0;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this.table, col.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            for (int r = 0; r < this.table.getRowCount(); ++r) {
                renderer = this.table.getCellRenderer(r, c);
                comp = renderer.getTableCellRendererComponent(this.table, this.table.getValueAt(r, c), false, false, r, c);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            col.setPreferredWidth(width += 2 * colModel.getColumnMargin());
        }
        JScrollPane scrollPane = new JScrollPane(this.table);
        GroupLayout layout = new GroupLayout(this.getRootPane());
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        CancelButton cancelButton = new CancelButton(this);
        this.loadButton = new JButton(Resource.get("load"));
        this.loadButton.setEnabled(false);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemStickBrowser.this.loadSelectedfile();
            }
        });
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(scrollPane).addGroup(layout.createSequentialGroup().addComponent(this.loadButton).addComponent(cancelButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(scrollPane).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadButton).addComponent(cancelButton)));
        this.getRootPane().setLayout(layout);
        this.setSize(600, 400);
    }

    public void refreshFiles() {
        this.table.setModel(new MemStickTableModel(this.path));
    }

    private void loadSelectedfile() {
        File selectedFile = this.programs[this.table.getSelectedRow()];
        ((MainGUI)this.getParent()).loadFile(selectedFile);
        this.setVisible(false);
        this.dispose();
    }

    static /* synthetic */ File[] access$102(MemStickBrowser x0, File[] x1) {
        x0.programs = x1;
        return x1;
    }

    static /* synthetic */ ImageIcon[] access$202(MemStickBrowser x0, ImageIcon[] x1) {
        x0.icons = x1;
        return x1;
    }

    static /* synthetic */ PBP[] access$302(MemStickBrowser x0, PBP[] x1) {
        x0.pbps = x1;
        return x1;
    }

    static /* synthetic */ PSF[] access$402(MemStickBrowser x0, PSF[] x1) {
        x0.psfs = x1;
        return x1;
    }

    private final class MemStickTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1675488447176776560L;

        public MemStickTableModel(File path) {
            if (!path.isDirectory()) {
                Emulator.log.error(path + Resource.get("nodirectory"));
                return;
            }
            MemStickBrowser.access$102(MemStickBrowser.this, path.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String lower = file.getName().toLowerCase();
                    if (lower.endsWith(".pbp")) {
                        return true;
                    }
                    if (file.isDirectory() && !file.getName().startsWith("%") && !file.getName().endsWith("%")) {
                        File[] eboot = file.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File arg0) {
                                return arg0.getName().equalsIgnoreCase("eboot.pbp");
                            }
                        });
                        return eboot.length != 0;
                    }
                    return false;
                }
            }));
            MemStickBrowser.access$202(MemStickBrowser.this, new ImageIcon[MemStickBrowser.this.programs.length]);
            MemStickBrowser.access$302(MemStickBrowser.this, new PBP[MemStickBrowser.this.programs.length]);
            MemStickBrowser.access$402(MemStickBrowser.this, new PSF[MemStickBrowser.this.programs.length]);
            for (int i = 0; i < MemStickBrowser.this.programs.length; ++i) {
                try {
                    Image image;
                    File metapbp = MemStickBrowser.this.programs[i];
                    if (MemStickBrowser.this.programs[i].isDirectory()) {
                        File[] psffile;
                        File[] icon0file;
                        File[] eboot = MemStickBrowser.this.programs[i].listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File arg0) {
                                return arg0.getName().equalsIgnoreCase("eboot.pbp");
                            }
                        });
                        File file = eboot[0];
                        ((MemStickBrowser)MemStickBrowser.this).programs[i] = file;
                        metapbp = file;
                        File metadir = new File(MemStickBrowser.this.programs[i].getParentFile().getParentFile().getPath() + File.separatorChar + "%" + MemStickBrowser.this.programs[i].getParentFile().getName());
                        if (metadir.exists() && (eboot = metadir.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File arg0) {
                                return arg0.getName().equalsIgnoreCase("eboot.pbp");
                            }
                        })).length > 0) {
                            metapbp = eboot[0];
                        }
                        if ((metadir = new File(MemStickBrowser.this.programs[i].getParentFile().getParentFile().getPath() + File.separatorChar + MemStickBrowser.this.programs[i].getParentFile().getName() + "%")).exists() && (eboot = metadir.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File arg0) {
                                return arg0.getName().equalsIgnoreCase("eboot.pbp");
                            }
                        })).length > 0) {
                            metapbp = eboot[0];
                        }
                        if ((icon0file = MemStickBrowser.this.programs[i].getParentFile().listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File arg0) {
                                return arg0.getName().equalsIgnoreCase("icon0.png");
                            }
                        })).length > 0) {
                            ((MemStickBrowser)MemStickBrowser.this).icons[i] = new ImageIcon(icon0file[0].getPath());
                        }
                        if ((psffile = MemStickBrowser.this.programs[i].getParentFile().listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File arg0) {
                                return arg0.getName().equalsIgnoreCase("param.sfo");
                            }
                        })).length > 0) {
                            FileChannel roChannel = new RandomAccessFile(psffile[0], "r").getChannel();
                            MappedByteBuffer readbuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
                            ((MemStickBrowser)MemStickBrowser.this).psfs[i] = new PSF();
                            MemStickBrowser.this.psfs[i].read(readbuffer);
                            roChannel.close();
                        }
                    }
                    if (MemStickBrowser.this.programs[i].getName().toLowerCase().endsWith(".pbp")) {
                        FileChannel roChannel = new RandomAccessFile(metapbp, "r").getChannel();
                        MappedByteBuffer readbuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
                        ((MemStickBrowser)MemStickBrowser.this).pbps[i] = new PBP(readbuffer);
                        PSF psf = MemStickBrowser.this.pbps[i].readPSF(readbuffer);
                        if (psf != null) {
                            ((MemStickBrowser)MemStickBrowser.this).psfs[i] = psf;
                        }
                        if (MemStickBrowser.this.pbps[i].getSizeIcon0() > 0) {
                            byte[] icon0 = new byte[MemStickBrowser.this.pbps[i].getSizeIcon0()];
                            ((ByteBuffer)readbuffer).position((int)MemStickBrowser.this.pbps[i].getOffsetIcon0());
                            readbuffer.get(icon0);
                            ((MemStickBrowser)MemStickBrowser.this).icons[i] = new ImageIcon(icon0);
                        }
                        roChannel.close();
                    }
                    if (MemStickBrowser.this.icons[i] == null) {
                        ((MemStickBrowser)MemStickBrowser.this).icons[i] = new ImageIcon(this.getClass().getResource("/jpcsp/images/icon0.png"));
                    }
                    if (MemStickBrowser.this.icons[i] == null || (image = MemStickBrowser.this.icons[i].getImage()).getWidth(null) <= 144 && image.getHeight(null) <= 80) continue;
                    image = image.getScaledInstance(144, 80, 4);
                    MemStickBrowser.this.icons[i].setImage(image);
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return MemStickBrowser.this.programs.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                switch (columnIndex) {
                    case 0: {
                        return MemStickBrowser.this.icons[rowIndex];
                    }
                    case 1: {
                        String title;
                        if (MemStickBrowser.this.psfs[rowIndex] == null || (title = MemStickBrowser.this.psfs[rowIndex].getPrintableString("TITLE")) == null) {
                            title = MemStickBrowser.this.programs[rowIndex].getParentFile().getName();
                        }
                        return title;
                    }
                    case 2: {
                        String prgPath = MemStickBrowser.this.programs[rowIndex].getCanonicalPath();
                        File cwd = new File(".");
                        if (prgPath.startsWith(cwd.getCanonicalPath())) {
                            prgPath = prgPath.substring(cwd.getCanonicalPath().length() + 1);
                        }
                        return prgPath;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static final class MemStickTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = -6321946514015824875L;

        public MemStickTableColumnModel() {
            this.setColumnMargin(0);
            CellRenderer cellRenderer = new CellRenderer();
            TableColumn tableColumn = new TableColumn(0, 144, cellRenderer, null);
            tableColumn.setHeaderValue(Resource.get("icon"));
            tableColumn.setMaxWidth(144);
            tableColumn.setMinWidth(144);
            TableColumn tableColumn2 = new TableColumn(1, 100, cellRenderer, null);
            tableColumn2.setHeaderValue(Resource.get("title"));
            TableColumn tableColumn3 = new TableColumn(2, 200, cellRenderer, null);
            tableColumn3.setHeaderValue(Resource.get("path"));
            this.addColumn(tableColumn);
            this.addColumn(tableColumn2);
            this.addColumn(tableColumn3);
        }

        private static final class CellRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 6767267483048658105L;

            private CellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
                if (obj instanceof Icon) {
                    this.setText("");
                    this.setIcon((Icon)obj);
                    return this;
                }
                this.setIcon(null);
                return super.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            }
        }
    }
}

