/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.MainGUI;
import jpcsp.State;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.settings.Settings;

public class UmdVideoPlayer
implements KeyListener {
    private static final int BASE_VIDEO_WIDTH = 480;
    private static final int BASE_VIDEO_HEIGTH = 272;
    private String fileName;
    private UmdIsoReader iso;
    private UmdIsoFile isoFile;
    private HashMap<Integer, MpsStreamInfo> mpsStreamMap;
    private int currentStreamIndex;
    private JLabel display;
    private int screenWidth;
    private int screenHeigth;
    private IContainer container;
    private IVideoResampler resampler;
    private int videoStreamId;
    private IStreamCoder videoCoder;
    private int audioStreamId;
    private IStreamCoder audioCoder;
    private IPacket packet;
    private long firstTimestampInStream;
    private long systemClockStartTime;
    private IConverter converter;
    private BufferedImage image;
    private boolean seekFrameFastForward;
    private boolean seekFrameRewind;
    private boolean videoPaused;
    private boolean done;
    private boolean endOfVideo;
    private boolean threadExit;
    private MpsDisplayThread displayThread;
    private MpsByteChannel byteChannel;
    private SourceDataLine mLine;

    public UmdVideoPlayer(MainGUI gui, UmdIsoReader iso) {
        this.iso = iso;
        this.display = new JLabel();
        gui.remove(Modules.sceDisplayModule.getCanvas());
        gui.getContentPane().add((Component)this.display, "Center");
        gui.addKeyListener(this);
        this.setVideoPlayerResizeScaleFactor(gui, 1);
        this.init();
    }

    @Override
    public void keyPressed(KeyEvent keyCode2) {
        if (keyCode2.getKeyCode() == 39) {
            this.goToNextMpsStream();
        } else if (keyCode2.getKeyCode() == 37 && this.currentStreamIndex > 0) {
            this.goToPreviousMpsStream();
        } else if (keyCode2.getKeyCode() == 87 && !this.videoPaused) {
            this.pauseVideo();
        } else if (keyCode2.getKeyCode() == 83) {
            this.resumeVideo();
        } else if (keyCode2.getKeyCode() == 65) {
            this.rewind();
        } else if (keyCode2.getKeyCode() == 68) {
            this.fastForward();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyCode2) {
    }

    @Override
    public void keyTyped(KeyEvent keyCode2) {
    }

    private void init() {
        this.image = null;
        this.done = false;
        this.threadExit = false;
        this.isoFile = null;
        this.mpsStreamMap = new HashMap();
        this.currentStreamIndex = 0;
        this.parsePlaylistFile();
        Modules.log.info("Setting aspect ratio to 16:9");
        if (this.mpsStreamMap.containsKey(this.currentStreamIndex)) {
            MpsStreamInfo info = this.mpsStreamMap.get(this.currentStreamIndex);
            this.fileName = "UMD_VIDEO/STREAM/" + info.getName() + ".MPS";
            Modules.log.info("Loading stream: " + this.fileName);
            try {
                this.isoFile = this.iso.getFile(this.fileName);
                String cpiFileName = "UMD_VIDEO/CLIPINF/" + info.getName() + ".CLP";
                UmdIsoFile cpiFile = this.iso.getFile(cpiFileName);
                if (cpiFile != null) {
                    Modules.log.info("Found CLIPINF data for this stream: " + cpiFileName);
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                Emulator.log.error(e);
            }
        }
        if (this.isoFile != null) {
            this.startVideo();
        }
    }

    public void setVideoPlayerResizeScaleFactor(MainGUI gui, int factor) {
        this.screenWidth = 480 * factor;
        this.screenHeigth = 272 * factor;
        Insets insets = gui.getInsets();
        Dimension minSize = new Dimension(this.screenWidth + insets.left + insets.right, this.screenHeigth + insets.top + insets.bottom);
        gui.setMinimumSize(minSize);
    }

    private int endianSwap32(int x) {
        return Integer.reverseBytes(x);
    }

    private short endianSwap16(short x) {
        return Short.reverseBytes(x);
    }

    private void parsePlaylistFile() {
        try {
            UmdIsoFile file = this.iso.getFile("UMD_VIDEO/PLAYLIST.UMD");
            int umdvMagic = file.readInt();
            int umdvVersion = file.readInt();
            int globalDataOffset = this.endianSwap32(file.readInt());
            file.seek(globalDataOffset);
            int playListSize = this.endianSwap32(file.readInt());
            int playListTracksNum = this.endianSwap16(file.readShort());
            file.skipBytes(2);
            if (umdvMagic != 1447316821) {
                Modules.log.warn("Accessing invalid PLAYLIST.UMD file!");
            } else {
                Modules.log.info("Accessing valid PLAYLIST.UMD file: playListSize=" + playListSize + ", playListTracksNum=" + playListTracksNum);
            }
            for (int i = 0; i < playListTracksNum; ++i) {
                file.skipBytes(2);
                file.skipBytes(2);
                file.skipBytes(2);
                file.skipBytes(30);
                file.skipBytes(2);
                file.skipBytes(2);
                short releaseDateYear = this.endianSwap16(file.readShort());
                byte releaseDateDay = file.readByte();
                byte releaseDateMonth = file.readByte();
                file.skipBytes(4);
                file.skipBytes(4);
                file.skipBytes(1);
                file.skipBytes(732);
                int streamHeigth = file.readByte() * 16;
                file.skipBytes(2);
                file.skipBytes(4);
                file.skipBytes(1);
                int streamWidth = file.readByte() * 16;
                file.skipBytes(1);
                byte streamNameCharsNum = file.readByte();
                byte[] stringBuf = new byte[5];
                file.read(stringBuf, 0, 5);
                String streamName = new String(stringBuf);
                file.skipBytes(3);
                file.skipBytes(2);
                int streamFirstTimestamp = this.endianSwap32(file.readInt());
                file.skipBytes(2);
                int streamLastTimestamp = this.endianSwap32(file.readInt());
                file.skipBytes(2);
                short streamMarkerDataLength = this.endianSwap16(file.readShort());
                int streamMarkersNum = this.endianSwap16(file.readShort());
                MpsStreamMarkerInfo[] streamMarkers = new MpsStreamMarkerInfo[streamMarkersNum];
                for (int j = 0; j < streamMarkersNum; ++j) {
                    file.skipBytes(1);
                    byte streamMarkerCharsNum = file.readByte();
                    file.skipBytes(4);
                    int streamMarkerTimestamp = this.endianSwap32(file.readInt());
                    file.skipBytes(2);
                    file.skipBytes(4);
                    byte[] markerBuf = new byte[24];
                    file.read(markerBuf, 0, 24);
                    String markerName = new String(markerBuf);
                    if (j + 1 == streamMarkersNum) {
                        file.skip(2L);
                    }
                    streamMarkers[j] = new MpsStreamMarkerInfo(markerName, streamMarkerTimestamp);
                }
                MpsStreamInfo info = new MpsStreamInfo(streamName, streamWidth, streamHeigth, streamFirstTimestamp, streamLastTimestamp, streamMarkers);
                this.mpsStreamMap.put(i, info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void goToNextMpsStream() {
        ++this.currentStreamIndex;
        if (this.mpsStreamMap.containsKey(this.currentStreamIndex)) {
            MpsStreamInfo info = this.mpsStreamMap.get(this.currentStreamIndex);
            this.fileName = "UMD_VIDEO/STREAM/" + info.getName() + ".MPS";
            Modules.log.info("Loading stream: " + this.fileName);
            try {
                this.isoFile = this.iso.getFile(this.fileName);
                String cpiFileName = "UMD_VIDEO/CLIPINF/" + info.getName() + ".CLP";
                UmdIsoFile cpiFile = this.iso.getFile(cpiFileName);
                if (cpiFile != null) {
                    Modules.log.info("Found CLIPINF data for this stream: " + cpiFileName);
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                Emulator.log.error(e);
            }
        }
        if (this.isoFile != null) {
            this.startVideo();
        }
    }

    private void goToPreviousMpsStream() {
        --this.currentStreamIndex;
        if (this.mpsStreamMap.containsKey(this.currentStreamIndex)) {
            MpsStreamInfo info = this.mpsStreamMap.get(this.currentStreamIndex);
            this.fileName = "UMD_VIDEO/STREAM/" + info.getName() + ".MPS";
            Modules.log.info("Loading stream: " + this.fileName);
            try {
                this.isoFile = this.iso.getFile(this.fileName);
                String cpiFileName = "UMD_VIDEO/CLIPINF/" + info.getName() + ".CLP";
                UmdIsoFile cpiFile = this.iso.getFile(cpiFileName);
                if (cpiFile != null) {
                    Modules.log.info("Found CLIPINF data for this stream: " + cpiFileName);
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                Emulator.log.error(e);
            }
        }
        if (this.isoFile != null) {
            this.startVideo();
        }
    }

    public void initVideo() {
        if (this.displayThread == null) {
            this.displayThread = new MpsDisplayThread();
            this.displayThread.setDaemon(true);
            this.displayThread.setName("UMD Video Player Thread");
            this.displayThread.start();
        }
        this.videoPaused = false;
    }

    public void pauseVideo() {
        this.videoPaused = true;
    }

    public void resumeVideo() {
        this.videoPaused = false;
        this.seekFrameFastForward = false;
        this.seekFrameRewind = false;
        this.firstTimestampInStream = Global.NO_PTS;
        this.systemClockStartTime = System.currentTimeMillis();
    }

    public void fastForward() {
        this.seekFrameFastForward = true;
    }

    public void rewind() {
        this.seekFrameRewind = true;
    }

    public boolean startVideo() {
        this.endOfVideo = false;
        this.videoPaused = false;
        try {
            this.container = IContainer.make();
        }
        catch (Throwable e) {
            Emulator.log.error(e);
            return false;
        }
        try {
            this.isoFile.seek(0L);
        }
        catch (IOException e) {
            Emulator.log.error(e);
            return false;
        }
        this.byteChannel = new MpsByteChannel(this.isoFile);
        if (this.container.open(this.byteChannel, null) < 0) {
            Emulator.log.error("could not open file: " + this.fileName);
            return false;
        }
        int numStreams = this.container.getNumStreams();
        this.videoStreamId = -1;
        this.videoCoder = null;
        this.audioStreamId = -1;
        this.audioCoder = null;
        boolean audioMuted = Settings.getInstance().readBool("emu.mutesound");
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = this.container.getStream(i);
            IStreamCoder coder = stream.getStreamCoder();
            if (coder.getCodecType() == ICodec.Type.CODEC_TYPE_VIDEO) {
                this.videoStreamId = i;
                this.videoCoder = coder;
                continue;
            }
            if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO || audioMuted) continue;
            this.audioStreamId = i;
            this.audioCoder = coder;
        }
        if (this.videoCoder != null && this.videoCoder.open() < 0) {
            Emulator.log.error("could not open video decoder for container: " + this.fileName);
            return false;
        }
        if (this.audioCoder != null && this.audioCoder.open() < 0) {
            Emulator.log.info("AT3+ audio format is not yet supported by Jpcsp (file=" + this.fileName + ")");
            return false;
        }
        this.resampler = null;
        if (this.videoCoder != null) {
            this.converter = ConverterFactory.createConverter("XUGGLER-BGR-24", IPixelFormat.Type.BGR24, this.videoCoder.getWidth(), this.videoCoder.getHeight());
            if (this.videoCoder.getPixelType() != IPixelFormat.Type.BGR24) {
                this.resampler = IVideoResampler.make(this.screenWidth, this.screenHeigth, IPixelFormat.Type.BGR24, this.videoCoder.getWidth(), this.videoCoder.getHeight(), this.videoCoder.getPixelType());
                if (this.resampler == null) {
                    Emulator.log.error("could not create color space resampler for: " + this.fileName);
                    return false;
                }
            }
        }
        if (this.audioCoder != null) {
            this.openAudio(this.audioCoder);
        }
        this.packet = IPacket.make();
        this.firstTimestampInStream = Global.NO_PTS;
        this.systemClockStartTime = 0L;
        return true;
    }

    private void closeVideo() {
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
        if (this.videoCoder != null) {
            this.videoCoder.close();
            this.videoCoder = null;
        }
        if (this.resampler != null) {
            this.resampler.delete();
            this.resampler = null;
        }
        if (this.converter != null) {
            this.converter.delete();
            this.converter = null;
        }
        if (this.packet != null) {
            this.packet.delete();
            this.packet = null;
        }
    }

    private void stopDisplayThread() {
        while (this.displayThread != null && !this.threadExit) {
            this.done = true;
            this.sleep(1L);
        }
        this.displayThread = null;
    }

    public void stopVideo() {
        this.stopDisplayThread();
        this.closeVideo();
        this.closeAudio();
        if (this.isoFile != null) {
            try {
                this.isoFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void stepVideo() {
        if (this.container.readNextPacket(this.packet) >= 0) {
            int offset;
            if (this.packet.getStreamIndex() == this.videoStreamId && this.videoCoder != null) {
                IVideoPicture picture = IVideoPicture.make(this.videoCoder.getPixelType(), this.videoCoder.getWidth(), this.videoCoder.getHeight());
                offset = 0;
                while (offset < this.packet.getSize()) {
                    int bytesDecoded = this.videoCoder.decodeVideo(picture, this.packet, offset);
                    if (bytesDecoded < 0) {
                        return;
                    }
                    offset += bytesDecoded;
                    if (!picture.isComplete()) continue;
                    IVideoPicture newPic = picture;
                    if (this.resampler != null && this.resampler.resample(newPic = IVideoPicture.make(this.resampler.getOutputPixelFormat(), this.screenWidth, this.screenHeigth), picture) < 0) {
                        return;
                    }
                    if (newPic.getPixelType() != IPixelFormat.Type.BGR24) {
                        return;
                    }
                    if (this.firstTimestampInStream == Global.NO_PTS) {
                        this.firstTimestampInStream = picture.getTimeStamp();
                        this.systemClockStartTime = System.currentTimeMillis();
                    } else {
                        long systemClockCurrentTime = System.currentTimeMillis();
                        long millisecondsClockTimeSinceStartofVideo = systemClockCurrentTime - this.systemClockStartTime;
                        long millisecondsStreamTimeSinceStartOfVideo = (picture.getTimeStamp() - this.firstTimestampInStream) / 1000L;
                        long millisecondsTolerance = 50L;
                        long millisecondsToSleep = millisecondsStreamTimeSinceStartOfVideo - (millisecondsClockTimeSinceStartofVideo + 50L);
                        if (!(this.seekFrameFastForward || this.seekFrameRewind || this.videoPaused)) {
                            this.sleep(millisecondsToSleep);
                        }
                    }
                    if (this.converter == null || newPic == null) continue;
                    this.image = this.converter.toImage(newPic);
                }
            } else if (this.packet.getStreamIndex() == this.audioStreamId && this.audioCoder != null) {
                int bytesDecoded;
                IAudioSamples samples = IAudioSamples.make(1024L, this.audioCoder.getChannels());
                for (offset = 0; offset < this.packet.getSize(); offset += bytesDecoded) {
                    bytesDecoded = this.audioCoder.decodeAudio(samples, this.packet, offset);
                    if (bytesDecoded >= 0) continue;
                    return;
                }
            }
            if (this.seekFrameFastForward) {
                this.container.seekKeyFrame(-1, 0L, IContainer.SEEK_FLAG_FRAME);
                int bitrate = this.container.getBitRate();
                long seconds = this.packet.getTimeStamp() / 1000L + 10L;
                long bytes = seconds * (long)bitrate / 8L;
                this.container.seekKeyFrame(this.videoStreamId, bytes, IContainer.SEEK_FLAG_BYTE);
            } else if (this.seekFrameRewind) {
                this.container.seekKeyFrame(-1, 0L, IContainer.SEEK_FLAG_BACKWARDS);
                int bitrate = this.container.getBitRate();
                long seconds = this.packet.getTimeStamp() / 1000L - 10L;
                long bytes = seconds * (long)bitrate / 8L;
                this.container.seekKeyFrame(this.videoStreamId, bytes, IContainer.SEEK_FLAG_BYTE);
            }
        } else {
            this.endOfVideo = true;
        }
    }

    private void openAudio(IStreamCoder aAudioCoder) {
        AudioFormat audioFormat = new AudioFormat(aAudioCoder.getSampleRate(), (int)IAudioSamples.findSampleBitDepth(aAudioCoder.getSampleFormat()), aAudioCoder.getChannels(), true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            this.mLine = (SourceDataLine)AudioSystem.getLine(info);
            this.mLine.open(audioFormat);
            this.mLine.start();
        }
        catch (IllegalArgumentException iae) {
            this.audioCoder = null;
        }
        catch (LineUnavailableException e) {
            return;
        }
    }

    private void playAudio(IAudioSamples aSamples) {
        byte[] rawBytes = aSamples.getData().getByteArray(0, aSamples.getSize());
        this.mLine.write(rawBytes, 0, aSamples.getSize());
    }

    private void closeAudio() {
        if (this.mLine != null) {
            this.mLine.drain();
            this.mLine.close();
            this.mLine = null;
        }
    }

    public void takeScreenshot() {
        int tag = 0;
        String screenshotName = State.title + "-" + "Shot" + "-" + tag + ".png";
        File screenshot = new File(screenshotName);
        File directory = new File(System.getProperty("user.dir"));
        for (File file : directory.listFiles()) {
            if (!file.getName().contains(State.title + "-" + "Shot")) continue;
            screenshotName = State.title + "-" + "Shot" + "-" + ++tag + ".png";
            screenshot = new File(screenshotName);
        }
        try {
            BufferedImage img = (BufferedImage)this.getImage();
            ImageIO.write((RenderedImage)img, "png", screenshot);
            img.flush();
        }
        catch (Exception e) {
            return;
        }
    }

    private Image getImage() {
        return this.image;
    }

    private void sleep(long millis) {
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class MpsByteChannel
    implements ReadableByteChannel {
        private UmdIsoFile file;
        private byte[] buffer;
        private int bufOffset;

        public MpsByteChannel(UmdIsoFile file) {
            this.file = file;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int length;
            int available = dst.remaining();
            if (this.buffer == null || this.buffer.length < available) {
                this.buffer = new byte[available];
            }
            if ((length = this.file.read(this.buffer, this.bufOffset, available)) > 0) {
                dst.put(this.buffer, this.bufOffset, length);
            }
            return length;
        }

        @Override
        public void close() throws IOException {
            this.file.close();
            this.file = null;
        }

        @Override
        public boolean isOpen() {
            return this.file != null;
        }
    }

    private class MpsDisplayThread
    extends Thread {
        private MpsDisplayThread() {
        }

        @Override
        public void run() {
            while (!UmdVideoPlayer.this.done) {
                while (!UmdVideoPlayer.this.endOfVideo && !UmdVideoPlayer.this.done) {
                    if (UmdVideoPlayer.this.videoPaused) continue;
                    UmdVideoPlayer.this.stepVideo();
                    if (UmdVideoPlayer.this.display == null || UmdVideoPlayer.this.image == null) continue;
                    UmdVideoPlayer.this.display.setIcon(new ImageIcon(UmdVideoPlayer.this.getImage()));
                }
                UmdVideoPlayer.this.goToNextMpsStream();
            }
            UmdVideoPlayer.this.threadExit = true;
        }
    }

    protected class MpsStreamMarkerInfo {
        private String streamMarkerName;
        private int streamMarkerTimestamp;

        public MpsStreamMarkerInfo(String name, int timestamp) {
            this.streamMarkerName = name;
            this.streamMarkerTimestamp = timestamp;
        }

        public String getName() {
            return this.streamMarkerName;
        }

        public int getTimestamp() {
            return this.streamMarkerTimestamp;
        }
    }

    protected class MpsStreamInfo {
        private String streamName;
        private int streamWidth;
        private int streamHeigth;
        private int streamFirstTimestamp;
        private int streamLastTimestamp;
        private MpsStreamMarkerInfo[] streamMarkers;

        public MpsStreamInfo(String name, int width, int heigth, int firstTimestamp, int lastTimestamp, MpsStreamMarkerInfo[] markers) {
            this.streamName = name;
            this.streamWidth = width;
            this.streamHeigth = heigth;
            this.streamFirstTimestamp = firstTimestamp;
            this.streamLastTimestamp = lastTimestamp;
            this.streamMarkers = markers;
        }

        public String getName() {
            return this.streamName;
        }

        public int getWidth() {
            return this.streamWidth;
        }

        public int getHeigth() {
            return this.streamHeigth;
        }

        public int getFirstTimestamp() {
            return this.streamFirstTimestamp;
        }

        public int getLastTimestamp() {
            return this.streamLastTimestamp;
        }

        public MpsStreamMarkerInfo[] getMarkers() {
            return this.streamMarkers;
        }
    }
}

