/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SyscallIgnore;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModuleFunction;
import jpcsp.HLE.modules.HLEModuleManager;
import jpcsp.format.DeferredStub;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.CpuDurationStatistics;

public class SyscallHandler {
    public static CpuDurationStatistics durationStatistics = new CpuDurationStatistics("Syscall");
    public static boolean ignoreUnmappedImports = false;
    private static CpuDurationStatistics[] syscallStatistics;
    public static final int syscallUnmappedImport = 1048575;
    private static IgnoreUnmappedImportsSettingsListerner ignoreUnmappedImportsSettingsListerner;

    public static void reset() {
        durationStatistics.reset();
        syscallStatistics = null;
    }

    public static void exit() {
    }

    private static void initStatistics() {
        syscallStatistics = new CpuDurationStatistics[HLEModuleManager.getInstance().getMaxSyscallCode()];
        for (int i = 0; i < syscallStatistics.length; ++i) {
            String name = HLEModuleManager.getInstance().functionName(i);
            if (name == null) {
                name = String.format("Syscall 0x%X", i);
            }
            SyscallHandler.syscallStatistics[i] = new CpuDurationStatistics(String.format("%-30s", name));
        }
    }

    private static boolean isEnableIgnoreUnmappedImports() {
        return ignoreUnmappedImports;
    }

    private static void setEnableIgnoreUnmappedImports(boolean enable) {
        ignoreUnmappedImports = enable;
        if (enable) {
            Modules.log.info("Ignore Unmapped Imports enabled");
        }
    }

    public static void syscall(int code) {
        if (ignoreUnmappedImportsSettingsListerner == null) {
            ignoreUnmappedImportsSettingsListerner = new IgnoreUnmappedImportsSettingsListerner();
            Settings.getInstance().registerSettingsListener("SyscallHandler", "emu.ignoreUnmappedImports", ignoreUnmappedImportsSettingsListerner);
        }
        if (code == 1048575) {
            CpuState cpu = Emulator.getProcessor().cpu;
            String description = String.format("0x%08X", cpu.pc);
            block0: for (SceModule module : Managers.modules.values()) {
                for (DeferredStub deferredStub : module.unresolvedImports) {
                    if (deferredStub.getImportAddress() != cpu.pc && deferredStub.getImportAddress() != cpu.pc - 4) continue;
                    description = deferredStub.toString();
                    continue block0;
                }
            }
            if (SyscallHandler.isEnableIgnoreUnmappedImports()) {
                Modules.log.warn(String.format("IGNORING: Unmapped import at %s - %08x %08x %08x", description, cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]));
            } else {
                Modules.log.error(String.format("Unmapped import at %s - %08x %08x %08x", description, cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]));
                Emulator.PauseEmu();
            }
            cpu.gpr[2] = 0;
        } else {
            boolean handled = HLEModuleManager.getInstance().handleSyscall(code);
            if (!handled) {
                HLEModuleFunction hleModuleFunction = HLEModuleManager.getInstance().getSyscallFunction(code);
                if (hleModuleFunction != null) {
                    Modules.log.error(String.format("HLE Function %s(%s) not activated by default for Firmware Version %d", hleModuleFunction.getFunctionName(), hleModuleFunction.getModuleName(), Emulator.getInstance().getFirmwareVersion()));
                } else {
                    CpuState cpu = Emulator.getProcessor().cpu;
                    String name = "";
                    for (SyscallIgnore c : SyscallIgnore.values()) {
                        if (c.getSyscall() != code) continue;
                        name = c.toString();
                        break;
                    }
                    Modules.log.warn(String.format("Unsupported syscall %X %s %08X %08X %08X", code, name, cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]));
                }
            }
        }
    }

    private static class IgnoreUnmappedImportsSettingsListerner
    extends AbstractBoolSettingsListener {
        private IgnoreUnmappedImportsSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            SyscallHandler.setEnableIgnoreUnmappedImports(value);
        }
    }
}

