/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelEventFlagInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class EventFlagManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private static HashMap<Integer, SceKernelEventFlagInfo> eventMap;
    private EventFlagWaitStateChecker eventFlagWaitStateChecker;
    protected static final int PSP_EVENT_WAITSINGLE = 0;
    protected static final int PSP_EVENT_WAITMULTIPLE = 512;
    protected static final int PSP_EVENT_WAITANDOR_MASK = 1;
    protected static final int PSP_EVENT_WAITAND = 0;
    protected static final int PSP_EVENT_WAITOR = 1;
    protected static final int PSP_EVENT_WAITCLEARALL = 16;
    protected static final int PSP_EVENT_WAITCLEAR = 32;
    public static final EventFlagManager singleton;

    public void reset() {
        eventMap = new HashMap();
        this.eventFlagWaitStateChecker = new EventFlagWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelEventFlagInfo event = eventMap.get(thread.wait.EventFlag_id);
        if (event != null) {
            --event.numWaitThreads;
            if (event.numWaitThreads < 0) {
                log.warn("removing waiting thread " + Integer.toHexString(thread.uid) + ", event " + Integer.toHexString(event.uid) + " numWaitThreads underflowed");
                event.numWaitThreads = 0;
            }
            return true;
        }
        return false;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext.gpr[2] = -2147352152;
        } else {
            log.warn("EventFlag deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext.gpr[2] = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext.gpr[2] = -2147352150;
        } else {
            log.warn("EventFlag deleted while we were waiting for it!");
            thread.cpuContext.gpr[2] = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(4)) {
            this.removeWaitingThread(thread);
        }
    }

    private void onEventFlagDeletedCancelled(int evid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingForType(4) || thread.wait.EventFlag_id != evid) continue;
            thread.cpuContext.gpr[2] = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onEventFlagDeleted(int evid) {
        this.onEventFlagDeletedCancelled(evid, -2147352139);
    }

    private void onEventFlagCancelled(int evid) {
        this.onEventFlagDeletedCancelled(evid, -2147352151);
    }

    private void onEventFlagModified(SceKernelEventFlagInfo event) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingForType(4) || thread.wait.EventFlag_id != event.uid || !this.checkEventFlag(event, thread.wait.EventFlag_bits, thread.wait.EventFlag_wait, thread.wait.EventFlag_outBits_addr)) continue;
            if (log.isDebugEnabled()) {
                log.debug("onEventFlagModified waking thread 0x" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "'");
            }
            --event.numWaitThreads;
            thread.cpuContext.gpr[2] = 0;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
            if (event.currentPattern != 0) continue;
            break;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private boolean checkEventFlag(SceKernelEventFlagInfo event, int bits, int wait, int outBits_addr) {
        boolean matched = false;
        if ((wait & 1) == 0 && (event.currentPattern & bits) == bits) {
            matched = true;
        } else if ((wait & 1) == 1 && (event.currentPattern & bits) != 0) {
            matched = true;
        }
        if (matched) {
            Memory mem = Memory.getInstance();
            if (Memory.isAddressGood(outBits_addr)) {
                mem.write32(outBits_addr, event.currentPattern);
            }
            if ((wait & 0x10) == 16) {
                event.currentPattern = 0;
            }
            if ((wait & 0x20) == 32) {
                event.currentPattern &= ~bits;
            }
        }
        return matched;
    }

    public int sceKernelCreateEventFlag(int name_addr, int attr, int initPattern, int option) {
        String name = Utilities.readStringZ(name_addr);
        if (log.isDebugEnabled()) {
            log.debug("sceKernelCreateEventFlag(name='" + name + "', attr=0x" + Integer.toHexString(attr) + ", initPattern=0x" + Integer.toHexString(initPattern) + ", option=0x" + Integer.toHexString(option) + ")");
        }
        SceKernelEventFlagInfo event = new SceKernelEventFlagInfo(name, attr, initPattern, initPattern);
        eventMap.put(event.uid, event);
        return event.uid;
    }

    public int sceKernelDeleteEventFlag(int uid) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelDeleteEventFlag uid=0x" + Integer.toHexString(uid) + ")");
        }
        SceUidManager.checkUidPurpose(uid, "ThreadMan-eventflag", true);
        SceKernelEventFlagInfo event = eventMap.remove(uid);
        if (event == null) {
            log.warn("sceKernelDeleteEventFlag unknown uid");
            return -2147352166;
        }
        if (event.numWaitThreads > 0) {
            log.warn("sceKernelDeleteEventFlag numWaitThreads " + event.numWaitThreads);
        }
        this.onEventFlagDeleted(uid);
        return 0;
    }

    public int sceKernelSetEventFlag(int uid, int bitsToSet) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelSetEventFlag uid=0x" + Integer.toHexString(uid) + " bitsToSet=0x" + Integer.toHexString(bitsToSet));
        }
        SceUidManager.checkUidPurpose(uid, "ThreadMan-eventflag", true);
        SceKernelEventFlagInfo event = eventMap.get(uid);
        if (event == null) {
            log.warn("sceKernelSetEventFlag unknown uid=0x" + Integer.toHexString(uid));
            return -2147352166;
        }
        event.currentPattern |= bitsToSet;
        this.onEventFlagModified(event);
        return 0;
    }

    public int sceKernelClearEventFlag(int uid, int bitsToKeep) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelClearEventFlag uid=0x" + Integer.toHexString(uid) + " bitsToKeep=0x" + Integer.toHexString(bitsToKeep));
        }
        SceUidManager.checkUidPurpose(uid, "ThreadMan-eventflag", true);
        SceKernelEventFlagInfo event = eventMap.get(uid);
        if (event == null) {
            log.warn("sceKernelClearEventFlag unknown uid=0x" + Integer.toHexString(uid));
            return -2147352166;
        }
        event.currentPattern &= bitsToKeep;
        return 0;
    }

    public int hleKernelWaitEventFlag(int uid, int bits, int wait, int outBits_addr, int timeout_addr, boolean doCallbacks) {
        if (log.isDebugEnabled()) {
            log.debug("hleKernelWaitEventFlag uid=0x" + Integer.toHexString(uid) + " bits=0x" + Integer.toHexString(bits) + " wait=0x" + Integer.toHexString(wait) + " outBits=0x" + Integer.toHexString(outBits_addr) + " timeout=0x" + Integer.toHexString(timeout_addr) + " callbacks=" + doCallbacks);
        }
        if ((wait & 0xFFFFFFCE) != 0 || (wait & 0x30) == 48) {
            return -2147352171;
        }
        if (bits == 0) {
            return -2147352143;
        }
        if (!Modules.ThreadManForUserModule.isDispatchThreadEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("hleKernelWaitEventFlag called when dispatch thread disabled");
            }
            return -2147352153;
        }
        SceUidManager.checkUidPurpose(uid, "ThreadMan-eventflag", true);
        SceKernelEventFlagInfo event = eventMap.get(uid);
        if (event == null) {
            log.warn("hleKernelWaitEventFlag unknown uid=0x" + Integer.toHexString(uid));
            return -2147352166;
        }
        if (event.numWaitThreads >= 1 && (event.attr & 0x200) != 512) {
            log.warn("hleKernelWaitEventFlag already another thread waiting on it");
            return -2147352144;
        }
        if (!this.checkEventFlag(event, bits, wait, outBits_addr)) {
            if (log.isDebugEnabled()) {
                log.debug("hleKernelWaitEventFlag - '" + event.name + "' fast check failed");
            }
            ++event.numWaitThreads;
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            currentThread.wait.EventFlag_id = uid;
            currentThread.wait.EventFlag_bits = bits;
            currentThread.wait.EventFlag_wait = wait;
            currentThread.wait.EventFlag_outBits_addr = outBits_addr;
            threadMan.hleKernelThreadEnterWaitState(4, uid, this.eventFlagWaitStateChecker, timeout_addr, doCallbacks);
        } else if (log.isDebugEnabled()) {
            log.debug("hleKernelWaitEventFlag - '" + event.name + "' fast check succeeded");
        }
        return 0;
    }

    public int sceKernelWaitEventFlag(int uid, int bits, int wait, int outBits_addr, int timeout_addr) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelWaitEventFlag redirecting to hleKernelWaitEventFlag(callbacks=false)");
        }
        return this.hleKernelWaitEventFlag(uid, bits, wait, outBits_addr, timeout_addr, false);
    }

    public int sceKernelWaitEventFlagCB(int uid, int bits, int wait, int outBits_addr, int timeout_addr) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelWaitEventFlagCB redirecting to hleKernelWaitEventFlag(callbacks=true)");
        }
        return this.hleKernelWaitEventFlag(uid, bits, wait, outBits_addr, timeout_addr, true);
    }

    public int sceKernelPollEventFlag(int uid, int bits, int wait, int outBits_addr) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelPollEventFlag uid=0x" + Integer.toHexString(uid) + " bits=0x" + Integer.toHexString(bits) + " wait=0x" + Integer.toHexString(wait) + " outBits=0x" + Integer.toHexString(outBits_addr));
        }
        SceUidManager.checkUidPurpose(uid, "ThreadMan-eventflag", true);
        SceKernelEventFlagInfo event = eventMap.get(uid);
        if (event == null) {
            log.warn("sceKernelPollEventFlag unknown uid=0x" + Integer.toHexString(uid));
            return -2147352166;
        }
        if (bits == 0) {
            return -2147352143;
        }
        if (!this.checkEventFlag(event, bits, wait, outBits_addr)) {
            if (Memory.isAddressGood(outBits_addr)) {
                Memory.getInstance().write32(outBits_addr, event.currentPattern);
            }
            return -2147352145;
        }
        return 0;
    }

    public int sceKernelCancelEventFlag(int uid, int newPattern, int numWaitThreadAddr) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelCancelEventFlag uid=0x" + Integer.toHexString(uid) + " newPattern=0x" + Integer.toHexString(newPattern) + " numWaitThreadAddr=0x" + Integer.toHexString(numWaitThreadAddr));
        }
        SceUidManager.checkUidPurpose(uid, "ThreadMan-eventflag", true);
        SceKernelEventFlagInfo event = eventMap.get(uid);
        if (event == null) {
            log.warn("sceKernelCancelEventFlag unknown uid=0x" + Integer.toHexString(uid));
            return -2147352166;
        }
        Memory mem = Memory.getInstance();
        if (Memory.isAddressGood(numWaitThreadAddr)) {
            mem.write32(numWaitThreadAddr, event.numWaitThreads);
        }
        event.currentPattern = newPattern;
        event.numWaitThreads = 0;
        this.onEventFlagCancelled(uid);
        return 0;
    }

    public int sceKernelReferEventFlagStatus(int uid, int addr) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelReferEventFlagStatus uid=0x" + Integer.toHexString(uid) + " addr=0x" + Integer.toHexString(addr));
        }
        SceUidManager.checkUidPurpose(uid, "ThreadMan-eventflag", true);
        SceKernelEventFlagInfo event = eventMap.get(uid);
        if (event == null) {
            log.warn("sceKernelReferEventFlagStatus unknown uid=0x" + Integer.toHexString(uid));
            return -2147352166;
        }
        event.write(Memory.getInstance(), addr);
        return 0;
    }

    private EventFlagManager() {
    }

    static {
        singleton = new EventFlagManager();
    }

    private class EventFlagWaitStateChecker
    implements IWaitStateChecker {
        private EventFlagWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelEventFlagInfo event = (SceKernelEventFlagInfo)eventMap.get(wait.EventFlag_id);
            if (event == null) {
                thread.cpuContext.gpr[2] = -2147352166;
                return false;
            }
            if (EventFlagManager.this.checkEventFlag(event, wait.EventFlag_bits, wait.EventFlag_wait, wait.EventFlag_outBits_addr)) {
                --event.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                return false;
            }
            return true;
        }
    }
}

