/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelMbxInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MbxManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelMbxInfo> mbxMap;
    private MbxWaitStateChecker mbxWaitStateChecker;
    private static final int PSP_MBX_ATTR_FIFO = 0;
    private static final int PSP_MBX_ATTR_PRIORITY = 256;
    private static final int PSP_MBX_ATTR_MSG_FIFO = 0;
    private static final int PSP_MBX_ATTR_MSG_PRIORITY = 1024;
    public static final MbxManager singleton = new MbxManager();

    public void reset() {
        this.mbxMap = new HashMap();
        this.mbxWaitStateChecker = new MbxWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelMbxInfo info = this.mbxMap.get(thread.wait.Mbx_id);
        if (info != null) {
            --info.numWaitThreads;
            if (info.numWaitThreads < 0) {
                log.warn("Removing waiting thread " + Integer.toHexString(thread.uid) + ", Mbx " + Integer.toHexString(info.uid) + " numWaitThreads underflowed");
                info.numWaitThreads = 0;
            }
            return true;
        }
        return false;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext.gpr[2] = -2147352152;
        } else {
            log.warn("Mbx deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext.gpr[2] = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext.gpr[2] = -2147352150;
        } else {
            log.warn("EventFlag deleted while we were waiting for it!");
            thread.cpuContext.gpr[2] = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(5)) {
            this.removeWaitingThread(thread);
        }
    }

    private void onMbxDeletedCancelled(int mbxid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingForType(5) || thread.wait.Mbx_id != mbxid) continue;
            thread.cpuContext.gpr[2] = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onMbxDeleted(int mbxid) {
        this.onMbxDeletedCancelled(mbxid, -2147352139);
    }

    private void onMbxCancelled(int mbxid) {
        this.onMbxDeletedCancelled(mbxid, -2147352151);
    }

    private void onMbxModified(SceKernelMbxInfo info) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        if ((info.attr & 0x100) == 0) {
            Iterator<SceKernelThreadInfo> it = threadMan.iterator();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(5) || thread.wait.Mbx_id != info.uid || !info.hasMessage()) continue;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("onMbxModified waking thread %s", thread.toString()));
                }
                Memory mem = Memory.getInstance();
                int msgAddr = info.removeMsg(mem);
                mem.write32(thread.wait.Mbx_resultAddr, msgAddr);
                --info.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
            }
        } else if ((info.attr & 0x100) == 256) {
            Iterator<SceKernelThreadInfo> it = threadMan.iteratorByPriority();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(5) || thread.wait.Mbx_id != info.uid || !info.hasMessage()) continue;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("onMbxModified waking thread %s", thread.toString()));
                }
                Memory mem = Memory.getInstance();
                int msgAddr = info.removeMsg(mem);
                mem.write32(thread.wait.Mbx_resultAddr, msgAddr);
                --info.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
            }
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    public void sceKernelCreateMbx(int name_addr, int attr, int opt_addr) {
        SceKernelMbxInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Memory.getInstance();
        String name = Utilities.readStringZ(name_addr);
        if (log.isDebugEnabled()) {
            log.debug("sceKernelCreateMbx(name=" + name + ",attr=0x" + Integer.toHexString(attr) + ",opt=0x" + Integer.toHexString(opt_addr) + ")");
        }
        if (Memory.isAddressGood(opt_addr)) {
            int optsize = mem.read32(opt_addr);
            log.warn("sceKernelCreateMbx option at 0x" + Integer.toHexString(opt_addr) + " (size=" + optsize + ")");
        }
        if ((info = new SceKernelMbxInfo(name, attr)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("sceKernelCreateMbx '" + name + "' assigned uid " + Integer.toHexString(info.uid));
            }
            this.mbxMap.put(info.uid, info);
            cpu.gpr[2] = info.uid;
        } else {
            cpu.gpr[2] = -2147352176;
        }
    }

    public void sceKernelDeleteMbx(int uid) {
        SceKernelMbxInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        if (log.isDebugEnabled()) {
            log.debug("sceKernelDeleteMbx(uid=0x" + Integer.toHexString(uid) + ")");
        }
        if ((info = this.mbxMap.remove(uid)) == null) {
            log.warn("sceKernelDeleteMbx unknown uid=0x" + Integer.toHexString(uid));
            cpu.gpr[2] = -2147352165;
        } else {
            cpu.gpr[2] = 0;
            this.onMbxDeleted(uid);
        }
    }

    public void sceKernelSendMbx(int uid, int msg_addr) {
        SceKernelMbxInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Memory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug("sceKernelSendMbx(uid=0x" + Integer.toHexString(uid) + ",msg=0x" + Integer.toHexString(msg_addr) + ")");
        }
        if ((info = this.mbxMap.get(uid)) == null) {
            log.warn("sceKernelSendMbx unknown uid=0x" + Integer.toHexString(uid));
            cpu.gpr[2] = -2147352165;
        } else {
            if ((info.attr & 0x400) == 0) {
                info.addMsg(mem, msg_addr);
            } else if ((info.attr & 0x400) == 1024) {
                info.addMsgByPriority(mem, msg_addr);
            }
            cpu.gpr[2] = 0;
            this.onMbxModified(info);
        }
    }

    private void hleKernelReceiveMbx(int uid, int addr_msg_addr, int timeout_addr, boolean doCallbacks, boolean poll) {
        SceKernelMbxInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Processor.memory;
        if (log.isDebugEnabled()) {
            String waitType = "";
            waitType = poll ? "poll" : (timeout_addr == 0 ? "forever" : mem.read32(timeout_addr) + " ms");
            if (doCallbacks) {
                waitType = waitType + " + CB";
            }
            log.debug("hleKernelReceiveMbx(uid=0x" + Integer.toHexString(uid) + ", msg_pointer=0x" + Integer.toHexString(addr_msg_addr) + ", timeout=0x" + Integer.toHexString(timeout_addr) + ")" + " " + waitType);
        }
        if ((info = this.mbxMap.get(uid)) == null) {
            log.warn("hleKernelReceiveMbx unknown uid=0x" + Integer.toHexString(uid));
            cpu.gpr[2] = -2147352165;
        } else {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            if (!info.hasMessage()) {
                if (!poll) {
                    if (log.isDebugEnabled()) {
                        log.debug("hleKernelReceiveMbx - '" + info.name + "' (waiting)");
                    }
                    ++info.numWaitThreads;
                    SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
                    currentThread.wait.Mbx_id = uid;
                    currentThread.wait.Mbx_resultAddr = addr_msg_addr;
                    threadMan.hleKernelThreadEnterWaitState(5, uid, this.mbxWaitStateChecker, timeout_addr, doCallbacks);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("hleKernelReceiveMbx has no messages.");
                    }
                    cpu.gpr[2] = -2147352142;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("hleKernelReceiveMbx - '" + info.name + "' fast check succeeded");
                }
                int msgAddr = info.removeMsg(mem);
                mem.write32(addr_msg_addr, msgAddr);
                cpu.gpr[2] = 0;
            }
        }
    }

    public void sceKernelReceiveMbx(int uid, int addr_msg_addr, int timeout_addr) {
        this.hleKernelReceiveMbx(uid, addr_msg_addr, timeout_addr, false, false);
    }

    public void sceKernelReceiveMbxCB(int uid, int addr_msg_addr, int timeout_addr) {
        this.hleKernelReceiveMbx(uid, addr_msg_addr, timeout_addr, true, false);
    }

    public void sceKernelPollMbx(int uid, int addr_msg_addr) {
        this.hleKernelReceiveMbx(uid, addr_msg_addr, 0, false, true);
    }

    public void sceKernelCancelReceiveMbx(int uid, int pnum_addr) {
        SceKernelMbxInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Memory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug("sceKernelCancelReceiveMbx(uid=0x" + Integer.toHexString(uid) + ")");
        }
        if ((info = this.mbxMap.get(uid)) == null) {
            log.warn("sceKernelCancelReceiveMbx unknown uid=0x" + Integer.toHexString(uid));
            cpu.gpr[2] = -2147352165;
        } else {
            if (Memory.isAddressGood(pnum_addr)) {
                mem.write32(pnum_addr, info.numWaitThreads);
            }
            cpu.gpr[2] = 0;
            this.onMbxCancelled(uid);
        }
    }

    public void sceKernelReferMbxStatus(int uid, int info_addr) {
        SceKernelMbxInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Memory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug("sceKernelReferMbxStatus(uid=0x" + Integer.toHexString(uid) + ",info=0x" + Integer.toHexString(info_addr) + ")");
        }
        if ((info = this.mbxMap.get(uid)) == null) {
            log.warn("sceKernelReferMbxStatus unknown uid=0x" + Integer.toHexString(uid));
            cpu.gpr[2] = -2147352165;
        } else {
            int maxSize;
            info.size = maxSize = mem.read32(info_addr);
            info.write(mem, info_addr);
            cpu.gpr[2] = 0;
        }
    }

    private MbxManager() {
    }

    private class MbxWaitStateChecker
    implements IWaitStateChecker {
        private MbxWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelMbxInfo info = (SceKernelMbxInfo)MbxManager.this.mbxMap.get(wait.Mbx_id);
            if (info == null) {
                thread.cpuContext.gpr[2] = -2147352165;
                return false;
            }
            if (info.hasMessage()) {
                Memory mem = Memory.getInstance();
                int msgAddr = info.removeMsg(mem);
                mem.write32(wait.Mbx_resultAddr, msgAddr);
                --info.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                return false;
            }
            return true;
        }
    }
}

