/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelMutexInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MutexManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelMutexInfo> mutexMap;
    private MutexWaitStateChecker mutexWaitStateChecker;
    private static final int PSP_MUTEX_ATTR_FIFO = 0;
    private static final int PSP_MUTEX_ATTR_PRIORITY = 256;
    private static final int PSP_MUTEX_ATTR_ALLOW_RECURSIVE = 512;
    public static final MutexManager singleton = new MutexManager();

    public void reset() {
        this.mutexMap = new HashMap();
        this.mutexWaitStateChecker = new MutexWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelMutexInfo info = this.mutexMap.get(thread.wait.Mutex_id);
        if (info != null) {
            --info.numWaitThreads;
            if (info.numWaitThreads < 0) {
                log.warn("removing waiting thread " + Integer.toHexString(thread.uid) + ", mutex " + Integer.toHexString(info.uid) + " numWaitThreads underflowed");
                info.numWaitThreads = 0;
            }
            return true;
        }
        return false;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext.gpr[2] = -2147352152;
        } else {
            log.warn("Mutex deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext.gpr[2] = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext.gpr[2] = -2147352150;
        } else {
            log.warn("EventFlag deleted while we were waiting for it!");
            thread.cpuContext.gpr[2] = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(12)) {
            this.removeWaitingThread(thread);
        }
    }

    private void onMutexDeletedCancelled(int mid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingForType(12) || thread.wait.Mutex_id != mid) continue;
            thread.cpuContext.gpr[2] = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onMutexDeleted(int mid) {
        this.onMutexDeletedCancelled(mid, -2147352139);
    }

    private void onMutexCancelled(int mid) {
        this.onMutexDeletedCancelled(mid, -2147352151);
    }

    private void onMutexModified(SceKernelMutexInfo info) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        if ((info.attr & 0x100) == 0) {
            Iterator<SceKernelThreadInfo> it = Modules.ThreadManForUserModule.iterator();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(12) || thread.wait.Mutex_id != info.uid || !this.tryLockMutex(info, thread.wait.Mutex_count, thread)) continue;
                info.threadid = thread.uid;
                --info.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                threadMan.hleChangeThreadState(thread, 2);
            }
        } else if ((info.attr & 0x100) == 256) {
            Iterator<SceKernelThreadInfo> it = Modules.ThreadManForUserModule.iteratorByPriority();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(12) || thread.wait.Mutex_id != info.uid || !this.tryLockMutex(info, thread.wait.Mutex_count, thread)) continue;
                info.threadid = thread.uid;
                --info.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                threadMan.hleChangeThreadState(thread, 2);
            }
        }
        if (reschedule) {
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        }
    }

    private boolean tryLockMutex(SceKernelMutexInfo info, int count, SceKernelThreadInfo thread) {
        if (info.lockedCount == 0) {
            info.threadid = thread.uid;
            info.lockedCount += count;
            return true;
        }
        if (info.threadid == thread.uid && (info.attr & 0x200) == 512) {
            info.lockedCount += count;
            return true;
        }
        return false;
    }

    public void sceKernelCreateMutex(int name_addr, int attr, int count, int option_addr) {
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Processor.memory;
        String name = "";
        if (Memory.isAddressGood(name_addr)) {
            name = Utilities.readStringNZ(mem, name_addr, 32);
        }
        if (log.isDebugEnabled()) {
            log.debug("sceKernelCreateMutex(name='" + name + "',attr=0x" + Integer.toHexString(attr) + ",count=0x" + Integer.toHexString(count) + ",option_addr=0x" + Integer.toHexString(option_addr) + ")");
        }
        SceKernelMutexInfo info = new SceKernelMutexInfo(name, count, attr);
        this.mutexMap.put(info.uid, info);
        if (count > 0) {
            info.threadid = Modules.ThreadManForUserModule.getCurrentThreadID();
        }
        cpu.gpr[2] = info.uid;
    }

    public void sceKernelDeleteMutex(int uid) {
        SceKernelMutexInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        if (log.isDebugEnabled()) {
            log.debug("sceKernelDeleteMutex(uid=" + Integer.toHexString(uid));
        }
        if ((info = this.mutexMap.remove(uid)) == null) {
            log.warn("sceKernelDeleteMutex unknown UID " + Integer.toHexString(uid));
            cpu.gpr[2] = -2147352125;
        } else {
            cpu.gpr[2] = 0;
            this.onMutexDeleted(uid);
        }
    }

    private void hleKernelLockMutex(int uid, int count, int timeout_addr, boolean wait, boolean doCallbacks) {
        CpuState cpu = Emulator.getProcessor().cpu;
        SceKernelMutexInfo info = this.mutexMap.get(uid);
        if (info == null) {
            log.warn(String.format("hleKernelLockMutex uid=%d, count=%d, timeout_addr=0x%08X, wait=%b, doCallbacks=%b - unknown UID", uid, count, timeout_addr, wait, doCallbacks));
            cpu.gpr[2] = -2147352125;
        } else if (count <= 0) {
            log.warn(String.format("hleKernelLockMutex uid=%d, count=%d, timeout_addr=0x%08X, wait=%b, doCallbacks=%b - illegal count", uid, count, timeout_addr, wait, doCallbacks));
            cpu.gpr[2] = -2147352131;
        } else if (count > 1 && (info.attr & 0x200) == 0) {
            log.warn(String.format("hleKernelLockMutex uid=%d, count=%d, timeout_addr=0x%08X, wait=%b, doCallbacks=%b - illegal count", uid, count, timeout_addr, wait, doCallbacks));
            cpu.gpr[2] = -2147352131;
        } else {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            if (!this.tryLockMutex(info, count, currentThread)) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("hleKernelLockMutex %s, count=%d, timeout_addr=0x%08X, wait=%b, doCallbacks=%b - fast check failed", info.toString(), count, timeout_addr, wait, doCallbacks));
                }
                if (wait && info.threadid != currentThread.uid) {
                    ++info.numWaitThreads;
                    currentThread.wait.Mutex_id = uid;
                    currentThread.wait.Mutex_count = count;
                    threadMan.hleKernelThreadEnterWaitState(12, uid, this.mutexWaitStateChecker, timeout_addr, doCallbacks);
                } else {
                    cpu.gpr[2] = (info.attr & 0x200) != 512 ? -2147352120 : -2147352124;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("hleKernelLockMutex %s, count=%d, timeout_addr=0x%08X, wait=%b, doCallbacks=%b - fast check succeeded", info.toString(), count, timeout_addr, wait, doCallbacks));
                }
                cpu.gpr[2] = 0;
            }
        }
    }

    public void sceKernelLockMutex(int uid, int count, int timeout_addr) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelLockMutex redirecting to hleKernelLockMutex");
        }
        this.hleKernelLockMutex(uid, count, timeout_addr, true, false);
    }

    public void sceKernelLockMutexCB(int uid, int count, int timeout_addr) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelLockMutex redirecting to hleKernelLockMutex");
        }
        this.hleKernelLockMutex(uid, count, timeout_addr, true, true);
    }

    public void sceKernelTryLockMutex(int uid, int count) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelTryLockMutex redirecting to hleKernelLockMutex");
        }
        this.hleKernelLockMutex(uid, count, 0, false, false);
    }

    public void sceKernelUnlockMutex(int uid, int count) {
        SceKernelMutexInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        if (log.isDebugEnabled()) {
            log.debug("sceKernelUnlockMutex(uid=" + Integer.toHexString(uid) + ", count=" + count + ")");
        }
        if ((info = this.mutexMap.get(uid)) == null) {
            log.warn("sceKernelUnlockMutex unknown uid");
            cpu.gpr[2] = -2147352125;
        } else if (info.lockedCount == 0) {
            log.debug("sceKernelUnlockMutex not locked");
            cpu.gpr[2] = -2147352123;
        } else if (info.lockedCount - count < 0) {
            log.warn("sceKernelUnlockMutex underflow");
            cpu.gpr[2] = -2147352121;
        } else {
            info.lockedCount -= count;
            cpu.gpr[2] = 0;
            if (info.lockedCount == 0) {
                info.threadid = 0;
                this.onMutexModified(info);
            }
        }
    }

    public void sceKernelCancelMutex(int uid, int newcount, int numWaitThreadAddr) {
        SceKernelMutexInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Memory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug("sceKernelCancelMutex uid=" + Integer.toHexString(uid) + ", newcount=" + newcount + ", numWaitThreadAddr=0x" + Integer.toHexString(numWaitThreadAddr));
        }
        if ((info = this.mutexMap.get(uid)) == null) {
            log.warn("sceKernelCancelMutex unknown UID " + Integer.toHexString(uid));
            cpu.gpr[2] = -2147352125;
        } else if (info.lockedCount == 0) {
            log.warn("sceKernelCancelMutex UID " + Integer.toHexString(uid) + " not locked");
            cpu.gpr[2] = -1;
        } else {
            if (Memory.isAddressGood(numWaitThreadAddr)) {
                mem.write32(numWaitThreadAddr, info.numWaitThreads);
            }
            info.lockedCount = newcount == -1 ? info.initCount : newcount;
            cpu.gpr[2] = 0;
            this.onMutexCancelled(uid);
        }
    }

    public void sceKernelReferMutexStatus(int uid, int addr) {
        SceKernelMutexInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        if (log.isDebugEnabled()) {
            log.debug("sceKernelReferMutexStatus uid=" + Integer.toHexString(uid) + "addr=" + String.format("0x%08X", addr));
        }
        if ((info = this.mutexMap.get(uid)) == null) {
            log.warn("sceKernelReferMutexStatus unknown UID " + Integer.toHexString(uid));
            cpu.gpr[2] = -2147352125;
        } else {
            Memory mem = Memory.getInstance();
            if (Memory.isAddressGood(addr)) {
                info.write(mem, addr);
                cpu.gpr[2] = 0;
            } else {
                log.warn("sceKernelReferMutexStatus bad address 0x" + Integer.toHexString(addr));
                cpu.gpr[2] = -1;
            }
        }
    }

    private MutexManager() {
    }

    private class MutexWaitStateChecker
    implements IWaitStateChecker {
        private MutexWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelMutexInfo info = (SceKernelMutexInfo)MutexManager.this.mutexMap.get(wait.Mutex_id);
            if (info == null) {
                thread.cpuContext.gpr[2] = -2147352125;
                return false;
            }
            if (MutexManager.this.tryLockMutex(info, wait.Mutex_count, thread)) {
                --info.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                return false;
            }
            return true;
        }
    }
}

