/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer64;
import jpcsp.Memory;
import org.apache.log4j.Logger;

public class SystemTimeManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    public static final SystemTimeManager singleton = new SystemTimeManager();

    public void reset() {
    }

    public static long hleSysClock2USec(long sysclocks) {
        return sysclocks;
    }

    public static int hleSysClock2USec32(long sysclocks) {
        long micros64 = SystemTimeManager.hleSysClock2USec(sysclocks);
        int micros32 = (int)micros64;
        if (micros64 > Integer.MAX_VALUE) {
            micros32 = Integer.MAX_VALUE;
        } else if (micros64 < Integer.MIN_VALUE) {
            micros32 = Integer.MIN_VALUE;
        }
        return micros32;
    }

    public void sceKernelUSec2SysClock(int usec, int clock_addr) {
        Memory mem = Memory.getInstance();
        if (Memory.isAddressGood(clock_addr)) {
            mem.write64(clock_addr, usec);
        } else {
            log.warn("sceKernelUSec2SysClock bad clock pointer 0x" + Integer.toHexString(clock_addr));
        }
        Emulator.getProcessor().cpu.gpr[2] = 0;
    }

    public void sceKernelUSec2SysClockWide(long usec) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelUSec2SysClockWide usec:" + usec);
        }
        Emulator.getProcessor().cpu.gpr[2] = (int)(usec & 0xFFFFFFFFL);
        Emulator.getProcessor().cpu.gpr[3] = (int)(usec >> 32 & 0xFFFFFFFFL);
    }

    public void sceKernelSysClock2USec(int clock_addr, int low_addr, int high_addr) {
        Memory mem = Memory.getInstance();
        if (!Memory.isAddressGood(clock_addr)) {
            log.warn("sceKernelSysClock2USec bad clock pointer 0x" + Integer.toHexString(clock_addr));
        } else {
            boolean ok = false;
            long clocks = mem.read64(clock_addr);
            if (Memory.isAddressGood(low_addr)) {
                mem.write32(low_addr, (int)(clocks / 1000000L));
                ok = true;
            }
            if (Memory.isAddressGood(high_addr)) {
                mem.write32(high_addr, (int)(clocks % 1000000L));
                ok = true;
            }
            if (!ok) {
                log.warn("sceKernelSysClock2USec bad output pointers  0x" + Integer.toHexString(low_addr) + " 0x" + Integer.toHexString(high_addr));
            }
            Emulator.getProcessor().cpu.gpr[2] = 0;
        }
    }

    public void sceKernelSysClock2USecWide(int sysclockLow, int sysclockHigh, int low_addr, int high_addr) {
        long clocks = (long)sysclockLow & 0xFFFFFFFFL | (long)sysclockHigh << 32;
        Memory mem = Memory.getInstance();
        boolean ok = false;
        if (Memory.isAddressGood(low_addr)) {
            mem.write32(low_addr, (int)(clocks / 1000000L));
            ok = true;
        }
        if (Memory.isAddressGood(high_addr)) {
            mem.write32(high_addr, (int)(clocks % 1000000L));
            ok = true;
        }
        if (!ok) {
            log.warn("sceKernelSysClock2USecWide bad output pointers  0x" + Integer.toHexString(low_addr) + " 0x" + Integer.toHexString(high_addr));
        }
        Emulator.getProcessor().cpu.gpr[2] = 0;
    }

    public static long getSystemTime() {
        return Emulator.getClock().microTime();
    }

    public int sceKernelGetSystemTime(TPointer64 time_addr) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelGetSystemTime pointer=0x%08X", time_addr.getAddress()));
        }
        long systemTime = SystemTimeManager.getSystemTime();
        time_addr.setValue(systemTime);
        return 0;
    }

    public long sceKernelGetSystemTimeWide() {
        long systemTime = SystemTimeManager.getSystemTime();
        if (log.isDebugEnabled()) {
            log.debug("sceKernelGetSystemTimeWide ret:" + systemTime);
        }
        return systemTime;
    }

    public int sceKernelGetSystemTimeLow() {
        long systemTime = SystemTimeManager.getSystemTime();
        return (int)(systemTime & 0xFFFFFFFFL);
    }

    private SystemTimeManager() {
    }
}

