/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.Memory;

public class SceIoDirent {
    public SceIoStat stat;
    public String filename;

    public SceIoDirent(SceIoStat stat, String filename) {
        this.stat = stat;
        this.filename = filename;
    }

    public void write(Memory mem, int address) {
        int i;
        if (!Memory.isAddressGood(address) || !Memory.isAddressGood(address + SceIoDirent.sizeof())) {
            Modules.log.warn("SceIoDirent write bad address " + String.format("0x%08X", address));
        }
        this.stat.write(mem, address);
        int len = this.filename.length();
        if (len > 255) {
            len = 255;
        }
        for (i = 0; i < len; ++i) {
            mem.write8(address + SceIoStat.sizeof() + i, (byte)this.filename.charAt(i));
        }
        while (i < 256) {
            mem.write8(address + SceIoStat.sizeof() + i, (byte)0);
            ++i;
        }
        mem.write32(address + SceIoStat.sizeof() + 256, -842150451);
        mem.write32(address + SceIoStat.sizeof() + 256 + 4, -842150451);
    }

    public static int sizeof() {
        return SceIoStat.sizeof() + 256 + 8;
    }
}

