/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.interrupts.AlarmInterruptHandler;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.scheduler.AlarmInterruptAction;
import jpcsp.scheduler.AlarmInterruptResultAction;

public class SceKernelAlarmInfo
extends pspAbstractMemoryMappedStructure {
    public int size = 20;
    public long schedule;
    public int handlerAddress;
    public int handlerArgument;
    public final int uid;
    public final AlarmInterruptHandler alarmInterruptHandler;
    public final AlarmInterruptAction alarmInterruptAction;
    public final AlarmInterruptResultAction alarmInterruptResultAction;
    private static final int DEFAULT_SIZE = 20;

    public SceKernelAlarmInfo(long schedule, int handlerAddress, int handlerArgument) {
        this.schedule = schedule;
        this.handlerAddress = handlerAddress;
        this.handlerArgument = handlerArgument;
        this.uid = SceUidManager.getNewUid("ThreadMan-Alarm");
        this.alarmInterruptHandler = new AlarmInterruptHandler(handlerAddress, handlerArgument);
        this.alarmInterruptAction = new AlarmInterruptAction(this);
        this.alarmInterruptResultAction = new AlarmInterruptResultAction(this);
    }

    @Override
    protected void read() {
        this.size = this.read32();
        this.setMaxSize(this.size);
        this.schedule = this.read64();
        this.handlerAddress = this.read32();
        this.handlerArgument = this.read32();
    }

    @Override
    protected void write() {
        this.setMaxSize(this.size);
        this.write32(this.size);
        this.write64(this.schedule);
        this.write32(this.handlerAddress);
        this.write32(this.handlerArgument);
    }

    @Override
    public int sizeof() {
        return this.size;
    }
}

