/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class SceKernelCallbackInfo {
    public static final int size = 56;
    public final String name;
    public final int threadId;
    public final int callback_addr;
    public final int callback_arg_addr;
    public int notifyCount;
    public int notifyArg;
    public final int uid;

    public SceKernelCallbackInfo(String name, int threadId, int callback_addr, int callback_arg_addr) {
        this.name = name;
        this.threadId = threadId;
        this.callback_addr = callback_addr;
        this.callback_arg_addr = callback_arg_addr;
        this.notifyCount = 0;
        this.notifyArg = 0;
        this.uid = SceUidManager.getNewUid("ThreadMan-callback");
    }

    public void write(Memory mem, int address) {
        mem.write32(address, 56);
        Utilities.writeStringNZ(mem, address + 4, 32, this.name);
        mem.write32(address + 36, this.threadId);
        mem.write32(address + 40, this.callback_addr);
        mem.write32(address + 44, this.callback_arg_addr);
        mem.write32(address + 48, this.notifyCount);
        mem.write32(address + 52, this.notifyArg);
    }

    public void startContext(SceKernelThreadInfo thread, IAction afterAction) {
        int registerA0 = this.notifyCount;
        int registerA1 = this.notifyArg;
        int registerA2 = this.callback_arg_addr;
        this.notifyCount = 0;
        this.notifyArg = 0;
        Modules.ThreadManForUserModule.executeCallback(thread, this.callback_addr, afterAction, true, registerA0, registerA1, registerA2);
    }

    public String toString() {
        return String.format("name:'%s', thread:'%s', PC:%08X, $a0:%08X, $a1: %08X, $a2: %08X", this.name, Modules.ThreadManForUserModule.getThreadName(this.threadId), this.callback_addr, this.notifyCount, this.notifyArg, this.callback_arg_addr);
    }
}

