/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.Memory;

public class SceKernelEventFlagInfo {
    public final String name;
    public final int attr;
    public final int initPattern;
    public int currentPattern;
    public int numWaitThreads;
    public final int uid;

    public SceKernelEventFlagInfo(String name, int attr, int initPattern, int currentPattern) {
        this.name = name;
        this.attr = attr;
        this.initPattern = initPattern;
        this.currentPattern = currentPattern;
        this.numWaitThreads = 0;
        this.uid = SceUidManager.getNewUid("ThreadMan-eventflag");
    }

    public void write(Memory mem, int address) {
        int i;
        mem.write32(address, 52);
        int len = this.name.length();
        for (i = 0; i < 32 && i < len; ++i) {
            mem.write8(address + 4 + i, (byte)this.name.charAt(i));
        }
        while (i < 32) {
            mem.write8(address + 4 + i, (byte)0);
            ++i;
        }
        mem.write32(address + 36, this.attr);
        mem.write32(address + 40, this.initPattern);
        mem.write32(address + 44, this.currentPattern);
        mem.write32(address + 48, this.numWaitThreads);
    }
}

