/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class SceKernelFplInfo {
    public int size = 56;
    public String name;
    public int attr;
    public int blockSize;
    public int numBlocks;
    public int freeBlocks;
    public int numWaitThreads;
    private final SysMemUserForUser.SysMemInfo sysMemInfo;
    public final int uid;
    public final int partitionid;
    public int[] blockAddress;
    public boolean[] blockAllocated;

    private SceKernelFplInfo(String name, int partitionid, int attr, int blockSize, int numBlocks, int memType, int memAlign) {
        this.name = name;
        this.attr = attr;
        this.blockSize = blockSize;
        this.numBlocks = numBlocks;
        this.freeBlocks = numBlocks;
        this.numWaitThreads = 0;
        this.uid = SceUidManager.getNewUid("ThreadMan-Fpl");
        this.partitionid = partitionid;
        this.blockAddress = new int[numBlocks];
        this.blockAllocated = new boolean[numBlocks];
        for (int i = 0; i < numBlocks; ++i) {
            this.blockAllocated[i] = false;
        }
        int alignedBlockSize = blockSize + (memAlign - 1) & ~(memAlign - 1);
        int totalFplSize = alignedBlockSize * numBlocks;
        this.sysMemInfo = Modules.SysMemUserForUserModule.malloc(partitionid, String.format("ThreadMan-Fpl-0x%x-%s", this.uid, name), memType, totalFplSize, 0);
        if (this.sysMemInfo == null) {
            throw new RuntimeException("SceKernelFplInfo: not enough free mem");
        }
        for (int i = 0; i < numBlocks; ++i) {
            this.blockAddress[i] = this.sysMemInfo.addr + alignedBlockSize * i;
        }
    }

    public static SceKernelFplInfo tryCreateFpl(String name, int partitionid, int attr, int blockSize, int numBlocks, int memType, int memAlign) {
        SceKernelFplInfo info = null;
        int alignedBlockSize = blockSize + (memAlign - 1) & ~(memAlign - 1);
        int totalFplSize = alignedBlockSize * numBlocks;
        int maxFreeSize = Modules.SysMemUserForUserModule.maxFreeMemSize();
        if (totalFplSize <= maxFreeSize) {
            info = new SceKernelFplInfo(name, partitionid, attr, blockSize, numBlocks, memType, memAlign);
        } else {
            Modules.log.warn("tryCreateFpl not enough free mem (want=" + totalFplSize + ", free=" + maxFreeSize + ", diff=" + (totalFplSize - maxFreeSize) + ")");
        }
        return info;
    }

    public void read(Memory mem, int address) {
        this.size = mem.read32(address);
        this.name = Utilities.readStringNZ(address + 4, 31);
        this.attr = mem.read32(address + 36);
        this.blockSize = mem.read32(address + 40);
        this.numBlocks = mem.read32(address + 44);
        this.freeBlocks = mem.read32(address + 48);
        this.numWaitThreads = mem.read32(address + 52);
    }

    public void write(Memory mem, int address) {
        int i;
        mem.write32(address, this.size);
        for (i = 0; i < 32 && i < this.name.length(); ++i) {
            mem.write8(address + 4 + i, (byte)this.name.charAt(i));
        }
        while (i < 32) {
            mem.write8(address + 4 + i, (byte)0);
            ++i;
        }
        mem.write32(address + 36, this.attr);
        mem.write32(address + 40, this.blockSize);
        mem.write32(address + 44, this.numBlocks);
        mem.write32(address + 48, this.freeBlocks);
        mem.write32(address + 52, this.numWaitThreads);
    }

    public boolean isBlockAllocated(int blockId) {
        return this.blockAllocated[blockId];
    }

    public void freeBlock(int blockId) {
        if (!this.isBlockAllocated(blockId)) {
            throw new IllegalArgumentException("Block " + blockId + " is not allocated");
        }
        this.blockAllocated[blockId] = false;
        ++this.freeBlocks;
    }

    public int allocateBlock(int blockId) {
        if (this.isBlockAllocated(blockId)) {
            throw new IllegalArgumentException("Block " + blockId + " is already allocated");
        }
        this.blockAllocated[blockId] = true;
        --this.freeBlocks;
        return this.blockAddress[blockId];
    }

    public int findFreeBlock() {
        for (int i = 0; i < this.numBlocks; ++i) {
            if (this.isBlockAllocated(i)) continue;
            return i;
        }
        return -1;
    }

    public int findBlockByAddress(int addr) {
        for (int i = 0; i < this.numBlocks; ++i) {
            if (this.blockAddress[i] != addr) continue;
            return i;
        }
        return -1;
    }

    public void deleteSysMemInfo() {
        Modules.SysMemUserForUserModule.free(this.sysMemInfo);
    }
}

