/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class SceKernelLwMutexInfo {
    public int size = 60;
    public String name;
    public int attr;
    public int lwMutexUid;
    public int lwMutexOpaqueWorkAreaAddr;
    public int initCount;
    public int lockedCount;
    public int numWaitThreads;
    public final int uid;
    public int threadid;

    public SceKernelLwMutexInfo(int workArea, String name, int count, int attr) {
        Memory mem = Memory.getInstance();
        this.lwMutexOpaqueWorkAreaAddr = workArea;
        this.name = name;
        this.attr = attr;
        this.initCount = count;
        this.lockedCount = count;
        this.numWaitThreads = 0;
        this.uid = SceUidManager.getNewUid("ThreadMan-LwMutex");
        mem.write32(this.lwMutexOpaqueWorkAreaAddr, this.uid);
    }

    public void read(Memory mem, int address) {
        this.size = mem.read32(address);
        this.name = Utilities.readStringNZ(mem, address + 4, 31);
        this.attr = mem.read32(address + 36);
        this.lwMutexUid = mem.read32(address + 40);
        this.lwMutexOpaqueWorkAreaAddr = mem.read32(address + 44);
        this.initCount = mem.read32(address + 48);
        this.lockedCount = mem.read32(address + 52);
        this.numWaitThreads = mem.read32(address + 56);
    }

    public void write(Memory mem, int address) {
        mem.write32(address, this.size);
        Utilities.writeStringNZ(mem, address + 4, 32, this.name);
        mem.write32(address + 36, this.attr);
        mem.write32(address + 40, this.lwMutexUid);
        mem.write32(address + 44, this.lwMutexOpaqueWorkAreaAddr);
        mem.write32(address + 48, this.initCount);
        mem.write32(address + 52, this.lockedCount);
        mem.write32(address + 56, this.numWaitThreads);
    }

    public String toString() {
        return String.format("SceKernelLwMutexInfo(uid=%x, name=%s, mutexUid=%x, lwMutexOpaqueWorkAreaAddr=0x%X, initCount=%d, lockedCount=%d, numWaitThreads=%d, attr=0x%X, threadid=0x%X)", this.uid, this.name, this.lwMutexUid, this.lwMutexOpaqueWorkAreaAddr, this.initCount, this.lockedCount, this.numWaitThreads, this.attr, this.threadid);
    }
}

