/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;

public class SceKernelModuleInfo
extends pspAbstractMemoryMappedStructure {
    public int size = 96;
    public byte nsegment;
    public byte[] reserved = new byte[3];
    public int[] segmentaddr = new int[4];
    public int[] segmentsize = new int[4];
    public int entry_addr;
    public int gp_value;
    public int text_addr;
    public int text_size;
    public int data_size;
    public int bss_size;
    public short attribute;
    public byte[] version = new byte[2];
    public String name;

    public void copy(SceModule sceModule) {
        this.nsegment = (byte)(sceModule.nsegment & 0xFF);
        this.segmentaddr[0] = sceModule.segmentaddr[0];
        this.segmentaddr[1] = sceModule.segmentaddr[1];
        this.segmentaddr[2] = sceModule.segmentaddr[2];
        this.segmentaddr[3] = sceModule.segmentaddr[3];
        this.segmentsize[0] = sceModule.segmentsize[0];
        this.segmentsize[1] = sceModule.segmentsize[1];
        this.segmentsize[2] = sceModule.segmentsize[2];
        this.segmentsize[3] = sceModule.segmentsize[3];
        this.entry_addr = sceModule.entry_addr;
        this.gp_value = sceModule.gp_value;
        this.text_addr = sceModule.text_addr;
        this.text_size = sceModule.text_size;
        this.data_size = sceModule.data_size;
        this.bss_size = sceModule.bss_size;
        this.attribute = sceModule.attribute;
        this.version[0] = sceModule.version[0];
        this.version[1] = sceModule.version[1];
        this.name = sceModule.modname;
    }

    @Override
    protected void read() {
        this.size = this.read32();
        this.setMaxSize(this.size);
        this.nsegment = (byte)(this.read8() & 0xFF);
        this.reserved[0] = (byte)(this.read8() & 0xFF);
        this.reserved[1] = (byte)(this.read8() & 0xFF);
        this.reserved[2] = (byte)(this.read8() & 0xFF);
        this.segmentaddr[0] = this.read32();
        this.segmentaddr[1] = this.read32();
        this.segmentaddr[2] = this.read32();
        this.segmentaddr[3] = this.read32();
        this.segmentsize[0] = this.read32();
        this.segmentsize[1] = this.read32();
        this.segmentsize[2] = this.read32();
        this.segmentsize[3] = this.read32();
        this.entry_addr = this.read32();
        this.gp_value = this.read32();
        this.text_addr = this.read32();
        this.text_size = this.read32();
        this.data_size = this.read32();
        this.bss_size = this.read32();
        this.attribute = (short)(this.read16() & 0xFFFF);
        this.version[0] = (byte)(this.read8() & 0xFF);
        this.version[1] = (byte)(this.read8() & 0xFF);
        this.name = this.readStringNZ(28);
    }

    @Override
    protected void write() {
        this.setMaxSize(this.size);
        this.write32(this.size);
        this.write8(this.nsegment);
        this.writeSkip(3);
        this.write32(this.segmentaddr[0]);
        this.write32(this.segmentaddr[1]);
        this.write32(this.segmentaddr[2]);
        this.write32(this.segmentaddr[3]);
        this.write32(this.segmentsize[0]);
        this.write32(this.segmentsize[1]);
        this.write32(this.segmentsize[2]);
        this.write32(this.segmentsize[3]);
        this.write32(this.entry_addr);
        this.write32(this.gp_value);
        this.write32(this.text_addr);
        this.write32(this.text_size);
        this.write32(this.data_size);
        this.write32(this.bss_size);
        this.write16(this.attribute);
        this.write8(this.version[0]);
        this.write8(this.version[1]);
        this.writeStringNZ(28, this.name);
    }

    @Override
    public int sizeof() {
        return this.size;
    }
}

