/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class SceKernelMppInfo {
    public int size = 56;
    public String name;
    public int attr;
    public int bufSize;
    public int freeSize;
    public int numSendWaitThreads;
    public int numReceiveWaitThreads;
    private final SysMemUserForUser.SysMemInfo sysMemInfo;
    public final int uid;
    public final int partitionid;
    public final int address;
    private int head;
    private int tail;

    private SceKernelMppInfo(String name, int partitionid, int attr, int size, int memType) {
        this.name = name;
        this.attr = attr;
        this.bufSize = size;
        this.freeSize = size;
        this.numSendWaitThreads = 0;
        this.numReceiveWaitThreads = 0;
        this.sysMemInfo = Modules.SysMemUserForUserModule.malloc(partitionid, "ThreadMan-MsgPipe", memType, size, 0);
        if (this.sysMemInfo == null) {
            throw new RuntimeException("SceKernelFplInfo: not enough free mem");
        }
        this.address = this.sysMemInfo.addr;
        this.uid = SceUidManager.getNewUid("ThreadMan-MsgPipe");
        this.partitionid = partitionid;
        this.head = 0;
        this.tail = 0;
    }

    public static SceKernelMppInfo tryCreateMpp(String name, int partitionid, int attr, int size, int memType) {
        SceKernelMppInfo info = null;
        int alignedSize = size + 255 & 0xFFFFFF00;
        int maxFreeSize = Modules.SysMemUserForUserModule.maxFreeMemSize();
        if (size <= 0) {
            Modules.log.warn("tryCreateMpp invalid size " + size);
        } else if (alignedSize > maxFreeSize) {
            Modules.log.warn("tryCreateMpp not enough free mem (want=" + alignedSize + ",free=" + maxFreeSize + ",diff=" + (alignedSize - maxFreeSize) + ")");
        } else {
            info = new SceKernelMppInfo(name, partitionid, attr, size, memType);
        }
        return info;
    }

    public void read(Memory mem, int address) {
        this.size = mem.read32(address);
        this.name = Utilities.readStringNZ(mem, address + 4, 32);
        this.attr = mem.read32(address + 36);
        this.bufSize = mem.read32(address + 40);
        this.freeSize = mem.read32(address + 44);
        this.numSendWaitThreads = mem.read32(address + 48);
        this.numReceiveWaitThreads = mem.read32(address + 52);
    }

    public void write(Memory mem, int address) {
        mem.write32(address, this.size);
        Utilities.writeStringNZ(mem, address + 4, 32, this.name);
        mem.write32(address + 36, this.attr);
        mem.write32(address + 40, this.bufSize);
        mem.write32(address + 44, this.freeSize);
        mem.write32(address + 48, this.numSendWaitThreads);
        mem.write32(address + 52, this.numReceiveWaitThreads);
    }

    public int availableReadSize() {
        return this.bufSize - this.freeSize;
    }

    public int availableWriteSize() {
        return this.freeSize;
    }

    public void deleteSysMemInfo() {
        Modules.SysMemUserForUserModule.free(this.sysMemInfo);
    }

    public void append(Memory mem, int src, int size) {
        this.freeSize -= size;
        while (size > 0) {
            int copySize = Math.min(this.bufSize - this.tail, size);
            mem.memcpy(this.address + this.tail, src, copySize);
            src += copySize;
            size -= copySize;
            this.tail = (this.tail + copySize) % this.bufSize;
        }
    }

    public void consume(Memory mem, int dst, int size) {
        this.freeSize += size;
        while (size > 0) {
            int copySize = Math.min(this.bufSize - this.head, size);
            mem.memcpy(dst, this.address + this.head, copySize);
            dst += copySize;
            size -= copySize;
            this.head = (this.head + copySize) % this.bufSize;
        }
    }
}

