/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class SceKernelMutexInfo {
    public int size = 52;
    public String name;
    public int attr;
    public int initCount;
    public int lockedCount;
    public int numWaitThreads;
    public final int uid;
    public int threadid;

    public SceKernelMutexInfo(String name, int count, int attr) {
        this.name = name;
        this.attr = attr;
        this.initCount = count;
        this.lockedCount = count;
        this.numWaitThreads = 0;
        this.uid = SceUidManager.getNewUid("ThreadMan-Mutex");
    }

    public void read(Memory mem, int address) {
        this.size = mem.read32(address);
        this.name = Utilities.readStringNZ(mem, address + 4, 31);
        this.attr = mem.read32(address + 36);
        this.initCount = mem.read32(address + 40);
        this.lockedCount = mem.read32(address + 44);
        this.numWaitThreads = mem.read32(address + 48);
    }

    public void write(Memory mem, int address) {
        mem.write32(address, this.size);
        Utilities.writeStringNZ(mem, address + 4, 32, this.name);
        mem.write32(address + 36, this.attr);
        mem.write32(address + 40, this.initCount);
        mem.write32(address + 44, this.lockedCount);
        mem.write32(address + 48, this.numWaitThreads);
    }

    public String toString() {
        return String.format("SceKernelMutexInfo(uid=%x, name=%s, initCount=%d, lockedCount=%d, numWaitThreads=%d, attr=0x%X)", this.uid, this.name, this.initCount, this.lockedCount, this.numWaitThreads, this.attr);
    }
}

