/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;

public class SceKernelThreadEventHandlerInfo
extends pspAbstractMemoryMappedStructure {
    public int size = 52;
    public String name;
    public int thid;
    public int mask;
    public int handler;
    public int common;
    public final int uid;
    public int result;
    private static final int DEFAULT_SIZE = 52;
    private static final String uidPurpose = "ThreadMan-ThreadEventHandler";
    public static final int THREAD_EVENT_ID_ALL = -1;
    public static final int THREAD_EVENT_ID_KERN = -8;
    public static final int THREAD_EVENT_ID_USER = -16;
    public static final int THREAD_EVENT_ID_CURRENT = 0;
    public static final int THREAD_EVENT_CREATE = 1;
    public static final int THREAD_EVENT_START = 2;
    public static final int THREAD_EVENT_EXIT = 4;
    public static final int THREAD_EVENT_DELETE = 8;
    public static final int THREAD_EVENT_ALL = 15;

    public SceKernelThreadEventHandlerInfo(String name, int thid, int mask, int handler, int common) {
        this.name = name;
        this.thid = thid;
        this.mask = mask;
        this.handler = handler;
        this.common = common;
        this.uid = SceUidManager.getNewUid(uidPurpose);
    }

    public void release() {
        SceUidManager.releaseUid(this.uid, uidPurpose);
        this.mask = 0;
        this.handler = 0;
    }

    public boolean hasEventMask(int event) {
        return (this.mask & event) == event;
    }

    public void triggerThreadEventHandler(SceKernelThreadInfo contextThread, int event) {
        Modules.ThreadManForUserModule.executeCallback(contextThread, this.handler, new AfterEventHandler(), false, event, this.thid, this.common);
    }

    @Override
    protected void read() {
        this.size = this.read32();
        this.setMaxSize(this.size);
        this.name = this.readStringNZ(32);
        this.thid = this.read32();
        this.mask = this.read32();
        this.handler = this.read32();
        this.common = this.read32();
    }

    @Override
    protected void write() {
        this.setMaxSize(this.size);
        this.write32(this.size);
        this.writeStringNZ(32, this.name);
        this.write32(this.thid);
        this.write32(this.mask);
        this.write32(this.handler);
        this.write32(this.common);
    }

    @Override
    public int sizeof() {
        return this.size;
    }

    private class AfterEventHandler
    implements IAction {
        private AfterEventHandler() {
        }

        @Override
        public void execute() {
            SceKernelThreadEventHandlerInfo.this.result = Emulator.getProcessor().cpu.gpr[2];
            if (Modules.log.isInfoEnabled()) {
                Modules.log.info(String.format("Thread Event Handler exit detected (thid=%X, result=0x%08X)", SceKernelThreadEventHandlerInfo.this.thid, SceKernelThreadEventHandlerInfo.this.result));
            }
        }
    }
}

