/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelCallbackInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.HLE.modules150.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class SceKernelThreadInfo
implements Comparator<SceKernelThreadInfo> {
    public static final int PSP_MODULE_USER = 0;
    public static final int PSP_MODULE_NO_STOP = 1;
    public static final int PSP_MODULE_SINGLE_LOAD = 2;
    public static final int PSP_MODULE_SINGLE_START = 4;
    public static final int PSP_MODULE_POPS = 512;
    public static final int PSP_MODULE_DEMO = 512;
    public static final int PSP_MODULE_GAMESHARING = 1024;
    public static final int PSP_MODULE_VSH = 2048;
    public static final int PSP_MODULE_KERNEL = 4096;
    public static final int PSP_MODULE_USE_MEMLMD_LIB = 8192;
    public static final int PSP_MODULE_USE_SEMAPHORE_LIB = 16384;
    public static final int PSP_THREAD_ATTR_USER = Integer.MIN_VALUE;
    public static final int PSP_THREAD_ATTR_USBWLAN = -1610612736;
    public static final int PSP_THREAD_ATTR_VSH = -1073741824;
    public static final int PSP_THREAD_ATTR_KERNEL = 4096;
    public static final int PSP_THREAD_ATTR_VFPU = 16384;
    public static final int PSP_THREAD_ATTR_SCRATCH_SRAM = 32768;
    public static final int PSP_THREAD_ATTR_NO_FILLSTACK = 0x100000;
    public static final int PSP_THREAD_ATTR_CLEAR_STACK = 0x200000;
    public static final int PSP_THREAD_RUNNING = 1;
    public static final int PSP_THREAD_READY = 2;
    public static final int PSP_THREAD_WAITING = 4;
    public static final int PSP_THREAD_SUSPEND = 8;
    public static final int PSP_THREAD_WAITING_SUSPEND = 12;
    public static final int PSP_THREAD_STOPPED = 16;
    public static final int PSP_THREAD_KILLED = 32;
    public static final int PSP_WAIT_NONE = 0;
    public static final int PSP_WAIT_SLEEP = 1;
    public static final int PSP_WAIT_DELAY = 2;
    public static final int PSP_WAIT_SEMA = 3;
    public static final int PSP_WAIT_EVENTFLAG = 4;
    public static final int PSP_WAIT_MBX = 5;
    public static final int PSP_WAIT_VPL = 6;
    public static final int PSP_WAIT_FPL = 7;
    public static final int PSP_WAIT_MSGPIPE = 8;
    public static final int PSP_WAIT_THREAD_END = 9;
    public static final int PSP_WAIT_EVENTHANDLER = 10;
    public static final int PSP_WAIT_CALLBACK_DELETE = 11;
    public static final int PSP_WAIT_MUTEX = 12;
    public static final int PSP_WAIT_LWMUTEX = 13;
    public static final int JPCSP_FIRST_INTERNAL_WAIT_TYPE = 256;
    public static final int JPCSP_WAIT_IO = 256;
    public static final int JPCSP_WAIT_UMD = 257;
    public static final int JPCSP_WAIT_BLOCKED = 258;
    public final String name;
    public int attr;
    public int status;
    public final int entry_addr;
    private int stackAddr;
    public int stackSize;
    public int gpReg_addr;
    public final int initPriority;
    public int currentPriority;
    public int waitType;
    public int waitId;
    public int wakeupCount;
    public int exitStatus;
    public long runClocks;
    public int intrPreemptCount;
    public int threadPreemptCount;
    public int releaseCount;
    public int notifyCallback;
    public int errno;
    private SysMemUserForUser.SysMemInfo stackSysMemInfo;
    public final int uid;
    public int moduleid;
    public CpuState cpuContext;
    public boolean doDelete;
    public IAction doDeleteAction;
    public boolean doCallbacks;
    public final ThreadWaitInfo wait;
    public int displayLastWaitVcount;
    public long javaThreadId = -1L;
    public long javaThreadCpuTimeNanos = -1L;
    public static final int THREAD_CALLBACK_UMD = 0;
    public static final int THREAD_CALLBACK_IO = 1;
    public static final int THREAD_CALLBACK_MEMORYSTICK = 2;
    public static final int THREAD_CALLBACK_MEMORYSTICK_FAT = 3;
    public static final int THREAD_CALLBACK_POWER = 4;
    public static final int THREAD_CALLBACK_EXIT = 5;
    public static final int THREAD_CALLBACK_USER_DEFINED = 6;
    public static final int THREAD_CALLBACK_SIZE = 7;
    private RegisteredCallbacks[] registeredCallbacks;
    public Queue<ThreadManForUser.Callback> pendingCallbacks = new LinkedList<ThreadManForUser.Callback>();
    private SysMemUserForUser.SysMemInfo extendedStackSysMemInfo;

    public SceKernelThreadInfo(String name, int entry_addr, int initPriority, int stackSize, int attr) {
        stackSize = stackSize < 512 ? 512 : stackSize + 255 & 0xFFFFFF00;
        this.name = name;
        this.entry_addr = entry_addr;
        this.initPriority = initPriority;
        this.stackSize = stackSize;
        this.attr = attr;
        this.uid = SceUidManager.getNewUid("ThreadMan-thread");
        this.stackSysMemInfo = Modules.SysMemUserForUserModule.malloc(2, String.format("ThreadMan-Stack-0x%x-%s", this.uid, name), 1, stackSize, 0);
        this.stackAddr = this.stackSysMemInfo == null ? 0 : this.stackSysMemInfo.addr;
        this.gpReg_addr = Emulator.getProcessor().cpu.gpr[28];
        this.cpuContext = new CpuState(Emulator.getProcessor().cpu);
        this.wait = new ThreadWaitInfo();
        this.reset();
    }

    public void reset() {
        this.status = 16;
        int k0 = this.stackAddr + this.stackSize - 256;
        Memory mem = Memory.getInstance();
        if (this.stackAddr != 0 && this.stackSize > 0) {
            if ((this.attr & 0x100000) != 0x100000) {
                mem.memset(this.stackAddr, (byte)-1, this.stackSize);
            }
            mem.memset(k0, (byte)0, 256);
            mem.write32(k0 + 192, this.stackAddr);
            mem.write32(k0 + 202, this.uid);
            mem.write32(k0 + 248, -1);
            mem.write32(k0 + 252, -1);
            mem.write32(this.stackAddr, this.uid);
        }
        this.currentPriority = this.initPriority;
        this.waitType = 0;
        this.waitId = 0;
        this.wakeupCount = 0;
        this.exitStatus = -2147352158;
        this.runClocks = 0L;
        this.intrPreemptCount = 0;
        this.threadPreemptCount = 0;
        this.releaseCount = 0;
        this.notifyCallback = 0;
        this.cpuContext.pc = this.entry_addr;
        this.cpuContext.npc = this.entry_addr;
        this.cpuContext.gpr[29] = this.stackAddr + this.stackSize - 512;
        this.cpuContext.gpr[26] = k0;
        this.cpuContext.gpr[31] = 0x8000020;
        this.doDelete = false;
        this.doCallbacks = false;
        this.registeredCallbacks = new RegisteredCallbacks[7];
        for (int i = 0; i < this.registeredCallbacks.length; ++i) {
            this.registeredCallbacks[i] = new RegisteredCallbacks(i);
        }
    }

    public void saveContext() {
        this.cpuContext = Emulator.getProcessor().cpu;
    }

    public void restoreContext() {
        this.cpuContext.pc = this.cpuContext.npc;
        Emulator.getProcessor().setCpu(this.cpuContext);
        RuntimeContext.update();
    }

    @Override
    public int compare(SceKernelThreadInfo o1, SceKernelThreadInfo o2) {
        return o1.currentPriority - o2.currentPriority;
    }

    private int getPSPWaitType() {
        if (this.waitType >= 256) {
            return 4;
        }
        return this.waitType;
    }

    public void write(Memory mem, int address) {
        mem.write32(address, 104);
        Utilities.writeStringNZ(mem, address + 4, 32, this.name);
        mem.write32(address + 36, this.attr);
        mem.write32(address + 40, this.status);
        mem.write32(address + 44, this.entry_addr);
        mem.write32(address + 48, this.stackAddr);
        mem.write32(address + 52, this.stackSize);
        mem.write32(address + 56, this.gpReg_addr);
        mem.write32(address + 60, this.initPriority);
        mem.write32(address + 64, this.currentPriority);
        mem.write32(address + 68, this.getPSPWaitType());
        mem.write32(address + 72, this.waitId);
        mem.write32(address + 76, this.wakeupCount);
        mem.write32(address + 80, this.exitStatus);
        mem.write64(address + 84, this.runClocks);
        mem.write32(address + 92, this.intrPreemptCount);
        mem.write32(address + 96, this.threadPreemptCount);
        mem.write32(address + 100, this.releaseCount);
    }

    public void writeRunStatus(Memory mem, int address) {
        mem.write32(address, 40);
        mem.write32(address + 4, this.status);
        mem.write32(address + 8, this.currentPriority);
        mem.write32(address + 12, this.waitType);
        mem.write32(address + 16, this.waitId);
        mem.write32(address + 20, this.wakeupCount);
        mem.write64(address + 24, this.runClocks);
        mem.write32(address + 28, this.intrPreemptCount);
        mem.write32(address + 32, this.threadPreemptCount);
        mem.write32(address + 36, this.releaseCount);
    }

    public void setSystemStack(int stackAddr, int stackSize) {
        this.freeStack();
        this.stackAddr = stackAddr;
        this.stackSize = stackSize;
    }

    public void freeStack() {
        if (this.stackSysMemInfo != null) {
            Modules.SysMemUserForUserModule.free(this.stackSysMemInfo);
            this.stackSysMemInfo = null;
            this.stackAddr = 0;
        }
        this.freeExtendedStack();
    }

    public void freeExtendedStack() {
        if (this.extendedStackSysMemInfo != null) {
            Modules.SysMemUserForUserModule.free(this.extendedStackSysMemInfo);
            this.extendedStackSysMemInfo = null;
        }
    }

    public int extendStack(int size) {
        this.extendedStackSysMemInfo = Modules.SysMemUserForUserModule.malloc(2, String.format("ThreadMan-ExtendedStack-0x%x-%s", this.uid, this.name), 1, size, 0);
        return this.extendedStackSysMemInfo.addr;
    }

    public int getStackAddr() {
        if (this.extendedStackSysMemInfo != null) {
            return this.extendedStackSysMemInfo.addr;
        }
        return this.stackAddr;
    }

    public static String getStatusName(int status) {
        StringBuilder s = new StringBuilder();
        if ((status & 1) == 1) {
            s.append(" | PSP_THREAD_RUNNING");
        }
        if ((status & 2) == 2) {
            s.append(" | PSP_THREAD_READY");
        }
        if ((status & 4) == 4) {
            s.append(" | PSP_THREAD_WAITING");
        }
        if ((status & 8) == 8) {
            s.append(" | PSP_THREAD_SUSPEND");
        }
        if ((status & 0x10) == 16) {
            s.append(" | PSP_THREAD_STOPPED");
        }
        if ((status & 0x20) == 32) {
            s.append(" | PSP_THREAD_KILLED");
        }
        if (s.length() > 0) {
            s.delete(0, 3);
        } else {
            s.append("UNKNOWN");
        }
        return s.toString();
    }

    public String getStatusName() {
        return SceKernelThreadInfo.getStatusName(this.status);
    }

    public static String getWaitName(int waitType, ThreadWaitInfo wait, int status) {
        StringBuilder s = new StringBuilder();
        if (waitType == 9) {
            s.append(String.format(" | ThreadEnd (0x%04X)", wait.ThreadEnd_id));
        }
        if (waitType == 4) {
            s.append(String.format(" | EventFlag (0x%04X)", wait.EventFlag_id));
        }
        if (waitType == 3) {
            s.append(String.format(" | Semaphore (0x%04X)", wait.Semaphore_id));
        }
        if (waitType == 12) {
            s.append(String.format(" | Mutex (0x%04X)", wait.Mutex_id));
        }
        if (waitType == 13) {
            s.append(String.format(" | LwMutex (0x%04X)", wait.LwMutex_id));
        }
        if (waitType == 256) {
            s.append(String.format(" | Io (0x%04X)", wait.Io_id));
        }
        if (waitType == 257) {
            s.append(String.format(" | Umd (0x%02X)", wait.wantedUmdStat));
        }
        if (waitType == 258) {
            s.append(String.format(" | Blocked", new Object[0]));
        }
        if (s.length() > 0) {
            s.delete(0, 3);
        } else {
            s.append("None");
            if ((status & 4) == 4) {
                if (wait.forever) {
                    s.append(" (sleeping)");
                } else {
                    int restDelay = (int)(wait.microTimeTimeout - Emulator.getClock().microTime());
                    if (restDelay < 0) {
                        restDelay = 0;
                    }
                    s.append(String.format(" (delay %d us, rest %d us)", wait.micros, restDelay));
                }
            }
        }
        return s.toString();
    }

    public String getWaitName() {
        return SceKernelThreadInfo.getWaitName(this.waitType, this.wait, this.status);
    }

    public boolean isSuspended() {
        return (this.status & 8) != 0;
    }

    public boolean isWaiting() {
        return (this.status & 4) != 0;
    }

    public boolean isWaitingForType(int waitType) {
        if (!this.isWaiting() || this.isSuspended()) {
            return false;
        }
        return this.waitType == waitType;
    }

    public boolean isRunning() {
        return (this.status & 1) != 0;
    }

    public boolean isReady() {
        return (this.status & 2) != 0;
    }

    public boolean isStopped() {
        return (this.status & 0x10) != 0;
    }

    public static boolean isKernelMode(int attr) {
        return (attr & 0x1000) != 0;
    }

    public static boolean isUserMode(int attr) {
        return (attr & Integer.MIN_VALUE) != 0;
    }

    public boolean isKernelMode() {
        return SceKernelThreadInfo.isKernelMode(this.attr);
    }

    public boolean isUserMode() {
        return SceKernelThreadInfo.isUserMode(this.attr);
    }

    public RegisteredCallbacks getRegisteredCallbacks(int type) {
        return this.registeredCallbacks[type];
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.name);
        s.append("(");
        s.append("Status " + this.getStatusName());
        s.append(", Wait " + this.getWaitName());
        s.append(", doCallbacks " + this.doCallbacks);
        s.append(")");
        return s.toString();
    }

    public static class RegisteredCallbacks {
        private int type;
        private List<SceKernelCallbackInfo> callbacks;
        private List<SceKernelCallbackInfo> readyCallbacks;
        private int maxNumberOfCallbacks = 32;

        public RegisteredCallbacks(int type) {
            this.type = type;
            this.callbacks = new LinkedList<SceKernelCallbackInfo>();
            this.readyCallbacks = new LinkedList<SceKernelCallbackInfo>();
        }

        public boolean hasCallbacks() {
            return !this.callbacks.isEmpty();
        }

        public SceKernelCallbackInfo getCallbackByUid(int cbid) {
            for (SceKernelCallbackInfo callback : this.callbacks) {
                if (callback.uid != cbid) continue;
                return callback;
            }
            return null;
        }

        public boolean hasCallback(int cbid) {
            return this.getCallbackByUid(cbid) != null;
        }

        public boolean hasCallback(SceKernelCallbackInfo callback) {
            return this.callbacks.contains(callback);
        }

        public boolean addCallback(SceKernelCallbackInfo callback) {
            if (this.hasCallback(callback)) {
                return true;
            }
            if (this.getNumberOfCallbacks() >= this.maxNumberOfCallbacks) {
                return false;
            }
            this.callbacks.add(callback);
            return true;
        }

        public void setCallbackReady(SceKernelCallbackInfo callback) {
            if (this.hasCallback(callback) && !this.isCallbackReady(callback)) {
                this.readyCallbacks.add(callback);
            }
        }

        public boolean isCallbackReady(SceKernelCallbackInfo callback) {
            return this.readyCallbacks.contains(callback);
        }

        public SceKernelCallbackInfo removeCallback(SceKernelCallbackInfo callback) {
            if (!this.callbacks.remove(callback)) {
                return null;
            }
            this.readyCallbacks.remove(callback);
            return callback;
        }

        public SceKernelCallbackInfo getNextReadyCallback() {
            if (this.readyCallbacks.isEmpty()) {
                return null;
            }
            return this.readyCallbacks.remove(0);
        }

        public int getNumberOfCallbacks() {
            return this.callbacks.size();
        }

        public SceKernelCallbackInfo getCallbackByIndex(int index) {
            return this.callbacks.get(index);
        }

        public String toString() {
            return String.format("RegisteredCallbacks[type %d, count %d, ready %d]", this.type, this.callbacks.size(), this.readyCallbacks.size());
        }
    }
}

