/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.interrupts.VTimerInterruptHandler;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.scheduler.VTimerInterruptAction;
import jpcsp.scheduler.VTimerInterruptResultAction;

public class SceKernelVTimerInfo
extends pspAbstractMemoryMappedStructure {
    public int size = 72;
    public String name;
    public int active;
    public long base;
    public long current;
    public long schedule;
    public int handlerAddress;
    public int handlerArgument;
    public final int uid;
    public VTimerInterruptHandler vtimerInterruptHandler;
    public final VTimerInterruptAction vtimerInterruptAction;
    public final VTimerInterruptResultAction vtimerInterruptResultAction;
    private int internalMemory;
    private SysMemUserForUser.SysMemInfo sysMemInfo;
    private static final int DEFAULT_SIZE = 72;
    public static final int ACTIVE_RUNNING = 1;
    public static final int ACTIVE_STOPPED = 0;

    public SceKernelVTimerInfo(String name) {
        this.name = name;
        this.active = 0;
        this.uid = SceUidManager.getNewUid("ThreadMan-VTimer");
        this.vtimerInterruptHandler = new VTimerInterruptHandler(this);
        this.vtimerInterruptAction = new VTimerInterruptAction(this);
        this.vtimerInterruptResultAction = new VTimerInterruptResultAction(this);
        this.internalMemory = 0;
    }

    public int getInternalMemory() {
        if (this.internalMemory == 0) {
            this.sysMemInfo = Modules.SysMemUserForUserModule.malloc(2, "SceKernelVTimerInfo", 0, 16, 0);
            if (this.sysMemInfo != null) {
                this.internalMemory = this.sysMemInfo.addr;
            }
        }
        return this.internalMemory;
    }

    public void delete() {
        if (this.internalMemory != 0) {
            Modules.SysMemUserForUserModule.free(this.sysMemInfo);
            this.internalMemory = 0;
        }
    }

    @Override
    protected void read() {
        this.size = this.read32();
        this.setMaxSize(this.size);
        this.name = this.readStringNZ(32);
        this.active = this.read32();
        this.base = this.read64();
        this.current = this.read64();
        this.schedule = this.read64();
        this.handlerAddress = this.read32();
        this.handlerArgument = this.read32();
    }

    @Override
    public int sizeof() {
        return this.size;
    }

    @Override
    protected void write() {
        this.setMaxSize(this.size);
        this.write32(this.size);
        this.writeStringNZ(32, this.name);
        this.write32(this.active);
        this.write64(this.base);
        this.write64(this.current);
        this.write64(this.schedule);
        this.write32(this.handlerAddress);
        this.write32(this.handlerArgument);
    }
}

