/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Calendar;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.kernel.types.pspUtilityDialogCommon;
import jpcsp.Memory;
import jpcsp.crypto.CryptoEngine;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.format.PSF;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;

public class SceUtilitySavedataParam
extends pspAbstractMemoryMappedStructure {
    public static final String savedataPath = "ms0:/PSP/SAVEDATA/";
    public static final String savedataFilePath = "ms0/PSP/SAVEDATA/";
    public static final String icon0FileName = "ICON0.PNG";
    public static final String icon1FileName = "ICON1.PNG";
    public static final String pic1FileName = "PIC1.PNG";
    public static final String snd0FileName = "SND0.AT3";
    public static final String paramSfoFileName = "PARAM.SFO";
    public static final String anyFileName = "<>";
    public pspUtilityDialogCommon base;
    public int mode;
    public static final int MODE_AUTOLOAD = 0;
    public static final int MODE_AUTOSAVE = 1;
    public static final int MODE_LOAD = 2;
    public static final int MODE_SAVE = 3;
    public static final int MODE_LISTLOAD = 4;
    public static final int MODE_LISTSAVE = 5;
    public static final int MODE_LISTDELETE = 6;
    public static final int MODE_DELETE = 7;
    public static final int MODE_SIZES = 8;
    public static final int MODE_AUTODELETE = 9;
    public static final int MODE_SINGLEDELETE = 10;
    public static final int MODE_LIST = 11;
    public static final int MODE_FILES = 12;
    public static final int MODE_MAKEDATASECURE = 13;
    public static final int MODE_MAKEDATA = 14;
    public static final int MODE_READSECURE = 15;
    public static final int MODE_READ = 16;
    public static final int MODE_WRITESECURE = 17;
    public static final int MODE_WRITE = 18;
    public static final int MODE_ERASESECURE = 19;
    public static final int MODE_ERASE = 20;
    public static final int MODE_DELETEDATA = 21;
    public static final int MODE_GETSIZE = 22;
    public static final String[] modeNames = new String[]{"AUTOLOAD", "AUTOSAVE", "LOAD", "SAVE", "LISTLOAD", "LISTSAVE", "LISTDELETE", "DELETE", "SIZES", "AUTODELETE", "SINGLEDELETE", "LIST", "FILES", "MAKEDATASECURE", "MAKEDATA", "READSECURE", "READ", "WRITESECURE", "WRITE", "ERASESECURE", "ERASE", "DELETEDATA", "GETSIZE"};
    public int bind;
    public static final int BIND_NOT_USED = 0;
    public static final int BIND_IS_OK = 1;
    public static final int BIND_IS_REJECTED = 2;
    public static final int BIND_IS_NOT_SUPPORTED = 3;
    public boolean overwrite;
    public String gameName;
    public String saveName;
    public String fileName;
    public String[] saveNameList;
    public int saveNameListAddr;
    int dataBuf;
    int dataBufSize;
    public int dataSize;
    public PspUtilitySavedataSFOParam sfoParam;
    public PspUtilitySavedataFileData icon0FileData;
    public PspUtilitySavedataFileData icon1FileData;
    public PspUtilitySavedataFileData pic1FileData;
    public PspUtilitySavedataFileData snd0FileData;
    int newDataAddr;
    public PspUtilitySavedataListSaveNewData newData;
    public int focus;
    public static final int FOCUS_UNKNOWN = 0;
    public static final int FOCUS_FIRSTLIST = 1;
    public static final int FOCUS_LASTLIST = 2;
    public static final int FOCUS_LATEST = 3;
    public static final int FOCUS_OLDEST = 4;
    public static final int FOCUS_FIRSTEMPTY = 7;
    public static final int FOCUS_LASTEMPTY = 8;
    public int abortStatus;
    public int msFreeAddr;
    public int msDataAddr;
    public int utilityDataAddr;
    public byte[] key = new byte[16];
    public int secureVersion;
    public int multiStatus;
    public static final int MULTI_STATUS_SINGLE = 0;
    public static final int MULTI_STATUS_INIT = 1;
    public static final int MULTI_STATUS_RELAY = 2;
    public static final int MULTI_STATUS_FINISH = 3;
    public int idListAddr;
    public int fileListAddr;
    public int sizeAddr;

    @Override
    protected void read() {
        this.base = new pspUtilityDialogCommon();
        this.read(this.base);
        this.setMaxSize(this.base.size);
        this.mode = this.read32();
        this.bind = this.read32();
        this.overwrite = this.read32() != 0;
        this.gameName = this.readStringNZ(13);
        this.readUnknown(3);
        this.saveName = this.readStringNZ(20);
        this.saveNameListAddr = this.read32();
        if (Memory.isAddressGood(this.saveNameListAddr)) {
            ArrayList<String> newSaveNameList = new ArrayList<String>();
            boolean endOfList = false;
            int i = 0;
            while (!endOfList) {
                String saveNameItem = Utilities.readStringNZ(this.mem, this.saveNameListAddr + i, 20);
                if (saveNameItem == null || saveNameItem.length() == 0) {
                    endOfList = true;
                } else {
                    newSaveNameList.add(saveNameItem);
                }
                i += 20;
            }
            this.saveNameList = newSaveNameList.toArray(new String[newSaveNameList.size()]);
        }
        this.fileName = this.readStringNZ(13);
        this.readUnknown(3);
        this.dataBuf = this.read32();
        this.dataBufSize = this.read32();
        this.dataSize = this.read32();
        this.sfoParam = new PspUtilitySavedataSFOParam();
        this.read(this.sfoParam);
        this.icon0FileData = new PspUtilitySavedataFileData();
        this.read(this.icon0FileData);
        this.icon1FileData = new PspUtilitySavedataFileData();
        this.read(this.icon1FileData);
        this.pic1FileData = new PspUtilitySavedataFileData();
        this.read(this.pic1FileData);
        this.snd0FileData = new PspUtilitySavedataFileData();
        this.read(this.snd0FileData);
        this.newDataAddr = this.read32();
        if (this.newDataAddr != 0) {
            this.newData = new PspUtilitySavedataListSaveNewData();
            this.newData.read(this.mem, this.newDataAddr);
        } else {
            this.newData = null;
        }
        this.focus = this.read32();
        this.abortStatus = this.read32();
        this.msFreeAddr = this.read32();
        this.msDataAddr = this.read32();
        this.utilityDataAddr = this.read32();
        this.read8Array(this.key);
        this.secureVersion = this.read32();
        this.multiStatus = this.read32();
        this.idListAddr = this.read32();
        this.fileListAddr = this.read32();
        this.sizeAddr = this.read32();
    }

    @Override
    protected void write() {
        this.setMaxSize(this.base.size);
        this.write(this.base);
        this.write32(this.mode);
        this.write32(this.bind);
        this.write32(this.overwrite ? 1 : 0);
        this.writeStringNZ(13, this.gameName);
        this.writeUnknown(3);
        this.writeStringNZ(20, this.saveName);
        this.write32(this.saveNameListAddr);
        this.writeStringNZ(13, this.fileName);
        this.writeUnknown(3);
        this.write32(this.dataBuf);
        this.write32(this.dataBufSize);
        this.write32(this.dataSize);
        this.write(this.sfoParam);
        this.write(this.icon0FileData);
        this.write(this.icon1FileData);
        this.write(this.pic1FileData);
        this.write(this.snd0FileData);
        this.write32(this.newDataAddr);
        if (this.newDataAddr != 0) {
            this.newData.write(this.mem, this.newDataAddr);
        }
        this.write32(this.focus);
        this.write32(this.abortStatus);
        this.write32(this.msFreeAddr);
        this.write32(this.msDataAddr);
        this.write32(this.utilityDataAddr);
        this.write8Array(this.key);
        this.write32(this.secureVersion);
        this.write32(this.multiStatus);
        this.write32(this.idListAddr);
        this.write32(this.fileListAddr);
        this.write32(this.sizeAddr);
    }

    public String getBasePath() {
        return this.getBasePath(this.saveName);
    }

    public String getBasePath(String saveName) {
        String path = savedataPath + this.gameName;
        if (saveName != null && !anyFileName.equals(saveName)) {
            path = path + saveName;
        }
        path = path + "/";
        return path;
    }

    public String getFileName(String saveName, String fileName) {
        return this.getBasePath(saveName) + fileName;
    }

    private int getFileSize(String fileName) {
        SceIoStat fileStat;
        int size = 0;
        if (fileName != null && fileName.length() > 0 && (fileStat = Modules.IoFileMgrForUserModule.statFile(this.getFileName(this.saveName, fileName))) != null) {
            size = (int)fileStat.size;
        }
        return size;
    }

    public int getSizeKb(String gameName, String saveName) {
        int sizeKb = Utilities.getSizeKb(this.getFileSize(this.fileName));
        sizeKb += Utilities.getSizeKb(this.getFileSize(icon0FileName));
        sizeKb += Utilities.getSizeKb(this.getFileSize(icon1FileName));
        sizeKb += Utilities.getSizeKb(this.getFileSize(pic1FileName));
        sizeKb += Utilities.getSizeKb(this.getFileSize(snd0FileName));
        return sizeKb += Utilities.getSizeKb(this.getFileSize(paramSfoFileName));
    }

    private SeekableDataInput getDataInput(String path, String name) {
        SeekableDataInput fileInput = Modules.IoFileMgrForUserModule.getFile(path + name, 1);
        return fileInput;
    }

    private SeekableRandomFile getDataOutput(String path, String name) {
        SeekableDataInput fileInput = Modules.IoFileMgrForUserModule.getFile(path + name, 515);
        if (fileInput instanceof SeekableRandomFile) {
            return (SeekableRandomFile)fileInput;
        }
        return null;
    }

    public void singleRead(Memory mem) throws IOException {
        String path = this.getBasePath();
        this.dataSize = CryptoEngine.getSavedataCryptoStatus() ? this.loadEncryptedFile(mem, path, this.fileName, this.dataBuf, this.dataBufSize, this.key, this.secureVersion) : this.loadFile(mem, path, this.fileName, this.dataBuf, this.dataBufSize);
    }

    public void singleWrite(Memory mem) throws IOException {
        String path = this.getBasePath();
        Modules.IoFileMgrForUserModule.mkdirs(path);
        if (CryptoEngine.getSavedataCryptoStatus()) {
            this.writeEncryptedFile(mem, path, this.fileName, this.dataBuf, this.dataSize, this.key, this.secureVersion);
        } else {
            this.writeFile(mem, path, this.fileName, this.dataBuf, this.dataSize);
        }
    }

    public void load(Memory mem) throws IOException {
        String path = this.getBasePath();
        this.dataSize = CryptoEngine.getSavedataCryptoStatus() ? this.loadEncryptedFile(mem, path, this.fileName, this.dataBuf, this.dataBufSize, this.key, this.secureVersion) : this.loadFile(mem, path, this.fileName, this.dataBuf, this.dataBufSize);
        this.safeLoad(mem, icon0FileName, this.icon0FileData);
        this.safeLoad(mem, icon1FileName, this.icon1FileData);
        this.safeLoad(mem, pic1FileName, this.pic1FileData);
        this.safeLoad(mem, snd0FileName, this.snd0FileData);
        this.loadPsf(mem, path, paramSfoFileName, this.sfoParam);
        this.bind = 1;
        this.abortStatus = 0;
    }

    private void safeLoad(Memory mem, String filename, PspUtilitySavedataFileData fileData) throws IOException {
        String path = this.getBasePath();
        try {
            fileData.size = this.loadFile(mem, path, filename, fileData.buf, fileData.bufSize);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
    }

    public void save(Memory mem) throws IOException {
        String path = this.getBasePath();
        Modules.IoFileMgrForUserModule.mkdirs(path);
        if (CryptoEngine.getSavedataCryptoStatus()) {
            this.writeEncryptedFile(mem, path, this.fileName, this.dataBuf, this.dataSize, this.key, this.secureVersion);
        } else {
            this.writeFile(mem, path, this.fileName, this.dataBuf, this.dataSize);
        }
        this.writeFile(mem, path, icon0FileName, this.icon0FileData.buf, this.icon0FileData.size);
        this.writeFile(mem, path, icon1FileName, this.icon1FileData.buf, this.icon1FileData.size);
        this.writeFile(mem, path, pic1FileName, this.pic1FileData.buf, this.pic1FileData.size);
        this.writeFile(mem, path, snd0FileName, this.snd0FileData.buf, this.snd0FileData.size);
        if (CryptoEngine.getSavedataCryptoStatus()) {
            this.writeEncryptedPsf(mem, path, paramSfoFileName, this.sfoParam, this.fileName, this.dataSize, this.key, this.secureVersion);
        } else {
            this.writePsf(mem, path, paramSfoFileName, this.sfoParam);
        }
    }

    private int loadFile(Memory mem, String path, String name, int address, int maxLength) throws IOException {
        if (name == null || name.length() <= 0 || address == 0) {
            return 0;
        }
        SeekableDataInput fileInput = this.getDataInput(path, name);
        if (fileInput == null) {
            throw new FileNotFoundException("File not found '" + path + "' '" + name + "'");
        }
        int fileSize = (int)fileInput.length();
        if (fileSize > maxLength && maxLength > 0) {
            fileSize = maxLength;
        }
        Utilities.readFully(fileInput, address, fileSize);
        fileInput.close();
        return fileSize;
    }

    private void writeEncryptedFile(Memory mem, String path, String name, int address, int length, byte[] key, int mode) throws IOException {
        if (name == null || name.length() <= 0 || address == 0) {
            return;
        }
        SeekableRandomFile fileOutput = this.getDataOutput(path, name);
        CryptoEngine crypto = new CryptoEngine();
        if (fileOutput == null) {
            return;
        }
        byte[] inBuf = new byte[length];
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, 1);
        for (int i = 0; i < length; ++i) {
            inBuf[i] = (byte)memoryReader.readNext();
        }
        byte[] outBuf = crypto.EncryptSavedata(inBuf, length, key, mode);
        fileOutput.write(outBuf);
        fileOutput.close();
    }

    private int loadEncryptedFile(Memory mem, String path, String name, int address, int maxLength, byte[] key, int mode) throws IOException {
        if (name == null || name.length() <= 0 || address == 0) {
            return 0;
        }
        SeekableDataInput fileInput = this.getDataInput(path, name);
        CryptoEngine crypto = new CryptoEngine();
        if (fileInput == null) {
            throw new FileNotFoundException("File not found '" + path + "' '" + name + "'");
        }
        int fileSize = (int)fileInput.length();
        byte[] inBuf = new byte[fileSize];
        fileInput.readFully(inBuf);
        byte[] outBuf = crypto.DecryptSavedata(inBuf, fileSize, key, mode);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, 1);
        for (int i = 0; i < outBuf.length; ++i) {
            memoryWriter.writeNext(outBuf[i]);
        }
        return outBuf.length;
    }

    private void writeFile(Memory mem, String path, String name, int address, int length) throws IOException {
        if (name == null || name.length() <= 0 || address == 0) {
            return;
        }
        SeekableRandomFile fileOutput = this.getDataOutput(path, name);
        if (fileOutput == null) {
            return;
        }
        Utilities.write(fileOutput, address, length);
        fileOutput.close();
    }

    private void loadPsf(Memory mem, String path, String name, PspUtilitySavedataSFOParam sfoParam) throws IOException {
        SeekableDataInput fileInput = this.getDataInput(path, name);
        if (fileInput != null) {
            byte[] buffer = new byte[(int)fileInput.length()];
            fileInput.readFully(buffer);
            fileInput.close();
            PSF psf = new PSF();
            psf.read(ByteBuffer.wrap(buffer));
            sfoParam.parentalLevel = psf.getNumeric("PARENTAL_LEVEL");
            sfoParam.title = psf.getString("TITLE");
            sfoParam.detail = psf.getString("SAVEDATA_DETAIL");
            sfoParam.savedataTitle = psf.getString("SAVEDATA_TITLE");
        }
    }

    private void writePsf(Memory mem, String path, String name, PspUtilitySavedataSFOParam sfoParam) throws IOException {
        SeekableRandomFile fileOutput = this.getDataOutput(path, name);
        if (fileOutput == null) {
            return;
        }
        PSF psf = new PSF();
        psf.put("PARENTAL_LEVEL", sfoParam.parentalLevel);
        psf.put("TITLE", sfoParam.title, 128);
        psf.put("SAVEDATA_DETAIL", sfoParam.detail, 1024);
        psf.put("SAVEDATA_TITLE", sfoParam.savedataTitle, 128);
        psf.write(fileOutput.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, psf.size()));
    }

    private void writeEncryptedPsf(Memory mem, String path, String psfName, PspUtilitySavedataSFOParam sfoParam, String dataName, int dataLength, byte[] key, int mode) throws IOException {
        SeekableRandomFile psfOutput = this.getDataOutput(path, psfName);
        SeekableRandomFile dataOutput = this.getDataOutput(path, dataName);
        if (psfOutput == null || dataOutput == null) {
            return;
        }
        CryptoEngine crypto = new CryptoEngine();
        byte[] dataBuffer = new byte[dataLength];
        dataOutput.readFully(dataBuffer);
        PSF psf = new PSF();
        psf.put("CATEGORY", "MS", 4);
        psf.put("PARENTAL_LEVEL", sfoParam.parentalLevel);
        psf.put("SAVEDATA_DETAIL", sfoParam.detail, 1024);
        psf.put("SAVEDATA_DIRECTORY", this.gameName + this.saveName, 64);
        crypto.UpdateSavedataHashes(psf, dataBuffer, dataLength, key, dataName, mode);
        psf.put("SAVEDATA_TITLE", sfoParam.savedataTitle, 128);
        psf.put("TITLE", sfoParam.title, 128);
        psf.write(psfOutput.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, psf.size()));
    }

    public boolean test(Memory mem) throws IOException {
        String path = this.getBasePath();
        boolean result = this.testFile(mem, path, this.fileName);
        return result;
    }

    private boolean testFile(Memory mem, String path, String name) throws IOException {
        if (name == null || name.length() <= 0) {
            return false;
        }
        SeekableDataInput fileInput = this.getDataInput(path, name);
        if (fileInput == null) {
            throw new FileNotFoundException("File not found '" + path + "' '" + name + "'");
        }
        fileInput.close();
        return true;
    }

    public boolean isPresent(String gameName, String saveName) {
        File f;
        if (saveName == null || saveName.length() <= 0 || anyFileName.equals(saveName)) {
            f = new File(savedataFilePath);
            String[] entries = f.list();
            if (entries == null) {
                return false;
            }
            for (int i = 0; i < f.list().length; ++i) {
                if (!entries[i].startsWith(gameName)) continue;
                saveName = entries[i].replace(gameName, "");
                break;
            }
        }
        if (this.fileName == null || this.fileName.length() <= 0) {
            f = new File(savedataFilePath + gameName + saveName);
            return f.list() != null;
        }
        String path = this.getBasePath(saveName);
        try {
            SeekableDataInput fileInput = this.getDataInput(path, this.fileName);
            if (fileInput != null) {
                fileInput.close();
                return true;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    public boolean isPresent() {
        return this.isPresent(this.gameName, this.saveName);
    }

    public long getTimestamp(String gameName, String saveName) {
        String sfoFileName = this.getFileName(saveName, paramSfoFileName);
        SceIoStat sfoStat = Modules.IoFileMgrForUserModule.statFile(sfoFileName);
        if (sfoStat != null) {
            Calendar cal = Calendar.getInstance();
            ScePspDateTime pspTime = sfoStat.mtime;
            cal.set(pspTime.year, pspTime.month, pspTime.day, pspTime.hour, pspTime.minute, pspTime.second);
            return cal.getTimeInMillis();
        }
        return 0L;
    }

    @Override
    public int sizeof() {
        return this.base.size;
    }

    public String getModeName() {
        if (this.mode < 0 || this.mode >= modeNames.length) {
            return String.format("UNKNOWN_MODE%d", this.mode);
        }
        return modeNames[this.mode];
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.format("Address 0x%08X, mode=%d(%s), gameName=%s, saveName=%s, fileName=%s", this.getBaseAddress(), this.mode, this.getModeName(), this.gameName, this.saveName, this.fileName));
        for (int i = 0; this.saveNameList != null && i < this.saveNameList.length; ++i) {
            if (i == 0) {
                s.append(", saveNameList=[");
            } else {
                s.append(", ");
            }
            s.append(this.saveNameList[i]);
            if (i != this.saveNameList.length - 1) continue;
            s.append("]");
        }
        return s.toString();
    }

    public static class PspUtilitySavedataListSaveNewData
    extends pspAbstractMemoryMappedStructure {
        public PspUtilitySavedataFileData icon0;
        public int titleAddr;
        public String title;

        @Override
        protected void read() {
            this.icon0 = new PspUtilitySavedataFileData();
            this.read(this.icon0);
            this.titleAddr = this.read32();
            this.title = this.titleAddr != 0 ? Utilities.readStringZ(this.mem, this.titleAddr) : null;
        }

        @Override
        protected void write() {
            this.write(this.icon0);
            this.write32(this.titleAddr);
            if (this.titleAddr != 0) {
                Utilities.writeStringZ(this.mem, this.titleAddr, this.title);
            }
        }

        @Override
        public int sizeof() {
            return this.icon0.sizeof() + 4;
        }
    }

    public static class PspUtilitySavedataFileData
    extends pspAbstractMemoryMappedStructure {
        public int buf;
        public int bufSize;
        public int size;

        @Override
        protected void read() {
            this.buf = this.read32();
            this.bufSize = this.read32();
            this.size = this.read32();
            this.readUnknown(4);
        }

        @Override
        protected void write() {
            this.write32(this.buf);
            this.write32(this.bufSize);
            this.write32(this.size);
            this.writeUnknown(4);
        }

        @Override
        public int sizeof() {
            return 16;
        }
    }

    public static class PspUtilitySavedataSFOParam
    extends pspAbstractMemoryMappedStructure {
        public String title;
        public String savedataTitle;
        public String detail;
        public int parentalLevel;

        @Override
        protected void read() {
            this.title = this.readStringNZ(128);
            this.savedataTitle = this.readStringNZ(128);
            this.detail = this.readStringNZ(1024);
            this.parentalLevel = this.read32();
        }

        @Override
        protected void write() {
            this.writeStringNZ(128, this.title);
            this.writeStringNZ(128, this.savedataTitle);
            this.writeStringNZ(1024, this.detail);
            this.write32(this.parentalLevel);
        }

        @Override
        public int sizeof() {
            return 1284;
        }
    }
}

