/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEUidClass;
import jpcsp.HLE.HLEUidObjectMapping;
import jpcsp.HLE.ITPointerBase;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TErrorPointer32;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.TPointer64;
import jpcsp.HLE.TPointerBase;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.HLEModuleFunction;
import jpcsp.Processor;

public class HLEModuleFunctionReflection
extends HLEModuleFunction {
    HLEModule hleModule;
    Class<?> hleModuleClass;
    String hleModuleMethodName;
    Method hleModuleMethod;
    Class<?>[] hleModuleMethodParametersTypes;
    Class<?> hleModuleMethodReturnType;
    boolean checkInsideInterrupt;
    boolean checkDispatchThreadEnabled;
    boolean fastOldInvoke;
    TErrorPointer32 errorHolder;
    LinkedList<Method> decodingRunListList;
    int parameterCount;
    RunListParams runListParams = new RunListParams();
    static HashMap<String, Method> methodsByName;
    static HashMap<String, HashMap<String, Method>> hleModuleModuleMethodsByName;
    static HashMap<String, Method> hleModuleMethodsByName;
    protected boolean[] canBeNullParams;
    protected Integer[] errorValuesOnNotFound;
    protected Method[] methodsToCheck;
    Method setReturnValueMethod;
    Method setReturnValueModuleMethodUidGenerator;

    public HLEModuleFunctionReflection(String moduleName, String functionName, HLEModule hleModule, String hleModuleMethodName, Method hleModuleMethod, boolean checkInsideInterrupt, boolean checkDispatchThreadEnabled) {
        super(moduleName, functionName);
        this.hleModule = hleModule;
        this.hleModuleClass = hleModule.getClass();
        this.hleModuleMethodName = hleModuleMethodName;
        this.checkInsideInterrupt = checkInsideInterrupt;
        this.checkDispatchThreadEnabled = checkDispatchThreadEnabled;
        this.hleModuleMethod = hleModuleMethod;
        this.hleModuleMethodParametersTypes = this.hleModuleMethod.getParameterTypes();
        this.hleModuleMethodReturnType = this.hleModuleMethod.getReturnType();
        this.parameterCount = this.hleModuleMethodParametersTypes.length;
        this.runListParams.params = new Object[this.parameterCount];
        if (!hleModuleModuleMethodsByName.containsKey(moduleName)) {
            hleModuleModuleMethodsByName.put(moduleName, new HashMap());
            hleModuleMethodsByName = hleModuleModuleMethodsByName.get(moduleName);
            for (Method method : this.hleModuleClass.getMethods()) {
                hleModuleMethodsByName.put(method.getName(), method);
            }
        } else {
            hleModuleMethodsByName = hleModuleModuleMethodsByName.get(moduleName);
        }
        try {
            if (this.hleModuleMethodReturnType == Void.TYPE && this.hleModuleMethodParametersTypes.length == 1 && this.hleModuleMethodParametersTypes[0] == Processor.class) {
                this.fastOldInvoke = true;
            } else {
                this.fastOldInvoke = false;
                this.prepareParameterDecodingRunList();
                this.prepareReturnValueRunList();
            }
        }
        catch (Throwable o) {
            Modules.log.error("OnMethod: " + hleModuleMethod);
            o.printStackTrace();
        }
    }

    protected Method getRunListMethod(String name) throws Throwable {
        Method method = methodsByName.get(name);
        if (method == null) {
            throw new Exception(String.format("Can't find method '%s'", name));
        }
        return method;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void prepareParameterDecodingRunList() throws Throwable {
        Annotation[][] paramsAnotations = this.hleModuleMethod.getParameterAnnotations();
        this.decodingRunListList = new LinkedList();
        this.canBeNullParams = new boolean[this.parameterCount];
        this.errorValuesOnNotFound = new Integer[this.parameterCount];
        this.methodsToCheck = new Method[this.parameterCount];
        int paramIndex = 0;
        for (Class<?> paramClass : this.hleModuleMethodParametersTypes) {
            Annotation[] paramAnnotations = paramsAnotations[paramIndex];
            String methodToCheckName = null;
            for (Annotation currentAnnotation : paramAnnotations) {
                if (currentAnnotation instanceof CanBeNull) {
                    this.canBeNullParams[paramIndex] = true;
                }
                if (!(currentAnnotation instanceof CheckArgument)) continue;
                methodToCheckName = ((CheckArgument)currentAnnotation).value();
            }
            if (paramClass == Processor.class) {
                this.decodingRunListList.add(this.getRunListMethod("parameterAddProcessor"));
            } else if (paramClass == Integer.TYPE) {
                this.decodingRunListList.add(this.getRunListMethod("parameterAddInteger"));
            } else if (paramClass == Float.TYPE) {
                this.decodingRunListList.add(this.getRunListMethod("parameterAddFloat"));
            } else if (paramClass == Long.TYPE) {
                this.decodingRunListList.add(this.getRunListMethod("parameterAddLong"));
            } else if (paramClass == Boolean.TYPE) {
                this.decodingRunListList.add(this.getRunListMethod("parameterAddBoolean"));
            } else if (TPointer.class.isAssignableFrom(paramClass)) {
                this.decodingRunListList.add(this.getRunListMethod("parameterAddTPointer"));
            } else if (TPointerBase.class.isAssignableFrom(paramClass)) {
                if (TPointer64.class.isAssignableFrom(paramClass)) {
                    this.decodingRunListList.add(this.getRunListMethod("parameterAddTPointer64"));
                } else if (TErrorPointer32.class.isAssignableFrom(paramClass)) {
                    this.decodingRunListList.add(this.getRunListMethod("parameterAddTErrorPointer32"));
                } else {
                    if (!TPointer32.class.isAssignableFrom(paramClass)) throw new RuntimeException("Unknown TPointerBase parameter class '" + paramClass + "'");
                    this.decodingRunListList.add(this.getRunListMethod("parameterAddTPointer32"));
                }
            } else {
                HLEUidClass hleUidClass = paramClass.getAnnotation(HLEUidClass.class);
                if (hleUidClass == null) throw new RuntimeException("Unknown parameter class '" + paramClass + "'");
                this.errorValuesOnNotFound[paramIndex] = hleUidClass.errorValueOnNotFound();
                this.decodingRunListList.add(this.getRunListMethod("parameterAddUidObject"));
            }
            if (methodToCheckName != null) {
                this.methodsToCheck[paramIndex] = hleModuleMethodsByName.get(methodToCheckName);
                if (this.methodsToCheck[paramIndex] != null) {
                    this.decodingRunListList.add(this.getRunListMethod("parameterCheck"));
                }
            }
            ++paramIndex;
        }
    }

    private void prepareReturnValueRunList() {
        block9: {
            try {
                this.setReturnValueMethod = this.getRunListMethod("setReturnValueVoid");
                if (this.hleModuleMethodReturnType == Void.TYPE) break block9;
                if (this.hleModuleMethodReturnType == Integer.TYPE) {
                    this.setReturnValueMethod = this.getRunListMethod("setReturnValueInt");
                    break block9;
                }
                if (this.hleModuleMethodReturnType == Boolean.TYPE) {
                    this.setReturnValueMethod = this.getRunListMethod("setReturnValueBoolean");
                    break block9;
                }
                if (this.hleModuleMethodReturnType == Long.TYPE) {
                    this.setReturnValueMethod = this.getRunListMethod("setReturnValueLong");
                    break block9;
                }
                if (this.hleModuleMethodReturnType == Float.TYPE) {
                    this.setReturnValueMethod = this.getRunListMethod("setReturnValueFloat");
                    break block9;
                }
                HLEUidClass hleUidClass = this.hleModuleMethodReturnType.getAnnotation(HLEUidClass.class);
                if (hleUidClass != null) {
                    if (hleUidClass.moduleMethodUidGenerator().length() == 0) {
                        this.setReturnValueMethod = this.getRunListMethod("setReturnValueUid");
                    } else {
                        this.setReturnValueModuleMethodUidGenerator = hleModuleMethodsByName.get(hleUidClass.moduleMethodUidGenerator());
                        this.setReturnValueMethod = this.getRunListMethod("setReturnValueUidWithGenerator");
                    }
                    break block9;
                }
                throw new RuntimeException("Can't handle return type '" + this.hleModuleMethodReturnType + "'");
            }
            catch (Throwable o) {
                Modules.log.error("prepareReturnValueRunList: ", o);
            }
        }
    }

    protected void executeParameterDecodingRunList(RunListParams runListParams) throws Throwable {
        for (Method decodingRunListMethod : this.decodingRunListList) {
            decodingRunListMethod.invoke((Object)this, runListParams);
        }
    }

    protected void checkAddressIsGood(RunListParams runListParams) {
        ITPointerBase pointer = (ITPointerBase)runListParams.params[runListParams.paramIndex - 1];
        if (!(pointer.isAddressGood() || pointer.getAddress() == 0 && this.canBeNullParams[runListParams.paramIndex - 1])) {
            throw new SceKernelErrorException(-2147483389);
        }
    }

    public void parameterAddProcessor(RunListParams runListParams) {
        runListParams.setParamNext(runListParams.processor);
    }

    public void parameterAddInteger(RunListParams runListParams) {
        runListParams.setParamNext(runListParams.processor.parameterReader.getNextInt());
    }

    public void parameterAddFloat(RunListParams runListParams) {
        runListParams.setParamNext(Float.valueOf(runListParams.processor.parameterReader.getNextFloat()));
    }

    public void parameterAddLong(RunListParams runListParams) {
        runListParams.setParamNext(runListParams.processor.parameterReader.getNextLong());
    }

    public void parameterAddBoolean(RunListParams runListParams) {
        int value = runListParams.processor.parameterReader.getNextInt();
        if (value < 0 || value > 1) {
            Modules.log.warn(String.format("Parameter exepcted to be bool but had value 0x%08X", value));
        }
        runListParams.setParamNext(value != 0);
    }

    public void parameterAddTPointer(RunListParams runListParams) {
        runListParams.setParamNext(new TPointer(Processor.memory, runListParams.processor.parameterReader.getNextInt()));
        this.checkAddressIsGood(runListParams);
    }

    public void parameterAddTPointer64(RunListParams runListParams) {
        runListParams.setParamNext(new TPointer64(Processor.memory, runListParams.processor.parameterReader.getNextInt()));
        this.checkAddressIsGood(runListParams);
    }

    public void parameterAddTPointer32(RunListParams runListParams) {
        runListParams.setParamNext(new TPointer32(Processor.memory, runListParams.processor.parameterReader.getNextInt()));
        this.checkAddressIsGood(runListParams);
    }

    public void parameterAddTErrorPointer32(RunListParams runListParams) {
        this.errorHolder = new TErrorPointer32(Processor.memory, runListParams.processor.parameterReader.getNextInt());
        runListParams.setParamNext(this.errorHolder);
        this.checkAddressIsGood(runListParams);
    }

    public void parameterAddUidObject(RunListParams runListParams) {
        int uid = runListParams.processor.parameterReader.getNextInt();
        Object object = HLEUidObjectMapping.getObject(this.hleModuleMethodParametersTypes[runListParams.paramIndex].getName(), uid);
        if (object == null) {
            throw new SceKernelErrorException(this.errorValuesOnNotFound[runListParams.paramIndex]);
        }
        runListParams.setParamNext(object);
    }

    public void parameterCheck(RunListParams runListParams) throws Throwable {
        try {
            runListParams.params[runListParams.paramIndex - 1] = this.methodsToCheck[runListParams.paramIndex - 1].invoke((Object)this.hleModule, runListParams.params[runListParams.paramIndex - 1]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public void setReturnValueVoid(RunListParams runListParams) {
    }

    public void setReturnValueInt(RunListParams runListParams) {
        runListParams.processor.parameterReader.setReturnValueInt((Integer)runListParams.returnObject);
    }

    public void setReturnValueBoolean(RunListParams runListParams) {
        runListParams.processor.parameterReader.setReturnValueInt((Boolean)runListParams.returnObject != false ? 1 : 0);
    }

    public void setReturnValueLong(RunListParams runListParams) {
        runListParams.processor.parameterReader.setReturnValueLong((Long)runListParams.returnObject);
    }

    public void setReturnValueFloat(RunListParams runListParams) {
        runListParams.processor.parameterReader.setReturnValueFloat(((Float)runListParams.returnObject).floatValue());
    }

    public void setReturnValueUid(RunListParams runListParams) {
        runListParams.processor.parameterReader.setReturnValueInt(HLEUidObjectMapping.createUidForObject(this.hleModuleMethodReturnType.getName(), runListParams.returnObject));
    }

    public void setReturnValueUidWithGenerator(RunListParams runListParams) throws Throwable {
        int uid = (Integer)this.setReturnValueModuleMethodUidGenerator.invoke((Object)this.hleModule, new Object[0]);
        runListParams.processor.parameterReader.setReturnValueInt(HLEUidObjectMapping.addObjectMap(this.hleModuleMethodReturnType.getName(), uid, runListParams.returnObject));
    }

    @Override
    public void execute(Processor processor) {
        try {
            this.executeInner(processor);
        }
        catch (Throwable o) {
            Modules.log.error(String.format("OnMethod: %s", this.hleModuleMethod), o);
        }
    }

    private void executeInner(Processor processor) throws Throwable {
        this.runListParams.processor = processor;
        this.runListParams.paramIndex = 0;
        try {
            if (this.checkInsideInterrupt && IntrManager.getInstance().isInsideInterrupt()) {
                throw new SceKernelErrorException(-2147352476);
            }
            if (this.checkDispatchThreadEnabled && !Modules.ThreadManForUserModule.isDispatchThreadEnabled()) {
                throw new SceKernelErrorException(-2147352153);
            }
            if (this.isUnimplemented()) {
                Modules.getLogger(this.getModuleName()).warn(String.format("Unimplemented NID function %s.%s [0x%08X]", this.getModuleName(), this.getFunctionName(), this.getNid()));
            }
            try {
                processor.parameterReader.setCpu(processor.cpu);
                if (this.fastOldInvoke) {
                    this.hleModuleMethod.invoke((Object)this.hleModule, processor);
                } else {
                    processor.parameterReader.resetReading();
                    this.executeParameterDecodingRunList(this.runListParams);
                    this.runListParams.returnObject = this.hleModuleMethod.invoke((Object)this.hleModule, this.runListParams.params);
                    if (this.errorHolder != null) {
                        this.errorHolder.setValue(0);
                    }
                    this.setReturnValueMethod.invoke((Object)this, this.runListParams);
                }
            }
            catch (InvocationTargetException e) {
                if (!(e.getCause() instanceof SceKernelErrorException)) {
                    Modules.log.error(String.format("Error '%s(%s)' calling hleModule='%s', hleModuleClass='%s', hleModuleMethodName='%s', hleModuleMethod='%s'", e.toString(), e.getCause(), this.hleModule, this.hleModuleClass, this.hleModuleMethodName, this.hleModuleMethod));
                }
                throw e.getCause();
            }
        }
        catch (SceKernelErrorException kernelError) {
            if (this.errorHolder != null) {
                this.errorHolder.setValue(kernelError.errorCode);
                this.runListParams.returnObject = 0;
            } else {
                this.runListParams.returnObject = kernelError.errorCode;
            }
            if (Modules.log.isDebugEnabled()) {
                Modules.log.debug(String.format("%s returning errorCode 0x%08X", this.hleModuleMethodName, kernelError.errorCode));
            }
            this.setReturnValueInt(this.runListParams);
        }
    }

    public Method getHLEModuleMethod() {
        return this.hleModuleMethod;
    }

    public boolean checkInsideInterrupt() {
        return this.checkInsideInterrupt;
    }

    public boolean checkDispatchThreadEnabled() {
        return this.checkDispatchThreadEnabled;
    }

    public int getErrorValueOnNotFound(int paramIndex) {
        return this.errorValuesOnNotFound[paramIndex];
    }

    public boolean canBeNullParam(int paramIndex) {
        return this.canBeNullParams[paramIndex];
    }

    public Method getMethodToCheck(int paramIndex) {
        if (this.methodsToCheck == null) {
            return null;
        }
        return this.methodsToCheck[paramIndex];
    }

    @Override
    public String compiledString() {
        return null;
    }

    static {
        hleModuleModuleMethodsByName = new HashMap();
        methodsByName = new HashMap();
        for (Method method : HLEModuleFunctionReflection.class.getMethods()) {
            methodsByName.put(method.getName(), method);
        }
    }

    class RunListParams {
        int paramIndex;
        Object[] params;
        Processor processor;
        Object returnObject;

        RunListParams() {
        }

        void setParamNext(Object value) {
            this.params[this.paramIndex++] = value;
        }
    }
}

