/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceIoDirent;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.Processor;
import jpcsp.autotests.AutoTestsOutput;
import jpcsp.connector.PGDFileConnector;
import jpcsp.crypto.CryptoEngine;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.hardware.MemoryStick;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class IoFileMgrForUser
extends HLEModule {
    private static Logger log = Modules.getLogger("IoFileMgrForUser");
    private static Logger stdout = Logger.getLogger("stdout");
    private static Logger stderr = Logger.getLogger("stderr");
    public static final int PSP_O_RDONLY = 1;
    public static final int PSP_O_WRONLY = 2;
    public static final int PSP_O_RDWR = 3;
    public static final int PSP_O_NBLOCK = 4;
    public static final int PSP_O_DIROPEN = 8;
    public static final int PSP_O_APPEND = 256;
    public static final int PSP_O_CREAT = 512;
    public static final int PSP_O_TRUNC = 1024;
    public static final int PSP_O_EXCL = 2048;
    public static final int PSP_O_NBUF = 16384;
    public static final int PSP_O_NOWAIT = 32768;
    public static final int PSP_O_PLOCK = 0x2000000;
    public static final int PSP_O_FGAMEDATA = 0x40000000;
    public static final int PSP_O_RETRY_0 = 0;
    public static final int PSP_O_RETRY_1 = 65536;
    public static final int PSP_O_RETRY_2 = 131072;
    public static final int PSP_O_RETRY_3 = 196608;
    public static final int PSP_O_RETRY_4 = 262144;
    public static final int PSP_O_RETRY_5 = 327680;
    public static final int PSP_O_RETRY_6 = 393216;
    public static final int PSP_O_RETRY_7 = 458752;
    public static final int PSP_O_RETRY_8 = 524288;
    public static final int PSP_O_RETRY_9 = 589824;
    public static final int PSP_O_RETRY_10 = 655360;
    public static final int PSP_O_RETRY_11 = 720896;
    public static final int PSP_O_RETRY_12 = 786432;
    public static final int PSP_O_RETRY_13 = 851968;
    public static final int PSP_O_RETRY_14 = 917504;
    public static final int PSP_O_RETRY_15 = 983040;
    public static final int PSP_SEEK_SET = 0;
    public static final int PSP_SEEK_CUR = 1;
    public static final int PSP_SEEK_END = 2;
    public static final int PSP_DEV_TYPE_NONE = 0;
    public static final int PSP_DEV_TYPE_CHARACTER = 1;
    public static final int PSP_DEV_TYPE_BLOCK = 4;
    public static final int PSP_DEV_TYPE_FILESYSTEM = 16;
    public static final int PSP_DEV_TYPE_ALIAS = 32;
    public static final int PSP_DEV_TYPE_MOUNT = 64;
    public static final int STDOUT_ID = 1;
    public static final int STDERR_ID = 2;
    public static final int STDIN_ID = 3;
    private static final int MIN_ID = 4;
    private static final int MAX_ID = 63;
    private static final String idPurpose = "IOFileManager-File";
    private static final String[] modeStrings = new String[]{"r", "r", "rw", "rw"};
    public HashMap<Integer, IoInfo> fileIds;
    public HashMap<Integer, IoInfo> fileUids;
    public HashMap<Integer, IoDirInfo> dirIds;
    private String filepath;
    private UmdIsoReader iso;
    private IoWaitStateChecker ioWaitStateChecker;
    private int defaultAsyncPriority;
    private static final int asyncThreadRegisterArgument = 16;
    private PGDFileConnector pgdFileConnector;
    private boolean allowExtractPGD;
    private IIoListener[] ioListeners;
    private final String[] umdPrefixes = new String[]{"disc", "umd"};

    @Override
    public String getName() {
        return "IoFileMgrForUser";
    }

    @Override
    public void start() {
        if (this.fileIds != null) {
            for (IoInfo info : this.fileIds.values()) {
                try {
                    info.readOnlyFile.close();
                }
                catch (IOException e) {
                    log.error("pspiofilemgr - error closing file: " + e.getMessage());
                }
            }
        }
        this.fileIds = new HashMap();
        this.fileUids = new HashMap();
        this.dirIds = new HashMap();
        MemoryStick.setStateMs(1);
        this.defaultAsyncPriority = -1;
        if (this.ioListeners == null) {
            this.ioListeners = new IIoListener[0];
        }
        this.ioWaitStateChecker = new IoWaitStateChecker();
        this.setSettingsListener("emu.extractPGD", new ExtractPGDSettingsListerner());
        super.start();
    }

    private void setAllowExtractPGDStatus(boolean status) {
        this.allowExtractPGD = status;
    }

    private boolean getAllowExtractPGDStatus() {
        return this.allowExtractPGD;
    }

    public IoInfo getFileIoInfo(int id) {
        return this.fileIds.get(id);
    }

    private static int getNewUid() {
        return SceUidManager.getNewUid(idPurpose);
    }

    private static void releaseUid(int uid) {
        SceUidManager.releaseUid(uid, idPurpose);
    }

    private static int getNewId() {
        return SceUidManager.getNewId(idPurpose, 4, 63);
    }

    private static void releaseId(int id) {
        SceUidManager.releaseId(id, idPurpose);
    }

    public String getDeviceFilePath(String pspfilename) {
        pspfilename = pspfilename.replaceAll("\\\\", "/");
        String device = null;
        String cwd = "";
        String filename = null;
        if (pspfilename.startsWith("flash0:")) {
            if (pspfilename.startsWith("flash0:/")) {
                return pspfilename.replace("flash0:", "flash0");
            }
            return pspfilename.replace("flash0:", "flash0/");
        }
        if (this.filepath == null) {
            return pspfilename;
        }
        int findcolon = pspfilename.indexOf(":");
        if (findcolon != -1) {
            device = pspfilename.substring(0, findcolon);
            pspfilename = pspfilename.substring(findcolon + 1);
        } else {
            int findslash = this.filepath.indexOf("/");
            if (findslash != -1) {
                device = this.filepath.substring(0, findslash);
                cwd = this.filepath.substring(findslash + 1);
                if (cwd.startsWith("/")) {
                    cwd = cwd.substring(1);
                }
                if (cwd.endsWith("/")) {
                    cwd = cwd.substring(0, cwd.length() - 1);
                }
            } else {
                device = this.filepath;
            }
        }
        if (device.equals("host0")) {
            device = this.iso != null ? "disc0" : "ms0";
        }
        if (device.equals("fatms0")) {
            device = "ms0";
        }
        if (device.startsWith("umd")) {
            pspfilename = "";
        }
        if (pspfilename.startsWith("/")) {
            pspfilename = pspfilename.substring(1);
        }
        if (pspfilename.endsWith("/")) {
            pspfilename = pspfilename.substring(0, pspfilename.length() - 1);
        }
        filename = device.toLowerCase();
        if (cwd.length() > 0) {
            filename = filename + "/" + cwd;
        }
        if (pspfilename.length() > 0) {
            filename = filename + "/" + pspfilename;
        }
        return filename;
    }

    private boolean isUmdPath(String deviceFilePath) {
        for (int i = 0; i < this.umdPrefixes.length; ++i) {
            if (!deviceFilePath.matches("^" + this.umdPrefixes[i] + "[0-9]+.*")) continue;
            return true;
        }
        return false;
    }

    private String trimUmdPrefix(String pcfilename) {
        for (int i = 0; i < this.umdPrefixes.length; ++i) {
            if (pcfilename.matches("^" + this.umdPrefixes[i] + "[0-9]+/.*")) {
                return pcfilename.substring(pcfilename.indexOf("/") + 1);
            }
            if (!pcfilename.matches("^" + this.umdPrefixes[i] + "[0-9]+")) continue;
            return "";
        }
        return pcfilename;
    }

    public void mkdirs(String dir) {
        String pcfilename = this.getDeviceFilePath(dir);
        if (pcfilename != null) {
            File f = new File(pcfilename);
            f.mkdirs();
        }
    }

    private boolean rmdir(File f, boolean recursive) {
        boolean subDirResult = true;
        if (recursive && f.isDirectory()) {
            File[] subFiles = f.listFiles();
            for (int i = 0; subFiles != null && i < subFiles.length; ++i) {
                if (this.rmdir(subFiles[i], recursive)) continue;
                subDirResult = false;
            }
        }
        return f.delete() && subDirResult;
    }

    public boolean rmdir(String dir, boolean recursive) {
        String pcfilename = this.getDeviceFilePath(dir);
        if (pcfilename == null) {
            return false;
        }
        File f = new File(pcfilename);
        return this.rmdir(f, recursive);
    }

    public String[] listFiles(String dir, String pattern) {
        String pcfilename = this.getDeviceFilePath(dir);
        if (pcfilename == null) {
            return null;
        }
        File f = new File(pcfilename);
        return pattern == null ? f.list() : f.list(new PatternFilter(pattern));
    }

    public SceIoStat statFile(String pspfilename) {
        String pcfilename = this.getDeviceFilePath(pspfilename);
        if (pcfilename == null) {
            return null;
        }
        return this.stat(pcfilename);
    }

    private SceIoStat stat(String pcfilename) {
        SceIoStat stat = null;
        if (pcfilename != null) {
            if (this.isUmdPath(pcfilename)) {
                if (this.iso == null) {
                    log.error("stat - no umd mounted");
                    Emulator.getProcessor().cpu.gpr[2] = -2147418093;
                } else if (!Modules.sceUmdUserModule.isUmdActivated()) {
                    log.warn("stat - umd mounted but not activated");
                    Emulator.getProcessor().cpu.gpr[2] = -2147351775;
                } else {
                    String isofilename = this.trimUmdPrefix(pcfilename);
                    int mode = 4;
                    int attr = 0;
                    long size = 0L;
                    long timestamp = 0L;
                    int startSector = 0;
                    try {
                        UmdIsoFile file = this.iso.getFile(isofilename);
                        attr = 32;
                        size = file.length();
                        timestamp = file.getTimestamp().getTime();
                        startSector = file.getStartSector();
                        mode = mode + mode * 8 + mode * 64;
                        stat = new SceIoStat(mode |= attr << 8, attr, size, ScePspDateTime.fromUnixTime(timestamp), ScePspDateTime.fromUnixTime(0L), ScePspDateTime.fromUnixTime(timestamp));
                        if (startSector > 0) {
                            stat.setReserved(0, startSector);
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        try {
                            if (this.iso.isDirectory(isofilename)) {
                                attr |= 0x10;
                                mode |= 1;
                            }
                            mode = mode + mode * 8 + mode * 64;
                            stat = new SceIoStat(mode |= attr << 8, attr, size, ScePspDateTime.fromUnixTime(timestamp), ScePspDateTime.fromUnixTime(0L), ScePspDateTime.fromUnixTime(timestamp));
                            if (startSector > 0) {
                                stat.setReserved(0, startSector);
                            }
                        }
                        catch (FileNotFoundException dnfe) {
                            log.warn("stat - '" + isofilename + "' umd file/dir not found");
                        }
                        catch (IOException e) {
                            log.warn("stat - umd io error: " + e.getMessage());
                        }
                    }
                    catch (IOException e) {
                        log.warn("stat - umd io error: " + e.getMessage());
                    }
                }
            } else {
                File file = new File(pcfilename);
                if (file.exists()) {
                    int mode = (file.canRead() ? 4 : 0) + (file.canWrite() ? 2 : 0) + (file.canExecute() ? 1 : 0);
                    int attr = 0;
                    long size = file.length();
                    long mtime = file.lastModified();
                    mode = mode + mode * 8 + mode * 64;
                    if (file.isDirectory()) {
                        attr |= 0x10;
                    }
                    if (file.isFile()) {
                        attr |= 0x20;
                    }
                    stat = new SceIoStat(mode |= attr << 8, attr, size, ScePspDateTime.fromUnixTime(mtime), ScePspDateTime.fromUnixTime(0L), ScePspDateTime.fromUnixTime(mtime));
                }
            }
        }
        return stat;
    }

    public SeekableDataInput getFile(String filename, int flags) {
        SeekableDataInput resultFile;
        block15: {
            resultFile = null;
            String pcfilename = this.getDeviceFilePath(filename);
            if (pcfilename != null) {
                if (this.isUmdPath(pcfilename)) {
                    if (this.iso == null) {
                        log.error("getFile - no umd mounted");
                        return resultFile;
                    }
                    if ((flags & 2) == 2 || (flags & 0x200) == 512 || (flags & 0x400) == 1024) {
                        log.error("getFile - refusing to open umd media for write");
                        return resultFile;
                    }
                    try {
                        UmdIsoFile file = this.iso.getFile(this.trimUmdPrefix(pcfilename));
                        resultFile = file;
                    }
                    catch (FileNotFoundException e) {
                        if (log.isDebugEnabled()) {
                            log.debug("getFile - umd file not found '" + pcfilename + "' (ok to ignore this message, debug purpose only)");
                        }
                    }
                    catch (IOException e) {
                        log.error("getFile - error opening umd media: " + e.getMessage());
                    }
                } else {
                    File file = new File(pcfilename);
                    if (file.exists() && (flags & 0x200) == 512 && (flags & 0x800) == 2048) {
                        if (log.isDebugEnabled()) {
                            log.debug("getFile - file already exists (PSP_O_CREAT + PSP_O_EXCL)");
                        }
                    } else {
                        if (file.exists() && (flags & 0x400) == 1024) {
                            log.warn("getFile - file already exists, deleting UNIMPLEMENT (PSP_O_TRUNC)");
                        }
                        String mode = this.getMode(flags);
                        try {
                            SeekableRandomFile raf;
                            resultFile = raf = new SeekableRandomFile(pcfilename, mode);
                        }
                        catch (FileNotFoundException e) {
                            if (!log.isDebugEnabled()) break block15;
                            log.debug("getFile - file not found '" + pcfilename + "' (ok to ignore this message, debug purpose only)");
                        }
                    }
                }
            }
        }
        return resultFile;
    }

    public SeekableDataInput getFile(int id) {
        IoInfo info = this.fileIds.get(id);
        if (info == null) {
            return null;
        }
        return info.readOnlyFile;
    }

    public String getFileFilename(int id) {
        IoInfo info = this.fileIds.get(id);
        if (info == null) {
            return null;
        }
        return info.filename;
    }

    private String getMode(int flags) {
        return modeStrings[flags & 3];
    }

    private void updateResult(CpuState cpu, IoInfo info, long result, boolean async, boolean resultIs64bit, IoOperation ioOperation) {
        this.updateResult(cpu, info, result, async, resultIs64bit, ioOperation, null, 0);
    }

    private void updateResult(CpuState cpu, IoInfo info, long result, boolean async, boolean resultIs64bit, IoOperation ioOperation, IAction asyncAction, int size) {
        if (info != null) {
            if (async) {
                if (!info.asyncPending) {
                    this.startIoAsync(info, result, ioOperation, asyncAction, size);
                    result = 0L;
                }
            } else {
                info.result = -2147351766L;
            }
        }
        cpu.gpr[2] = (int)(result & 0xFFFFFFFFL);
        if (resultIs64bit) {
            cpu.gpr[3] = (int)(result >> 32);
        }
    }

    private String getWhenceName(int whence) {
        switch (whence) {
            case 0: {
                return "PSP_SEEK_SET";
            }
            case 1: {
                return "PSP_SEEK_CUR";
            }
            case 2: {
                return "PSP_SEEK_END";
            }
        }
        return "UNHANDLED " + whence;
    }

    public void setfilepath(String filepath) {
        filepath = filepath.replaceAll("\\\\", "/");
        log.info("pspiofilemgr - filepath " + filepath);
        this.filepath = filepath;
    }

    public void setIsoReader(UmdIsoReader iso) {
        this.iso = iso;
    }

    public UmdIsoReader getIsoReader() {
        return this.iso;
    }

    protected void delayIoOperation(IoOperation ioOperation) {
        if (ioOperation.delayMillis > 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(ioOperation.delayMillis * 1000, false);
        }
    }

    public void hleAsyncThread(Processor processor) {
        CpuState cpu = processor.cpu;
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        int uid = cpu.gpr[16];
        IoInfo info = this.fileUids.get(uid);
        if (info == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("hleAsyncThread non-existing uid=%x", uid));
            }
            cpu.gpr[2] = 0;
            threadMan.hleKernelExitDeleteThread();
        } else {
            if (log.isDebugEnabled()) {
                log.debug(String.format("hleAsyncThread id=%x", info.id));
            }
            boolean asyncCompleted = this.doStepAsync(info);
            if (threadMan.getCurrentThread() == info.asyncThread) {
                if (asyncCompleted) {
                    threadMan.hleKernelSleepThread(false);
                } else {
                    threadMan.hleKernelDelayThread(info.getAsyncRestMillis() * 1000, false);
                }
            }
        }
    }

    private void triggerAsyncThread(IoInfo info) {
        if (info.asyncThread != null) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            threadMan.hleKernelWakeupThread(info.asyncThread);
        }
    }

    private void startIoAsync(IoInfo info, long result, IoOperation ioOperation, IAction asyncAction, int size) {
        if (info == null) {
            return;
        }
        info.asyncPending = true;
        long now = Emulator.getClock().currentTimeMillis();
        info.asyncDoneMillis = now + (long)ioOperation.getDelayMillis(size);
        info.asyncAction = asyncAction;
        info.result = result;
        if (info.asyncThread == null) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            int asyncPriority = info.asyncThreadPriority;
            if (asyncPriority < 0) {
                asyncPriority = threadMan.getCurrentThread().currentPriority;
            }
            int stackSize = 8192;
            if (Emulator.getInstance().getFirmwareVersion() > 150) {
                stackSize = 2048;
            }
            info.asyncThread = threadMan.hleKernelCreateThread("SceIofileAsync", 0x8000040, asyncPriority, stackSize, threadMan.getCurrentThread().attr, 0);
            info.asyncThread.cpuContext.gpr[16] = info.uid;
            threadMan.hleKernelStartThread(info.asyncThread, 0, 0, info.asyncThread.gpReg_addr);
        } else {
            this.triggerAsyncThread(info);
        }
    }

    private boolean doStepAsync(IoInfo info) {
        boolean done = true;
        if (info.asyncAction != null) {
            IAction asyncAction = info.asyncAction;
            info.asyncAction = null;
            asyncAction.execute();
        }
        if (info.asyncPending) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            if (info.getAsyncRestMillis() > 0) {
                done = false;
            } else {
                info.asyncPending = false;
                if (info.cbid >= 0) {
                    threadMan.hleKernelNotifyCallback(1, info.cbid, info.notifyArg);
                }
                Iterator<SceKernelThreadInfo> it = threadMan.iterator();
                while (it.hasNext()) {
                    SceKernelThreadInfo thread = it.next();
                    if (thread.waitType != 256 || thread.wait.Io_id != info.id) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("IoFileMgrForUser.doStepAsync - onContextSwitch waking " + Integer.toHexString(thread.uid) + " thread:'" + thread.name + "'");
                    }
                    Memory mem = Memory.getInstance();
                    if (Memory.isAddressGood(thread.wait.Io_resultAddr)) {
                        if (log.isDebugEnabled()) {
                            log.debug("IoFileMgrForUser.doStepAsync - storing result 0x" + Long.toHexString(info.result));
                        }
                        mem.write64(thread.wait.Io_resultAddr, info.result);
                    }
                    info.result = -2147351766L;
                    thread.cpuContext.gpr[2] = 0;
                    threadMan.hleChangeThreadState(thread, 2);
                }
            }
        }
        return done;
    }

    public void unregisterIoListener(IIoListener ioListener) {
        if (this.ioListeners != null) {
            for (int i = 0; i < this.ioListeners.length; ++i) {
                if (this.ioListeners[i] != ioListener) continue;
                IIoListener[] newIoListeners = new IIoListener[this.ioListeners.length - 1];
                System.arraycopy(this.ioListeners, 0, newIoListeners, 0, i);
                System.arraycopy(this.ioListeners, i + 1, newIoListeners, i, this.ioListeners.length - i - 1);
                this.ioListeners = newIoListeners;
                break;
            }
        }
    }

    public void registerIoListener(IIoListener ioListener) {
        if (this.ioListeners == null) {
            this.ioListeners = new IIoListener[1];
            this.ioListeners[0] = ioListener;
        } else {
            for (int i = 0; i < this.ioListeners.length; ++i) {
                if (this.ioListeners[i] != ioListener) continue;
                return;
            }
            IIoListener[] newIoListeners = new IIoListener[this.ioListeners.length + 1];
            System.arraycopy(this.ioListeners, 0, newIoListeners, 0, this.ioListeners.length);
            newIoListeners[this.ioListeners.length] = ioListener;
            this.ioListeners = newIoListeners;
        }
    }

    public void hleIoWaitAsync(int id, int res_addr, boolean wait, boolean callbacks) {
        IoInfo info;
        if (log.isDebugEnabled()) {
            log.debug("hleIoWaitAsync(id=" + Integer.toHexString(id) + ",res=0x" + Integer.toHexString(res_addr) + ") wait=" + wait + " callbacks=" + callbacks);
        }
        if ((info = this.fileIds.get(id)) == null) {
            log.warn("hleIoWaitAsync - unknown id " + Integer.toHexString(id));
            Emulator.getProcessor().cpu.gpr[2] = -2147351773;
        } else if (info.result == -2147351766L) {
            log.debug("hleIoWaitAsync - PSP_ERROR_NO_ASYNC_OP");
            Emulator.getProcessor().cpu.gpr[2] = -2147351766;
        } else if (info.asyncPending && !wait) {
            log.debug("hleIoWaitAsync - poll return = 1(busy)");
            Emulator.getProcessor().cpu.gpr[2] = 1;
        } else {
            boolean waitForAsync = false;
            if (wait) {
                waitForAsync = true;
            }
            if (!info.asyncPending) {
                log.debug("hleIoWaitAsync - already context switched, not waiting");
                waitForAsync = false;
            }
            if (info.closePending) {
                log.debug("hleIoWaitAsync - file marked with closePending, calling hleIoClose, not waiting");
                this.hleIoClose(info.id, false);
                waitForAsync = false;
            }
            if (info.result == -2147418110L) {
                log.debug("hleIoWaitAsync - file not found, not waiting");
                info.close();
                this.triggerAsyncThread(info);
                waitForAsync = false;
            }
            Emulator.getProcessor().cpu.gpr[2] = 0;
            if (waitForAsync) {
                for (IIoListener ioListener : this.ioListeners) {
                    ioListener.sceIoWaitAsync(Emulator.getProcessor().cpu.gpr[2], id, res_addr);
                }
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
                currentThread.wait.Io_id = info.id;
                currentThread.wait.Io_resultAddr = res_addr;
                threadMan.hleKernelThreadEnterWaitState(256, info.id, this.ioWaitStateChecker, callbacks);
            } else {
                Memory mem = Memory.getInstance();
                if (Memory.isAddressGood(res_addr)) {
                    if (log.isDebugEnabled()) {
                        log.debug("hleIoWaitAsync - storing result 0x" + Long.toHexString(info.result));
                    }
                    mem.write64(res_addr, info.result);
                }
                for (IIoListener ioListener : this.ioListeners) {
                    ioListener.sceIoPollAsync(Emulator.getProcessor().cpu.gpr[2], id, res_addr);
                }
            }
        }
    }

    public void hleIoOpen(int filename_addr, int flags, int permissions, boolean async) {
        IoInfo info;
        String mode;
        String filename;
        block44: {
            filename = Utilities.readStringZ(filename_addr);
            if (log.isInfoEnabled()) {
                log.info("hleIoOpen filename = " + filename + " flags = " + Integer.toHexString(flags) + " permissions = 0" + Integer.toOctalString(permissions));
            }
            if (log.isDebugEnabled()) {
                if ((flags & 1) == 1) {
                    log.debug("PSP_O_RDONLY");
                }
                if ((flags & 2) == 2) {
                    log.debug("PSP_O_WRONLY");
                }
                if ((flags & 4) == 4) {
                    log.debug("PSP_O_NBLOCK");
                }
                if ((flags & 8) == 8) {
                    log.debug("PSP_O_DIROPEN");
                }
                if ((flags & 0x100) == 256) {
                    log.debug("PSP_O_APPEND");
                }
                if ((flags & 0x200) == 512) {
                    log.debug("PSP_O_CREAT");
                }
                if ((flags & 0x400) == 1024) {
                    log.debug("PSP_O_TRUNC");
                }
                if ((flags & 0x800) == 2048) {
                    log.debug("PSP_O_EXCL");
                }
                if ((flags & 0x4000) == 16384) {
                    log.debug("PSP_O_NBUF");
                }
                if ((flags & 0x8000) == 32768) {
                    log.debug("PSP_O_NOWAIT");
                }
                if ((flags & 0x2000000) == 0x2000000) {
                    log.debug("PSP_O_PLOCK");
                }
                if ((flags & 0x40000000) == 0x40000000) {
                    log.debug("PSP_O_FGAMEDATA");
                }
            }
            if ((mode = this.getMode(flags)) == null) {
                log.error("hleIoOpen - unhandled flags " + Integer.toHexString(flags));
                for (IIoListener ioListener : this.ioListeners) {
                    ioListener.sceIoOpen(-1, filename_addr, filename, flags, permissions, mode);
                }
                Emulator.getProcessor().cpu.gpr[2] = -1;
                return;
            }
            int retry = flags >> 16 & 0xF;
            if (retry != 0) {
                log.info("hleIoOpen - retry count is " + retry);
            }
            if ((flags & 1) == 1 && (flags & 0x100) == 256) {
                log.warn("hleIoOpen - read and append flags both set!");
            }
            info = null;
            try {
                String pcfilename = this.getDeviceFilePath(filename);
                if (pcfilename != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("hleIoOpen - opening file " + pcfilename);
                    }
                    if (this.isUmdPath(pcfilename)) {
                        if (this.iso == null) {
                            log.error("hleIoOpen - no umd mounted");
                            Emulator.getProcessor().cpu.gpr[2] = -2147418093;
                            break block44;
                        }
                        if (!Modules.sceUmdUserModule.isUmdActivated()) {
                            log.warn("hleIoOpen - umd mounted but not activated");
                            Emulator.getProcessor().cpu.gpr[2] = -2147351775;
                            break block44;
                        }
                        if ((flags & 2) == 2 || (flags & 0x200) == 512 || (flags & 0x400) == 1024) {
                            log.error("hleIoOpen - refusing to open umd media for write");
                            Emulator.getProcessor().cpu.gpr[2] = -2147418082;
                            break block44;
                        }
                        try {
                            String trimmedFileName = this.trimUmdPrefix(pcfilename);
                            UmdIsoFile file = this.iso.getFile(trimmedFileName);
                            info = new IoInfo(filename, file, mode, flags, permissions);
                            if (!info.isValidId()) {
                                log.warn(String.format("hleIoOpen - too many open files", new Object[0]));
                                Emulator.getProcessor().cpu.gpr[2] = -2147351776;
                                async = false;
                            } else {
                                if (trimmedFileName != null && trimmedFileName.length() == 0) {
                                    info.sectorBlockMode = true;
                                }
                                info.result = -2147351766L;
                                Emulator.getProcessor().cpu.gpr[2] = info.id;
                                if (log.isDebugEnabled()) {
                                    log.debug("hleIoOpen assigned id = 0x" + Integer.toHexString(info.id));
                                }
                            }
                            break block44;
                        }
                        catch (FileNotFoundException e) {
                            if (log.isDebugEnabled()) {
                                log.debug("hleIoOpen - umd file not found (ok to ignore this message, debug purpose only)");
                            }
                            Emulator.getProcessor().cpu.gpr[2] = -2147418110;
                        }
                        catch (IOException e) {
                            log.error("hleIoOpen - error opening umd media: " + e.getMessage());
                            Emulator.getProcessor().cpu.gpr[2] = -1;
                        }
                        break block44;
                    }
                    File file = new File(pcfilename);
                    if (file.exists() && (flags & 0x200) == 512 && (flags & 0x800) == 2048) {
                        if (log.isDebugEnabled()) {
                            log.debug("hleIoOpen - file already exists (PSP_O_CREAT + PSP_O_EXCL)");
                        }
                        Emulator.getProcessor().cpu.gpr[2] = -2147418095;
                    } else {
                        if (!file.exists() && (flags & 0x200) == 512) {
                            String parentDir = new File(pcfilename).getParent();
                            new File(parentDir).mkdirs();
                        }
                        SeekableRandomFile raf = new SeekableRandomFile(pcfilename, mode);
                        info = new IoInfo(filename, raf, mode, flags, permissions);
                        if ((flags & 2) == 2 && (flags & 0x400) == 1024) {
                            info.truncate(0);
                        }
                        info.result = -2147351766L;
                        Emulator.getProcessor().cpu.gpr[2] = info.id;
                        if (log.isDebugEnabled()) {
                            log.debug("hleIoOpen assigned id = 0x" + Integer.toHexString(info.id));
                        }
                    }
                    break block44;
                }
                Emulator.getProcessor().cpu.gpr[2] = -1;
            }
            catch (FileNotFoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug("hleIoOpen - file not found (ok to ignore this message, debug purpose only)");
                }
                Emulator.getProcessor().cpu.gpr[2] = -2147418110;
            }
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoOpen(Emulator.getProcessor().cpu.gpr[2], filename_addr, filename, flags, permissions, mode);
        }
        if (async) {
            int result = Emulator.getProcessor().cpu.gpr[2];
            if (info == null) {
                log.debug("sceIoOpenAsync - file not found (ok to ignore this message, debug purpose only)");
                info = new IoInfo(Utilities.readStringZ(filename_addr), null, null, flags, permissions);
                Emulator.getProcessor().cpu.gpr[2] = info.id;
            }
            this.startIoAsync(info, result, IoOperation.open, null, 0);
        }
    }

    private void hleIoClose(int id, boolean async) {
        CpuState cpu = Emulator.getProcessor().cpu;
        if (log.isDebugEnabled()) {
            log.debug("hleIoClose - id " + Integer.toHexString(id));
        }
        IoInfo info = this.fileIds.get(id);
        if (async) {
            if (info != null) {
                if (info.asyncPending) {
                    log.warn("sceIoCloseAsync - id " + Integer.toHexString(id) + " PSP_ERROR_ASYNC_BUSY");
                    cpu.gpr[2] = -2147351767;
                } else {
                    info.closePending = true;
                    this.updateResult(cpu, info, 0L, true, false, IoOperation.close);
                }
            } else {
                cpu.gpr[2] = -2147351773;
            }
        } else {
            try {
                if (info == null) {
                    if (id != 1 && id != 2) {
                        log.warn("sceIoClose - unknown id " + Integer.toHexString(id));
                    }
                    cpu.gpr[2] = -2147351773;
                } else {
                    if (info.readOnlyFile != null) {
                        info.readOnlyFile.close();
                    }
                    info.close();
                    this.triggerAsyncThread(info);
                    info.result = 0L;
                    cpu.gpr[2] = 0;
                }
            }
            catch (IOException e) {
                log.error("pspiofilemgr - error closing file: " + e.getMessage());
                e.printStackTrace();
                cpu.gpr[2] = -1;
            }
            for (IIoListener ioListener : this.ioListeners) {
                ioListener.sceIoClose(cpu.gpr[2], id);
            }
        }
    }

    private void hleIoWrite(int id, int data_addr, int size, boolean async) {
        int result;
        String message;
        IoInfo info = null;
        if (id == 1) {
            message = Utilities.stripNL(Utilities.readStringNZ(data_addr, size));
            stdout.info(message);
            result = size;
        } else if (id == 2) {
            message = Utilities.stripNL(Utilities.readStringNZ(data_addr, size));
            stderr.info(message);
            result = size;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("hleIoWrite(id=" + Integer.toHexString(id) + ",data=0x" + Integer.toHexString(data_addr) + ",size=0x" + Integer.toHexString(size) + ") async=" + async);
            }
            try {
                info = this.fileIds.get(id);
                if (info == null) {
                    log.warn("hleIoWrite - unknown id " + Integer.toHexString(id));
                    result = -2147351773;
                } else if (info.asyncPending) {
                    log.warn("hleIoWrite - id " + Integer.toHexString(id) + " PSP_ERROR_ASYNC_BUSY");
                    result = -2147351767;
                } else if (data_addr < 0x8000000 && data_addr + size > MemoryMap.END_RAM) {
                    log.warn("hleIoWrite - id " + Integer.toHexString(id) + " data is outside of ram 0x" + Integer.toHexString(data_addr) + " - 0x" + Integer.toHexString(data_addr + size));
                    result = -1;
                } else {
                    if ((info.flags & 0x100) == 256) {
                        info.msFile.seek(info.msFile.length());
                        info.position = info.msFile.length();
                    }
                    if (info.position > info.readOnlyFile.length()) {
                        int towrite;
                        byte[] junk = new byte[512];
                        info.msFile.seek(info.msFile.length());
                        for (towrite = (int)(info.position - info.readOnlyFile.length()); towrite >= 512; towrite -= 512) {
                            info.msFile.write(junk, 0, 512);
                        }
                        if (towrite > 0) {
                            info.msFile.write(junk, 0, towrite);
                        }
                    }
                    info.position += (long)size;
                    Utilities.write(info.msFile, data_addr, size);
                    result = size;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                result = -1;
            }
        }
        this.updateResult(Emulator.getProcessor().cpu, info, result, async, false, IoOperation.write, null, size);
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoWrite(Emulator.getProcessor().cpu.gpr[2], id, data_addr, Emulator.getProcessor().cpu.gpr[6], size);
        }
    }

    public void hleIoRead(int id, int data_addr, int size, boolean async) {
        int result;
        if (log.isDebugEnabled()) {
            log.debug("hleIoRead(id=" + Integer.toHexString(id) + ",data=0x" + Integer.toHexString(data_addr) + ",size=0x" + Integer.toHexString(size) + ") async=" + async);
        }
        IoInfo info = null;
        long position = 0L;
        SeekableDataInput dataInput = null;
        int requestedSize = size;
        IOAsyncReadAction asyncAction = null;
        if (id == 3) {
            log.warn("UNIMPLEMENTED:hleIoRead id = stdin");
            result = 0;
        } else {
            try {
                info = this.fileIds.get(id);
                if (info == null) {
                    log.warn("hleIoRead - unknown id " + Integer.toHexString(id));
                    result = -2147351773;
                } else if (info.asyncPending) {
                    log.warn("hleIoRead - id " + Integer.toHexString(id) + " PSP_ERROR_ASYNC_BUSY");
                    result = -2147351767;
                } else if (data_addr < 0x8000000 && data_addr + size > MemoryMap.END_RAM) {
                    log.warn("hleIoRead - id " + Integer.toHexString(id) + " data is outside of ram 0x" + Integer.toHexString(data_addr) + " - 0x" + Integer.toHexString(data_addr + size));
                    result = -2147352272;
                } else if (info.readOnlyFile == null || info.position >= info.readOnlyFile.length()) {
                    result = 0;
                } else {
                    if (info.sectorBlockMode) {
                        size *= 2048;
                    }
                    if (info.readOnlyFile.getFilePointer() + (long)size > info.readOnlyFile.length()) {
                        int oldSize = size;
                        size = (int)(info.readOnlyFile.length() - info.readOnlyFile.getFilePointer());
                        if (log.isDebugEnabled()) {
                            log.debug("hleIoRead - clamping size old=" + oldSize + " new=" + size + " fp=" + info.readOnlyFile.getFilePointer() + " len=" + info.readOnlyFile.length());
                        }
                    }
                    if (async) {
                        asyncAction = new IOAsyncReadAction(info, data_addr, requestedSize, size);
                        result = 0;
                    } else {
                        position = info.position;
                        dataInput = info.readOnlyFile;
                        Utilities.readFully(info.readOnlyFile, data_addr, size);
                        info.position += (long)size;
                        result = size;
                        RuntimeContext.invalidateRange(data_addr, size);
                        if (info.sectorBlockMode) {
                            result /= 2048;
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                result = -2147352272;
            }
            catch (Exception e) {
                e.printStackTrace();
                result = -2147352272;
                log.error("hleIoRead: Check other console for exception details. Press Run to continue.");
                Emulator.PauseEmu();
            }
        }
        this.updateResult(Emulator.getProcessor().cpu, info, result, async, false, IoOperation.read, asyncAction, size);
        if (asyncAction == null) {
            for (IIoListener ioListener : this.ioListeners) {
                ioListener.sceIoRead(result, id, data_addr, requestedSize, size, position, dataInput);
            }
        }
    }

    private void hleIoLseek(int id, long offset, int whence, boolean resultIs64bit, boolean async) {
        IoInfo info = null;
        long result = 0L;
        if (id == 1 || id == 2 || id == 3) {
            log.error("seek - can't seek on stdio id " + Integer.toHexString(id));
            result = -1L;
        } else {
            try {
                info = this.fileIds.get(id);
                if (info == null) {
                    log.warn("seek - unknown id " + Integer.toHexString(id));
                    result = -2147351773L;
                } else if (info.asyncPending) {
                    log.warn("seek - id " + Integer.toHexString(id) + " PSP_ERROR_ASYNC_BUSY");
                    result = -2147351767L;
                } else if (info.readOnlyFile == null) {
                    result = 0L;
                } else {
                    if (info.sectorBlockMode) {
                        offset *= 2048L;
                    }
                    switch (whence) {
                        case 0: {
                            if (offset < 0L) {
                                log.warn("SEEK_SET id " + Integer.toHexString(id) + " filename:'" + info.filename + "' offset=0x" + Long.toHexString(offset) + " (less than 0!)");
                                result = -2147483137L;
                                for (IIoListener ioListener : this.ioListeners) {
                                    ioListener.sceIoSeek64(-2147483137L, id, offset, whence);
                                }
                                return;
                            }
                            info.position = offset;
                            if (offset >= info.readOnlyFile.length()) break;
                            info.readOnlyFile.seek(offset);
                            break;
                        }
                        case 1: {
                            if (info.position + offset < 0L) {
                                log.warn("SEEK_CUR id " + Integer.toHexString(id) + " filename:'" + info.filename + "' newposition=0x" + Long.toHexString(info.position + offset) + " (less than 0!)");
                                result = -2147483137L;
                                for (IIoListener ioListener : this.ioListeners) {
                                    ioListener.sceIoSeek64(-2147483137L, id, offset, whence);
                                }
                                return;
                            }
                            info.position += offset;
                            if (info.position >= info.readOnlyFile.length()) break;
                            info.readOnlyFile.seek(info.position);
                            break;
                        }
                        case 2: {
                            if (info.readOnlyFile.length() + offset < 0L) {
                                log.warn("SEEK_END id " + Integer.toHexString(id) + " filename:'" + info.filename + "' newposition=0x" + Long.toHexString(info.position + offset) + " (less than 0!)");
                                result = -2147483137L;
                                for (IIoListener ioListener : this.ioListeners) {
                                    ioListener.sceIoSeek64(-2147483137L, id, offset, whence);
                                }
                                return;
                            }
                            info.position = info.readOnlyFile.length() + offset;
                            if (info.position >= info.readOnlyFile.length()) break;
                            info.readOnlyFile.seek(info.position);
                            break;
                        }
                        default: {
                            log.error("seek - unhandled whence " + whence);
                        }
                    }
                    result = info.position;
                    if (info.sectorBlockMode) {
                        result /= 2048L;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                result = -1L;
            }
        }
        this.updateResult(Emulator.getProcessor().cpu, info, result, async, resultIs64bit, IoOperation.seek);
        if (resultIs64bit) {
            for (IIoListener ioListener : this.ioListeners) {
                ioListener.sceIoSeek64((long)Emulator.getProcessor().cpu.gpr[2] & 0xFFFFFFFFL | (long)Emulator.getProcessor().cpu.gpr[3] << 32, id, offset, whence);
            }
        } else {
            for (IIoListener ioListener : this.ioListeners) {
                ioListener.sceIoSeek32(Emulator.getProcessor().cpu.gpr[2], id, (int)offset, whence);
            }
        }
    }

    public void hleIoIoctl(int id, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen, boolean async) {
        int i;
        IoInfo info = null;
        int result = -1;
        Memory mem = Memory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug(String.format("hleIoIoctl(id=%x, cmd=0x%08X, indata=0x%08X, inlen=%d, outdata=0x%08X, outlen=%d, async=%b", id, cmd, indata_addr, inlen, outdata_addr, outlen, async));
            if (Memory.isAddressGood(indata_addr)) {
                for (i = 0; i < inlen; i += 4) {
                    log.debug(String.format("hleIoIoctl indata[%d]=0x%08X", i / 4, mem.read32(indata_addr + i)));
                }
            }
            if (Memory.isAddressGood(outdata_addr)) {
                for (i = 0; i < Math.min(outlen, 256); i += 4) {
                    log.debug(String.format("hleIoIoctl outdata[%d]=0x%08X", i / 4, mem.read32(outdata_addr + i)));
                }
            }
        }
        if ((info = this.fileIds.get(id)) == null) {
            log.warn("hleIoIoctl - unknown id " + Integer.toHexString(id));
            result = -2147351773;
        } else if (info.asyncPending) {
            log.warn("hleIoIoctl - id " + Integer.toHexString(id) + " PSP_ERROR_ASYNC_BUSY");
            result = -2147351767;
        } else {
            block10 : switch (cmd) {
                case 0x1010005: {
                    if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                        if (info.isUmdFile()) {
                            try {
                                int offset = mem.read32(indata_addr);
                                log.debug("hleIoIoctl umd file seek set " + offset);
                                info.readOnlyFile.seek(offset);
                                info.position = offset;
                                result = 0;
                            }
                            catch (IOException e) {
                                log.warn("hleIoIoctl cmd=0x01010005 exception: " + e.getMessage());
                                result = -1;
                            }
                            break;
                        }
                        log.warn("hleIoIoctl cmd=0x01010005 only allowed on UMD files");
                        break;
                    }
                    log.warn("hleIoIoctl cmd=0x01010005 " + String.format("0x%08X %d", indata_addr, inlen) + " unsupported parameters");
                    result = -2147483137;
                    break;
                }
                case 0x1020001: {
                    if (Memory.isAddressGood(outdata_addr) && outlen == 2048) {
                        if (info.isUmdFile() && this.iso != null) {
                            try {
                                byte[] primaryVolumeSector = this.iso.readSector(UmdIsoReader.startSector);
                                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(outdata_addr, outlen, 1);
                                for (int i2 = 0; i2 < outlen; ++i2) {
                                    memoryWriter.writeNext(primaryVolumeSector[i2] & 0xFF);
                                }
                                memoryWriter.flush();
                                result = 0;
                            }
                            catch (IOException e) {
                                log.error(e);
                                result = -2147352272;
                            }
                            break;
                        }
                        log.warn("hleIoIoctl cmd=0x01020001 only allowed on UMD files");
                        break;
                    }
                    log.warn("hleIoIoctl cmd=0x01020001 " + String.format("0x%08X %d", outdata_addr, outlen) + " unsupported parameters");
                    result = -2147418090;
                    break;
                }
                case 0x1020002: {
                    if (Memory.isAddressGood(outdata_addr) && outlen <= 2048) {
                        if (info.isUmdFile() && this.iso != null) {
                            try {
                                byte[] primaryVolumeSector = this.iso.readSector(UmdIsoReader.startSector);
                                ByteBuffer primaryVolume = ByteBuffer.wrap(primaryVolumeSector);
                                primaryVolume.position(140);
                                int pathTableLocation = Utilities.readWord(primaryVolume);
                                byte[] pathTableSector = this.iso.readSector(pathTableLocation);
                                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(outdata_addr, outlen, 1);
                                for (int i3 = 0; i3 < outlen; ++i3) {
                                    memoryWriter.writeNext(pathTableSector[i3] & 0xFF);
                                }
                                memoryWriter.flush();
                                result = 0;
                            }
                            catch (IOException e) {
                                log.error(e);
                                result = -2147352272;
                            }
                            break;
                        }
                        log.warn("hleIoIoctl cmd=0x01020002 only allowed on UMD files");
                        break;
                    }
                    log.warn("hleIoIoctl cmd=0x01020002 " + String.format("0x%08X %d", outdata_addr, outlen) + " unsupported parameters");
                    result = -2147418090;
                    break;
                }
                case 16908291: {
                    if (Memory.isAddressGood(outdata_addr) && outlen == 4) {
                        if (info.isUmdFile() && this.iso != null) {
                            mem.write32(outdata_addr, 2048);
                            result = 0;
                            break;
                        }
                        log.warn("hleIoIoctl cmd=0x01020003 only allowed on UMD files");
                        break;
                    }
                    log.warn("hleIoIoctl cmd=0x01020003 " + String.format("0x%08X %d", outdata_addr, outlen) + " unsupported parameters");
                    result = -2147418090;
                    break;
                }
                case 16908292: {
                    if (Memory.isAddressGood(outdata_addr) && outlen >= 4) {
                        if (info.isUmdFile()) {
                            try {
                                int fPointer = (int)info.readOnlyFile.getFilePointer();
                                mem.write32(outdata_addr, fPointer);
                                log.debug("hleIoIoctl umd file get file pointer " + fPointer);
                                result = 0;
                            }
                            catch (IOException e) {
                                log.warn("hleIoIoctl cmd=0x01020004 exception: " + e.getMessage());
                            }
                            break;
                        }
                        log.warn("hleIoIoctl cmd=0x01020004 only allowed on UMD files");
                        break;
                    }
                    log.warn("hleIoIoctl cmd=0x01020004 " + String.format("0x%08X %d", outdata_addr, outlen) + " unsupported parameters");
                    result = -2147483137;
                    break;
                }
                case 16908294: {
                    if (Memory.isAddressGood(outdata_addr) && outlen >= 4) {
                        int startSector = 0;
                        if (info.isUmdFile() && info.readOnlyFile instanceof UmdIsoFile) {
                            UmdIsoFile file = (UmdIsoFile)info.readOnlyFile;
                            startSector = file.getStartSector();
                            log.debug("hleIoIoctl umd file get start sector " + startSector);
                            mem.write32(outdata_addr, startSector);
                            result = 0;
                            break;
                        }
                        log.warn("hleIoIoctl cmd=0x01020006 only allowed on UMD files and only implemented for UmdIsoFile");
                        break;
                    }
                    log.warn("hleIoIoctl cmd=0x01020006 " + String.format("0x%08X %d", outdata_addr, outlen) + " unsupported parameters");
                    result = -2147483137;
                    break;
                }
                case 16908295: {
                    if (Memory.isAddressGood(outdata_addr) && outlen >= 8) {
                        if (info.isUmdFile()) {
                            try {
                                long length = info.readOnlyFile.length();
                                mem.write64(outdata_addr, length);
                                log.debug("hleIoIoctl get file size " + length);
                                result = 0;
                            }
                            catch (IOException e) {
                                log.warn("hleIoIoctl cmd=0x01020007 exception: " + e.getMessage());
                            }
                            break;
                        }
                        log.warn("hleIoIoctl cmd=0x01020007 only allowed on UMD files");
                        break;
                    }
                    log.warn("hleIoIoctl cmd=0x01020007 " + String.format("0x%08X %d", outdata_addr, outlen) + " unsupported parameters");
                    result = -2147483137;
                    break;
                }
                case 16973832: {
                    if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                        int length = mem.read32(indata_addr);
                        if (length <= 0) break;
                        if (Memory.isAddressGood(outdata_addr) && outlen >= length) {
                            try {
                                Utilities.readFully(info.readOnlyFile, outdata_addr, length);
                                info.position += (long)length;
                                result = length;
                            }
                            catch (IOException e) {
                                log.error(e);
                                result = -2147352272;
                            }
                            break;
                        }
                        log.warn(String.format("hleIoIoctl cmd=0x%08X inlen=%d unsupported output parameters 0x%08X %d", cmd, inlen, outdata_addr, outlen));
                        result = -2147483137;
                        break;
                    }
                    log.warn(String.format("hleIoIoctl cmd=0x%08X unsupported input parameters 0x%08X %d", cmd, indata_addr, inlen));
                    result = -2147483137;
                    break;
                }
                case 32702467: {
                    if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                        int numberOfSectors = mem.read32(indata_addr);
                        if (numberOfSectors <= 0) break;
                        if (Memory.isAddressGood(outdata_addr) && outlen >= numberOfSectors) {
                            try {
                                int length = numberOfSectors * 2048;
                                Utilities.readFully(info.readOnlyFile, outdata_addr, length);
                                info.position += (long)length;
                                result = length / 2048;
                            }
                            catch (IOException e) {
                                log.error(e);
                                result = -2147352272;
                            }
                            break;
                        }
                        log.warn(String.format("hleIoIoctl cmd=0x%08X inlen=%d unsupported output parameters 0x%08X %d", cmd, inlen, outdata_addr, outlen));
                        result = -2147418090;
                        break;
                    }
                    log.warn(String.format("hleIoIoctl cmd=0x%08X unsupported input parameters 0x%08X %d", cmd, indata_addr, inlen));
                    result = -2147418090;
                    break;
                }
                case 32571558: {
                    if (Memory.isAddressGood(indata_addr) && inlen >= 16) {
                        if (info.isUmdFile()) {
                            try {
                                long offset = mem.read64(indata_addr);
                                int whence = mem.read32(indata_addr + 12);
                                if (info.sectorBlockMode) {
                                    offset *= 2048L;
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug("hleIoIoctl UMD file seek offset " + offset + ", whence " + whence);
                                }
                                switch (whence) {
                                    case 0: {
                                        info.position = offset;
                                        info.readOnlyFile.seek(info.position);
                                        result = 0;
                                        break block10;
                                    }
                                    case 1: {
                                        info.position += offset;
                                        info.readOnlyFile.seek(info.position);
                                        result = 0;
                                        break block10;
                                    }
                                    case 2: {
                                        info.position = info.readOnlyFile.length() + offset;
                                        info.readOnlyFile.seek(info.position);
                                        result = 0;
                                        break block10;
                                    }
                                }
                                log.error("hleIoIoctl - unhandled whence " + whence);
                                result = -1;
                            }
                            catch (IOException e) {
                                log.warn("hleIoIoctl cmd=0x01F100A6 exception: " + e.getMessage());
                                result = -1;
                            }
                            break;
                        }
                        log.warn("hleIoIoctl cmd=0x01F100A6 only allowed on UMD files");
                        break;
                    }
                    log.warn("hleIoIoctl cmd=0x01F100A6 " + String.format("0x%08X %d", indata_addr, inlen) + " unsupported parameters");
                    result = -2147483137;
                    break;
                }
                case 0x4100001: {
                    if (Memory.isAddressGood(indata_addr) && inlen == 16) {
                        SeekableDataInput decInput;
                        CryptoEngine crypto = new CryptoEngine();
                        String keyHex = "";
                        if (this.pgdFileConnector == null) {
                            this.pgdFileConnector = new PGDFileConnector();
                        }
                        byte[] keyBuf = new byte[16];
                        for (int i4 = 0; i4 < 16; ++i4) {
                            keyBuf[i4] = (byte)mem.read8(indata_addr + i4);
                            keyHex = keyHex + String.format("%02x", keyBuf[i4] & 0xFF);
                        }
                        if (this.getAllowExtractPGDStatus()) {
                            this.pgdFileConnector.extractPGDFile(info.filename, info.readOnlyFile, keyHex);
                        }
                        if ((decInput = this.pgdFileConnector.loadDecryptedPGDFile(info.filename)) != null) {
                            info.readOnlyFile = decInput;
                        } else {
                            try {
                                String pgdPath = this.pgdFileConnector.getBaseDirectory(this.pgdFileConnector.id);
                                new File(pgdPath).mkdirs();
                                String decFileName = this.pgdFileConnector.getCompleteFileName("PGDfile.raw.decrypted");
                                SeekableRandomFile decFile = new SeekableRandomFile(decFileName, "rw");
                                int maxAlignedChunkSize = 20208;
                                int pgdHeaderSize = 160;
                                byte[] inBuf = new byte[maxAlignedChunkSize + pgdHeaderSize];
                                byte[] outBuf = new byte[maxAlignedChunkSize + 16];
                                byte[] headerBuf = new byte[64];
                                byte[] hashBuf = new byte[16];
                                info.readOnlyFile.readFully(inBuf, 0, pgdHeaderSize);
                                System.arraycopy(inBuf, 16, headerBuf, 0, 16);
                                System.arraycopy(inBuf, 48, headerBuf, 16, 48);
                                byte[] headerBufDec = crypto.DecryptPGD(headerBuf, 64, keyBuf);
                                System.arraycopy(headerBufDec, 0, hashBuf, 0, 16);
                                int dataSize = headerBufDec[20] & 0xFF | (headerBufDec[21] & 0xFF) << 8 | (headerBufDec[22] & 0xFF) << 16 | (headerBufDec[23] & 0xFF) << 24;
                                int chunkSize = headerBufDec[24] & 0xFF | (headerBufDec[25] & 0xFF) << 8 | (headerBufDec[26] & 0xFF) << 16 | (headerBufDec[27] & 0xFF) << 24;
                                int hashOffset = headerBufDec[28] & 0xFF | (headerBufDec[29] & 0xFF) << 8 | (headerBufDec[30] & 0xFF) << 16 | (headerBufDec[31] & 0xFF) << 24;
                                if (log.isDebugEnabled()) {
                                    log.debug(String.format("PGD dataSize=%d, chunkSize=%d, hashOffset=%d", dataSize, chunkSize, hashOffset));
                                }
                                if (dataSize <= maxAlignedChunkSize) {
                                    info.readOnlyFile.seek(hashOffset);
                                    info.readOnlyFile.readFully(inBuf, 160, dataSize);
                                    System.arraycopy(hashBuf, 0, outBuf, 0, 16);
                                    System.arraycopy(inBuf, 160, outBuf, 16, dataSize);
                                    decFile.write(crypto.DecryptPGD(outBuf, dataSize + 16, keyBuf));
                                } else {
                                    info.readOnlyFile.seek(hashOffset);
                                    info.readOnlyFile.readFully(inBuf, 160, maxAlignedChunkSize);
                                    System.arraycopy(hashBuf, 0, outBuf, 0, 16);
                                    System.arraycopy(inBuf, 160, outBuf, 16, maxAlignedChunkSize);
                                    decFile.write(crypto.DecryptPGD(outBuf, maxAlignedChunkSize + 16, keyBuf));
                                    for (int i5 = 0; i5 < dataSize; i5 += maxAlignedChunkSize) {
                                        info.readOnlyFile.readFully(inBuf, 160, maxAlignedChunkSize);
                                        System.arraycopy(hashBuf, 0, outBuf, 0, 16);
                                        System.arraycopy(inBuf, 160, outBuf, 16, maxAlignedChunkSize);
                                        decFile.write(crypto.UpdatePGDCipher(outBuf, maxAlignedChunkSize + 16));
                                    }
                                }
                                crypto.FinishPGDCipher();
                                decFile.setLength(dataSize);
                                decFile.close();
                            }
                            catch (Exception e) {
                                log.error(e);
                            }
                            try {
                                info.readOnlyFile.seek(info.position);
                            }
                            catch (IOException e) {
                                log.error(e);
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("hleIoIoctl get AES key " + keyHex);
                            }
                            info.readOnlyFile = this.pgdFileConnector.loadDecryptedPGDFile(info.filename);
                        }
                        result = 0;
                        break;
                    }
                    log.warn("hleIoIoctl cmd=0x04100001 " + String.format("0x%08X %d", indata_addr, inlen) + " unsupported parameters");
                    result = -2147483137;
                    break;
                }
                default: {
                    log.warn(String.format("hleIoIoctl 0x%08X unknown command, inlen=%d, outlen=%d", cmd, inlen, outlen));
                    if (Memory.isAddressGood(indata_addr)) {
                        for (i = 0; i < inlen; i += 4) {
                            log.warn(String.format("hleIoIoctl indata[%d]=0x%08X", i / 4, mem.read32(indata_addr + i)));
                        }
                    }
                    if (!Memory.isAddressGood(outdata_addr)) break;
                    for (i = 0; i < Math.min(outlen, 256); i += 4) {
                        log.warn(String.format("hleIoIoctl outdata[%d]=0x%08X", i / 4, mem.read32(outdata_addr + i)));
                    }
                }
            }
        }
        this.updateResult(Emulator.getProcessor().cpu, info, result, async, false, IoOperation.ioctl);
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoIoctl(Emulator.getProcessor().cpu.gpr[2], id, cmd, indata_addr, inlen, outdata_addr, outlen);
        }
    }

    @HLEFunction(nid=844229206, version=150)
    public void sceIoPollAsync(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int res_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceIoPollAsync redirecting to hleIoWaitAsync");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoWaitAsync(id, res_addr, false, false);
    }

    @HLEFunction(nid=-499192781, version=150)
    public void sceIoWaitAsync(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int res_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceIoWaitAsync redirecting to hleIoWaitAsync");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoWaitAsync(id, res_addr, true, false);
    }

    @HLEFunction(nid=903599942, version=150)
    public void sceIoWaitAsyncCB(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int res_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceIoWaitAsyncCB redirecting to hleIoWaitAsync");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoWaitAsync(id, res_addr, true, true);
    }

    @HLEFunction(nid=-888801066, version=150)
    public void sceIoGetAsyncStat(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int poll = cpu.gpr[5];
        int res_addr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("sceIoGetAsyncStat poll=0x" + Integer.toHexString(poll) + " redirecting to hleIoWaitAsync");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoWaitAsync(id, res_addr, poll == 0, false);
    }

    @HLEFunction(nid=-1298959745, version=150)
    public void sceIoChangeAsyncPriority(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int priority = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceIoChangeAsyncPriority id=0x" + Integer.toHexString(id) + ", priority=0x" + Integer.toHexString(priority));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (priority == -1) {
            priority = Modules.ThreadManForUserModule.getCurrentThread().currentPriority;
        }
        if (priority < 0) {
            cpu.gpr[2] = -2147352173;
        } else if (id == -1) {
            this.defaultAsyncPriority = priority;
            cpu.gpr[2] = 0;
        } else {
            IoInfo info = this.fileIds.get(id);
            if (info != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceIoChangeAsyncPriority changing priority of async thread from fd=%x to %d", info.id, priority));
                }
                info.asyncThreadPriority = priority;
                cpu.gpr[2] = 0;
                Modules.ThreadManForUserModule.hleKernelChangeThreadPriority(info.asyncThread, priority);
            } else {
                log.warn("sceIoChangeAsyncPriority invalid fd=" + id);
                cpu.gpr[2] = -2147351773;
            }
        }
    }

    @HLEFunction(nid=-1591081708, version=150)
    public void sceIoSetAsyncCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int cbid = cpu.gpr[5];
        int notifyArg = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("sceIoSetAsyncCallback - id " + Integer.toHexString(id) + " cbid " + Integer.toHexString(cbid) + " arg 0x" + Integer.toHexString(notifyArg));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        IoInfo info = this.fileIds.get(id);
        if (info == null) {
            log.warn("sceIoSetAsyncCallback - unknown id " + Integer.toHexString(id));
            cpu.gpr[2] = -2147351773;
        } else if (Modules.ThreadManForUserModule.hleKernelRegisterCallback(1, cbid)) {
            info.cbid = cbid;
            info.notifyArg = notifyArg;
            this.triggerAsyncThread(info);
            cpu.gpr[2] = 0;
        } else {
            log.warn("sceIoSetAsyncCallback - not a callback id " + Integer.toHexString(id));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-2129900605, version=150)
    public void sceIoClose(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceIoClose redirecting to hleIoClose");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoClose(id, false);
        this.delayIoOperation(IoOperation.close);
    }

    @HLEFunction(nid=-10927946, version=150)
    public void sceIoCloseAsync(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceIoCloseAsync redirecting to hleIoClose");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoClose(id, true);
    }

    @HLEFunction(nid=278876348, version=150)
    public void sceIoOpen(Processor processor) {
        CpuState cpu = processor.cpu;
        int filename_addr = cpu.gpr[4];
        int flags = cpu.gpr[5];
        int permissions = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("sceIoOpen redirecting to hleIoOpen");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoOpen(filename_addr, flags, permissions, false);
        this.delayIoOperation(IoOperation.open);
    }

    @HLEFunction(nid=-1985308410, version=150)
    public void sceIoOpenAsync(Processor processor) {
        CpuState cpu = processor.cpu;
        int filename_addr = cpu.gpr[4];
        int flags = cpu.gpr[5];
        int permissions = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("sceIoOpenAsync redirecting to hleIoOpen");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoOpen(filename_addr, flags, permissions, true);
    }

    @HLEFunction(nid=1784909187, version=150)
    public void sceIoRead(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int data_addr = cpu.gpr[5];
        int size = cpu.gpr[6];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoRead(id, data_addr, size, false);
        this.delayIoOperation(IoOperation.read);
    }

    @HLEFunction(nid=-1598707774, version=150)
    public void sceIoReadAsync(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int data_addr = cpu.gpr[5];
        int size = cpu.gpr[6];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoRead(id, data_addr, size, true);
    }

    @HLEFunction(nid=1122763692, version=150)
    public void sceIoWrite(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int data_addr = cpu.gpr[5];
        int size = cpu.gpr[6];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoWrite(id, data_addr, size, false);
        if (id != 1 && id != 2) {
            this.delayIoOperation(IoOperation.write);
        }
    }

    @HLEFunction(nid=262974233, version=150)
    public void sceIoWriteAsync(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int data_addr = cpu.gpr[5];
        int size = cpu.gpr[6];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoWrite(id, data_addr, size, true);
    }

    @HLEFunction(nid=669722552, version=150)
    public void sceIoLseek(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        long offset = (long)cpu.gpr[6] & 0xFFFFFFFFL | (long)cpu.gpr[7] << 32;
        int whence = cpu.gpr[8];
        if (log.isDebugEnabled()) {
            log.debug("sceIoLseek - id " + Integer.toHexString(id) + " offset " + offset + " (hex=0x" + Long.toHexString(offset) + ") whence " + this.getWhenceName(whence));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoLseek(id, offset, whence, true, false);
        this.delayIoOperation(IoOperation.seek);
    }

    @HLEFunction(nid=1907465847, version=150)
    public void sceIoLseekAsync(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        long offset = (long)cpu.gpr[6] & 0xFFFFFFFFL | (long)cpu.gpr[7] << 32;
        int whence = cpu.gpr[8];
        if (log.isDebugEnabled()) {
            log.debug("sceIoLseekAsync - id " + Integer.toHexString(id) + " offset " + offset + " (hex=0x" + Long.toHexString(offset) + ") whence " + this.getWhenceName(whence));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoLseek(id, offset, whence, true, true);
    }

    @HLEFunction(nid=1754673956, version=150)
    public void sceIoLseek32(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int offset = cpu.gpr[5];
        int whence = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("sceIoLseek32 - id " + Integer.toHexString(id) + " offset " + offset + " (hex=0x" + Integer.toHexString(offset) + ") whence " + this.getWhenceName(whence));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoLseek(id, offset, whence, false, false);
        this.delayIoOperation(IoOperation.seek);
    }

    @HLEFunction(nid=456678799, version=150)
    public void sceIoLseek32Async(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int offset = cpu.gpr[5];
        int whence = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("sceIoLseek32Async - id " + Integer.toHexString(id) + " offset " + offset + " (hex=0x" + Integer.toHexString(offset) + ") whence " + this.getWhenceName(whence));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoLseek(id, offset, whence, false, true);
    }

    @HLEFunction(nid=1667441737, version=150)
    public void sceIoIoctl(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int cmd = cpu.gpr[5];
        int indata_addr = cpu.gpr[6];
        int inlen = cpu.gpr[7];
        int outdata_addr = cpu.gpr[8];
        int outlen = cpu.gpr[9];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoIoctl(id, cmd, indata_addr, inlen, outdata_addr, outlen, false);
        this.delayIoOperation(IoOperation.ioctl);
    }

    @HLEFunction(nid=-379977429, version=150)
    public void sceIoIoctlAsync(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int cmd = cpu.gpr[5];
        int indata_addr = cpu.gpr[6];
        int inlen = cpu.gpr[7];
        int outdata_addr = cpu.gpr[8];
        int outlen = cpu.gpr[9];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleIoIoctl(id, cmd, indata_addr, inlen, outdata_addr, outlen, true);
    }

    @HLEFunction(nid=-1298276452, version=150)
    public void sceIoDopen(Processor processor) {
        String dirname;
        int dirname_addr;
        block21: {
            CpuState cpu = processor.cpu;
            dirname_addr = cpu.gpr[4];
            dirname = Utilities.readStringZ(dirname_addr);
            if (log.isDebugEnabled()) {
                log.debug("sceIoDopen dirname = " + dirname);
            }
            if (IntrManager.getInstance().isInsideInterrupt()) {
                cpu.gpr[2] = -2147352476;
                return;
            }
            String pcfilename = this.getDeviceFilePath(dirname);
            if (pcfilename != null) {
                if (this.isUmdPath(pcfilename)) {
                    String isofilename = this.trimUmdPrefix(pcfilename);
                    if (log.isDebugEnabled()) {
                        log.debug("sceIoDopen - isofilename = " + isofilename);
                    }
                    if (this.iso == null) {
                        log.error("sceIoDopen - no umd mounted");
                        cpu.gpr[2] = -2147418093;
                    } else if (!Modules.sceUmdUserModule.isUmdActivated()) {
                        log.warn("sceIoDopen - umd mounted but not activated");
                        cpu.gpr[2] = -2147351775;
                    } else {
                        try {
                            if (this.iso.isDirectory(isofilename)) {
                                String[] filenames = this.iso.listDirectory(isofilename);
                                IoDirInfo info = new IoDirInfo(pcfilename, filenames);
                                cpu.gpr[2] = info.id;
                                break block21;
                            }
                            log.warn("sceIoDopen '" + isofilename + "' not a umd directory!");
                            cpu.gpr[2] = -1;
                        }
                        catch (FileNotFoundException e) {
                            log.warn("sceIoDopen - '" + isofilename + "' umd file not found");
                            cpu.gpr[2] = -1;
                        }
                        catch (IOException e) {
                            log.warn("sceIoDopen - umd io error: " + e.getMessage());
                            cpu.gpr[2] = -1;
                        }
                    }
                } else if (dirname.startsWith("/") && dirname.indexOf(":") != -1) {
                    log.warn("sceIoDopen apps running outside of ms0 dir are not fully supported, relative child paths should still work");
                    cpu.gpr[2] = -1;
                } else {
                    File f;
                    if (log.isDebugEnabled()) {
                        log.debug("sceIoDopen - pcfilename = " + pcfilename);
                    }
                    if ((f = new File(pcfilename)).isDirectory()) {
                        IoDirInfo info = new IoDirInfo(pcfilename, f.list());
                        cpu.gpr[2] = info.id;
                    } else {
                        log.warn("sceIoDopen '" + pcfilename + "' not a directory! (could be missing)");
                        cpu.gpr[2] = -2147418110;
                    }
                }
            } else {
                cpu.gpr[2] = -1;
            }
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoDopen(Emulator.getProcessor().cpu.gpr[2], dirname_addr, dirname);
        }
        this.delayIoOperation(IoOperation.open);
    }

    @HLEFunction(nid=-471138228, version=150)
    public void sceIoDread(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int dirent_addr = cpu.gpr[5];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        IoDirInfo info = this.dirIds.get(id);
        if (info == null) {
            log.warn("sceIoDread unknown id " + Integer.toHexString(id));
            cpu.gpr[2] = -2147351773;
        } else if (info.hasNext()) {
            String filename = info.next();
            SceIoStat stat = this.stat(info.path + "/" + filename);
            if (stat != null) {
                SceIoDirent dirent = new SceIoDirent(stat, filename);
                dirent.write(Memory.getInstance(), dirent_addr);
                if ((stat.attr & 0x10) == 16) {
                    log.debug("sceIoDread id=" + Integer.toHexString(id) + " #" + info.printableposition + " dir='" + info.path + "', dir='" + filename + "'");
                } else {
                    log.debug("sceIoDread id=" + Integer.toHexString(id) + " #" + info.printableposition + " dir='" + info.path + "', file='" + filename + "'");
                }
                cpu.gpr[2] = 1;
            } else {
                log.warn("sceIoDread id=" + Integer.toHexString(id) + " stat failed (" + info.path + "/" + filename + ")");
                cpu.gpr[2] = -1;
            }
        } else {
            log.debug("sceIoDread id=" + Integer.toHexString(id) + " no more files");
            cpu.gpr[2] = 0;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoDread(cpu.gpr[2], id, dirent_addr);
        }
        this.delayIoOperation(IoOperation.read);
    }

    @HLEFunction(nid=-351722391, version=150)
    public void sceIoDclose(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceIoDclose - id = " + Integer.toHexString(id));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        IoDirInfo info = this.dirIds.get(id);
        if (info == null) {
            log.warn("sceIoDclose - unknown id " + Integer.toHexString(id));
            cpu.gpr[2] = -2147351773;
        } else {
            info.close();
            cpu.gpr[2] = 0;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoDclose(cpu.gpr[2], id);
        }
        this.delayIoOperation(IoOperation.close);
    }

    @HLEFunction(nid=-226845615, version=150)
    public void sceIoRemove(Processor processor) {
        File file;
        CpuState cpu = processor.cpu;
        int file_addr = cpu.gpr[4];
        String filename = Utilities.readStringZ(file_addr);
        if (log.isDebugEnabled()) {
            log.debug("sceIoRemove - file = " + filename);
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        String pcfilename = this.getDeviceFilePath(filename);
        cpu.gpr[2] = pcfilename != null ? (this.isUmdPath(pcfilename) ? -1 : ((file = new File(pcfilename)).delete() ? 0 : -1)) : -1;
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoRemove(cpu.gpr[2], file_addr, filename);
        }
        this.delayIoOperation(IoOperation.remove);
    }

    @HLEFunction(nid=111607812, version=150)
    public void sceIoMkdir(Processor processor) {
        CpuState cpu = processor.cpu;
        int dir_addr = cpu.gpr[4];
        int permissions = cpu.gpr[5];
        String dir = Utilities.readStringZ(dir_addr);
        if (log.isDebugEnabled()) {
            log.debug("sceIoMkdir dir = " + dir);
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        String pcfilename = this.getDeviceFilePath(dir);
        if (pcfilename != null) {
            File f = new File(pcfilename);
            f.mkdir();
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -1;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoMkdir(cpu.gpr[2], dir_addr, dir, permissions);
        }
        this.delayIoOperation(IoOperation.mkdir);
    }

    @HLEFunction(nid=286770783, version=150)
    public void sceIoRmdir(Processor processor) {
        CpuState cpu = processor.cpu;
        int dir_addr = cpu.gpr[4];
        String dir = Utilities.readStringZ(dir_addr);
        if (log.isDebugEnabled()) {
            log.debug("sceIoRmdir dir = " + dir);
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        String pcfilename = this.getDeviceFilePath(dir);
        if (pcfilename != null) {
            File f = new File(pcfilename);
            f.delete();
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -1;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoRmdir(cpu.gpr[2], dir_addr, dir);
        }
        this.delayIoOperation(IoOperation.remove);
    }

    @HLEFunction(nid=1442083197, version=150)
    public void sceIoChdir(Processor processor) {
        CpuState cpu = processor.cpu;
        int path_addr = cpu.gpr[4];
        String path = Utilities.readStringZ(path_addr);
        if (log.isDebugEnabled()) {
            log.debug("sceIoChdir path = " + path);
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (path.equals("..")) {
            int index = this.filepath.lastIndexOf("/");
            if (index != -1) {
                this.filepath = this.filepath.substring(0, index);
            }
            log.info("pspiofilemgr - filepath " + this.filepath + " (going up one level)");
            cpu.gpr[2] = 0;
        } else {
            String pcfilename = this.getDeviceFilePath(path);
            if (pcfilename != null) {
                this.filepath = pcfilename;
                log.info("pspiofilemgr - filepath " + this.filepath);
                cpu.gpr[2] = 0;
            } else {
                cpu.gpr[2] = -1;
            }
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoChdir(cpu.gpr[2], path_addr, path);
        }
    }

    @HLEFunction(nid=-1416215681, version=150)
    public void sceIoSync(Processor processor) {
        CpuState cpu = processor.cpu;
        int device_addr = cpu.gpr[4];
        int flag = cpu.gpr[5];
        String device = Utilities.readStringZ(device_addr);
        if (log.isDebugEnabled()) {
            log.debug("IGNORING: sceIoSync(device='" + device + "', flag=0x" + Integer.toHexString(flag) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoSync(0, device_addr, device, flag);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1393998104, version=150)
    public void sceIoGetstat(Processor processor) {
        CpuState cpu = processor.cpu;
        int file_addr = cpu.gpr[4];
        int stat_addr = cpu.gpr[5];
        String filename = Utilities.readStringZ(file_addr);
        if (log.isDebugEnabled()) {
            log.debug("sceIoGetstat - file = " + filename + " stat = " + Integer.toHexString(stat_addr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        String pcfilename = this.getDeviceFilePath(filename);
        SceIoStat stat = this.stat(pcfilename);
        if (stat != null) {
            stat.write(Memory.getInstance(), stat_addr);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2147418110;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoGetStat(cpu.gpr[2], file_addr, filename, stat_addr);
        }
    }

    @HLEFunction(nid=-1196998412, version=150)
    public void sceIoChstat(Processor processor) {
        CpuState cpu = processor.cpu;
        int file_addr = cpu.gpr[4];
        int stat_addr = cpu.gpr[5];
        int bits = cpu.gpr[6];
        String filename = Utilities.readStringZ(file_addr);
        if (log.isDebugEnabled()) {
            log.debug("sceIoChstat - file = " + filename + ", bits=0x" + Integer.toHexString(bits));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        String pcfilename = this.getDeviceFilePath(filename);
        if (pcfilename != null) {
            if (this.isUmdPath(pcfilename)) {
                cpu.gpr[2] = -1;
            } else {
                File file = new File(pcfilename);
                SceIoStat stat = new SceIoStat();
                stat.read(Memory.getInstance(), stat_addr);
                int mode = stat.mode;
                boolean successful = true;
                if ((bits & 1) != 0 && !file.setExecutable((mode & 1) != 0)) {
                    successful = false;
                }
                if ((bits & 2) != 0 && !file.setWritable((mode & 2) != 0)) {
                    successful = false;
                }
                if ((bits & 4) != 0 && !file.setReadable((mode & 4) != 0)) {
                    successful = false;
                }
                if ((bits & 0x40) != 0 && !file.setExecutable((mode & 0x40) != 0, true)) {
                    successful = false;
                }
                if ((bits & 0x80) != 0 && !file.setWritable((mode & 0x80) != 0, true)) {
                    successful = false;
                }
                if ((bits & 0x100) != 0 && !file.setReadable((mode & 0x100) != 0, true)) {
                    successful = false;
                }
                cpu.gpr[2] = successful ? 0 : -1;
            }
        } else {
            cpu.gpr[2] = -1;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoChstat(cpu.gpr[2], file_addr, filename, stat_addr, bits);
        }
    }

    @HLEFunction(nid=2005992352, version=150)
    public void sceIoRename(Processor processor) {
        File newfile;
        File file;
        CpuState cpu = processor.cpu;
        int file_addr = cpu.gpr[4];
        int new_file_addr = cpu.gpr[4];
        String filename = Utilities.readStringZ(file_addr);
        String newfilename = Utilities.readStringZ(new_file_addr);
        if (log.isDebugEnabled()) {
            log.debug("sceIoRename - file = " + filename + ", new_file = " + newfilename);
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        String pcfilename = this.getDeviceFilePath(filename);
        String newpcfilename = this.getDeviceFilePath(newfilename);
        cpu.gpr[2] = pcfilename != null ? (this.isUmdPath(pcfilename) ? -1 : ((file = new File(pcfilename)).renameTo(newfile = new File(newpcfilename)) ? 0 : -1)) : -1;
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoRename(cpu.gpr[2], file_addr, filename, new_file_addr, newfilename);
        }
        this.delayIoOperation(IoOperation.rename);
    }

    @HLEFunction(nid=1425406737, version=150)
    public void sceIoDevctl(Processor processor, int device_addr, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        int i;
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        String device = Utilities.readStringZ(device_addr);
        if (log.isDebugEnabled()) {
            log.debug("sceIoDevctl(device='" + device + "',cmd=0x" + Integer.toHexString(cmd) + ",indata=0x" + Integer.toHexString(indata_addr) + ",inlen=" + inlen + ",outdata=0x" + Integer.toHexString(outdata_addr) + ",outlen=" + outlen + ")");
            if (Memory.isAddressGood(indata_addr)) {
                for (i = 0; i < inlen; i += 4) {
                    log.debug("sceIoDevctl indata[" + i / 4 + "]=0x" + Integer.toHexString(mem.read32(indata_addr + i)));
                }
            }
            if (Memory.isAddressGood(outdata_addr)) {
                for (i = 0; i < outlen; i += 4) {
                    log.debug("sceIoDevctl outdata[" + i / 4 + "]=0x" + Integer.toHexString(mem.read32(outdata_addr + i)));
                }
            }
        }
        if (device.equals("emulator:")) {
            switch (cmd) {
                case 1: {
                    if (!Memory.isAddressGood(outdata_addr) || outlen < 4) break;
                    mem.write32(outdata_addr, 0);
                    cpu.gpr[2] = 0;
                    break;
                }
                case 2: {
                    AutoTestsOutput.appendString(new String(mem.readChunk(indata_addr, inlen).array()));
                    cpu.gpr[2] = 0;
                    break;
                }
                case 3: {
                    cpu.gpr[2] = 0;
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Unknown emulator: cmd 0x%08X", cmd));
                }
            }
            for (IIoListener ioListener : this.ioListeners) {
                ioListener.sceIoDevctl(cpu.gpr[2], device_addr, device, cmd, indata_addr, inlen, outdata_addr, outlen);
            }
            this.delayIoOperation(IoOperation.ioctl);
            return;
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        switch (cmd) {
            case 32636929: {
                if (log.isDebugEnabled()) {
                    log.debug("sceIoDevctl " + String.format("0x%08X", cmd) + " get disc type");
                }
                if (Memory.isAddressGood(outdata_addr) && outlen >= 8) {
                    int result = this.iso == null ? 0 : 16;
                    mem.write32(outdata_addr + 4, result);
                    cpu.gpr[2] = 0;
                    break;
                }
                cpu.gpr[2] = -1;
                break;
            }
            case 32636930: {
                if (log.isDebugEnabled()) {
                    log.debug("sceIoDevctl " + String.format("0x%08X", cmd) + " get current LBA");
                }
                if (Memory.isAddressGood(outdata_addr) && outlen >= 4) {
                    mem.write32(outdata_addr, 0);
                    cpu.gpr[2] = 0;
                    break;
                }
                cpu.gpr[2] = -1;
                break;
            }
            case 32571555: {
                if (log.isDebugEnabled()) {
                    log.debug("sceIoDevctl " + String.format("0x%08X", cmd) + " seek UMD disc");
                }
                if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                    int sector = mem.read32(indata_addr);
                    if (log.isDebugEnabled()) {
                        log.debug("sector=" + sector);
                    }
                    cpu.gpr[2] = 0;
                    break;
                }
                cpu.gpr[2] = -1;
                break;
            }
            case 32571556: {
                int sectorNum;
                int unk2;
                int sector;
                int unk1;
                if (log.isDebugEnabled()) {
                    log.debug("sceIoDevctl " + String.format("0x%08X", cmd) + " prepare UMD data to cache");
                }
                if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                    unk1 = mem.read32(indata_addr);
                    sector = mem.read32(indata_addr + 4);
                    unk2 = mem.read32(indata_addr + 8);
                    sectorNum = mem.read32(indata_addr + 12);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("sector=%d, sectorNum=%d, unk1=%d, unk2=%d", sector, sectorNum, unk1, unk2));
                    }
                    cpu.gpr[2] = 0;
                    break;
                }
                cpu.gpr[2] = -1;
                break;
            }
            case 32702629: {
                int sectorNum;
                int unk2;
                int sector;
                int unk1;
                if (log.isDebugEnabled()) {
                    log.debug("sceIoDevctl " + String.format("0x%08X", cmd) + " prepare UMD data to cache and get status");
                }
                if (Memory.isAddressGood(indata_addr) && inlen >= 4 && Memory.isAddressGood(outdata_addr) && outlen >= 4) {
                    unk1 = mem.read32(indata_addr);
                    sector = mem.read32(indata_addr + 4);
                    unk2 = mem.read32(indata_addr + 8);
                    sectorNum = mem.read32(indata_addr + 12);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("sector=%d, sectorNum=%d, unk1=%d, unk2=%d", sector, sectorNum, unk1, unk2));
                    }
                    mem.write32(outdata_addr, 1);
                    cpu.gpr[2] = 0;
                    break;
                }
                cpu.gpr[2] = -1;
                break;
            }
            case 33708033: {
                log.debug("sceIoDevctl " + String.format("0x%08X", cmd) + " check ms driver status");
                if (!device.equals("mscmhc0:")) {
                    cpu.gpr[2] = -2147351771;
                    break;
                }
                if (Memory.isAddressGood(outdata_addr)) {
                    mem.write32(outdata_addr, 1);
                    cpu.gpr[2] = 0;
                    break;
                }
                cpu.gpr[2] = -1;
                break;
            }
            case 33642500: {
                int callbackType;
                int cbid;
                log.debug("sceIoDevctl register memorystick insert/eject callback (mscmhc0)");
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                if (!device.equals("mscmhc0:")) {
                    cpu.gpr[2] = -2147351771;
                    break;
                }
                if (Memory.isAddressGood(indata_addr) && inlen == 4) {
                    cbid = mem.read32(indata_addr);
                    callbackType = 2;
                    if (threadMan.hleKernelRegisterCallback(2, cbid)) {
                        threadMan.hleKernelNotifyCallback(2, cbid, MemoryStick.getStateMs());
                        cpu.gpr[2] = 0;
                        break;
                    }
                    cpu.gpr[2] = -2145255294;
                    break;
                }
                cpu.gpr[2] = -2145255295;
                break;
            }
            case 33642501: {
                int cbid;
                log.debug("sceIoDevctl unregister memorystick insert/eject callback (mscmhc0)");
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                if (!device.equals("mscmhc0:")) {
                    cpu.gpr[2] = -2147351771;
                    break;
                }
                if (Memory.isAddressGood(indata_addr) && inlen == 4) {
                    cbid = mem.read32(indata_addr);
                    if (threadMan.hleKernelUnRegisterCallback(2, cbid) != null) {
                        cpu.gpr[2] = 0;
                        break;
                    }
                    cpu.gpr[2] = -2145255295;
                    break;
                }
                cpu.gpr[2] = -1;
                break;
            }
            case 33708038: {
                log.debug("sceIoDevctl check ms inserted (mscmhc0)");
                if (!device.equals("mscmhc0:")) {
                    cpu.gpr[2] = -2147351771;
                    break;
                }
                if (Memory.isAddressGood(outdata_addr)) {
                    mem.write32(outdata_addr, 1);
                    cpu.gpr[2] = 0;
                    break;
                }
                cpu.gpr[2] = -1;
                break;
            }
            case 37836833: {
                int callbackType;
                int cbid;
                log.debug("sceIoDevctl register memorystick insert/eject callback (fatms0)");
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                if (!device.equals("fatms0:")) {
                    cpu.gpr[2] = -2145255295;
                    break;
                }
                if (Memory.isAddressGood(indata_addr) && inlen == 4) {
                    cbid = mem.read32(indata_addr);
                    callbackType = 3;
                    if (threadMan.hleKernelRegisterCallback(3, cbid)) {
                        threadMan.hleKernelNotifyCallback(3, cbid, MemoryStick.getStateFatMs());
                        cpu.gpr[2] = 0;
                        break;
                    }
                    cpu.gpr[2] = -2147418090;
                    break;
                }
                cpu.gpr[2] = -2147418090;
                break;
            }
            case 37836834: {
                int cbid;
                log.debug("sceIoDevctl unregister memorystick insert/eject callback (fatms0)");
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                if (!device.equals("fatms0:")) {
                    cpu.gpr[2] = -2145255295;
                    break;
                }
                if (Memory.isAddressGood(indata_addr) && inlen == 4) {
                    cbid = mem.read32(indata_addr);
                    threadMan.hleKernelUnRegisterCallback(3, cbid);
                    cpu.gpr[2] = 0;
                    break;
                }
                cpu.gpr[2] = -2147418090;
                break;
            }
            case 37836835: {
                log.debug("sceIoDevctl set assigned device (fatms0)");
                if (!device.equals("fatms0:")) {
                    cpu.gpr[2] = -2145255295;
                    break;
                }
                if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                    MemoryStick.setStateFatMs(mem.read32(indata_addr));
                    cpu.gpr[2] = 0;
                    break;
                }
                cpu.gpr[2] = -1;
                break;
            }
            case 37902372: {
                log.debug("sceIoDevctl check write protection (fatms0)");
                if (!device.equals("fatms0:") && !device.equals("ms0:")) {
                    cpu.gpr[2] = -2145255295;
                    break;
                }
                if (Memory.isAddressGood(outdata_addr)) {
                    mem.write32(outdata_addr, 0);
                    cpu.gpr[2] = 0;
                    break;
                }
                cpu.gpr[2] = -1;
                break;
            }
            case 37902360: {
                int maxClusters;
                log.debug("sceIoDevctl get MS capacity (fatms0)");
                int sectorSize = 512;
                int sectorCount = MemoryStick.getSectorSize() / sectorSize;
                int freeClusters = maxClusters = (int)(MemoryStick.getFreeSize() * 95L / 100L / (long)(sectorSize * sectorCount));
                int maxSectors = maxClusters;
                if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                    int addr = mem.read32(indata_addr);
                    if (Memory.isAddressGood(addr)) {
                        log.debug("sceIoDevctl refer ms free space");
                        mem.write32(addr, maxClusters);
                        mem.write32(addr + 4, freeClusters);
                        mem.write32(addr + 8, maxSectors);
                        mem.write32(addr + 12, sectorSize);
                        mem.write32(addr + 16, sectorCount);
                        cpu.gpr[2] = 0;
                        break;
                    }
                    log.warn("sceIoDevctl 0x02425818 bad save address " + String.format("0x%08X", addr));
                    cpu.gpr[2] = -1;
                    break;
                }
                log.warn("sceIoDevctl 0x02425818 bad param address " + String.format("0x%08X", indata_addr) + " or size " + inlen);
                cpu.gpr[2] = -1;
                break;
            }
            case 37902371: {
                log.debug("sceIoDevctl check assigned device (fatms0)");
                if (!device.equals("fatms0:")) {
                    cpu.gpr[2] = -2145255295;
                    break;
                }
                if (Memory.isAddressGood(outdata_addr) && outlen >= 4) {
                    mem.write32(outdata_addr, MemoryStick.getStateFatMs());
                    cpu.gpr[2] = 0;
                    break;
                }
                cpu.gpr[2] = -1;
                break;
            }
            case 54611969: {
                log.debug("sceIoDevctl register usb thread");
                if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                    cpu.gpr[2] = 0;
                    break;
                }
                cpu.gpr[2] = -1;
                break;
            }
            case 54611970: {
                log.debug("sceIoDevctl unregister usb thread");
                if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                    cpu.gpr[2] = 0;
                    break;
                }
                cpu.gpr[2] = -1;
                break;
            }
            default: {
                log.warn("sceIoDevctl " + String.format("0x%08X", cmd) + " unknown command");
                if (Memory.isAddressGood(indata_addr)) {
                    for (i = 0; i < inlen; i += 4) {
                        log.warn("sceIoDevctl indata[" + i / 4 + "]=0x" + Integer.toHexString(mem.read32(indata_addr + i)));
                    }
                }
                cpu.gpr[2] = -1;
            }
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoDevctl(cpu.gpr[2], device_addr, device, cmd, indata_addr, inlen, outdata_addr, outlen);
        }
        this.delayIoOperation(IoOperation.ioctl);
    }

    @HLEFunction(nid=146633588, version=150)
    public void sceIoGetDevType(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceIoGetDevType - id " + Integer.toHexString(id));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        IoInfo info = this.fileIds.get(id);
        if (info == null) {
            log.warn("sceIoGetDevType - unknown id " + Integer.toHexString(id));
            cpu.gpr[2] = -2147351773;
        } else {
            cpu.gpr[2] = 32;
        }
    }

    @HLEFunction(nid=-1297733439, version=150)
    public void sceIoAssign(Processor processor) {
        String perm;
        CpuState cpu = processor.cpu;
        int alias_addr = cpu.gpr[4];
        int physical_addr = cpu.gpr[5];
        int filesystem_addr = cpu.gpr[6];
        int mode = cpu.gpr[7];
        int arg_addr = cpu.gpr[8];
        int argSize = cpu.gpr[9];
        String alias = Utilities.readStringZ(alias_addr);
        String physical_dev = Utilities.readStringZ(physical_addr);
        String filesystem_dev = Utilities.readStringZ(filesystem_addr);
        switch (mode) {
            case 0: {
                perm = "IOASSIGN_RDWR";
                break;
            }
            case 1: {
                perm = "IOASSIGN_RDONLY";
                break;
            }
            default: {
                perm = "unhandled " + mode;
            }
        }
        log.warn("IGNORING: sceIoAssign(alias='" + alias + "', physical_dev='" + physical_dev + "', filesystem_dev='" + filesystem_dev + "', mode=" + perm + ", arg_addr=0x" + Integer.toHexString(arg_addr) + ", argSize=" + argSize + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 0;
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoAssign(cpu.gpr[2], alias_addr, alias, physical_addr, physical_dev, filesystem_addr, filesystem_dev, mode, arg_addr, argSize);
        }
    }

    @HLEFunction(nid=1829283953, version=150)
    public void sceIoUnassign(Processor processor) {
        CpuState cpu = processor.cpu;
        int alias_addr = cpu.gpr[4];
        String alias = Utilities.readStringZ(alias_addr);
        log.warn("IGNORING: sceIoUnassign (alias='" + alias + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-390306447, version=150)
    public void sceIoCancel(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceIoCancel - id " + Integer.toHexString(id));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        IoInfo info = this.fileIds.get(id);
        if (info == null) {
            log.warn("sceIoCancel - unknown id " + Integer.toHexString(id));
            cpu.gpr[2] = -2147351773;
        } else {
            info.closePending = true;
            cpu.gpr[2] = 0;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoCancel(cpu.gpr[2], id);
        }
    }

    @HLEFunction(nid=1546379980, version=150)
    public void sceIoGetFdList(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int out_addr = cpu.gpr[4];
        int outSize = cpu.gpr[5];
        int fdNum_addr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceIoGetFdList out_addr=0x%08X, outSize=%d, fdNum_addr=0x%08X", out_addr, outSize, fdNum_addr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        int count = 0;
        if (Memory.isAddressGood(out_addr) && outSize > 0) {
            IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(out_addr, 4 * outSize, 4);
            for (Integer fd : this.fileIds.keySet()) {
                if (count >= outSize) break;
                memoryWriter.writeNext(fd);
            }
            memoryWriter.flush();
        }
        if (fdNum_addr != 0) {
            mem.write32(fdNum_addr, this.fileIds.size());
        }
        cpu.gpr[2] = count;
    }

    static /* synthetic */ int access$000(IoFileMgrForUser x0) {
        return x0.defaultAsyncPriority;
    }

    private class ExtractPGDSettingsListerner
    extends AbstractBoolSettingsListener {
        private ExtractPGDSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            IoFileMgrForUser.this.setAllowExtractPGDStatus(value);
        }
    }

    private class IOAsyncReadAction
    implements IAction {
        private IoInfo info;
        private int address;
        private int size;
        private int requestedSize;

        public IOAsyncReadAction(IoInfo info, int address, int requestedSize, int size) {
            this.info = info;
            this.address = address;
            this.requestedSize = requestedSize;
            this.size = size;
        }

        @Override
        public void execute() {
            long position = this.info.position;
            int result = 0;
            try {
                Utilities.readFully(this.info.readOnlyFile, this.address, this.size);
                this.info.position += (long)this.size;
                result = this.size;
                if (this.info.sectorBlockMode) {
                    result /= 2048;
                }
            }
            catch (IOException e) {
                log.error(e);
                result = -2147352272;
            }
            this.info.result = result;
            RuntimeContext.invalidateRange(this.address, this.size);
            for (IIoListener ioListener : IoFileMgrForUser.this.ioListeners) {
                ioListener.sceIoRead(result, this.info.id, this.address, this.requestedSize, this.size, position, this.info.readOnlyFile);
            }
        }
    }

    private class IoWaitStateChecker
    implements IWaitStateChecker {
        private IoWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            IoInfo info = IoFileMgrForUser.this.fileIds.get(wait.Io_id);
            if (info == null) {
                return false;
            }
            return info.asyncPending;
        }
    }

    public static interface IIoListener {
        public void sceIoSync(int var1, int var2, String var3, int var4);

        public void sceIoPollAsync(int var1, int var2, int var3);

        public void sceIoWaitAsync(int var1, int var2, int var3);

        public void sceIoOpen(int var1, int var2, String var3, int var4, int var5, String var6);

        public void sceIoClose(int var1, int var2);

        public void sceIoWrite(int var1, int var2, int var3, int var4, int var5);

        public void sceIoRead(int var1, int var2, int var3, int var4, int var5, long var6, SeekableDataInput var8);

        public void sceIoCancel(int var1, int var2);

        public void sceIoSeek32(int var1, int var2, int var3, int var4);

        public void sceIoSeek64(long var1, int var3, long var4, int var6);

        public void sceIoMkdir(int var1, int var2, String var3, int var4);

        public void sceIoRmdir(int var1, int var2, String var3);

        public void sceIoChdir(int var1, int var2, String var3);

        public void sceIoDopen(int var1, int var2, String var3);

        public void sceIoDread(int var1, int var2, int var3);

        public void sceIoDclose(int var1, int var2);

        public void sceIoDevctl(int var1, int var2, String var3, int var4, int var5, int var6, int var7, int var8);

        public void sceIoIoctl(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public void sceIoAssign(int var1, int var2, String var3, int var4, String var5, int var6, String var7, int var8, int var9, int var10);

        public void sceIoGetStat(int var1, int var2, String var3, int var4);

        public void sceIoRemove(int var1, int var2, String var3);

        public void sceIoChstat(int var1, int var2, String var3, int var4, int var5);

        public void sceIoRename(int var1, int var2, String var3, int var4, String var5);
    }

    private static class PatternFilter
    implements FilenameFilter {
        private Pattern pattern;

        public PatternFilter(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.pattern.matcher(name).matches();
        }
    }

    public class IoDirInfo {
        final String path;
        final String[] filenames;
        int position;
        int printableposition;
        final int id;

        public IoDirInfo(String path, String[] filenames) {
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            this.path = path;
            this.filenames = filenames;
            this.position = 0;
            this.printableposition = 0;
            if (filenames != null) {
                if (filenames.length > this.position && filenames[this.position].equals(".")) {
                    ++this.position;
                }
                if (filenames.length > this.position && filenames[this.position].equals("\u0001")) {
                    ++this.position;
                }
            }
            this.id = IoFileMgrForUser.getNewId();
            IoFileMgrForUser.this.dirIds.put(this.id, this);
        }

        public boolean hasNext() {
            return this.position < this.filenames.length;
        }

        public String next() {
            String filename = null;
            if (this.position < this.filenames.length) {
                filename = this.filenames[this.position];
                ++this.position;
                ++this.printableposition;
            }
            return filename;
        }

        public IoDirInfo close() {
            IoDirInfo info = IoFileMgrForUser.this.dirIds.remove(this.id);
            if (info != null) {
                IoFileMgrForUser.releaseId(this.id);
            }
            return info;
        }
    }

    public class IoInfo {
        public final int flags;
        public final int permissions;
        public final String filename;
        public final SeekableRandomFile msFile;
        public SeekableDataInput readOnlyFile;
        public final String mode;
        public long position;
        public boolean sectorBlockMode;
        public final int id;
        public final int uid;
        public long result;
        public boolean closePending = false;
        public boolean asyncPending;
        public long asyncDoneMillis;
        public int asyncThreadPriority = IoFileMgrForUser.access$000(IoFileMgrForUser.this);
        public SceKernelThreadInfo asyncThread;
        public IAction asyncAction;
        public int cbid = -1;
        public int notifyArg = 0;

        public IoInfo(String filename, SeekableRandomFile f, String mode, int flags, int permissions) {
            this.filename = filename;
            this.msFile = f;
            this.readOnlyFile = f;
            this.mode = mode;
            this.flags = flags;
            this.permissions = permissions;
            this.sectorBlockMode = false;
            this.id = IoFileMgrForUser.getNewId();
            if (this.isValidId()) {
                this.uid = IoFileMgrForUser.getNewUid();
                IoFileMgrForUser.this.fileIds.put(this.id, this);
                IoFileMgrForUser.this.fileUids.put(this.uid, this);
            } else {
                this.uid = -1;
            }
        }

        public IoInfo(String filename, SeekableDataInput f, String mode, int flags, int permissions) {
            this.filename = filename;
            this.msFile = null;
            this.readOnlyFile = f;
            this.mode = mode;
            this.flags = flags;
            this.permissions = permissions;
            this.sectorBlockMode = false;
            this.id = IoFileMgrForUser.getNewId();
            if (this.isValidId()) {
                this.uid = IoFileMgrForUser.getNewUid();
                IoFileMgrForUser.this.fileIds.put(this.id, this);
                IoFileMgrForUser.this.fileUids.put(this.uid, this);
            } else {
                this.uid = -1;
            }
        }

        public boolean isValidId() {
            return this.id != Integer.MIN_VALUE;
        }

        public boolean isUmdFile() {
            return this.msFile == null;
        }

        public int getAsyncRestMillis() {
            long now = Emulator.getClock().currentTimeMillis();
            if (now >= this.asyncDoneMillis) {
                return 0;
            }
            return (int)(this.asyncDoneMillis - now);
        }

        public void truncate(int length) {
            try {
                if (this.msFile != null) {
                    this.msFile.setLength(length);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public IoInfo close() {
            IoInfo info = IoFileMgrForUser.this.fileIds.remove(this.id);
            if (info != null) {
                IoFileMgrForUser.this.fileUids.remove(this.uid);
                IoFileMgrForUser.releaseId(this.id);
                IoFileMgrForUser.releaseUid(this.uid);
            }
            return info;
        }
    }

    protected static enum IoOperation {
        open(5),
        close(1),
        seek,
        ioctl(2),
        remove,
        rename,
        mkdir,
        read(4, 65536),
        write(5, 65536);

        private int delayMillis;
        private int sizeUnit;

        private IoOperation() {
            this.delayMillis = 0;
        }

        private IoOperation(int delayMillis) {
            this.delayMillis = delayMillis;
            this.sizeUnit = 0;
        }

        private IoOperation(int delayMillis, int sizeUnit) {
            this.delayMillis = delayMillis;
            this.sizeUnit = sizeUnit;
        }

        int getDelayMillis() {
            return this.delayMillis;
        }

        int getDelayMillis(int size) {
            if (this.sizeUnit == 0 || size <= 0) {
                return this.getDelayMillis();
            }
            return (int)((long)this.delayMillis * (long)size / (long)this.sizeUnit);
        }
    }
}

