/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.SceKernelLMOption;
import jpcsp.HLE.kernel.types.SceKernelModuleInfo;
import jpcsp.HLE.kernel.types.SceKernelSMOption;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.HLEModuleManager;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Loader;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ModuleMgrForUser
extends HLEModule {
    protected static Logger log = Modules.getLogger("ModuleMgrForUser");
    public static final int loadHLEModuleDelay = 1000;

    @Override
    public String getName() {
        return "ModuleMgrForUser";
    }

    private String extractHLEModuleName(String path) {
        String result = "UNKNOWN";
        String sectorString = path.substring(path.indexOf("sce_lbn") + 7, path.indexOf("_size"));
        int PRXStartSector = (int)Utilities.parseHexLong(sectorString);
        try {
            byte[] buffer = Modules.IoFileMgrForUserModule.getIsoReader().readSector(PRXStartSector);
            String libName = new String(buffer);
            int indexSce = libName.indexOf("sce");
            int indexSpace = libName.indexOf(" ");
            if (indexSce >= 0 && indexSpace > indexSce) {
                String module = libName.substring(indexSce, indexSpace);
                if (module.startsWith("sceFont")) {
                    result = "libfont";
                } else if (module.startsWith("sceMpeg")) {
                    result = "mpeg";
                } else if (module.startsWith("sceSAScore")) {
                    result = "sc_sascore";
                } else if (module.startsWith("sceATRAC3plus")) {
                    result = "libatrac3plus";
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return result;
    }

    private boolean loadHLEModule(Processor processor, String name, String prxname) {
        CpuState cpu = processor.cpu;
        HLEModuleManager moduleManager = HLEModuleManager.getInstance();
        if (moduleManager.hasFlash0Module(prxname)) {
            log.info("hleKernelLoadModule(path='" + name + "') HLE module loaded");
            cpu.gpr[2] = moduleManager.LoadFlash0Module(prxname);
            return true;
        }
        for (bannedModulesList bannedModuleName : bannedModulesList.values()) {
            if (!bannedModuleName.name().equalsIgnoreCase(prxname.toString())) continue;
            log.warn("IGNORED:hleKernelLoadModule(path='" + name + "'): module from banlist not loaded");
            cpu.gpr[2] = moduleManager.LoadFlash0Module(prxname.toString());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hleKernelLoadHLEModule(Processor processor, String name, StringBuilder prxname) {
        CpuState cpu = processor.cpu;
        HLEModuleManager moduleManager = HLEModuleManager.getInstance();
        if (prxname == null) {
            prxname = new StringBuilder();
        }
        int findprx = name.lastIndexOf("/");
        int endprx = name.toLowerCase().indexOf(".prx");
        if (endprx >= 0) {
            prxname.append(name.substring(findprx + 1, endprx));
        } else if (name.contains("sce_lbn")) {
            prxname.append(this.extractHLEModuleName(name));
        } else {
            prxname.append("UNKNOWN");
        }
        if (name.startsWith("flash0:")) {
            log.warn("IGNORED:hleKernelLoadModule(path='" + name + "'): module from flash0 not loaded");
            cpu.gpr[2] = moduleManager.LoadFlash0Module(prxname.toString());
            return true;
        }
        if (this.loadHLEModule(processor, name, prxname.toString())) {
            return true;
        }
        SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(name, 1);
        if (moduleInput != null) {
            int sceHeaderLength = 64;
            byte[] header = new byte[164];
            try {
                moduleInput.readFully(header);
                ByteBuffer f = ByteBuffer.wrap(header);
                int sceMagic = Utilities.readWord(f);
                if (sceMagic == 1162040190) {
                    f.position(64);
                    int pspMagic = Utilities.readWord(f);
                    if (pspMagic == 1347637374) {
                        f.position(f.position() + 6);
                        String libName = Utilities.readStringZ(f);
                        if (libName != null && libName.length() > 0 && this.loadHLEModule(processor, name, libName)) {
                            prxname.setLength(0);
                            prxname.append(libName);
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    moduleInput.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    public void hleKernelLoadModule(Processor processor, String name, int flags, int uid, boolean byUid) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        StringBuilder prxname = new StringBuilder();
        if (this.hleKernelLoadHLEModule(processor, name, prxname)) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(1000, false);
            return;
        }
        try {
            SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(name, flags);
            if (moduleInput != null) {
                SysMemUserForUser.SysMemInfo testInfo;
                UmdIsoFile umdIsoFile;
                String realFileName;
                if (moduleInput instanceof UmdIsoFile && (realFileName = (umdIsoFile = (UmdIsoFile)moduleInput).getName()) != null && !name.endsWith(realFileName) && this.hleKernelLoadHLEModule(processor, realFileName, null)) {
                    moduleInput.close();
                    return;
                }
                byte[] moduleBytes = new byte[(int)moduleInput.length()];
                moduleInput.readFully(moduleBytes);
                ByteBuffer moduleBuffer = ByteBuffer.wrap(moduleBytes);
                int partitionId = 2;
                boolean allocType = false;
                int moduleHeaderSize = 256;
                SceModule testModule = Loader.getInstance().LoadModule(name, moduleBuffer, 0x8800000, true);
                moduleBuffer.rewind();
                int totalAllocSize = 256 + testModule.loadAddressHigh - testModule.loadAddressLow;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Module '%s' requires %d bytes memory", name, totalAllocSize));
                }
                if ((testInfo = Modules.SysMemUserForUserModule.malloc(2, "ModuleMgr-TestInfo", 0, totalAllocSize, 0)) == null) {
                    log.error(String.format("Failed module allocation of size 0x%08X for '%s' (maxFreeMemSize=0x%08X)", totalAllocSize, name, Modules.SysMemUserForUserModule.maxFreeMemSize()));
                    cpu.gpr[2] = -1;
                    return;
                }
                int testBase = testInfo.addr;
                Modules.SysMemUserForUserModule.free(testInfo);
                SysMemUserForUser.SysMemInfo moduleInfo = Modules.SysMemUserForUserModule.malloc(2, "ModuleMgr", 2, 256, testBase);
                if (moduleInfo == null) {
                    log.error(String.format("Failed module allocation 0x%08X != null for '%s'", testBase, name));
                    cpu.gpr[2] = -1;
                    return;
                }
                if (moduleInfo.addr != testBase) {
                    log.error(String.format("Failed module allocation 0x%08X != 0x%08X for '%s'", testBase, moduleInfo.addr, name));
                    cpu.gpr[2] = -1;
                    return;
                }
                int moduleBase = moduleInfo.addr;
                SceModule module = Loader.getInstance().LoadModule(name, moduleBuffer, moduleBase + 256, false);
                module.load();
                if ((module.fileFormat & 8) == 8 || (module.fileFormat & 0x10) == 16) {
                    log.info("hleKernelLoadModule(path='" + name + "') encrypted module not loaded");
                    SceModule fakeModule = new SceModule(true);
                    fakeModule.addAllocatedMemory(moduleInfo);
                    fakeModule.modname = prxname.toString();
                    fakeModule.write(mem, moduleInfo.addr);
                    Managers.modules.addModule(fakeModule);
                    cpu.gpr[2] = fakeModule.modid;
                } else if ((module.fileFormat & 1) == 1) {
                    module.addAllocatedMemory(moduleInfo);
                    cpu.gpr[2] = module.modid;
                } else {
                    cpu.gpr[2] = -1;
                }
                moduleInput.close();
            } else {
                log.warn("hleKernelLoadModule(path='" + name + "') can't find file");
                cpu.gpr[2] = -2147418110;
            }
        }
        catch (IOException e) {
            log.error("hleKernelLoadModule - Error while loading module " + name + ": " + e.getMessage());
            cpu.gpr[2] = -1;
        }
    }

    protected int getSelfModuleId() {
        return Modules.ThreadManForUserModule.getCurrentThread().moduleid;
    }

    @HLEFunction(nid=-1208719848, version=150)
    public void sceKernelLoadModuleByID(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int uid = cpu.gpr[4];
        int option_addr = cpu.gpr[5];
        String name = Modules.IoFileMgrForUserModule.getFileFilename(uid);
        if (log.isDebugEnabled()) {
            log.debug("sceKernelLoadModuleByID(uid=0x" + Integer.toHexString(uid) + "('" + name + "')" + ",option=0x" + Integer.toHexString(option_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        SceKernelLMOption lmOption = null;
        if (option_addr != 0) {
            lmOption = new SceKernelLMOption();
            lmOption.read(mem, option_addr);
            log.info("sceKernelLoadModule: partition=" + lmOption.mpidText + ", position=" + lmOption.position);
        }
        this.hleKernelLoadModule(processor, name, 0, uid, true);
    }

    @HLEFunction(nid=-1753357434, version=150)
    public void sceKernelLoadModule(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int path_addr = cpu.gpr[4];
        int flags = cpu.gpr[5];
        int option_addr = cpu.gpr[6];
        String name = Utilities.readStringZ(path_addr);
        if (log.isDebugEnabled()) {
            log.debug("sceKernelLoadModule(path='" + name + "',flags=0x" + Integer.toHexString(flags) + ",option=0x" + Integer.toHexString(option_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        SceKernelLMOption lmOption = null;
        if (option_addr != 0) {
            lmOption = new SceKernelLMOption();
            lmOption.read(mem, option_addr);
            log.info("sceKernelLoadModule: partition=" + lmOption.mpidText + ", position=" + lmOption.position);
        }
        this.hleKernelLoadModule(processor, name, flags, 0, false);
    }

    @HLEFunction(nid=1896833461, version=150)
    public void sceKernelLoadModuleMs(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceKernelLoadModuleMs [0x710F61B5]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-114860648, version=150)
    public void sceKernelLoadModuleBufferUsbWlan(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceKernelLoadModuleBufferUsbWlan [0xF9275D98]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1357955564, version=150)
    public void sceKernelStartModule(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int uid = cpu.gpr[4];
        int argsize = cpu.gpr[5];
        int argp_addr = cpu.gpr[6];
        int status_addr = cpu.gpr[7];
        int option_addr = cpu.gpr[8];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelStartModule(uid=0x" + Integer.toHexString(uid) + ", argsize=" + argsize + ", argp=0x" + Integer.toHexString(argp_addr) + ", status=0x" + Integer.toHexString(status_addr) + ", option=0x" + Integer.toHexString(option_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        SceModule sceModule = Managers.modules.getModuleByUID(uid);
        SceKernelSMOption smOption = null;
        if (option_addr != 0) {
            smOption = new SceKernelSMOption();
            smOption.read(mem, option_addr);
        }
        if (sceModule == null) {
            log.warn("sceKernelStartModule - unknown module UID 0x" + Integer.toHexString(uid));
            cpu.gpr[2] = -2147352274;
        } else if (sceModule.isFlashModule) {
            if (HLEModuleManager.getInstance().hasFlash0Module(sceModule.modname)) {
                log.info("IGNORING:sceKernelStartModule HLE module '" + sceModule.modname + "'");
            } else {
                log.warn("IGNORING:sceKernelStartModule flash module '" + sceModule.modname + "'");
            }
            sceModule.start();
            cpu.gpr[2] = sceModule.modid;
        } else {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            int attribute = sceModule.attribute;
            int entryAddr = sceModule.entry_addr;
            if (entryAddr == -1) {
                log.info("sceKernelStartModule - module has no entry point, trying to use module_start_func");
                entryAddr = sceModule.module_start_func;
                attribute = sceModule.module_start_thread_attr;
            }
            if (Memory.isAddressGood(entryAddr)) {
                if (Memory.isAddressGood(status_addr)) {
                    mem.write32(status_addr, 0);
                }
                int priority = 32;
                if (smOption != null && smOption.priority > 0) {
                    priority = smOption.priority;
                } else if (sceModule.module_start_thread_priority > 0) {
                    priority = sceModule.module_start_thread_priority;
                }
                int stackSize = 262144;
                if (smOption != null && smOption.stackSize > 0) {
                    stackSize = smOption.stackSize;
                } else if (sceModule.module_start_thread_stacksize > 0) {
                    stackSize = sceModule.module_start_thread_stacksize;
                }
                if (smOption != null) {
                    attribute = smOption.attribute;
                }
                SceKernelThreadInfo thread = threadMan.hleKernelCreateThread("SceModmgrStart", entryAddr, priority, stackSize, attribute, 0);
                thread.moduleid = sceModule.modid;
                cpu.gpr[2] = sceModule.modid;
                sceModule.start();
                threadMan.hleKernelStartThread(thread, argsize, argp_addr, sceModule.gp_value);
            } else if (entryAddr == 0) {
                Modules.log.info("sceKernelStartModule - no entry address");
                sceModule.start();
                cpu.gpr[2] = sceModule.modid;
            } else {
                Modules.log.warn("sceKernelStartModule - invalid entry address 0x" + Integer.toHexString(entryAddr));
                cpu.gpr[2] = -1;
            }
        }
    }

    @HLEFunction(nid=-771778518, version=150)
    public void sceKernelStopModule(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int uid = cpu.gpr[4];
        int argsize = cpu.gpr[5];
        int argp_addr = cpu.gpr[6];
        int status_addr = cpu.gpr[7];
        int option_addr = cpu.gpr[8];
        log.info("sceKernelStopModule(uid=0x" + Integer.toHexString(uid) + ", argsize=" + argsize + ", argp=0x" + Integer.toHexString(argp_addr) + ", status=0x" + Integer.toHexString(status_addr) + ", option=0x" + Integer.toHexString(option_addr) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        SceModule sceModule = Managers.modules.getModuleByUID(uid);
        if (sceModule == null) {
            log.warn("sceKernelStopModule - unknown module UID 0x" + Integer.toHexString(uid));
            cpu.gpr[2] = -2147352274;
        } else if (sceModule.isFlashModule) {
            if (HLEModuleManager.getInstance().hasFlash0Module(sceModule.modname)) {
                log.info("IGNORING:sceKernelStopModule HLE module '" + sceModule.modname + "'");
            } else {
                log.warn("IGNORING:sceKernelStopModule flash module '" + sceModule.modname + "'");
            }
            sceModule.stop();
            cpu.gpr[2] = 0;
        } else {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            if (Memory.isAddressGood(sceModule.module_stop_func)) {
                if (Memory.isAddressGood(status_addr)) {
                    mem.write32(status_addr, 0);
                }
                SceKernelThreadInfo thread = threadMan.hleKernelCreateThread("SceModmgrStop", sceModule.module_stop_func, sceModule.module_stop_thread_priority, sceModule.module_stop_thread_stacksize, sceModule.module_stop_thread_attr, option_addr);
                thread.moduleid = sceModule.modid;
                cpu.gpr[2] = 0;
                sceModule.stop();
                threadMan.hleKernelStartThread(thread, argsize, argp_addr, sceModule.gp_value);
            } else if (sceModule.module_stop_func == 0) {
                log.info("sceKernelStopModule - module has no stop function");
                sceModule.stop();
                cpu.gpr[2] = sceModule.modid;
            } else if (sceModule.isModuleStopped()) {
                log.warn("sceKernelStopModule - module already stopped");
                cpu.gpr[2] = -2147352267;
            } else {
                log.warn(String.format("sceKernelStopModule - invalid stop function 0x%08X", sceModule.module_stop_func));
                cpu.gpr[2] = -1;
            }
        }
    }

    @HLEFunction(nid=772346282, version=150)
    public void sceKernelUnloadModule(Processor processor) {
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        log.info("sceKernelUnloadModule(uid=" + Integer.toHexString(uid) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        SceModule sceModule = Managers.modules.getModuleByUID(uid);
        if (sceModule == null) {
            log.warn("sceKernelUnloadModule unknown module UID 0x" + Integer.toHexString(uid));
            cpu.gpr[2] = -1;
        } else if (sceModule.isModuleStarted() && !sceModule.isModuleStopped()) {
            log.warn("sceKernelUnloadModule module 0x" + Integer.toHexString(uid) + " is still running!");
            cpu.gpr[2] = -2147352264;
        } else {
            HLEModuleManager.getInstance().UnloadFlash0Module(sceModule);
            cpu.gpr[2] = sceModule.modid;
        }
    }

    @HLEFunction(nid=-696915016, version=150)
    public void sceKernelSelfStopUnloadModule(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int argsize = cpu.gpr[4];
        int argp_addr = cpu.gpr[5];
        int status_addr = cpu.gpr[6];
        int options_addr = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelSelfStopUnloadModule(argsize=" + argsize + ",argp_addr=0x" + Integer.toHexString(argp_addr) + ",status_addr=0x" + Integer.toHexString(status_addr) + ",options_addr=0x" + Integer.toHexString(options_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        SceModule sceModule = Managers.modules.getModuleByUID(this.getSelfModuleId());
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo thread = null;
        if (Memory.isAddressGood(sceModule.module_stop_func)) {
            if (Memory.isAddressGood(status_addr)) {
                mem.write32(status_addr, 0);
            }
            thread = threadMan.hleKernelCreateThread("SceModmgrStop", sceModule.module_stop_func, sceModule.module_stop_thread_priority, sceModule.module_stop_thread_stacksize, sceModule.module_stop_thread_attr, options_addr);
            thread.moduleid = sceModule.modid;
        }
        cpu.gpr[2] = 0;
        sceModule.stop();
        sceModule.unload();
        threadMan.hleKernelExitDeleteThread();
        if (thread != null) {
            threadMan.hleKernelStartThread(thread, argsize, argp_addr, sceModule.gp_value);
        }
    }

    @HLEFunction(nid=-1892812992, version=150)
    public void sceKernelStopUnloadSelfModuleWithStatus(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int exitcode = cpu.gpr[4];
        int argsize = cpu.gpr[5];
        int argp_addr = cpu.gpr[6];
        int status_addr = cpu.gpr[7];
        int options_addr = cpu.gpr[8];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelSelfStopUnloadModule(exitcode=" + exitcode + ",argsize=" + argsize + ",argp_addr=0x" + Integer.toHexString(argp_addr) + ",status_addr=0x" + Integer.toHexString(status_addr) + ",options_addr=0x" + Integer.toHexString(options_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        SceModule sceModule = Managers.modules.getModuleByUID(this.getSelfModuleId());
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo thread = null;
        if (Memory.isAddressGood(sceModule.module_stop_func)) {
            if (Memory.isAddressGood(status_addr)) {
                mem.write32(status_addr, 0);
            }
            thread = threadMan.hleKernelCreateThread("SceModmgrStop", sceModule.module_stop_func, sceModule.module_stop_thread_priority, sceModule.module_stop_thread_stacksize, sceModule.module_stop_thread_attr, options_addr);
            thread.moduleid = sceModule.modid;
            threadMan.getCurrentThread().exitStatus = exitcode;
        }
        cpu.gpr[2] = 0;
        sceModule.stop();
        sceModule.unload();
        threadMan.hleKernelExitDeleteThread();
        if (thread != null) {
            threadMan.hleKernelStartThread(thread, argsize, argp_addr, sceModule.gp_value);
        }
    }

    @HLEFunction(nid=-870500711, version=150)
    public void sceKernelStopUnloadSelfModule(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int argsize = cpu.gpr[4];
        int argp_addr = cpu.gpr[5];
        int status_addr = cpu.gpr[6];
        int options_addr = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelStopUnloadSelfModule(argsize=" + argsize + ",argp_addr=0x" + Integer.toHexString(argp_addr) + ",status_addr=0x" + Integer.toHexString(status_addr) + ",option_addr=0x" + Integer.toHexString(options_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        SceModule sceModule = Managers.modules.getModuleByUID(this.getSelfModuleId());
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo thread = null;
        if (Memory.isAddressGood(sceModule.module_stop_func)) {
            if (Memory.isAddressGood(status_addr)) {
                mem.write32(status_addr, 0);
            }
            thread = threadMan.hleKernelCreateThread("SceModmgrStop", sceModule.module_stop_func, sceModule.module_stop_thread_priority, sceModule.module_stop_thread_stacksize, sceModule.module_stop_thread_attr, options_addr);
            thread.moduleid = sceModule.modid;
        }
        cpu.gpr[2] = 0;
        sceModule.stop();
        sceModule.unload();
        threadMan.hleKernelExitDeleteThread();
        if (thread != null) {
            threadMan.hleKernelStartThread(thread, argsize, argp_addr, sceModule.gp_value);
        }
    }

    @HLEFunction(nid=1682150882, version=150)
    public void sceKernelGetModuleIdList(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceKernelGetModuleIdList [0x644395E2]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1955380953, version=150)
    public void sceKernelQueryModuleInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int uid = cpu.gpr[4];
        int info_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelQueryModuleInfo UID 0x" + Integer.toHexString(uid) + " info " + String.format("0x%08X", info_addr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        SceModule sceModule = Managers.modules.getModuleByUID(uid);
        if (sceModule == null) {
            log.warn("sceKernelQueryModuleInfo unknown module UID 0x" + Integer.toHexString(uid));
            cpu.gpr[2] = -1;
        } else if (!Memory.isAddressGood(info_addr)) {
            log.warn("sceKernelQueryModuleInfo bad info pointer " + String.format("0x%08X", info_addr));
            cpu.gpr[2] = -1;
        } else {
            SceKernelModuleInfo moduleInfo = new SceKernelModuleInfo();
            moduleInfo.copy(sceModule);
            moduleInfo.write(mem, info_addr);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-257793131, version=150)
    public void sceKernelGetModuleId(Processor processor) {
        CpuState cpu = processor.cpu;
        int moduleid = this.getSelfModuleId();
        if (log.isDebugEnabled()) {
            log.debug("sceKernelGetModuleId returning 0x" + Integer.toHexString(moduleid));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = moduleid;
    }

    @HLEFunction(nid=-659082969, version=150)
    public void sceKernelGetModuleIdByAddress(Processor processor) {
        CpuState cpu = processor.cpu;
        int addr = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelGetModuleIdByAddress(addr=0x" + Integer.toHexString(addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        SceModule module = Managers.modules.getModuleByAddress(addr);
        if (module != null) {
            cpu.gpr[2] = module.modid;
        } else {
            log.warn("sceKernelGetModuleIdByAddress(addr=0x" + Integer.toHexString(addr) + ") module not found");
            cpu.gpr[2] = -1;
        }
    }

    static enum bannedModulesList {
        audiocodec,
        sceAudiocodec_Driver,
        videocodec,
        sceVideocodec_Driver,
        mpegbase,
        sceMpegbase_Driver,
        pspnet_adhoc_download,
        pspnet_ap_dialog_dummy,
        sceNetApDialogDummy_Library,
        libparse_uri,
        libparse_http;

    }
}

