/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Debugger.DumpDebugState;
import jpcsp.Emulator;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.TPointer64;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.managers.SystemTimeManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelAlarmInfo;
import jpcsp.HLE.kernel.types.SceKernelCallbackInfo;
import jpcsp.HLE.kernel.types.SceKernelSystemStatus;
import jpcsp.HLE.kernel.types.SceKernelThreadEventHandlerInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceKernelVTimerInfo;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.hardware.Interrupts;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.scheduler.Scheduler;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ThreadManForUser
extends HLEModule {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelThreadInfo> threadMap;
    private HashMap<Integer, SceKernelThreadEventHandlerInfo> threadEventHandlerMap;
    private HashMap<Integer, Integer> threadEventMap;
    private LinkedList<SceKernelThreadInfo> readyThreads;
    private SceKernelThreadInfo currentThread;
    private SceKernelThreadInfo idle0;
    private SceKernelThreadInfo idle1;
    public Statistics statistics;
    private boolean dispatchThreadEnabled;
    private static final int SCE_KERNEL_DISPATCHTHREAD_STATE_DISABLED = 0;
    private static final int SCE_KERNEL_DISPATCHTHREAD_STATE_ENABLED = 1;
    protected static final int THREAD_DELAY_MINIMUM_MICROS = 200;
    protected static final int CALLBACKID_REGISTER = 16;
    protected CallbackManager callbackManager = new CallbackManager();
    protected static final int IDLE_THREAD_ADDRESS = 0x8000000;
    public static final int THREAD_EXIT_HANDLER_ADDRESS = 0x8000020;
    public static final int CALLBACK_EXIT_HANDLER_ADDRESS = 0x8000030;
    public static final int ASYNC_LOOP_ADDRESS = 0x8000040;
    public static final int NET_APCTL_LOOP_ADDRESS = 0x8000060;
    private HashMap<Integer, SceKernelCallbackInfo> callbackMap;
    private boolean USE_THREAD_BANLIST = false;
    private static final boolean LOG_CONTEXT_SWITCHING = true;
    private static final boolean LOG_INSTRUCTIONS = false;
    public boolean exitCalled = false;
    public static final int SCE_KERNEL_TMID_Thread = 1;
    public static final int SCE_KERNEL_TMID_Semaphore = 2;
    public static final int SCE_KERNEL_TMID_EventFlag = 3;
    public static final int SCE_KERNEL_TMID_Mbox = 4;
    public static final int SCE_KERNEL_TMID_Vpl = 5;
    public static final int SCE_KERNEL_TMID_Fpl = 6;
    public static final int SCE_KERNEL_TMID_Mpipe = 7;
    public static final int SCE_KERNEL_TMID_Callback = 8;
    public static final int SCE_KERNEL_TMID_ThreadEventHandler = 9;
    public static final int SCE_KERNEL_TMID_Alarm = 10;
    public static final int SCE_KERNEL_TMID_VTimer = 11;
    public static final int SCE_KERNEL_TMID_Mutex = 12;
    public static final int SCE_KERNEL_TMID_LwMutex = 13;
    public static final int SCE_KERNEL_TMID_SleepThread = 64;
    public static final int SCE_KERNEL_TMID_DelayThread = 65;
    public static final int SCE_KERNEL_TMID_SuspendThread = 66;
    public static final int SCE_KERNEL_TMID_DormantThread = 67;
    protected static final int INTR_NUMBER = 15;
    protected Map<Integer, SceKernelAlarmInfo> alarms;
    protected Map<Integer, SceKernelVTimerInfo> vtimers;
    protected boolean needThreadReschedule;
    protected WaitThreadEndWaitStateChecker waitThreadEndWaitStateChecker;
    protected TimeoutThreadWaitStateChecker timeoutThreadWaitStateChecker;
    private final String[] threadNameBanList = new String[]{"bgm thread", "sgx-psp-freq-thr", "sgx-psp-pcm-th", "ss playthread", "spcbgm", "scemainsamplebgmmp3", "se thread"};

    @Override
    public String getName() {
        return "ThreadManForUser";
    }

    @Override
    public void start() {
        this.threadMap = new HashMap();
        this.threadEventMap = new HashMap();
        this.threadEventHandlerMap = new HashMap();
        this.readyThreads = new LinkedList();
        this.statistics = new Statistics();
        this.callbackMap = new HashMap();
        this.callbackManager.Initialize();
        this.install_idle_threads();
        this.install_thread_exit_handler();
        this.install_callback_exit_handler();
        this.install_async_loop_handler();
        this.install_net_apctl_loop_handler();
        this.alarms = new HashMap<Integer, SceKernelAlarmInfo>();
        this.vtimers = new HashMap<Integer, SceKernelVTimerInfo>();
        this.dispatchThreadEnabled = true;
        this.needThreadReschedule = true;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean.isThreadCpuTimeSupported()) {
            threadMXBean.setThreadCpuTimeEnabled(true);
        }
        this.waitThreadEndWaitStateChecker = new WaitThreadEndWaitStateChecker();
        this.timeoutThreadWaitStateChecker = new TimeoutThreadWaitStateChecker();
        this.setSettingsListener("emu.ignoreaudiothreads", new EnableThreadBanningSettingsListerner());
        super.start();
    }

    @Override
    public void stop() {
        this.alarms = null;
        this.vtimers = null;
        for (SceKernelThreadInfo thread : this.threadMap.values()) {
            this.terminateThread(thread);
        }
        super.stop();
    }

    public Iterator<SceKernelThreadInfo> iterator() {
        return this.threadMap.values().iterator();
    }

    public Iterator<SceKernelThreadInfo> iteratorByPriority() {
        Collection<SceKernelThreadInfo> c = this.threadMap.values();
        LinkedList<SceKernelThreadInfo> list = new LinkedList<SceKernelThreadInfo>(c);
        Collections.sort(list, this.idle0);
        return list.iterator();
    }

    public void Initialise(SceModule module, int entry_addr, int attr, String pspfilename, int moduleid, boolean fromSyscall) {
        int rootStackSize;
        int n = rootStackSize = fromSyscall ? 16384 : 262144;
        if (module != null && module.module_start_thread_stacksize > 0) {
            rootStackSize = module.module_start_thread_stacksize;
        }
        int rootInitPriority = 32;
        if (module != null && module.module_start_thread_priority > 0) {
            rootInitPriority = module.module_start_thread_priority;
        }
        this.currentThread = new SceKernelThreadInfo("root", entry_addr, rootInitPriority, rootStackSize, attr);
        this.currentThread.moduleid = moduleid;
        this.threadMap.put(this.currentThread.uid, this.currentThread);
        if (!this.currentThread.isKernelMode()) {
            this.currentThread.attr |= Integer.MIN_VALUE;
        }
        int len = pspfilename.length();
        int address = this.currentThread.cpuContext.gpr[29];
        Utilities.writeStringZ(Memory.getInstance(), address, pspfilename);
        this.currentThread.cpuContext.gpr[4] = len + 1;
        this.currentThread.cpuContext.gpr[5] = address;
        this.currentThread.status = 2;
        this.currentThread.status = 1;
        this.currentThread.restoreContext();
    }

    private void install_idle_threads() {
        Memory mem = Memory.getInstance();
        int instruction_addiu = 0x24040000;
        int instruction_lui = 1008666624;
        int instruction_jr = 65011720;
        int instruction_syscall = 0xC | (this.getHleFunctionByName("sceKernelDelayThread").getSyscallCode() & 0xFFFFF) << 6;
        SysMemUserForUser.SysMemInfo info = Modules.SysMemUserForUserModule.malloc(1, "ThreadMan-RootMem", 2, 16384, 0x8800000);
        int reservedMem = info.addr;
        mem.write32(0x8000000, instruction_addiu);
        mem.write32(0x8000004, instruction_lui);
        mem.write32(0x8000008, instruction_jr);
        mem.write32(0x800000C, instruction_syscall);
        this.idle0 = new SceKernelThreadInfo("idle0", -2013265920, 127, 0, 4096);
        this.idle0.setSystemStack(reservedMem, 8192);
        this.idle0.reset();
        this.idle0.exitStatus = -2147352156;
        this.threadMap.put(this.idle0.uid, this.idle0);
        this.hleChangeThreadState(this.idle0, 2);
        this.idle1 = new SceKernelThreadInfo("idle1", -2013265920, 127, 0, 4096);
        this.idle1.setSystemStack(reservedMem + 8192, 8192);
        this.idle1.reset();
        this.idle1.exitStatus = -2147352156;
        this.threadMap.put(this.idle1.uid, this.idle1);
        this.hleChangeThreadState(this.idle1, 2);
    }

    private void install_thread_exit_handler() {
        Memory mem = Memory.getInstance();
        int instruction_syscall = 0xC | (this.getHleFunctionByName("hleKernelExitThread").getSyscallCode() & 0xFFFFF) << 6;
        int instruction_jr = 65011720;
        mem.write32(0x8000020, instruction_syscall);
        mem.write32(134217764, instruction_jr);
    }

    private void install_callback_exit_handler() {
        Memory mem = Memory.getInstance();
        int instruction_syscall = 0xC | (this.getHleFunctionByName("hleKernelExitCallback").getSyscallCode() & 0xFFFFF) << 6;
        int instruction_jr = 65011720;
        mem.write32(0x8000030, instruction_syscall);
        mem.write32(134217780, instruction_jr);
    }

    private void install_async_loop_handler() {
        Memory mem = Memory.getInstance();
        int instruction_syscall = 0xC | (this.getHleFunctionByName("hleKernelAsyncLoop").getSyscallCode() & 0xFFFFF) << 6;
        int instruction_b = 268500990;
        int instruction_nop = 0;
        int instruction_jr = 65011720;
        mem.write32(0x8000040, instruction_syscall);
        mem.write32(0x8000044, instruction_b);
        mem.write32(0x8000048, instruction_nop);
        mem.write32(134217804, instruction_jr);
        mem.write32(0x8000050, instruction_nop);
    }

    private void install_net_apctl_loop_handler() {
        Memory mem = Memory.getInstance();
        int instruction_syscall = 0xC | (this.getHleFunctionByName("hleKernelNetApctlLoop").getSyscallCode() & 0xFFFFF) << 6;
        int instruction_b = 268500990;
        int instruction_nop = 0;
        int instruction_jr = 65011720;
        mem.write32(0x8000060, instruction_syscall);
        mem.write32(134217828, instruction_b);
        mem.write32(0x8000068, instruction_nop);
        mem.write32(134217836, instruction_jr);
        mem.write32(0x8000070, instruction_nop);
    }

    public void exit() {
        this.exitCalled = true;
        if (this.threadMap != null) {
            this.deleteAllThreads();
            log.info("----------------------------- ThreadMan exit -----------------------------");
        }
    }

    public void step() {
        if (this.currentThread != null) {
            ++this.currentThread.runClocks;
        } else if (!this.exitCalled) {
            log.error("No ready threads!");
        }
    }

    private void internalContextSwitch(SceKernelThreadInfo newThread) {
        if (this.currentThread != null) {
            if (this.currentThread.status == 1) {
                this.hleChangeThreadState(this.currentThread, 2);
            }
            this.currentThread.saveContext();
        }
        if (newThread != null) {
            this.hleChangeThreadState(newThread, 1);
            newThread.restoreContext();
            if (log.isDebugEnabled() && !this.isIdleThread(newThread)) {
                log.debug("---------------------------------------- SceUID=" + Integer.toHexString(newThread.uid) + " name:'" + newThread.name + "'");
            }
        } else if (!this.exitCalled) {
            DumpDebugState.dumpDebugState();
            log.info("No ready threads - pausing emulator. caller:" + this.getCallingFunction());
            Emulator.PauseEmuWithStatus(-1);
        }
        this.currentThread = newThread;
        RuntimeContext.update();
    }

    private boolean contextSwitch(SceKernelThreadInfo newThread) {
        if (IntrManager.getInstance().isInsideInterrupt()) {
            if (log.isDebugEnabled()) {
                log.debug("Inside an interrupt, not context switching to " + newThread);
            }
            return false;
        }
        if (Interrupts.isInterruptsDisabled()) {
            if (log.isDebugEnabled()) {
                log.debug("Interrupts are disabled, not context switching to " + newThread);
            }
            return false;
        }
        if (!this.dispatchThreadEnabled) {
            log.info("DispatchThread disabled, not context switching to " + newThread);
            return false;
        }
        this.internalContextSwitch(newThread);
        this.checkThreadCallbacks(this.currentThread);
        this.executePendingCallbacks(this.currentThread);
        return true;
    }

    private void executePendingCallbacks(SceKernelThreadInfo thread) {
        if (!thread.pendingCallbacks.isEmpty() && RuntimeContext.canExecuteCallback(thread)) {
            Callback callback = thread.pendingCallbacks.poll();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Executing pending callback '%s' for thread '%s'", callback, thread));
            }
            callback.execute(thread);
        }
    }

    public void checkPendingCallbacks() {
        this.executePendingCallbacks(this.currentThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SceKernelThreadInfo nextThread() {
        SceKernelThreadInfo found = null;
        LinkedList<SceKernelThreadInfo> linkedList = this.readyThreads;
        synchronized (linkedList) {
            for (SceKernelThreadInfo thread : this.readyThreads) {
                if (found != null && thread.currentPriority >= found.currentPriority) continue;
                found = thread;
            }
        }
        return found;
    }

    public void hleRescheduleCurrentThread() {
        if (this.needThreadReschedule) {
            SceKernelThreadInfo newThread = this.nextThread();
            if (newThread != null && (this.currentThread == null || this.currentThread.status != 1 || this.currentThread.currentPriority > newThread.currentPriority)) {
                if (Modules.log.isDebugEnabled()) {
                    log.debug("Context switching to '" + newThread + "' after reschedule");
                }
                if (this.contextSwitch(newThread)) {
                    this.needThreadReschedule = false;
                }
            } else {
                this.needThreadReschedule = false;
            }
        }
    }

    public void hleRescheduleCurrentThread(boolean doCallbacks) {
        SceKernelThreadInfo thread = this.currentThread;
        if (doCallbacks) {
            if (thread != null) {
                thread.doCallbacks = doCallbacks;
            }
            this.checkCallbacks();
        }
        this.hleRescheduleCurrentThread();
        if (this.currentThread == thread && doCallbacks && thread.isRunning()) {
            thread.doCallbacks = false;
        }
    }

    public int getCurrentThreadID() {
        if (this.currentThread == null) {
            return -1;
        }
        return this.currentThread.uid;
    }

    public SceKernelThreadInfo getCurrentThread() {
        return this.currentThread;
    }

    public boolean isIdleThread(SceKernelThreadInfo thread) {
        return thread == this.idle0 || thread == this.idle1;
    }

    public boolean isKernelMode() {
        return this.currentThread.isKernelMode();
    }

    public String getThreadName(int uid) {
        SceKernelThreadInfo thread = this.threadMap.get(uid);
        if (thread == null) {
            return "NOT A THREAD";
        }
        return thread.name;
    }

    public boolean isThreadBlocked(SceKernelThreadInfo thread) {
        return thread.isWaitingForType(258);
    }

    public boolean isDispatchThreadEnabled() {
        return this.dispatchThreadEnabled;
    }

    public void hleBlockCurrentThread() {
        this.hleBlockCurrentThread(null);
    }

    public void hleKernelThreadEnterWaitState(int waitType, int waitId, IWaitStateChecker waitStateChecker, int timeoutAddr, boolean callbacks) {
        int micros = 0;
        boolean forever = true;
        if (Memory.isAddressGood(timeoutAddr)) {
            micros = Memory.getInstance().read32(timeoutAddr);
            forever = false;
        }
        this.hleKernelThreadEnterWaitState(this.currentThread, waitType, waitId, waitStateChecker, micros, forever, callbacks);
    }

    public void hleKernelThreadEnterWaitState(int waitType, int waitId, IWaitStateChecker waitStateChecker, boolean callbacks) {
        this.hleKernelThreadEnterWaitState(this.currentThread, waitType, waitId, waitStateChecker, 0, true, callbacks);
    }

    public void hleKernelThreadEnterWaitState(SceKernelThreadInfo thread, int waitType, int waitId, IWaitStateChecker waitStateChecker, int micros, boolean forever, boolean callbacks) {
        thread.waitType = waitType;
        thread.waitId = waitId;
        thread.wait.waitStateChecker = waitStateChecker;
        this.hleKernelThreadWait(thread, micros, forever);
        this.hleChangeThreadState(thread, 4);
        this.hleRescheduleCurrentThread(callbacks);
    }

    private void hleBlockThread(SceKernelThreadInfo thread, boolean doCallbacks, IAction onUnblockAction, IWaitStateChecker waitStateChecker) {
        if (!thread.isWaiting()) {
            thread.doCallbacks = doCallbacks;
            thread.wait.onUnblockAction = onUnblockAction;
            thread.waitType = 258;
            thread.waitId = 0;
            thread.wait.waitStateChecker = waitStateChecker;
            this.hleChangeThreadState(thread, thread.isSuspended() ? 12 : 4);
        }
    }

    public void hleBlockCurrentThread(boolean doCallbacks, IAction onUnblockAction, IWaitStateChecker waitStateChecker) {
        if (Modules.log.isDebugEnabled()) {
            log.debug("-------------------- block SceUID=" + Integer.toHexString(this.currentThread.uid) + " name:'" + this.currentThread.name + "' caller:" + this.getCallingFunction());
        }
        this.hleBlockThread(this.currentThread, doCallbacks, onUnblockAction, waitStateChecker);
        this.hleRescheduleCurrentThread(doCallbacks);
    }

    public void hleBlockCurrentThread(IAction onUnblockAction) {
        this.hleBlockCurrentThread(false, onUnblockAction, null);
    }

    public void hleBlockCurrentThread(IAction onUnblockAction, IWaitStateChecker waitStateChecker) {
        this.hleBlockCurrentThread(false, onUnblockAction, waitStateChecker);
    }

    public void hleBlockCurrentThreadCB(IAction onUnblockAction, IWaitStateChecker waitStateChecker) {
        this.hleBlockCurrentThread(true, onUnblockAction, waitStateChecker);
    }

    public SceKernelThreadInfo getThreadById(int uid) {
        return this.threadMap.get(uid);
    }

    public SceKernelThreadInfo getThreadByName(String name) {
        for (SceKernelThreadInfo thread : this.threadMap.values()) {
            if (!name.equals(thread.name)) continue;
            return thread;
        }
        return null;
    }

    public void hleUnblockThread(int uid) {
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-thread", false)) {
            SceKernelThreadInfo thread = this.threadMap.get(uid);
            this.hleChangeThreadState(thread, 2);
            if (thread != null && Modules.log.isDebugEnabled()) {
                log.debug("-------------------- unblock SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' caller:" + this.getCallingFunction());
            }
        }
    }

    private String getCallingFunction() {
        String msg = "";
        StackTraceElement[] lines = new Exception().getStackTrace();
        if (lines.length >= 3) {
            msg = lines[2].toString();
            msg = msg.substring(0, msg.indexOf("("));
            String[] parts = msg.split("\\.");
            msg = "'" + parts[parts.length - 2] + "." + parts[parts.length - 1] + "'";
        } else {
            StackTraceElement e;
            String line;
            StackTraceElement[] arr$ = lines;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(line = (e = arr$[i$]).toString()).startsWith("jpcsp.Allegrex") && !line.startsWith("jpcsp.Processor"); ++i$) {
                msg = msg + "\n" + line;
            }
        }
        return msg;
    }

    public void hleThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (thread.waitType != 0) {
            this.onWaitTimeout(thread);
            this.hleChangeThreadState(thread, 2);
        }
    }

    private void onWaitTimeout(SceKernelThreadInfo thread) {
        switch (thread.waitType) {
            case 9: {
                thread.cpuContext.gpr[2] = -2147352152;
                break;
            }
            case 4: {
                Managers.eventFlags.onThreadWaitTimeout(thread);
                break;
            }
            case 3: {
                Managers.semas.onThreadWaitTimeout(thread);
                break;
            }
            case 257: {
                Modules.sceUmdUserModule.onThreadWaitTimeout(thread);
                break;
            }
            case 12: {
                Managers.mutex.onThreadWaitTimeout(thread);
                break;
            }
            case 13: {
                Managers.lwmutex.onThreadWaitTimeout(thread);
                break;
            }
            case 8: {
                Managers.msgPipes.onThreadWaitTimeout(thread);
                break;
            }
            case 5: {
                Managers.mbx.onThreadWaitTimeout(thread);
                break;
            }
            case 7: {
                Managers.fpl.onThreadWaitTimeout(thread);
                break;
            }
            case 6: {
                Managers.vpl.onThreadWaitTimeout(thread);
            }
        }
    }

    private void hleThreadWaitRelease(SceKernelThreadInfo thread) {
        if (thread.isSuspended()) {
            this.hleChangeThreadState(thread, 8);
        } else if (thread.waitType != 0) {
            this.onWaitReleased(thread);
            this.hleChangeThreadState(thread, 2);
        }
    }

    private void onWaitReleased(SceKernelThreadInfo thread) {
        switch (thread.waitType) {
            case 9: {
                thread.cpuContext.gpr[2] = -2147352150;
                break;
            }
            case 4: {
                Managers.eventFlags.onThreadWaitReleased(thread);
                break;
            }
            case 3: {
                Managers.semas.onThreadWaitReleased(thread);
                break;
            }
            case 257: {
                Modules.sceUmdUserModule.onThreadWaitReleased(thread);
                break;
            }
            case 12: {
                Managers.mutex.onThreadWaitReleased(thread);
                break;
            }
            case 13: {
                Managers.lwmutex.onThreadWaitReleased(thread);
                break;
            }
            case 8: {
                Managers.msgPipes.onThreadWaitReleased(thread);
                break;
            }
            case 5: {
                Managers.mbx.onThreadWaitReleased(thread);
                break;
            }
            case 7: {
                Managers.fpl.onThreadWaitReleased(thread);
                break;
            }
            case 6: {
                Managers.vpl.onThreadWaitReleased(thread);
                break;
            }
            case 258: {
                thread.cpuContext.gpr[2] = -2147352150;
            }
        }
    }

    private void deleteAllThreads() {
        LinkedList<SceKernelThreadInfo> threadsToBeDeleted = new LinkedList<SceKernelThreadInfo>(this.threadMap.values());
        for (SceKernelThreadInfo thread : threadsToBeDeleted) {
            this.hleDeleteThread(thread);
        }
    }

    public void hleDeleteThread(SceKernelThreadInfo thread) {
        if (!this.threadMap.containsKey(thread.uid)) {
            log.debug(String.format("Thread %s already deleted", thread.toString()));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("really deleting thread:'%s'", thread.name));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("thread:'%s' freeing stack 0x%08X", thread.name, thread.getStackAddr()));
        }
        thread.freeStack();
        Managers.eventFlags.onThreadDeleted(thread);
        Managers.semas.onThreadDeleted(thread);
        Managers.mutex.onThreadDeleted(thread);
        Managers.lwmutex.onThreadDeleted(thread);
        Managers.msgPipes.onThreadDeleted(thread);
        Managers.mbx.onThreadDeleted(thread);
        Managers.fpl.onThreadDeleted(thread);
        Managers.vpl.onThreadDeleted(thread);
        Modules.sceUmdUserModule.onThreadDeleted(thread);
        RuntimeContext.onThreadDeleted(thread);
        this.cancelThreadWait(thread);
        this.threadMap.remove(thread.uid);
        SceUidManager.releaseUid(thread.uid, "ThreadMan-thread");
        this.statistics.addThreadStatistics(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromReadyThreads(SceKernelThreadInfo thread) {
        LinkedList<SceKernelThreadInfo> linkedList = this.readyThreads;
        synchronized (linkedList) {
            this.readyThreads.remove(thread);
            this.needThreadReschedule = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToReadyThreads(SceKernelThreadInfo thread, boolean addFirst) {
        LinkedList<SceKernelThreadInfo> linkedList = this.readyThreads;
        synchronized (linkedList) {
            if (addFirst) {
                this.readyThreads.addFirst(thread);
            } else {
                this.readyThreads.addLast(thread);
            }
            this.needThreadReschedule = true;
        }
    }

    private void setToBeDeletedThread(SceKernelThreadInfo thread) {
        thread.doDelete = true;
        if (thread.isStopped() && thread.doDeleteAction == null) {
            thread.doDeleteAction = new DeleteThreadAction(thread);
            Scheduler.getInstance().addAction(thread.doDeleteAction);
        }
    }

    private void triggerThreadEvent(SceKernelThreadInfo thread, SceKernelThreadInfo contextThread, int event) {
        int handlerUid;
        SceKernelThreadEventHandlerInfo handler;
        if (this.threadEventMap.containsKey(thread.uid) && (handler = this.threadEventHandlerMap.get(handlerUid = this.threadEventMap.get(thread.uid).intValue())).hasEventMask(event)) {
            handler.triggerThreadEventHandler(contextThread, event);
        }
    }

    public void hleKernelChangeThreadPriority(SceKernelThreadInfo thread, int newPriority) {
        if (thread == null) {
            return;
        }
        int oldPriority = thread.currentPriority;
        thread.currentPriority = newPriority;
        if ((thread.status & 2) == 2 && newPriority < this.currentThread.currentPriority) {
            if (log.isDebugEnabled()) {
                log.debug("hleKernelChangeThreadPriority yielding to thread with higher priority");
            }
            this.needThreadReschedule = true;
            this.hleRescheduleCurrentThread();
        } else if ((thread.status & 2) == 2 && newPriority == oldPriority) {
            if (log.isDebugEnabled()) {
                log.debug("hleKernelChangeThreadPriority yielding to thread with same priority");
            }
            this.removeFromReadyThreads(thread);
            this.addToReadyThreads(thread, false);
            this.needThreadReschedule = true;
            this.hleRescheduleCurrentThread();
        } else if (thread.uid == this.currentThread.uid && newPriority > oldPriority) {
            if (log.isDebugEnabled()) {
                log.debug("hleKernelChangeThreadPriority rescheduling");
            }
            this.needThreadReschedule = true;
            this.hleRescheduleCurrentThread();
        }
    }

    public void hleChangeThreadState(SceKernelThreadInfo thread, int newStatus) {
        if (thread == null) {
            return;
        }
        if (thread.status == newStatus) {
            return;
        }
        if (!this.dispatchThreadEnabled && thread == this.currentThread && newStatus != 1) {
            log.info("DispatchThread disabled, not changing thread state of " + thread + " to " + newStatus);
            return;
        }
        boolean addReadyThreadsFirst = false;
        if (thread.status == 4 && newStatus != 12) {
            if (thread.wait.waitTimeoutAction != null) {
                Scheduler.getInstance().removeAction(thread.wait.microTimeTimeout, thread.wait.waitTimeoutAction);
                thread.wait.waitTimeoutAction = null;
            }
            if (thread.waitType == 258 && thread.wait.onUnblockAction != null) {
                thread.wait.onUnblockAction.execute();
                thread.wait.onUnblockAction = null;
            }
            thread.doCallbacks = false;
        } else if (thread.isStopped()) {
            if (thread.doDeleteAction != null) {
                Scheduler.getInstance().removeAction(0L, thread.doDeleteAction);
                thread.doDeleteAction = null;
            }
        } else if (thread.isReady()) {
            this.removeFromReadyThreads(thread);
        } else if (thread.isSuspended()) {
            thread.doCallbacks = false;
        } else if (thread.isRunning()) {
            this.needThreadReschedule = true;
            addReadyThreadsFirst = true;
        }
        thread.status = newStatus;
        if (thread.status == 4) {
            if (thread.wait.waitTimeoutAction != null) {
                Scheduler.getInstance().addAction(thread.wait.microTimeTimeout, thread.wait.waitTimeoutAction);
            }
            if (thread.waitType == 0) {
                log.warn("changeThreadState thread '" + thread.name + "' => PSP_THREAD_WAITING. waitType should NOT be PSP_WAIT_NONE. caller:" + this.getCallingFunction());
            }
        } else if (thread.isStopped()) {
            if (thread.name.equals("root") || thread.name.equals("SceModmgrStart") || thread.name.equals("SceKernelModmgrStop")) {
                thread.doDelete = true;
            }
            if (thread.doDelete && thread.doDeleteAction == null) {
                thread.doDeleteAction = new DeleteThreadAction(thread);
                Scheduler.getInstance().addAction(0L, thread.doDeleteAction);
            }
            this.onThreadStopped(thread);
        } else if (thread.isReady()) {
            this.addToReadyThreads(thread, addReadyThreadsFirst);
            thread.waitType = 0;
            thread.wait.waitTimeoutAction = null;
            thread.wait.waitStateChecker = null;
            thread.doCallbacks = false;
        } else if (thread.isRunning() && thread.waitType != 0 && !this.isIdleThread(thread)) {
            log.error("changeThreadState thread '" + thread.name + "' => PSP_THREAD_RUNNING. waitType should be PSP_WAIT_NONE. caller:" + this.getCallingFunction());
        }
    }

    private void cancelThreadWait(SceKernelThreadInfo thread) {
        thread.wait.onUnblockAction = null;
        thread.wait.waitStateChecker = null;
        thread.waitType = 0;
        if (thread.wait.waitTimeoutAction != null) {
            Scheduler.getInstance().removeAction(thread.wait.microTimeTimeout, thread.wait.waitTimeoutAction);
            thread.wait.waitTimeoutAction = null;
        }
    }

    private void terminateThread(SceKernelThreadInfo thread) {
        this.hleChangeThreadState(thread, 16);
        this.cancelThreadWait(thread);
        RuntimeContext.onThreadExit(thread);
        if (thread == this.currentThread) {
            this.hleRescheduleCurrentThread();
        }
    }

    private void onThreadStopped(SceKernelThreadInfo stoppedThread) {
        for (SceKernelThreadInfo thread : this.threadMap.values()) {
            if (!thread.isWaitingForType(9) || thread.wait.ThreadEnd_id != stoppedThread.uid) continue;
            this.hleThreadWaitRelease(thread);
            thread.cpuContext.gpr[2] = stoppedThread.exitStatus;
        }
    }

    public void hleKernelExitCallback() {
        this.hleKernelExitCallback(Emulator.getProcessor());
    }

    @HLEFunction(nid=-1, version=150)
    public void hleKernelExitCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        int callbackId = cpu.gpr[16];
        Callback callback = this.callbackManager.remove(callbackId);
        if (callback != null) {
            if (log.isTraceEnabled()) {
                log.trace("End of callback " + callback);
            }
            cpu.gpr[16] = callback.getSavedIdRegister();
            cpu.gpr[31] = callback.getSavedRa();
            cpu.pc = callback.getSavedPc();
            IAction afterAction = callback.getAfterAction();
            if (afterAction != null) {
                afterAction.execute();
            }
            if (callback.isReturnVoid()) {
                cpu.gpr[2] = callback.getSavedV0();
                cpu.gpr[3] = callback.getSavedV1();
            }
        }
    }

    public void callAddress(int address, IAction afterAction, boolean returnVoid) {
        this.callAddress(null, address, afterAction, returnVoid, null);
    }

    private void callAddress(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid, int[] parameters) {
        if (thread != null) {
            int status = thread.status;
            int waitType = thread.waitType;
            int waitId = thread.waitId;
            ThreadWaitInfo threadWaitInfo = new ThreadWaitInfo();
            threadWaitInfo.copy(thread.wait);
            boolean doCallbacks = thread.doCallbacks;
            thread.waitType = 0;
            afterAction = new AfterCallAction(thread, status, waitType, waitId, threadWaitInfo, doCallbacks, afterAction);
            this.hleChangeThreadState(thread, 2);
        }
        int callbackId = this.callbackManager.getNewCallbackId();
        Callback callback = new Callback(callbackId, address, parameters, afterAction, returnVoid);
        this.callbackManager.addCallback(callback);
        boolean callbackCalled = false;
        if ((thread == null || thread == this.currentThread) && RuntimeContext.canExecuteCallback(thread)) {
            thread = this.currentThread;
            this.hleChangeThreadState(thread, 1);
            callback.execute(thread);
            callbackCalled = true;
        }
        if (!callbackCalled) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Pushing pending callback '%s' for thread '%s'", callback, thread));
            }
            thread.pendingCallbacks.add(callback);
        }
    }

    public void executeCallback(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Execute callback 0x%08X, afterAction=%s, returnVoid=%b", address, afterAction, returnVoid));
        }
        this.callAddress(thread, address, afterAction, returnVoid, null);
    }

    public void executeCallback(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid, int registerA0) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Execute callback 0x%08X($a0=0x%08X), afterAction=%s, returnVoid=%b", address, registerA0, afterAction, returnVoid));
        }
        this.callAddress(thread, address, afterAction, returnVoid, new int[]{registerA0});
    }

    public void executeCallback(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid, int registerA0, int registerA1) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Execute callback 0x%08X($a0=0x%08X, $a1=0x%08X), afterAction=%s, returnVoid=%b", address, registerA0, registerA1, afterAction, returnVoid));
        }
        this.callAddress(thread, address, afterAction, returnVoid, new int[]{registerA0, registerA1});
    }

    public void executeCallback(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid, int registerA0, int registerA1, int registerA2) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Execute callback 0x%08X($a0=0x%08X, $a1=0x%08X, $a2=0x%08X), afterAction=%s, returnVoid=%b", address, registerA0, registerA1, registerA2, afterAction, returnVoid));
        }
        this.callAddress(thread, address, afterAction, returnVoid, new int[]{registerA0, registerA1, registerA2});
    }

    public void executeCallback(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid, int registerA0, int registerA1, int registerA2, int registerA3) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Execute callback 0x%08X($a0=0x%08X, $a1=0x%08X, $a2=0x%08X, $a3=0x%08X), afterAction=%s, returnVoid=%b", address, registerA0, registerA1, registerA2, registerA3, afterAction, returnVoid));
        }
        this.callAddress(thread, address, afterAction, returnVoid, new int[]{registerA0, registerA1, registerA2, registerA3});
    }

    public void executeCallback(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid, int registerA0, int registerA1, int registerA2, int registerA3, int registerT0) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Execute callback 0x%08X($a0=0x%08X, $a1=0x%08X, $a2=0x%08X, $a3=0x%08X, $t0=0x%08X), afterAction=%s, returnVoid=%b", address, registerA0, registerA1, registerA2, registerA3, registerT0, afterAction, returnVoid));
        }
        this.callAddress(thread, address, afterAction, returnVoid, new int[]{registerA0, registerA1, registerA2, registerA3, registerT0});
    }

    @HLEFunction(nid=-1, version=150)
    public void hleKernelExitThread(Processor processor) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Thread exit detected SceUID=%x name='%s' return:0x%08X", this.currentThread.uid, this.currentThread.name, processor.cpu.gpr[2]));
        }
        this.sceKernelExitThread(processor, processor.cpu.gpr[2]);
    }

    public void hleKernelExitDeleteThread() {
        Processor processor = Emulator.getProcessor();
        if (log.isDebugEnabled()) {
            log.debug(String.format("hleKernelExitDeleteThread SceUID=%x name='%s' return:0x%08X", this.currentThread.uid, this.currentThread.name, processor.cpu.gpr[2]));
        }
        this.sceKernelExitDeleteThread(processor, processor.cpu.gpr[2]);
    }

    @HLEFunction(nid=-1, version=150)
    public void hleKernelAsyncLoop(Processor processor) {
        Modules.IoFileMgrForUserModule.hleAsyncThread(processor);
    }

    @HLEFunction(nid=-1, version=150)
    public void hleKernelNetApctlLoop(Processor processor) {
        Modules.sceNetApctlModule.hleNetApctlThread(processor);
    }

    private boolean checkThreadID(int uid) {
        if (uid == 0) {
            log.warn("checkThreadID illegal thread (uid=0) caller:" + this.getCallingFunction());
            Emulator.getProcessor().cpu.gpr[2] = -2147352169;
            return false;
        }
        if (uid < 0) {
            log.warn("checkThreadID not found thread " + Integer.toHexString(uid) + " (uid<0) caller:" + this.getCallingFunction());
            Emulator.getProcessor().cpu.gpr[2] = -2147352168;
            return false;
        }
        SceUidManager.checkUidPurpose(uid, "ThreadMan-thread", true);
        return true;
    }

    public SceKernelThreadInfo hleKernelCreateThread(String name, int entry_addr, int initPriority, int stackSize, int attr, int option_addr) {
        if (option_addr != 0) {
            Modules.log.warn("hleKernelCreateThread unhandled SceKernelThreadOptParam: option_addr=0x" + Integer.toHexString(option_addr));
        }
        SceKernelThreadInfo thread = new SceKernelThreadInfo(name, entry_addr, initPriority, stackSize, attr);
        this.threadMap.put(thread.uid, thread);
        if (this.currentThread != null) {
            thread.moduleid = this.currentThread.moduleid;
        }
        if (log.isDebugEnabled()) {
            log.debug("hleKernelCreateThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' PC=" + Integer.toHexString(thread.cpuContext.pc) + " attr:0x" + Integer.toHexString(attr) + " pri:0x" + Integer.toHexString(initPriority) + " stackSize:0x" + Integer.toHexString(stackSize));
        }
        return thread;
    }

    private void setThreadBanningEnabled(boolean enabled) {
        this.USE_THREAD_BANLIST = enabled;
        log.info("Audio threads disabled: " + this.USE_THREAD_BANLIST);
    }

    private boolean isBannedThread(SceKernelThreadInfo thread) {
        if (this.USE_THREAD_BANLIST) {
            String name = thread.name.toLowerCase();
            if (name.contains("snd") || name.contains("sound") || name.contains("at3") || name.contains("atrac") || name.contains("sas") || name.contains("wave") || name.contains("audio") || name.contains("mpeg") || name.contains("fmod") || name.contains("mp3")) {
                return true;
            }
            for (String threadName : this.threadNameBanList) {
                if (!name.equals(threadName)) continue;
                return true;
            }
        }
        return false;
    }

    public void hleKernelStartThread(SceKernelThreadInfo thread, int userDataLength, int userDataAddr, int gp) {
        if (log.isDebugEnabled()) {
            log.debug("hleKernelStartThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' dataLen=0x" + Integer.toHexString(userDataLength) + " data=0x" + Integer.toHexString(userDataAddr) + " gp=0x" + Integer.toHexString(gp));
        }
        thread.reset();
        int address = thread.getStackAddr() + thread.stackSize - 256 - (userDataLength + 15 & 0xFFFFFFF0);
        if (userDataAddr == 0) {
            thread.cpuContext.gpr[4] = 0;
            thread.cpuContext.gpr[5] = 0;
        } else {
            Memory.getInstance().memcpy(address, userDataAddr, userDataLength);
            thread.cpuContext.gpr[4] = userDataLength;
            thread.cpuContext.gpr[5] = address;
        }
        thread.cpuContext.gpr[29] = address - 64;
        if (log.isDebugEnabled() && thread.cpuContext.gpr[28] != gp) {
            log.debug("hleKernelStartThread oldGP=0x" + Integer.toHexString(thread.cpuContext.gpr[28]) + " newGP=0x" + Integer.toHexString(gp));
        }
        thread.cpuContext.gpr[28] = gp;
        this.hleChangeThreadState(thread, 2);
        if (thread.currentPriority < this.currentThread.currentPriority) {
            if (log.isDebugEnabled()) {
                log.debug("hleKernelStartThread switching in thread immediately");
            }
            this.hleRescheduleCurrentThread();
        }
    }

    public void hleKernelSleepThread(boolean doCallbacks) {
        if (this.currentThread.wakeupCount > 0) {
            --this.currentThread.wakeupCount;
            Emulator.getProcessor().cpu.gpr[2] = 0;
        } else {
            this.currentThread.waitType = 1;
            this.hleKernelThreadWait(this.currentThread, 0, true);
            this.hleChangeThreadState(this.currentThread, 4);
            Emulator.getProcessor().cpu.gpr[2] = 0;
            this.hleRescheduleCurrentThread(doCallbacks);
        }
    }

    public void hleKernelWakeupThread(SceKernelThreadInfo thread) {
        if (!thread.isWaiting() || thread.waitType != 1) {
            ++thread.wakeupCount;
            if (log.isDebugEnabled()) {
                log.debug("sceKernelWakeupThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' not sleeping/waiting (status=0x" + Integer.toHexString(thread.status) + "), incrementing wakeupCount to " + thread.wakeupCount);
            }
        } else if (this.isBannedThread(thread)) {
            log.warn("sceKernelWakeupThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' banned, not waking up");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("sceKernelWakeupThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "'");
            }
            this.hleThreadWaitRelease(thread);
            this.hleRescheduleCurrentThread();
        }
    }

    private void hleKernelWaitThreadEnd(int uid, int timeoutAddr, boolean callbacks) {
        SceKernelThreadInfo thread;
        if (!this.checkThreadID(uid)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("hleKernelWaitThreadEnd SceUID=0x%X, callbacks=%b", uid, callbacks));
        }
        if ((thread = this.threadMap.get(uid)) == null) {
            log.warn(String.format("hleKernelWaitThreadEnd unknown thread 0x%X", uid));
            Emulator.getProcessor().cpu.gpr[2] = -2147352168;
        } else if (this.isBannedThread(thread)) {
            log.warn(String.format("hleKernelWaitThreadEnd %s banned, not waiting", thread.toString()));
            Emulator.getProcessor().cpu.gpr[2] = 0;
            this.hleRescheduleCurrentThread();
        } else if (thread.isStopped()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("hleKernelWaitThreadEnd %s thread already stopped, not waiting", thread.toString()));
            }
            Emulator.getProcessor().cpu.gpr[2] = 0;
            this.hleRescheduleCurrentThread();
        } else {
            this.currentThread.wait.ThreadEnd_id = uid;
            this.hleKernelThreadEnterWaitState(9, uid, this.waitThreadEndWaitStateChecker, timeoutAddr, callbacks);
        }
    }

    public void hleKernelThreadWait(SceKernelThreadInfo thread, int micros, boolean forever) {
        thread.wait.forever = forever;
        thread.wait.micros = micros;
        if (forever) {
            thread.wait.microTimeTimeout = 0L;
            thread.wait.waitTimeoutAction = null;
        } else {
            long longMicros = (long)micros & 0xFFFFFFFFL;
            thread.wait.microTimeTimeout = Emulator.getClock().microTime() + longMicros;
            thread.wait.waitTimeoutAction = new TimeoutThreadAction(thread);
            thread.wait.waitStateChecker = this.timeoutThreadWaitStateChecker;
        }
        if (Modules.log.isDebugEnabled() && !this.isIdleThread(thread)) {
            log.debug("-------------------- hleKernelThreadWait micros=" + micros + " forever:" + forever + " thread:'" + thread.name + "' caller:" + this.getCallingFunction());
        }
    }

    public void hleKernelDelayThread(int micros, boolean doCallbacks) {
        this.currentThread.waitType = 2;
        if (micros < 200) {
            micros = 200;
        }
        if (log.isDebugEnabled()) {
            log.debug("hleKernelDelayThread micros=" + micros + ", callbacks=" + doCallbacks);
        }
        this.hleKernelThreadWait(this.currentThread, micros, false);
        this.hleChangeThreadState(this.currentThread, 4);
        this.hleRescheduleCurrentThread(doCallbacks);
    }

    public SceKernelCallbackInfo hleKernelCreateCallback(String name, int func_addr, int user_arg_addr) {
        SceKernelCallbackInfo callback = new SceKernelCallbackInfo(name, this.currentThread.uid, func_addr, user_arg_addr);
        if (log.isDebugEnabled()) {
            log.debug(String.format("hleKernelCreateCallback %s", callback));
        }
        this.callbackMap.put(callback.uid, callback);
        return callback;
    }

    public boolean hleKernelDeleteCallback(int uid) {
        boolean removed;
        SceKernelCallbackInfo info = this.callbackMap.remove(uid);
        boolean bl = removed = info != null;
        if (removed) {
            if (log.isDebugEnabled()) {
                log.debug("hleKernelDeleteCallback SceUID=" + Integer.toHexString(uid) + " name:'" + info.name + "'");
            }
        } else {
            log.warn("hleKernelDeleteCallback not a callback uid 0x" + Integer.toHexString(uid));
        }
        return removed;
    }

    protected int getThreadCurrentStackSize(Processor processor) {
        int size = processor.cpu.gpr[29] - this.currentThread.getStackAddr();
        if (size < 0) {
            size = 0;
        }
        return size;
    }

    private boolean userCurrentThreadTryingToSwitchToKernelMode(int newAttr) {
        return this.currentThread.isUserMode() && !SceKernelThreadInfo.isUserMode(newAttr);
    }

    private boolean userThreadCalledKernelCurrentThread(SceKernelThreadInfo thread) {
        return !this.isIdleThread(thread) && (!thread.isKernelMode() || this.currentThread.isKernelMode());
    }

    private int getDispatchThreadState() {
        return this.dispatchThreadEnabled ? 1 : 0;
    }

    public boolean hleKernelRegisterCallback(int callbackType, int cbid) {
        SceKernelCallbackInfo callback = this.callbackMap.get(cbid);
        if (callback == null) {
            log.warn("hleKernelRegisterCallback(type=" + callbackType + ") unknown uid " + Integer.toHexString(cbid));
            return false;
        }
        SceKernelThreadInfo thread = this.getThreadById(callback.threadId);
        if (thread == null) {
            log.warn("hleKernelRegisterCallback(type=" + callbackType + ") unknown thread uid " + Integer.toHexString(callback.threadId));
            return false;
        }
        SceKernelThreadInfo.RegisteredCallbacks registeredCallbacks = thread.getRegisteredCallbacks(callbackType);
        return registeredCallbacks.addCallback(callback);
    }

    public SceKernelCallbackInfo hleKernelUnRegisterCallback(int callbackType, int cbid) {
        SceKernelCallbackInfo callback = null;
        for (SceKernelThreadInfo thread : this.threadMap.values()) {
            SceKernelThreadInfo.RegisteredCallbacks registeredCallbacks = thread.getRegisteredCallbacks(callbackType);
            callback = registeredCallbacks.getCallbackByUid(cbid);
            if (callback == null) continue;
            if (registeredCallbacks.isCallbackReady(callback)) {
                log.warn("hleKernelUnRegisterCallback(type=" + callbackType + ") removing pending callback");
            }
            registeredCallbacks.removeCallback(callback);
            break;
        }
        if (callback == null) {
            log.warn("hleKernelUnRegisterCallback(type=" + callbackType + ") cbid=" + Integer.toHexString(cbid) + " no matching callbacks found");
        }
        return callback;
    }

    public void hleKernelNotifyCallback(int callbackType, int notifyArg) {
        this.hleKernelNotifyCallback(callbackType, -1, notifyArg);
    }

    private void notifyCallback(SceKernelThreadInfo thread, SceKernelCallbackInfo callback, int callbackType, int notifyArg) {
        if (callback.notifyCount != 0) {
            log.warn("hleKernelNotifyCallback(type=" + callbackType + ") thread:'" + thread.name + "' overwriting previous notifyArg 0x" + Integer.toHexString(callback.notifyArg) + " -> 0x" + Integer.toHexString(notifyArg) + ", newCount=" + (callback.notifyCount + 1));
        }
        ++callback.notifyCount;
        callback.notifyArg = notifyArg;
        thread.getRegisteredCallbacks(callbackType).setCallbackReady(callback);
    }

    public void hleKernelNotifyCallback(int callbackType, int cbid, int notifyArg) {
        boolean pushed = false;
        for (SceKernelThreadInfo thread : this.threadMap.values()) {
            SceKernelThreadInfo.RegisteredCallbacks registeredCallbacks = thread.getRegisteredCallbacks(callbackType);
            if (!registeredCallbacks.hasCallbacks()) continue;
            if (cbid != -1) {
                SceKernelCallbackInfo callback = registeredCallbacks.getCallbackByUid(cbid);
                if (callback == null) continue;
                this.notifyCallback(thread, callback, callbackType, notifyArg);
            } else {
                int numberOfCallbacks = registeredCallbacks.getNumberOfCallbacks();
                for (int i = 0; i < numberOfCallbacks; ++i) {
                    SceKernelCallbackInfo callback = registeredCallbacks.getCallbackByIndex(i);
                    this.notifyCallback(thread, callback, callbackType, notifyArg);
                }
            }
            pushed = true;
        }
        if (pushed) {
            if (log.isDebugEnabled()) {
                log.debug("hleKernelNotifyCallback(type=" + callbackType + ") calling checkCallbacks");
            }
            this.checkCallbacks();
        } else if (log.isDebugEnabled()) {
            log.debug(String.format("hleKernelNotifyCallback(type=%d) no registered callbacks to push", callbackType));
        }
    }

    private boolean checkThreadCallbacks(SceKernelThreadInfo thread) {
        boolean handled = false;
        if (thread == null || !thread.doCallbacks) {
            return handled;
        }
        for (int callbackType = 0; callbackType < 7; ++callbackType) {
            SceKernelThreadInfo.RegisteredCallbacks registeredCallbacks = thread.getRegisteredCallbacks(callbackType);
            SceKernelCallbackInfo callback = registeredCallbacks.getNextReadyCallback();
            if (callback == null) continue;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Entering callback type %d %s for thread %s (current thread is %s)", callbackType, callback.toString(), thread.toString(), this.currentThread.toString()));
            }
            callback.startContext(thread, null);
            handled = true;
            break;
        }
        return handled;
    }

    public void cancelAlarm(SceKernelAlarmInfo sceKernelAlarmInfo) {
        Scheduler.getInstance().removeAction(sceKernelAlarmInfo.schedule, sceKernelAlarmInfo.alarmInterruptAction);
        sceKernelAlarmInfo.schedule = 0L;
    }

    public void rescheduleAlarm(SceKernelAlarmInfo sceKernelAlarmInfo, int delay) {
        if (delay < 0) {
            delay = 100;
        }
        sceKernelAlarmInfo.schedule += (long)delay;
        this.scheduleAlarm(sceKernelAlarmInfo);
        if (log.isDebugEnabled()) {
            log.debug(String.format("New Schedule for Alarm uid=%x: %d", sceKernelAlarmInfo.uid, sceKernelAlarmInfo.schedule));
        }
    }

    private void scheduleAlarm(SceKernelAlarmInfo sceKernelAlarmInfo) {
        Scheduler.getInstance().addAction(sceKernelAlarmInfo.schedule, sceKernelAlarmInfo.alarmInterruptAction);
    }

    protected void hleKernelSetAlarm(Processor processor, long delayUsec, int handlerAddress, int handlerArgument) {
        CpuState cpu = processor.cpu;
        long now = Scheduler.getNow();
        long schedule = now + delayUsec;
        SceKernelAlarmInfo sceKernelAlarmInfo = new SceKernelAlarmInfo(schedule, handlerAddress, handlerArgument);
        this.alarms.put(sceKernelAlarmInfo.uid, sceKernelAlarmInfo);
        this.scheduleAlarm(sceKernelAlarmInfo);
        cpu.gpr[2] = sceKernelAlarmInfo.uid;
    }

    protected long getSystemTime() {
        return SystemTimeManager.getSystemTime();
    }

    protected long getVTimerRunningTime(SceKernelVTimerInfo sceKernelVTimerInfo) {
        if (sceKernelVTimerInfo.active != 1) {
            return 0L;
        }
        return this.getSystemTime() - sceKernelVTimerInfo.base;
    }

    public long getVTimerTime(SceKernelVTimerInfo sceKernelVTimerInfo) {
        return sceKernelVTimerInfo.current + this.getVTimerRunningTime(sceKernelVTimerInfo);
    }

    protected long getVTimerScheduleForScheduler(SceKernelVTimerInfo sceKernelVTimerInfo) {
        return sceKernelVTimerInfo.base + sceKernelVTimerInfo.schedule;
    }

    protected void setVTimer(SceKernelVTimerInfo sceKernelVTimerInfo, long time) {
        sceKernelVTimerInfo.current = time - this.getVTimerRunningTime(sceKernelVTimerInfo);
    }

    protected void startVTimer(SceKernelVTimerInfo sceKernelVTimerInfo) {
        sceKernelVTimerInfo.active = 1;
        sceKernelVTimerInfo.base = this.getSystemTime();
        if (sceKernelVTimerInfo.schedule != 0L && sceKernelVTimerInfo.handlerAddress != 0) {
            this.scheduleVTimer(sceKernelVTimerInfo, sceKernelVTimerInfo.schedule);
        }
    }

    protected void stopVTimer(SceKernelVTimerInfo sceKernelVTimerInfo) {
        sceKernelVTimerInfo.active = 0;
        sceKernelVTimerInfo.current += this.getVTimerRunningTime(sceKernelVTimerInfo);
    }

    protected void scheduleVTimer(SceKernelVTimerInfo sceKernelVTimerInfo, long schedule) {
        sceKernelVTimerInfo.schedule = schedule;
        if (sceKernelVTimerInfo.active == 1) {
            Scheduler scheduler = Scheduler.getInstance();
            scheduler.addAction(this.getVTimerScheduleForScheduler(sceKernelVTimerInfo), sceKernelVTimerInfo.vtimerInterruptAction);
        }
    }

    public void cancelVTimer(SceKernelVTimerInfo sceKernelVTimerInfo) {
        Scheduler.getInstance().removeAction(this.getVTimerScheduleForScheduler(sceKernelVTimerInfo), sceKernelVTimerInfo.vtimerInterruptAction);
        sceKernelVTimerInfo.schedule = 0L;
        sceKernelVTimerInfo.handlerAddress = 0;
        sceKernelVTimerInfo.handlerArgument = 0;
    }

    public void rescheduleVTimer(SceKernelVTimerInfo sceKernelVTimerInfo, int delay) {
        if (delay < 0) {
            delay = 100;
        }
        sceKernelVTimerInfo.schedule += (long)delay;
        this.scheduleVTimer(sceKernelVTimerInfo, sceKernelVTimerInfo.schedule);
        if (log.isDebugEnabled()) {
            log.debug(String.format("New Schedule for VTimer uid=%x: %d", sceKernelVTimerInfo.uid, sceKernelVTimerInfo.schedule));
        }
    }

    public void checkCallbacks() {
        boolean handled;
        if (log.isTraceEnabled()) {
            log.trace("checkCallbacks current thread is '" + this.currentThread.name + "' doCallbacks:" + this.currentThread.doCallbacks + " caller:" + this.getCallingFunction());
        }
        SceKernelThreadInfo checkCurrentThread = this.currentThread;
        block0: do {
            handled = false;
            for (SceKernelThreadInfo thread : this.threadMap.values()) {
                if (!thread.doCallbacks || !this.checkThreadCallbacks(thread)) continue;
                handled = true;
                continue block0;
            }
        } while (handled && checkCurrentThread == this.currentThread);
    }

    @HLEFunction(nid=1855890256, version=150)
    public void _sceKernelReturnFromCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented _sceKernelReturnFromCallback");
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=202403411, version=150, checkInsideInterrupt=true)
    public void sceKernelRegisterThreadEventHandler(Processor processor) {
        CpuState cpu = processor.cpu;
        int name_addr = cpu.gpr[4];
        int thid = cpu.gpr[5];
        int mask = cpu.gpr[6];
        int handler_func = cpu.gpr[7];
        int common_addr = cpu.gpr[8];
        String name = Utilities.readStringNZ(name_addr, 32);
        if (log.isDebugEnabled()) {
            log.debug("sceKernelRegisterThreadEventHandler name=" + name + ", thid=0x" + Integer.toHexString(thid) + ", mask=0x" + Integer.toHexString(mask) + ", handler_func=0x" + Integer.toHexString(handler_func) + ", common_addr=0x" + Integer.toHexString(common_addr));
        }
        if (this.threadMap.containsKey(thid)) {
            SceKernelThreadEventHandlerInfo handler = new SceKernelThreadEventHandlerInfo(name, thid, mask, handler_func, common_addr);
            this.threadEventHandlerMap.put(handler.uid, handler);
            this.threadEventMap.put(thid, handler.uid);
            cpu.gpr[2] = handler.uid;
        } else {
            SceKernelThreadEventHandlerInfo handler = new SceKernelThreadEventHandlerInfo(name, thid, mask, handler_func, common_addr);
            if (thid == 0) {
                this.threadEventHandlerMap.put(handler.uid, handler);
                this.threadEventMap.put(this.getCurrentThread().uid, handler.uid);
                cpu.gpr[2] = handler.uid;
            } else if (thid == -16) {
                this.threadEventHandlerMap.put(handler.uid, handler);
                for (SceKernelThreadInfo thread : this.threadMap.values()) {
                    if (!thread.isUserMode()) continue;
                    this.threadEventMap.put(thread.uid, handler.uid);
                }
                cpu.gpr[2] = handler.uid;
            } else if (thid == -8 && this.isKernelMode()) {
                this.threadEventHandlerMap.put(handler.uid, handler);
                for (SceKernelThreadInfo thread : this.threadMap.values()) {
                    if (!thread.isKernelMode()) continue;
                    this.threadEventMap.put(thread.uid, handler.uid);
                }
                cpu.gpr[2] = handler.uid;
            } else if (thid == -1 && this.isKernelMode()) {
                this.threadEventHandlerMap.put(handler.uid, handler);
                for (SceKernelThreadInfo thread : this.threadMap.values()) {
                    this.threadEventMap.put(thread.uid, handler.uid);
                }
                cpu.gpr[2] = handler.uid;
            } else {
                cpu.gpr[2] = -2147352168;
            }
        }
    }

    @HLEFunction(nid=1928577349, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelReleaseThreadEventHandler(Processor processor) {
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelReleaseThreadEventHandler uid=0x" + Integer.toHexString(uid));
        }
        if (this.threadEventHandlerMap.containsKey(uid)) {
            SceKernelThreadEventHandlerInfo handler = this.threadEventHandlerMap.remove(uid);
            handler.release();
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2147352160;
        }
    }

    @HLEFunction(nid=916384619, version=150)
    public void sceKernelReferThreadEventHandlerStatus(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int uid = cpu.gpr[4];
        int status_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelReferThreadEventHandlerStatus uid=0x" + Integer.toHexString(uid) + ", status_addr=0x" + Integer.toHexString(status_addr));
        }
        if (this.threadEventHandlerMap.containsKey(uid)) {
            this.threadEventHandlerMap.get(uid).write(mem, status_addr);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2147352160;
        }
    }

    @HLEFunction(nid=-400773233, version=150, checkInsideInterrupt=true)
    public void sceKernelCreateCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        int name_addr = cpu.gpr[4];
        int func_addr = cpu.gpr[5];
        int user_arg_addr = cpu.gpr[6];
        String name = Utilities.readStringNZ(name_addr, 32);
        SceKernelCallbackInfo callback = this.hleKernelCreateCallback(name, func_addr, user_arg_addr);
        cpu.gpr[2] = callback.uid;
    }

    @HLEFunction(nid=-306554812, version=150, checkInsideInterrupt=true)
    public void sceKernelDeleteCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        cpu.gpr[2] = this.hleKernelDeleteCallback(uid) ? 0 : -2147352159;
    }

    @HLEFunction(nid=-1055151932, version=150)
    public void sceKernelNotifyCallback(Processor processor) {
        SceKernelCallbackInfo callback;
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        int arg = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelNotifyCallback uid=0x" + Integer.toHexString(uid) + ", arg=0x" + Integer.toHexString(arg));
        }
        if ((callback = this.callbackMap.get(uid)) != null) {
            boolean foundCallback = false;
            for (int i = 0; i < 7; ++i) {
                SceKernelThreadInfo.RegisteredCallbacks registeredCallbacks = this.getCurrentThread().getRegisteredCallbacks(i);
                if (!registeredCallbacks.hasCallback(callback)) continue;
                this.hleKernelNotifyCallback(i, uid, arg);
                foundCallback = true;
                break;
            }
            if (!foundCallback && this.hleKernelRegisterCallback(6, uid)) {
                this.hleKernelNotifyCallback(6, uid, arg);
            }
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2147352159;
        }
    }

    @HLEFunction(nid=-1170189866, version=150)
    public void sceKernelCancelCallback(Processor processor) {
        SceKernelCallbackInfo callback;
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelCancelCallback uid=0x" + Integer.toHexString(uid));
        }
        if ((callback = this.callbackMap.get(uid)) != null) {
            callback.notifyArg = 0;
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2147352159;
        }
    }

    @HLEFunction(nid=708658431, version=150)
    public void sceKernelGetCallbackCount(Processor processor) {
        SceKernelCallbackInfo callback;
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelGetCallbackCount uid=0x" + Integer.toHexString(uid));
        }
        cpu.gpr[2] = (callback = this.callbackMap.get(uid)) != null ? callback.notifyCount : -2147352159;
    }

    @HLEFunction(nid=882732396, version=150, checkInsideInterrupt=true)
    public void sceKernelCheckCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        if (log.isDebugEnabled()) {
            log.debug("sceKernelCheckCallback(void)");
        }
        SceKernelThreadInfo thread = this.currentThread;
        thread.doCallbacks = true;
        cpu.gpr[2] = this.checkThreadCallbacks(thread) ? 1 : 0;
        thread.doCallbacks = false;
    }

    @HLEFunction(nid=1930352828, version=150)
    public void sceKernelReferCallbackStatus(Processor processor) {
        SceKernelCallbackInfo info;
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int uid = cpu.gpr[4];
        int info_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelReferCallbackStatus SceUID=" + Integer.toHexString(uid) + " info=" + Integer.toHexString(info_addr));
        }
        if ((info = this.callbackMap.get(uid)) == null) {
            log.warn("sceKernelReferCallbackStatus unknown uid 0x" + Integer.toHexString(uid));
            cpu.gpr[2] = -2147352159;
        } else if (!Memory.isAddressGood(info_addr)) {
            log.warn("sceKernelReferCallbackStatus bad info address 0x" + Integer.toHexString(info_addr));
            cpu.gpr[2] = -2147352365;
        } else {
            int size = mem.read32(info_addr);
            if (size == 56) {
                info.write(mem, info_addr);
                cpu.gpr[2] = 0;
            } else {
                log.warn("sceKernelReferCallbackStatus bad info size got " + size + " want " + 56);
                cpu.gpr[2] = -1;
            }
        }
    }

    @HLEFunction(nid=-1697770722, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelSleepThread() {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelSleepThread SceUID=" + Integer.toHexString(this.currentThread.uid) + " name:'" + this.currentThread.name + "'");
        }
        this.hleKernelSleepThread(false);
        return 0;
    }

    @HLEFunction(nid=-2105381008, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelSleepThreadCB() {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelSleepThreadCB SceUID=" + Integer.toHexString(this.currentThread.uid) + " name:'" + this.currentThread.name + "'");
        }
        this.hleKernelSleepThread(true);
        this.checkCallbacks();
        return 0;
    }

    @HLEFunction(nid=-711021265, version=150)
    public void sceKernelWakeupThread(Processor processor) {
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        if (!this.checkThreadID(uid)) {
            return;
        }
        SceKernelThreadInfo thread = this.threadMap.get(uid);
        if (thread == null) {
            log.warn("sceKernelWakeupThread SceUID=" + Integer.toHexString(uid) + " unknown thread");
            cpu.gpr[2] = -2147352168;
        } else {
            cpu.gpr[2] = 0;
            this.hleKernelWakeupThread(thread);
        }
    }

    @HLEFunction(nid=-53498586, version=150)
    public void sceKernelCancelWakeupThread(Processor processor) {
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        if (uid == 0) {
            uid = this.currentThread.uid;
        }
        SceUidManager.checkUidPurpose(uid, "ThreadMan-thread", true);
        SceKernelThreadInfo thread = this.threadMap.get(uid);
        if (thread == null) {
            log.warn("sceKernelCancelWakeupThread SceUID=" + Integer.toHexString(uid) + ") unknown thread");
            cpu.gpr[2] = -2147352168;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("sceKernelCancelWakeupThread SceUID=" + Integer.toHexString(uid) + ") wakeupCount=" + thread.wakeupCount);
            }
            cpu.gpr[2] = thread.wakeupCount;
            thread.wakeupCount = 0;
        }
    }

    @HLEFunction(nid=-1723534561, version=150)
    public void sceKernelSuspendThread(Processor processor) {
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        if (!this.checkThreadID(uid)) {
            return;
        }
        SceKernelThreadInfo thread = this.threadMap.get(uid);
        if (thread == null) {
            log.warn("sceKernelSuspendThread SceUID=" + Integer.toHexString(uid) + " unknown thread");
            cpu.gpr[2] = -2147352168;
        } else if (uid == this.currentThread.uid) {
            log.warn("sceKernelSuspendThread on self is not allowed");
            cpu.gpr[2] = -2147352169;
        } else if (thread.isSuspended()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceKernelSuspendThread thread already suspended: thread=%s", thread.toString()));
            }
            cpu.gpr[2] = -2147352157;
        } else if (thread.isStopped()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceKernelSuspendThread thread already stopped: thread=%s", thread.toString()));
            }
            cpu.gpr[2] = -2147352158;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("sceKernelSuspendThread SceUID=" + Integer.toHexString(uid));
            }
            if (thread.isWaiting()) {
                this.hleChangeThreadState(thread, 12);
            } else {
                this.hleChangeThreadState(thread, 8);
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=1964338831, version=150)
    public void sceKernelResumeThread(Processor processor) {
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        if (!this.checkThreadID(uid)) {
            return;
        }
        SceKernelThreadInfo thread = this.threadMap.get(uid);
        if (thread == null) {
            log.warn("sceKernelResumeThread SceUID=" + Integer.toHexString(uid) + " unknown thread");
            cpu.gpr[2] = -2147352168;
        } else if (!thread.isSuspended()) {
            log.warn("sceKernelResumeThread SceUID=" + Integer.toHexString(uid) + " not suspended (status=" + thread.status + ")");
            cpu.gpr[2] = -2147352155;
        } else if (this.isBannedThread(thread)) {
            log.warn("sceKernelResumeThread SceUID=" + Integer.toHexString(uid) + " name:'" + thread.name + "' banned, not resuming");
            cpu.gpr[2] = 0;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("sceKernelResumeThread SceUID=" + Integer.toHexString(uid) + " name:'" + thread.name + "'");
            }
            if (thread.isWaiting()) {
                this.hleChangeThreadState(thread, 4);
            } else {
                this.hleChangeThreadState(thread, 2);
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=663490037, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelWaitThreadEnd(Processor processor) {
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        int timeout_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelWaitThreadEnd redirecting to hleKernelWaitThreadEnd(callbacks=false)");
        }
        this.hleKernelWaitThreadEnd(uid, timeout_addr, false);
    }

    @HLEFunction(nid=-2079424205, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelWaitThreadEndCB(Processor processor) {
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        int timeout_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceKernelWaitThreadEndCB redirecting to hleKernelWaitThreadEnd(callbacks=true)");
        }
        this.hleKernelWaitThreadEnd(uid, timeout_addr, true);
        this.checkCallbacks();
    }

    @HLEFunction(nid=-827462841, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelDelayThread(Processor processor) {
        CpuState cpu = processor.cpu;
        int micros = cpu.gpr[4];
        this.hleKernelDelayThread(micros, false);
    }

    @HLEFunction(nid=1759157814, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelDelayThreadCB(Processor processor) {
        CpuState cpu = processor.cpu;
        int micros = cpu.gpr[4];
        this.hleKernelDelayThread(micros, true);
    }

    @HLEFunction(nid=-1122878050, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelDelaySysClockThread(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int sysclocks_addr = cpu.gpr[4];
        if (Memory.isAddressGood(sysclocks_addr)) {
            long sysclocks = mem.read64(sysclocks_addr);
            int micros = SystemTimeManager.hleSysClock2USec32(sysclocks);
            this.hleKernelDelayThread(micros, false);
        } else {
            log.warn("sceKernelDelaySysClockThread invalid sysclocks address 0x" + Integer.toHexString(sysclocks_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=293726563, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelDelaySysClockThreadCB(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int sysclocks_addr = cpu.gpr[4];
        if (Memory.isAddressGood(sysclocks_addr)) {
            long sysclocks = mem.read64(sysclocks_addr);
            int micros = SystemTimeManager.hleSysClock2USec32(sysclocks);
            this.hleKernelDelayThread(micros, true);
        } else {
            log.warn("sceKernelDelaySysClockThreadCB invalid sysclocks address 0x" + Integer.toHexString(sysclocks_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-690336863, version=150, checkInsideInterrupt=true)
    public int sceKernelCreateSema(int name_addr, int attr, int initVal, int maxVal, int option) {
        return Managers.semas.sceKernelCreateSema(name_addr, attr, initVal, maxVal, option);
    }

    @HLEFunction(nid=683034780, version=150, checkInsideInterrupt=true)
    public int sceKernelDeleteSema(int semaid) {
        return Managers.semas.sceKernelDeleteSema(semaid);
    }

    @HLEFunction(nid=1062463040, version=150)
    public int sceKernelSignalSema(int semaid, int signal) {
        return Managers.semas.sceKernelSignalSema(semaid, signal);
    }

    @HLEFunction(nid=1312428293, version=150, checkInsideInterrupt=true)
    public int sceKernelWaitSema(int semaid, int signal, int timeout_addr) {
        return Managers.semas.sceKernelWaitSema(semaid, signal, timeout_addr);
    }

    @HLEFunction(nid=1830890412, version=150, checkInsideInterrupt=true)
    public int sceKernelWaitSemaCB(int semaid, int signal, int timeout_addr) {
        return Managers.semas.sceKernelWaitSemaCB(semaid, signal, timeout_addr);
    }

    @HLEFunction(nid=1488058679, version=150)
    public int sceKernelPollSema(int semaid, int signal) {
        return Managers.semas.sceKernelPollSema(semaid, signal);
    }

    @HLEFunction(nid=-1879180894, version=150)
    public int sceKernelCancelSema(int semaid, int newcount, int numWaitThreadAddr) {
        return Managers.semas.sceKernelCancelSema(semaid, newcount, numWaitThreadAddr);
    }

    @HLEFunction(nid=-1133515835, version=150)
    public int sceKernelReferSemaStatus(int semaid, int addr) {
        return Managers.semas.sceKernelReferSemaStatus(semaid, addr);
    }

    @HLEFunction(nid=1438779904, version=150, checkInsideInterrupt=true)
    public int sceKernelCreateEventFlag(int name_addr, int attr, int initPattern, int option) {
        return Managers.eventFlags.sceKernelCreateEventFlag(name_addr, attr, initPattern, option);
    }

    @HLEFunction(nid=-274838416, version=150, checkInsideInterrupt=true)
    public int sceKernelDeleteEventFlag(int uid) {
        return Managers.eventFlags.sceKernelDeleteEventFlag(uid);
    }

    @HLEFunction(nid=531716658, version=150)
    public int sceKernelSetEventFlag(int uid, int bitsToSet) {
        return Managers.eventFlags.sceKernelSetEventFlag(uid, bitsToSet);
    }

    @HLEFunction(nid=-2128394524, version=150)
    public int sceKernelClearEventFlag(int uid, int bitsToKeep) {
        return Managers.eventFlags.sceKernelClearEventFlag(uid, bitsToKeep);
    }

    @HLEFunction(nid=1076875042, version=150, checkInsideInterrupt=true)
    public int sceKernelWaitEventFlag(int uid, int bits, int wait, int outBits_addr, int timeout_addr) {
        return Managers.eventFlags.sceKernelWaitEventFlag(uid, bits, wait, outBits_addr, timeout_addr);
    }

    @HLEFunction(nid=848057450, version=150, checkInsideInterrupt=true)
    public int sceKernelWaitEventFlagCB(int uid, int bits, int wait, int outBits_addr, int timeout_addr) {
        return Managers.eventFlags.sceKernelWaitEventFlagCB(uid, bits, wait, outBits_addr, timeout_addr);
    }

    @HLEFunction(nid=821905648, version=150)
    public int sceKernelPollEventFlag(int uid, int bits, int wait, int outBits_addr) {
        return Managers.eventFlags.sceKernelPollEventFlag(uid, bits, wait, outBits_addr);
    }

    @HLEFunction(nid=-853527918, version=150)
    public int sceKernelCancelEventFlag(int uid, int newPattern, int numWaitThreadAddr) {
        return Managers.eventFlags.sceKernelCancelEventFlag(uid, newPattern, numWaitThreadAddr);
    }

    @HLEFunction(nid=-1502936800, version=150)
    public int sceKernelReferEventFlagStatus(int uid, int addr) {
        return Managers.eventFlags.sceKernelReferEventFlagStatus(uid, addr);
    }

    @HLEFunction(nid=-2128272867, version=150, checkInsideInterrupt=true)
    public void sceKernelCreateMbx(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.mbx.sceKernelCreateMbx(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]);
    }

    @HLEFunction(nid=-2044372262, version=150, checkInsideInterrupt=true)
    public void sceKernelDeleteMbx(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.mbx.sceKernelDeleteMbx(cpu.gpr[4]);
    }

    @HLEFunction(nid=-374143458, version=150)
    public void sceKernelSendMbx(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.mbx.sceKernelSendMbx(cpu.gpr[4], cpu.gpr[5]);
    }

    @HLEFunction(nid=405144948, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelReceiveMbx(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.mbx.sceKernelReceiveMbx(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]);
    }

    @HLEFunction(nid=-208116862, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelReceiveMbxCB(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.mbx.sceKernelReceiveMbxCB(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]);
    }

    @HLEFunction(nid=226586986, version=150)
    public void sceKernelPollMbx(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.mbx.sceKernelPollMbx(cpu.gpr[4], cpu.gpr[5]);
    }

    @HLEFunction(nid=-2016092874, version=150)
    public void sceKernelCancelReceiveMbx(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.mbx.sceKernelCancelReceiveMbx(cpu.gpr[4], cpu.gpr[5]);
    }

    @HLEFunction(nid=-1461139386, version=150)
    public void sceKernelReferMbxStatus(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.mbx.sceKernelReferMbxStatus(cpu.gpr[4], cpu.gpr[5]);
    }

    @HLEFunction(nid=2081276576, version=150, checkInsideInterrupt=true)
    public void sceKernelCreateMsgPipe(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.msgPipes.sceKernelCreateMsgPipe(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7], cpu.gpr[8]);
    }

    @HLEFunction(nid=-256386532, version=150, checkInsideInterrupt=true)
    public void sceKernelDeleteMsgPipe(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.msgPipes.sceKernelDeleteMsgPipe(cpu.gpr[4]);
    }

    @HLEFunction(nid=-2022850643, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelSendMsgPipe(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.msgPipes.sceKernelSendMsgPipe(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7], cpu.gpr[8], cpu.gpr[9]);
    }

    @HLEFunction(nid=2084696770, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelSendMsgPipeCB(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.msgPipes.sceKernelSendMsgPipeCB(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7], cpu.gpr[8], cpu.gpr[9]);
    }

    @HLEFunction(nid=-2008244336, version=150)
    public void sceKernelTrySendMsgPipe(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.msgPipes.sceKernelTrySendMsgPipe(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7], cpu.gpr[8]);
    }

    @HLEFunction(nid=1954716534, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelReceiveMsgPipe(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.msgPipes.sceKernelReceiveMsgPipe(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7], cpu.gpr[8], cpu.gpr[9]);
    }

    @HLEFunction(nid=-67475075, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelReceiveMsgPipeCB(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.msgPipes.sceKernelReceiveMsgPipeCB(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7], cpu.gpr[8], cpu.gpr[9]);
    }

    @HLEFunction(nid=-548271729, version=150)
    public void sceKernelTryReceiveMsgPipe(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.msgPipes.sceKernelTryReceiveMsgPipe(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7], cpu.gpr[8]);
    }

    @HLEFunction(nid=882607693, version=150)
    public void sceKernelCancelMsgPipe(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.msgPipes.sceKernelCancelMsgPipe(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]);
    }

    @HLEFunction(nid=868106276, version=150)
    public void sceKernelReferMsgPipeStatus(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.msgPipes.sceKernelReferMsgPipeStatus(cpu.gpr[4], cpu.gpr[5]);
    }

    @HLEFunction(nid=1455438261, version=150, checkInsideInterrupt=true)
    public void sceKernelCreateVpl(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.vpl.sceKernelCreateVpl(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7], cpu.gpr[8]);
    }

    @HLEFunction(nid=-1984703348, version=150, checkInsideInterrupt=true)
    public void sceKernelDeleteVpl(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.vpl.sceKernelDeleteVpl(cpu.gpr[4]);
    }

    @HLEFunction(nid=-1093503947, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelAllocateVpl(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.vpl.sceKernelAllocateVpl(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7]);
    }

    @HLEFunction(nid=-334862017, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelAllocateVplCB(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.vpl.sceKernelAllocateVplCB(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7]);
    }

    @HLEFunction(nid=-1355360504, version=150)
    public void sceKernelTryAllocateVpl(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.vpl.sceKernelTryAllocateVpl(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]);
    }

    @HLEFunction(nid=-1221137921, version=150, checkInsideInterrupt=true)
    public void sceKernelFreeVpl(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.vpl.sceKernelFreeVpl(cpu.gpr[4], cpu.gpr[5]);
    }

    @HLEFunction(nid=490150794, version=150)
    public void sceKernelCancelVpl(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.vpl.sceKernelCancelVpl(cpu.gpr[4], cpu.gpr[5]);
    }

    @HLEFunction(nid=964756069, version=150)
    public void sceKernelReferVplStatus(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.vpl.sceKernelReferVplStatus(cpu.gpr[4], cpu.gpr[5]);
    }

    @HLEFunction(nid=-1065634704, version=150, checkInsideInterrupt=true)
    public void sceKernelCreateFpl(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.fpl.sceKernelCreateFpl(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7], cpu.gpr[8], cpu.gpr[9]);
    }

    @HLEFunction(nid=-317452064, version=150, checkInsideInterrupt=true)
    public void sceKernelDeleteFpl(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.fpl.sceKernelDeleteFpl(cpu.gpr[4]);
    }

    @HLEFunction(nid=-646321729, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelAllocateFpl(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.fpl.sceKernelAllocateFpl(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]);
    }

    @HLEFunction(nid=-416797514, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelAllocateFplCB(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.fpl.sceKernelAllocateFplCB(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]);
    }

    @HLEFunction(nid=1648027237, version=150)
    public void sceKernelTryAllocateFpl(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.fpl.sceKernelTryAllocateFpl(cpu.gpr[4], cpu.gpr[5]);
    }

    @HLEFunction(nid=-163493263, version=150, checkInsideInterrupt=true)
    public void sceKernelFreeFpl(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.fpl.sceKernelFreeFpl(cpu.gpr[4], cpu.gpr[5]);
    }

    @HLEFunction(nid=-1465231073, version=150)
    public void sceKernelCancelFpl(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.fpl.sceKernelCancelFpl(cpu.gpr[4], cpu.gpr[5]);
    }

    @HLEFunction(nid=-669409716, version=150)
    public void sceKernelReferFplStatus(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.fpl.sceKernelReferFplStatus(cpu.gpr[4], cpu.gpr[5]);
    }

    @HLEFunction(nid=244480749, version=150)
    public void _sceKernelReturnFromTimerHandler(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented _sceKernelReturnFromTimerHandler");
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=286125210, version=150)
    public void sceKernelUSec2SysClock(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.systime.sceKernelUSec2SysClock(cpu.gpr[4], cpu.gpr[5]);
    }

    @HLEFunction(nid=-926083700, version=150)
    public void sceKernelUSec2SysClockWide(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.systime.sceKernelUSec2SysClockWide(cpu.gpr[4]);
    }

    @HLEFunction(nid=-1167355166, version=150)
    public void sceKernelSysClock2USec(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.systime.sceKernelSysClock2USec(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]);
    }

    @HLEFunction(nid=-513696388, version=150)
    public void sceKernelSysClock2USecWide(Processor processor) {
        CpuState cpu = processor.cpu;
        Managers.systime.sceKernelSysClock2USecWide(cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7]);
    }

    @HLEFunction(nid=-613183691, version=150)
    public int sceKernelGetSystemTime(TPointer64 time_addr) {
        return Managers.systime.sceKernelGetSystemTime(time_addr);
    }

    @HLEFunction(nid=-2101586057, version=150)
    public long sceKernelGetSystemTimeWide() {
        return Managers.systime.sceKernelGetSystemTimeWide();
    }

    @HLEFunction(nid=916379037, version=150)
    public int sceKernelGetSystemTimeLow() {
        return Managers.systime.sceKernelGetSystemTimeLow();
    }

    @HLEFunction(nid=1716697290, version=150)
    public void sceKernelSetAlarm(Processor processor) {
        CpuState cpu = processor.cpu;
        int delayUsec = cpu.gpr[4];
        int handlerAddress = cpu.gpr[5];
        int handlerArgument = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelSetAlarm(%d,0x%08X,0x%08X)", delayUsec, handlerAddress, handlerArgument));
        }
        this.hleKernelSetAlarm(processor, delayUsec, handlerAddress, handlerArgument);
    }

    @HLEFunction(nid=-1295888046, version=150)
    public void sceKernelSetSysClockAlarm(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int delaySysclockAddr = cpu.gpr[4];
        int handlerAddress = cpu.gpr[5];
        int handlerArgument = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelSetSysClockAlarm(0x%08X,0x%08X,0x%08X)", delaySysclockAddr, handlerAddress, handlerArgument));
        }
        if (Memory.isAddressGood(delaySysclockAddr)) {
            long delaySysclock = mem.read64(delaySysclockAddr);
            long delayUsec = SystemTimeManager.hleSysClock2USec(delaySysclock);
            this.hleKernelSetAlarm(processor, delayUsec, handlerAddress, handlerArgument);
        } else {
            cpu.gpr[2] = -2147352365;
        }
    }

    @HLEFunction(nid=2120595865, version=150)
    public void sceKernelCancelAlarm(Processor processor) {
        SceKernelAlarmInfo sceKernelAlarmInfo;
        CpuState cpu = processor.cpu;
        int alarmUid = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelCancelAlarm(uid=0x%x)", alarmUid));
        }
        if ((sceKernelAlarmInfo = this.alarms.get(alarmUid)) == null) {
            log.warn(String.format("sceKernelCancelAlarm unknown uid=0x%x", alarmUid));
            cpu.gpr[2] = -2147352161;
        } else {
            this.cancelAlarm(sceKernelAlarmInfo);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-626789020, version=150)
    public void sceKernelReferAlarmStatus(Processor processor) {
        SceKernelAlarmInfo sceKernelAlarmInfo;
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int alarmUid = cpu.gpr[4];
        int infoAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelReferAlarmStatus(uid=0x%x, infoAddr=0x%08X)", alarmUid, infoAddr));
        }
        if ((sceKernelAlarmInfo = this.alarms.get(alarmUid)) == null) {
            log.warn(String.format("sceKernelReferAlarmStatus unknown uid=0x%x", alarmUid));
            cpu.gpr[2] = -2147352161;
        } else if (!Memory.isAddressGood(infoAddr)) {
            cpu.gpr[2] = -2147352365;
        } else {
            int size;
            sceKernelAlarmInfo.size = size = mem.read32(infoAddr);
            sceKernelAlarmInfo.write(mem, infoAddr);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=553645408, version=150, checkInsideInterrupt=true)
    public void sceKernelCreateVTimer(Processor processor) {
        CpuState cpu = processor.cpu;
        int nameAddr = cpu.gpr[4];
        int optAddr = cpu.gpr[5];
        String name = Utilities.readStringZ(nameAddr);
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelCreateVTimer(name=%s(0x%08X), optAddr=0x%08X)", name, nameAddr, optAddr));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = new SceKernelVTimerInfo(name);
        this.vtimers.put(sceKernelVTimerInfo.uid, sceKernelVTimerInfo);
        cpu.gpr[2] = sceKernelVTimerInfo.uid;
    }

    @HLEFunction(nid=848272978, version=150, checkInsideInterrupt=true)
    public void sceKernelDeleteVTimer(Processor processor) {
        SceKernelVTimerInfo sceKernelVTimerInfo;
        CpuState cpu = processor.cpu;
        int vtimerUid = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelDeleteVTimer(uid=0x%x)", vtimerUid));
        }
        if ((sceKernelVTimerInfo = this.vtimers.remove(vtimerUid)) == null) {
            log.warn(String.format("sceKernelDeleteVTimer unknown uid=0x%x", vtimerUid));
            cpu.gpr[2] = -2147352130;
        } else {
            sceKernelVTimerInfo.delete();
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-1280992912, version=150)
    public void sceKernelGetVTimerBase(Processor processor) {
        SceKernelVTimerInfo sceKernelVTimerInfo;
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int vtimerUid = cpu.gpr[4];
        int baseAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelGetVTimerBase(uid=0x%x,baseAddr=0x%08X)", vtimerUid, baseAddr));
        }
        if ((sceKernelVTimerInfo = this.vtimers.get(vtimerUid)) == null) {
            log.warn(String.format("sceKernelGetVTimerBase unknown uid=0x%x", vtimerUid));
            cpu.gpr[2] = -2147352130;
        } else if (!Memory.isAddressGood(baseAddr)) {
            cpu.gpr[2] = -2147352365;
        } else {
            mem.write64(baseAddr, sceKernelVTimerInfo.base);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-1212052617, version=150)
    public void sceKernelGetVTimerBaseWide(Processor processor) {
        SceKernelVTimerInfo sceKernelVTimerInfo;
        CpuState cpu = processor.cpu;
        int vtimerUid = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelGetVTimerBaseWide(uid=0x%x)", vtimerUid));
        }
        if ((sceKernelVTimerInfo = this.vtimers.get(vtimerUid)) == null) {
            log.warn(String.format("sceKernelGetVTimerBaseWide unknown uid=0x%x", vtimerUid));
            cpu.gpr[2] = -2147352130;
        } else {
            Utilities.returnRegister64(cpu, sceKernelVTimerInfo.base);
        }
    }

    @HLEFunction(nid=55218719, version=150)
    public void sceKernelGetVTimerTime(Processor processor) {
        SceKernelVTimerInfo sceKernelVTimerInfo;
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int vtimerUid = cpu.gpr[4];
        int timeAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelGetVTimerTime(uid=0x%x,timeAddr=0x%08X)", vtimerUid, timeAddr));
        }
        if ((sceKernelVTimerInfo = this.vtimers.get(vtimerUid)) == null) {
            log.warn(String.format("sceKernelGetVTimerTime unknown uid=0x%x", vtimerUid));
            cpu.gpr[2] = -2147352130;
        } else if (!Memory.isAddressGood(timeAddr)) {
            cpu.gpr[2] = -2147352365;
        } else {
            long time = this.getVTimerTime(sceKernelVTimerInfo);
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceKernelGetVTimerTime returning %d", time));
            }
            mem.write64(timeAddr, time);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-1061945390, version=150)
    public void sceKernelGetVTimerTimeWide(Processor processor) {
        SceKernelVTimerInfo sceKernelVTimerInfo;
        CpuState cpu = processor.cpu;
        int vtimerUid = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelGetVTimerTimeWide(uid=0x%x)", vtimerUid));
        }
        if ((sceKernelVTimerInfo = this.vtimers.get(vtimerUid)) == null) {
            log.warn(String.format("sceKernelGetVTimerTimeWide unknown uid=0x%x", vtimerUid));
            cpu.gpr[2] = -2147352130;
        } else {
            long time = this.getVTimerTime(sceKernelVTimerInfo);
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceKernelGetVTimerTimeWide returning %d", time));
            }
            Utilities.returnRegister64(cpu, time);
        }
    }

    @HLEFunction(nid=1412093488, version=150, checkInsideInterrupt=true)
    public void sceKernelSetVTimerTime(Processor processor) {
        SceKernelVTimerInfo sceKernelVTimerInfo;
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int vtimerUid = cpu.gpr[4];
        int timeAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelSetVTimerTime(uid=0x%x,timeAddr=0x%08X)", vtimerUid, timeAddr));
        }
        if ((sceKernelVTimerInfo = this.vtimers.get(vtimerUid)) == null) {
            log.warn(String.format("sceKernelSetVTimerTime unknown uid=0x%x", vtimerUid));
            cpu.gpr[2] = -2147352130;
        } else if (!Memory.isAddressGood(timeAddr)) {
            cpu.gpr[2] = -2147352365;
        } else {
            long time = mem.read64(timeAddr);
            this.setVTimer(sceKernelVTimerInfo, time);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-77322813, version=150, checkInsideInterrupt=true)
    public void sceKernelSetVTimerTimeWide(Processor processor) {
        SceKernelVTimerInfo sceKernelVTimerInfo;
        CpuState cpu = processor.cpu;
        int vtimerUid = cpu.gpr[4];
        long time = Utilities.getRegister64(cpu, 6);
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelSetVTimerTime(uid=0x%x,time=0x%016X)", vtimerUid, time));
        }
        if ((sceKernelVTimerInfo = this.vtimers.get(vtimerUid)) == null) {
            log.warn(String.format("sceKernelSetVTimerTime unknown uid=0x%x", vtimerUid));
            cpu.gpr[2] = -2147352130;
        } else {
            this.setVTimer(sceKernelVTimerInfo, time);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-963800009, version=150)
    public void sceKernelStartVTimer(Processor processor) {
        SceKernelVTimerInfo sceKernelVTimerInfo;
        CpuState cpu = processor.cpu;
        int vtimerUid = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelStartVTimer(uid=0x%x)", vtimerUid));
        }
        if ((sceKernelVTimerInfo = this.vtimers.get(vtimerUid)) == null) {
            log.warn(String.format("sceKernelStartVTimer unknown uid=0x%x", vtimerUid));
            cpu.gpr[2] = -2147352130;
        } else if (sceKernelVTimerInfo.active == 1) {
            cpu.gpr[2] = 1;
        } else {
            this.startVTimer(sceKernelVTimerInfo);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-793842041, version=150)
    public void sceKernelStopVTimer(Processor processor) {
        SceKernelVTimerInfo sceKernelVTimerInfo;
        CpuState cpu = processor.cpu;
        int vtimerUid = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelStopVTimer(uid=0x%x)", vtimerUid));
        }
        if ((sceKernelVTimerInfo = this.vtimers.get(vtimerUid)) == null) {
            log.warn(String.format("sceKernelStopVTimer unknown uid=0x%x", vtimerUid));
            cpu.gpr[2] = -2147352130;
        } else if (sceKernelVTimerInfo.active == 0) {
            cpu.gpr[2] = 0;
        } else {
            this.stopVTimer(sceKernelVTimerInfo);
            cpu.gpr[2] = 1;
        }
    }

    @HLEFunction(nid=-659383890, version=150)
    public void sceKernelSetVTimerHandler(Processor processor) {
        SceKernelVTimerInfo sceKernelVTimerInfo;
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int vtimerUid = cpu.gpr[4];
        int scheduleAddr = cpu.gpr[5];
        int handlerAddress = cpu.gpr[6];
        int handlerArgument = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.warn(String.format("sceKernelSetVTimerHandler(uid=0x%x,scheduleAddr=0x%08X,handlerAddress=0x%08X,handlerArgument=0x%08X)", vtimerUid, scheduleAddr, handlerAddress, handlerArgument));
        }
        if ((sceKernelVTimerInfo = this.vtimers.get(vtimerUid)) == null) {
            log.warn(String.format("sceKernelSetVTimerHandler unknown uid=0x%x", vtimerUid));
            cpu.gpr[2] = -2147352130;
        } else if (!Memory.isAddressGood(scheduleAddr)) {
            cpu.gpr[2] = -2147352365;
        } else {
            long schedule = mem.read64(scheduleAddr);
            sceKernelVTimerInfo.handlerAddress = handlerAddress;
            sceKernelVTimerInfo.handlerArgument = handlerArgument;
            if (handlerAddress != 0) {
                this.scheduleVTimer(sceKernelVTimerInfo, schedule);
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=1404047002, version=150)
    public void sceKernelSetVTimerHandlerWide(Processor processor) {
        SceKernelVTimerInfo sceKernelVTimerInfo;
        CpuState cpu = processor.cpu;
        int vtimerUid = cpu.gpr[4];
        long schedule = Utilities.getRegister64(cpu, 6);
        int handlerAddress = cpu.gpr[8];
        int handlerArgument = cpu.gpr[9];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelSetVTimerHandlerWide(uid=0x%x,schedule=0x%016X,handlerAddress=0x%08X,handlerArgument=0x%08X)", vtimerUid, schedule, handlerAddress, handlerArgument));
        }
        if ((sceKernelVTimerInfo = this.vtimers.get(vtimerUid)) == null) {
            log.warn(String.format("sceKernelSetVTimerHandler unknown uid=0x%x", vtimerUid));
            cpu.gpr[2] = -2147352130;
        } else {
            sceKernelVTimerInfo.handlerAddress = handlerAddress;
            sceKernelVTimerInfo.handlerArgument = handlerArgument;
            if (handlerAddress != 0) {
                this.scheduleVTimer(sceKernelVTimerInfo, schedule);
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-757721617, version=150)
    public void sceKernelCancelVTimerHandler(Processor processor) {
        SceKernelVTimerInfo sceKernelVTimerInfo;
        CpuState cpu = processor.cpu;
        int vtimerUid = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelCancelVTimerHandler(uid=0x%x)", vtimerUid));
        }
        if ((sceKernelVTimerInfo = this.vtimers.get(vtimerUid)) == null) {
            log.warn(String.format("sceKernelCancelVTimerHandler unknown uid=0x%x", vtimerUid));
            cpu.gpr[2] = -2147352130;
        } else {
            this.cancelVTimer(sceKernelVTimerInfo);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=1597161130, version=150)
    public void sceKernelReferVTimerStatus(Processor processor) {
        SceKernelVTimerInfo sceKernelVTimerInfo;
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int vtimerUid = cpu.gpr[4];
        int infoAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelReferVTimerStatus(uid=0x%x,infoAddr=0x%08X)", vtimerUid, infoAddr));
        }
        if ((sceKernelVTimerInfo = this.vtimers.get(vtimerUid)) == null) {
            log.warn(String.format("sceKernelReferVTimerStatus unknown uid=0x%x", vtimerUid));
            cpu.gpr[2] = -2147352130;
        } else if (!Memory.isAddressGood(infoAddr)) {
            cpu.gpr[2] = -2147352365;
        } else {
            int size;
            sceKernelVTimerInfo.size = size = mem.read32(infoAddr);
            sceKernelVTimerInfo.write(mem, infoAddr);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=1148030438, version=150)
    public void sceKernelCreateThread(Processor processor) {
        CpuState cpu = processor.cpu;
        int name_addr = cpu.gpr[4];
        int entry_addr = cpu.gpr[5];
        int initPriority = cpu.gpr[6];
        int stackSize = cpu.gpr[7];
        int attr = cpu.gpr[8];
        int option_addr = cpu.gpr[9];
        String name = Utilities.readStringNZ(name_addr, 32);
        if (log.isDebugEnabled()) {
            log.debug("sceKernelCreateThread redirecting to hleKernelCreateThread");
        }
        SceKernelThreadInfo thread = this.hleKernelCreateThread(name, entry_addr, initPriority, stackSize, attr, option_addr);
        if (thread.stackSize > 0 && thread.getStackAddr() == 0) {
            log.warn("sceKernelCreateThread not enough memory to create the stack");
            this.hleDeleteThread(thread);
            cpu.gpr[2] = -2147352176;
        } else {
            if (this.currentThread.isKernelMode() && !SceKernelThreadInfo.isUserMode(thread.attr)) {
                log.debug("sceKernelCreateThread inheriting kernel mode");
                thread.attr |= 0x1000;
            }
            if (this.currentThread.isUserMode()) {
                if (!SceKernelThreadInfo.isUserMode(thread.attr)) {
                    log.debug("sceKernelCreateThread inheriting user mode");
                }
                thread.attr |= Integer.MIN_VALUE;
                thread.attr &= 0xFFFFEFFF;
            }
            cpu.gpr[2] = thread.uid;
            this.triggerThreadEvent(thread, this.currentThread, 1);
        }
    }

    @HLEFunction(nid=-1616888621, version=150, checkInsideInterrupt=true)
    public void sceKernelDeleteThread(Processor processor) {
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        if (uid == 0) {
            uid = this.currentThread.uid;
        }
        if (!this.checkThreadID(uid)) {
            return;
        }
        SceKernelThreadInfo thread = this.threadMap.get(uid);
        if (thread == null) {
            cpu.gpr[2] = -2147352168;
        } else if (!thread.isStopped()) {
            cpu.gpr[2] = -2147352156;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("sceKernelDeleteThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "'");
            }
            this.setToBeDeletedThread(thread);
            cpu.gpr[2] = 0;
            this.triggerThreadEvent(thread, this.currentThread, 8);
        }
    }

    @HLEFunction(nid=-193624995, version=150, checkInsideInterrupt=true)
    public void sceKernelStartThread(Processor processor) {
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        int len = cpu.gpr[5];
        int data_addr = cpu.gpr[6];
        if (!this.checkThreadID(uid)) {
            return;
        }
        SceKernelThreadInfo thread = this.threadMap.get(uid);
        if (thread == null) {
            cpu.gpr[2] = -2147352168;
        } else if (this.isBannedThread(thread)) {
            log.warn("sceKernelStartThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' banned, not starting");
            cpu.gpr[2] = 0;
            this.hleRescheduleCurrentThread();
        } else if (!thread.isStopped()) {
            cpu.gpr[2] = -2147352156;
        } else {
            SceKernelThreadInfo callingThread = this.currentThread;
            log.debug("sceKernelStartThread redirecting to hleKernelStartThread");
            cpu.gpr[2] = 0;
            this.hleKernelStartThread(thread, len, data_addr, thread.gpReg_addr);
            thread.exitStatus = -2147352156;
            this.triggerThreadEvent(thread, callingThread, 2);
        }
    }

    @HLEFunction(nid=1395282478, version=150)
    public void _sceKernelExitThread(Processor processor, int exitStatus) {
        this.sceKernelExitThread(processor, exitStatus);
    }

    @HLEFunction(nid=-1435252427, version=150, checkInsideInterrupt=true)
    public void sceKernelExitThread(Processor processor, int exitStatus) {
        SceKernelThreadInfo thread = this.currentThread;
        if (log.isDebugEnabled()) {
            log.debug("sceKernelExitThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' exitStatus:0x" + Integer.toHexString(exitStatus));
        }
        thread.exitStatus = exitStatus < 0 ? -2147352366 : exitStatus;
        this.triggerThreadEvent(thread, this.currentThread, 4);
        processor.parameterReader.setReturnValueInt(0);
        this.hleChangeThreadState(thread, 16);
        RuntimeContext.onThreadExit(thread);
        this.hleRescheduleCurrentThread();
    }

    @HLEFunction(nid=-2137202021, version=150, checkInsideInterrupt=true)
    public void sceKernelExitDeleteThread(Processor processor, int exitStatus) {
        SceKernelThreadInfo thread = this.currentThread;
        if (log.isDebugEnabled()) {
            log.debug("sceKernelExitDeleteThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' exitStatus:0x" + Integer.toHexString(exitStatus));
        }
        thread.exitStatus = exitStatus;
        this.triggerThreadEvent(thread, this.currentThread, 4);
        this.triggerThreadEvent(thread, this.currentThread, 8);
        processor.parameterReader.setReturnValueInt(0);
        this.hleChangeThreadState(thread, 16);
        RuntimeContext.onThreadExit(thread);
        this.setToBeDeletedThread(thread);
        this.hleRescheduleCurrentThread();
    }

    @HLEFunction(nid=1633944506, version=150)
    public void sceKernelTerminateThread(Processor processor, int uid) {
        if (!this.checkThreadID(uid)) {
            return;
        }
        SceKernelThreadInfo thread = this.getThreadCurrentIsInvalid(uid);
        log.debug("sceKernelTerminateThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "'");
        this.triggerThreadEvent(thread, this.currentThread, 4);
        processor.parameterReader.setReturnValueInt(0);
        this.terminateThread(thread);
        thread.exitStatus = -2147352148;
    }

    @HLEFunction(nid=943684556, version=150, checkInsideInterrupt=true)
    public void sceKernelTerminateDeleteThread(Processor processor, int uid) {
        if (!this.checkThreadID(uid)) {
            return;
        }
        SceKernelThreadInfo thread = this.getThreadCurrentIsInvalid(uid);
        log.debug("sceKernelTerminateDeleteThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "'");
        this.triggerThreadEvent(thread, this.currentThread, 4);
        this.triggerThreadEvent(thread, this.currentThread, 8);
        processor.parameterReader.setReturnValueInt(0);
        this.terminateThread(thread);
        this.setToBeDeletedThread(thread);
    }

    @HLEFunction(nid=987073420, version=150, checkInsideInterrupt=true)
    public int sceKernelSuspendDispatchThread() {
        int state = this.getDispatchThreadState();
        if (log.isDebugEnabled()) {
            log.debug("sceKernelSuspendDispatchThread() state=" + state);
        }
        if (Interrupts.isInterruptsDisabled()) {
            return -2147352474;
        }
        this.dispatchThreadEnabled = false;
        return state;
    }

    @HLEFunction(nid=669134530, version=150, checkInsideInterrupt=true)
    public int sceKernelResumeDispatchThread(int state) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelResumeDispatchThread(state=" + state + ")");
        }
        boolean isInterruptsDisabled = Interrupts.isInterruptsDisabled();
        if (state == 1) {
            this.dispatchThreadEnabled = true;
            this.hleRescheduleCurrentThread();
        }
        if (isInterruptsDisabled) {
            return -2147352474;
        }
        return 0;
    }

    @HLEFunction(nid=-361460175, version=150)
    public int sceKernelChangeCurrentThreadAttr(int removeAttr, int addAttr) {
        int newAttr;
        if (log.isDebugEnabled()) {
            log.debug("sceKernelChangeCurrentThreadAttr removeAttr:0x" + Integer.toHexString(removeAttr) + " addAttr:0x" + Integer.toHexString(addAttr) + " oldAttr:0x" + Integer.toHexString(this.currentThread.attr));
        }
        if (this.userCurrentThreadTryingToSwitchToKernelMode(newAttr = this.currentThread.attr & ~removeAttr | addAttr)) {
            log.debug("sceKernelChangeCurrentThreadAttr forcing user mode");
            newAttr |= Integer.MIN_VALUE;
            newAttr &= 0xFFFFEFFF;
        }
        this.currentThread.attr = newAttr;
        return 0;
    }

    @HLEFunction(nid=1908185201, version=150)
    public void sceKernelChangeThreadPriority(Processor processor, int uid, @CheckArgument(value="checkThreadPriority") int priority) {
        SceUidManager.checkUidPurpose(uid, "ThreadMan-thread", true);
        SceKernelThreadInfo thread = this.getThread(uid);
        if (thread.isStopped()) {
            log.warn("sceKernelChangeThreadPriority SceUID=" + Integer.toHexString(uid) + " newPriority:0x" + Integer.toHexString(priority) + " oldPriority:0x" + Integer.toHexString(thread.currentPriority) + " thread is stopped, ignoring");
            thread.currentPriority = thread.initPriority;
            throw new SceKernelErrorException(-2147352158);
        }
        if (log.isDebugEnabled()) {
            log.debug("sceKernelChangeThreadPriority SceUID=" + Integer.toHexString(uid) + " newPriority:0x" + Integer.toHexString(priority) + " oldPriority:0x" + Integer.toHexString(thread.currentPriority));
        }
        processor.parameterReader.setReturnValueInt(0);
        this.hleKernelChangeThreadPriority(thread, priority);
    }

    public int checkThreadPriority(int priority) {
        if (priority == 0) {
            priority = this.currentThread.currentPriority;
        }
        if (this.currentThread.isUserMode() && (priority < 8 || priority >= 120)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("checkThreadPriority priority:0x%x is outside of valid range in user mode", priority));
            }
            throw new SceKernelErrorException(-2147352173);
        }
        if (this.currentThread.isKernelMode() && (priority < 1 || priority >= 127)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("checkThreadPriority priority:0x%x is outside of valid range in kernel mode", priority));
            }
            throw new SceKernelErrorException(-2147352173);
        }
        return priority;
    }

    protected SceKernelThreadInfo getThreadCurrentIsInvalid(int uid) {
        SceKernelThreadInfo thread = this.getThread(uid);
        if (thread == this.currentThread) {
            throw new SceKernelErrorException(-2147352169);
        }
        return thread;
    }

    protected SceKernelThreadInfo getThread(int uid) {
        if (uid == 0) {
            uid = this.currentThread.uid;
        }
        if (uid < 0) {
            log.warn(ThreadManForUser.getCallingFunctionName(1) + " SceUID=" + Integer.toHexString(uid) + " is invalid");
            throw new SceKernelErrorException(-2147352169);
        }
        SceKernelThreadInfo thread = this.threadMap.get(uid);
        if (thread == null) {
            log.warn(ThreadManForUser.getCallingFunctionName(1) + " unknown uid=0x" + Integer.toHexString(uid));
            throw new SceKernelErrorException(-2147352168);
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEFunction(nid=-1859955545, version=150)
    public int sceKernelRotateThreadReadyQueue(@CheckArgument(value="checkThreadPriority") int priority) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelRotateThreadReadyQueue priority=" + priority);
        }
        LinkedList<SceKernelThreadInfo> linkedList = this.readyThreads;
        synchronized (linkedList) {
            for (SceKernelThreadInfo thread : this.readyThreads) {
                if (thread.currentPriority != priority) continue;
                if (priority == this.currentThread.currentPriority) {
                    thread = this.currentThread;
                    this.hleChangeThreadState(thread, 2);
                }
                this.removeFromReadyThreads(thread);
                this.addToReadyThreads(thread, false);
                this.hleRescheduleCurrentThread();
                break;
            }
        }
        return 0;
    }

    @HLEFunction(nid=741662803, version=150)
    public int sceKernelReleaseWaitThread(int uid) {
        if (uid == 0) {
            throw new SceKernelErrorException(-2147352169);
        }
        SceKernelThreadInfo thread = this.getThread(uid);
        if (thread == this.currentThread) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceKernelReleaseWaitThread(0x%X): can't release itself: %s", uid, thread));
            }
            return -2147352169;
        }
        if (!thread.isWaiting()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceKernelReleaseWaitThread(0x%X): thread not waiting: %s", uid, thread));
            }
            return -2147352154;
        }
        if (thread.waitType >= 256) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceKernelReleaseWaitThread(0x%X): thread waiting in privileged status: waitType=0x%X", uid, thread.waitType));
            }
            return -2147352367;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelReleaseWaitThread(0x%X): releasing waiting thread: %s", uid, thread));
        }
        this.hleThreadWaitRelease(thread);
        this.hleRescheduleCurrentThread();
        return 0;
    }

    @HLEFunction(nid=691750328, version=150, checkInsideInterrupt=true)
    public int sceKernelGetThreadId() {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelGetThreadId returning uid=0x" + Integer.toHexString(this.currentThread.uid));
        }
        return this.currentThread.uid;
    }

    @HLEFunction(nid=-1800773138, version=150, checkInsideInterrupt=true)
    public int sceKernelGetThreadCurrentPriority(Processor processor) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelGetThreadCurrentPriority returning currentPriority=" + this.currentThread.currentPriority);
        }
        return this.currentThread.currentPriority;
    }

    @HLEFunction(nid=991444518, version=150)
    public int sceKernelGetThreadExitStatus(int uid) {
        SceKernelThreadInfo thread = this.getThread(uid);
        if (!thread.isStopped()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceKernelGetThreadExitStatus not stopped uid=0x%x", uid));
            }
            return -2147352156;
        }
        if (log.isDebugEnabled()) {
            log.debug("sceKernelGetThreadExitStatus uid=0x" + Integer.toHexString(uid) + " exitStatus=0x" + Integer.toHexString(thread.exitStatus));
        }
        return thread.exitStatus;
    }

    @HLEFunction(nid=-784605547, version=150, checkInsideInterrupt=true)
    public int sceKernelCheckThreadStack(Processor processor) {
        int size = this.getThreadCurrentStackSize(processor);
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelCheckThreadStack returning size=0x%X", size));
        }
        return size;
    }

    @HLEFunction(nid=1376296097, version=150, checkInsideInterrupt=true)
    public int sceKernelGetThreadStackFreeSize(int uid) {
        SceKernelThreadInfo thread = this.getThread(uid);
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(thread.getStackAddr(), thread.stackSize, 4);
        int unusedStackSize = thread.stackSize;
        for (int i = 0; i < thread.stackSize; i += 4) {
            int stackValue = memoryReader.readNext();
            if (stackValue == -1) continue;
            unusedStackSize = i;
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelGetThreadStackFreeSize returning size=0x%X", unusedStackSize));
        }
        return unusedStackSize;
    }

    @HLEFunction(nid=398551118, version=150)
    public int sceKernelReferThreadStatus(int uid, TPointer ptr) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelReferThreadStatus uid=0x" + Integer.toHexString(uid) + " addr=0x" + Integer.toHexString(ptr.getAddress()));
        }
        SceKernelThreadInfo thread = this.getThread(uid);
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelReferThreadStatus for thread %s", thread.toString()));
        }
        this.getThread(uid).write(ptr.getMemory(), ptr.getAddress());
        return 0;
    }

    @HLEFunction(nid=-3970540, version=150, checkInsideInterrupt=true)
    public int sceKernelReferThreadRunStatus(int uid, TPointer ptr) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelReferThreadRunStatus uid=0x" + Integer.toHexString(uid) + " addr=0x" + Integer.toHexString(ptr.getAddress()));
        }
        this.getThread(uid).writeRunStatus(ptr.getMemory(), ptr.getAddress());
        return 0;
    }

    @HLEFunction(nid=1652453178, version=150)
    public int sceKernelReferSystemStatus(TPointer statusPtr) {
        SceKernelSystemStatus status = new SceKernelSystemStatus();
        status.read(statusPtr.getMemory(), statusPtr.getAddress());
        status.status = 0;
        status.write(statusPtr.getMemory(), statusPtr.getAddress());
        return 0;
    }

    @HLEFunction(nid=-1807654608, version=150, checkInsideInterrupt=true)
    public int sceKernelGetThreadmanIdList(int type, TPointer32 readBufPtr, int readBufSize, TPointer32 idCountPtr) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelGetThreadmanIdList type=" + type + " readbuf:0x" + Integer.toHexString(readBufPtr.getAddress()) + " readbufsize:" + readBufSize + " idcount:0x" + Integer.toHexString(idCountPtr.getAddress()));
        }
        if (type != 1) {
            log.warn("UNIMPLEMENTED:sceKernelGetThreadmanIdList type=" + type);
            idCountPtr.setValue(0);
            return 0;
        }
        int saveCount = 0;
        int fullCount = 0;
        for (SceKernelThreadInfo thread : this.threadMap.values()) {
            if (!this.userThreadCalledKernelCurrentThread(thread)) continue;
            if (saveCount < readBufSize) {
                if (log.isDebugEnabled()) {
                    log.debug("sceKernelGetThreadmanIdList adding thread '" + thread.name + "'");
                }
                readBufPtr.setValue(saveCount << 2, thread.uid);
                ++saveCount;
            } else {
                log.warn("sceKernelGetThreadmanIdList NOT adding thread '" + thread.name + "' (no more space)");
            }
            ++fullCount;
        }
        idCountPtr.setValue(fullCount);
        return 0;
    }

    @HLEFunction(nid=1473209053, version=150)
    public int sceKernelGetThreadmanIdType(int uid) {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelGetThreadmanIdType uid=0x" + uid);
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-thread", false)) {
            return 1;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-sema", false)) {
            return 2;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-eventflag", false)) {
            return 3;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-Mbx", false)) {
            return 4;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-Vpl", false)) {
            return 5;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-Fpl", false)) {
            return 6;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-MsgPipe", false)) {
            return 7;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-callback", false)) {
            return 8;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-ThreadEventHandler", false)) {
            return 9;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-Alarm", false)) {
            return 10;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-VTimer", false)) {
            return 11;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-Mutex", false)) {
            return 12;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-LwMutex", false)) {
            return 13;
        }
        return -2147352366;
    }

    @HLEFunction(nid=1691636750, version=150)
    public int sceKernelReferThreadProfiler() {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelReferThreadProfiler");
        }
        return 0;
    }

    @HLEFunction(nid=-2112310051, version=150)
    public int sceKernelReferGlobalProfiler() {
        if (log.isDebugEnabled()) {
            log.debug("sceKernelReferGlobalProfiler");
        }
        return 0;
    }

    public class WaitThreadEndWaitStateChecker
    implements IWaitStateChecker {
        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelThreadInfo threadEnd = ThreadManForUser.this.getThreadById(wait.ThreadEnd_id);
            if (threadEnd == null) {
                thread.cpuContext.gpr[2] = -2147352168;
                return false;
            }
            if (threadEnd.isStopped()) {
                thread.cpuContext.gpr[2] = threadEnd.exitStatus;
                return false;
            }
            return true;
        }
    }

    public class DeleteThreadAction
    implements IAction {
        private SceKernelThreadInfo thread;

        public DeleteThreadAction(SceKernelThreadInfo thread) {
            this.thread = thread;
        }

        @Override
        public void execute() {
            ThreadManForUser.this.hleDeleteThread(this.thread);
        }
    }

    public class TimeoutThreadWaitStateChecker
    implements IWaitStateChecker {
        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            if (wait.forever) {
                return true;
            }
            if (wait.microTimeTimeout <= Emulator.getClock().microTime()) {
                ThreadManForUser.this.hleThreadWaitTimeout(thread);
                return false;
            }
            if (wait.waitTimeoutAction == null) {
                wait.waitTimeoutAction = new TimeoutThreadAction(thread);
            }
            return true;
        }
    }

    public class TimeoutThreadAction
    implements IAction {
        private SceKernelThreadInfo thread;

        public TimeoutThreadAction(SceKernelThreadInfo thread) {
            this.thread = thread;
        }

        @Override
        public void execute() {
            ThreadManForUser.this.hleThreadWaitTimeout(this.thread);
        }
    }

    private class AfterCallAction
    implements IAction {
        SceKernelThreadInfo thread;
        int status;
        int waitType;
        int waitId;
        ThreadWaitInfo threadWaitInfo;
        boolean doCallback;
        IAction afterAction;

        public AfterCallAction(SceKernelThreadInfo thread, int status, int waitType, int waitId, ThreadWaitInfo threadWaitInfo, boolean doCallback, IAction afterAction) {
            this.thread = thread;
            this.status = status;
            this.waitType = waitType;
            this.waitId = waitId;
            this.threadWaitInfo = threadWaitInfo;
            this.doCallback = doCallback;
            this.afterAction = afterAction;
        }

        @Override
        public void execute() {
            boolean restoreWaitState = true;
            if (this.threadWaitInfo.waitStateChecker != null && !this.threadWaitInfo.waitStateChecker.continueWaitState(this.thread, this.threadWaitInfo)) {
                restoreWaitState = false;
            }
            if (restoreWaitState) {
                if (this.status == 1) {
                    this.doCallback = false;
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("AfterCallAction: restoring wait state for thread '%s' to %s, %s, doCallbacks %b", this.thread.toString(), SceKernelThreadInfo.getStatusName(this.status), SceKernelThreadInfo.getWaitName(this.waitType, this.threadWaitInfo, this.status), this.doCallback));
                }
                this.thread.waitType = this.waitType;
                this.thread.waitId = this.waitId;
                this.thread.wait.copy(this.threadWaitInfo);
                ThreadManForUser.this.hleChangeThreadState(this.thread, this.status);
            } else if (this.thread.status != 2) {
                if (log.isDebugEnabled()) {
                    log.debug("AfterCallAction: set thread to READY state: " + this.thread.toString());
                }
                ThreadManForUser.this.hleChangeThreadState(this.thread, 2);
                this.doCallback = false;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("AfterCallAction: leaving thread in READY state: " + this.thread.toString());
                }
                this.doCallback = false;
            }
            this.thread.doCallbacks = this.doCallback;
            ThreadManForUser.this.hleRescheduleCurrentThread();
            if (this.afterAction != null) {
                this.afterAction.execute();
            }
        }
    }

    public static class Callback {
        private int id;
        private int address;
        private int[] parameters;
        private int savedIdRegister;
        private int savedRa;
        private int savedPc;
        private int savedV0;
        private int savedV1;
        private IAction afterAction;
        private boolean returnVoid;

        public Callback(int id, int address, int[] parameters, IAction afterAction, boolean returnVoid) {
            this.id = id;
            this.address = address;
            this.parameters = parameters;
            this.afterAction = afterAction;
            this.returnVoid = returnVoid;
        }

        public IAction getAfterAction() {
            return this.afterAction;
        }

        public int getId() {
            return this.id;
        }

        public int getSavedIdRegister() {
            return this.savedIdRegister;
        }

        public int getSavedRa() {
            return this.savedRa;
        }

        public int getSavedPc() {
            return this.savedPc;
        }

        public int getSavedV0() {
            return this.savedV0;
        }

        public int getSavedV1() {
            return this.savedV1;
        }

        public boolean isReturnVoid() {
            return this.returnVoid;
        }

        public void execute(SceKernelThreadInfo thread) {
            CpuState cpu = thread.cpuContext;
            this.savedIdRegister = cpu.gpr[16];
            this.savedRa = cpu.gpr[31];
            this.savedPc = cpu.pc;
            this.savedV0 = cpu.gpr[2];
            this.savedV1 = cpu.gpr[3];
            if (this.parameters != null) {
                System.arraycopy(this.parameters, 0, cpu.gpr, 4, this.parameters.length);
            }
            cpu.gpr[16] = this.id;
            cpu.gpr[31] = 0x8000030;
            cpu.pc = this.address;
            RuntimeContext.executeCallback();
        }

        public String toString() {
            return String.format("Callback address=0x%08X,id=%d,returnVoid=%b", this.address, this.getId(), this.isReturnVoid());
        }
    }

    public static class CallbackManager {
        private Map<Integer, Callback> callbacks;
        private int currentCallbackId;

        public void Initialize() {
            this.callbacks = new HashMap<Integer, Callback>();
            this.currentCallbackId = 1;
        }

        public void addCallback(Callback callback) {
            this.callbacks.put(callback.getId(), callback);
        }

        public Callback remove(int id) {
            Callback callback = this.callbacks.remove(id);
            return callback;
        }

        public int getNewCallbackId() {
            return this.currentCallbackId++;
        }
    }

    public static class Statistics {
        private ArrayList<ThreadStatistics> threads = new ArrayList();
        public long allCycles = 0L;
        public long startTimeMillis = System.currentTimeMillis();
        public long endTimeMillis;
        public long allCpuMillis = 0L;

        public void exit() {
            this.endTimeMillis = System.currentTimeMillis();
        }

        public long getDurationMillis() {
            return this.endTimeMillis - this.startTimeMillis;
        }

        private void addThreadStatistics(SceKernelThreadInfo thread) {
        }

        private static class ThreadStatistics
        implements Comparable<ThreadStatistics> {
            public String name;
            public long runClocks;

            private ThreadStatistics() {
            }

            @Override
            public int compareTo(ThreadStatistics o) {
                return -new Long(this.runClocks).compareTo(o.runClocks);
            }

            public String getQuotedName() {
                return "'" + this.name + "'";
            }
        }
    }

    private class EnableThreadBanningSettingsListerner
    extends AbstractBoolSettingsListener {
        private EnableThreadBanningSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            ThreadManForUser.this.setThreadBanningEnabled(value);
        }
    }
}

