/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.security.MessageDigest;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Random;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Clock;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SystemTimeManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.State;
import org.apache.log4j.Logger;

public class UtilsForUser
extends HLEModule {
    private static Logger log = Modules.getLogger("UtilsForUser");
    private HashMap<Integer, SceKernelUtilsMt19937Context> Mt19937List;
    private SceKernelUtilsMd5Context md5Ctx;
    private SceKernelUtilsSha1Context sha1Ctx;
    protected static final int PSP_KERNEL_ICACHE_PROBE_MISS = 0;
    protected static final int PSP_KERNEL_ICACHE_PROBE_HIT = 1;
    protected static final int PSP_KERNEL_DCACHE_PROBE_MISS = 0;
    protected static final int PSP_KERNEL_DCACHE_PROBE_HIT = 1;
    protected static final int PSP_KERNEL_DCACHE_PROBE_HIT_DIRTY = 2;

    @Override
    public String getName() {
        return "UtilsForUser";
    }

    @Override
    public void start() {
        this.Mt19937List = new HashMap();
        super.start();
    }

    @HLEFunction(nid=-1079410590, version=150)
    public void sceKernelDcacheInvalidateRange(Processor processor) {
        CpuState cpu = processor.cpu;
        int addr = cpu.gpr[4];
        int size = cpu.gpr[5];
        if (log.isTraceEnabled()) {
            log.trace(String.format("IGNORING: sceKernelDcacheInvalidateRange addr=0x%08X, size=%d", addr, size));
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1025542386, version=150)
    public void sceKernelIcacheInvalidateRange(Processor processor) {
        CpuState cpu = processor.cpu;
        int addr = cpu.gpr[4];
        int size = cpu.gpr[5];
        if (log.isInfoEnabled()) {
            log.info(String.format("sceKernelIcacheInvalidateRange addr=0x%08X, size=%d", addr, size));
        }
        RuntimeContext.invalidateRange(addr, size);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-937924008, version=150)
    public void sceKernelUtilsMd5Digest(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int inAddr = cpu.gpr[4];
        int inSize = cpu.gpr[5];
        int outAddr = cpu.gpr[6];
        log.info("sceKernelUtilsMd5Digest (inAddr=0x" + Integer.toHexString(inAddr) + ", inSize=" + inSize + ", outAddr=0x" + Integer.toHexString(outAddr) + ")");
        byte[] input = new byte[inSize];
        byte[] hash = null;
        if (Memory.isAddressGood(inAddr)) {
            for (int i = 0; i < inSize; ++i) {
                input[i] = (byte)mem.read8(inAddr + i);
            }
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            hash = md.digest(input);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (hash != null && Memory.isAddressGood(outAddr)) {
            for (int i = 0; i < 16; ++i) {
                mem.write8(outAddr + i, hash[i]);
            }
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1638117242, version=150)
    public void sceKernelUtilsMd5BlockInit(Processor processor) {
        CpuState cpu = processor.cpu;
        int md5CtxAddr = cpu.gpr[4];
        log.info("sceKernelUtilsMd5BlockInit (md5CtxAddr=0x" + Integer.toHexString(md5CtxAddr) + ")");
        this.md5Ctx = new SceKernelUtilsMd5Context();
        this.md5Ctx.init(md5CtxAddr);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1642194213, version=150)
    public void sceKernelUtilsMd5BlockUpdate(Processor processor) {
        CpuState cpu = processor.cpu;
        int md5CtxAddr = cpu.gpr[4];
        int inAddr = cpu.gpr[5];
        int inSize = cpu.gpr[6];
        log.info("sceKernelUtilsMd5BlockUpdate (md5CtxAddr=0x" + Integer.toHexString(md5CtxAddr) + ", inAddr=0x" + Integer.toHexString(inAddr) + ", inSize=" + inSize + ")");
        this.md5Ctx.update(md5CtxAddr, inAddr, inSize);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1194176904, version=150)
    public void sceKernelUtilsMd5BlockResult(Processor processor) {
        CpuState cpu = processor.cpu;
        int md5CtxAddr = cpu.gpr[4];
        int outAddr = cpu.gpr[5];
        log.info("sceKernelUtilsMd5BlockResult (md5CtxAddr=0x" + Integer.toHexString(md5CtxAddr) + ", outAddr=0x" + Integer.toHexString(outAddr) + ")");
        this.md5Ctx.result(md5CtxAddr, outAddr);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-2080220687, version=150)
    public void sceKernelUtilsSha1Digest(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int inAddr = cpu.gpr[4];
        int inSize = cpu.gpr[5];
        int outAddr = cpu.gpr[6];
        log.info("sceKernelUtilsSha1Digest (inAddr=0x" + Integer.toHexString(inAddr) + ", inSize=" + inSize + ", outAddr=0x" + Integer.toHexString(outAddr) + ")");
        byte[] input = new byte[inSize];
        byte[] hash = null;
        if (Memory.isAddressGood(inAddr)) {
            for (int i = 0; i < inSize; ++i) {
                input[i] = (byte)mem.read8(inAddr + i);
            }
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            hash = md.digest(input);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (hash != null && Memory.isAddressGood(outAddr)) {
            for (int i = 0; i < 16; ++i) {
                mem.write8(outAddr + i, hash[i]);
            }
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-117647942, version=150)
    public void sceKernelUtilsSha1BlockInit(Processor processor) {
        CpuState cpu = processor.cpu;
        int sha1CtxAddr = cpu.gpr[4];
        log.info("sceKernelUtilsSha1BlockInit (sha1CtxAddr=0x" + Integer.toHexString(sha1CtxAddr) + ")");
        this.sha1Ctx = new SceKernelUtilsSha1Context();
        this.sha1Ctx.init(sha1CtxAddr);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=879717800, version=150)
    public void sceKernelUtilsSha1BlockUpdate(Processor processor) {
        CpuState cpu = processor.cpu;
        int sha1CtxAddr = cpu.gpr[4];
        int inAddr = cpu.gpr[5];
        int inSize = cpu.gpr[6];
        log.info("sceKernelUtilsSha1BlockUpdate (sha1CtxAddr=0x" + Integer.toHexString(sha1CtxAddr) + ", inAddr=0x" + Integer.toHexString(inAddr) + ", inSize=" + inSize + ")");
        this.sha1Ctx.update(sha1CtxAddr, inAddr, inSize);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1482628105, version=150)
    public void sceKernelUtilsSha1BlockResult(Processor processor) {
        CpuState cpu = processor.cpu;
        int sha1CtxAddr = cpu.gpr[4];
        int outAddr = cpu.gpr[5];
        log.info("sceKernelUtilsSha1BlockResult (sha1CtxAddr=0x" + Integer.toHexString(sha1CtxAddr) + ", outAddr=0x" + Integer.toHexString(outAddr) + ")");
        this.sha1Ctx.result(sha1CtxAddr, outAddr);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-396302498, version=150)
    public void sceKernelUtilsMt19937Init(Processor processor) {
        CpuState cpu = processor.cpu;
        int ctx_addr = cpu.gpr[4];
        int seed = cpu.gpr[5];
        this.Mt19937List.remove(ctx_addr);
        this.Mt19937List.put(ctx_addr, new SceKernelUtilsMt19937Context(seed));
        Memory.getInstance().memset(ctx_addr, (byte)-51, 628);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=117148259, version=150)
    public void sceKernelUtilsMt19937UInt(Processor processor) {
        CpuState cpu = processor.cpu;
        int ctx_addr = cpu.gpr[4];
        SceKernelUtilsMt19937Context ctx = this.Mt19937List.get(ctx_addr);
        if (ctx != null) {
            cpu.gpr[2] = ctx.r.nextInt();
        } else {
            log.warn("sceKernelUtilsMt19937UInt uninitialised context " + Integer.toHexString(ctx_addr));
            Emulator.getProcessor().cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=939220034, version=150)
    public void sceKernelGetGPI(Processor processor) {
        CpuState cpu = processor.cpu;
        if (State.debugger != null) {
            int gpi = State.debugger.GetGPI();
            if (log.isDebugEnabled()) {
                log.debug("sceKernelGetGPI 0x" + String.format("%02X", gpi));
            }
            cpu.gpr[2] = gpi;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("sceKernelGetGPI debugger not enabled");
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=1792230871, version=150)
    public void sceKernelSetGPO(Processor processor) {
        CpuState cpu = processor.cpu;
        int value = cpu.gpr[4];
        if (State.debugger != null) {
            State.debugger.SetGPO(value);
            if (log.isDebugEnabled()) {
                log.debug("sceKernelSetGPO 0x" + String.format("%02X", value));
            }
        } else if (log.isDebugEnabled()) {
            log.debug("sceKernelSetGPO debugger not enabled");
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1847265625, version=150)
    public void sceKernelLibcClock(Processor processor) {
        CpuState cpu = processor.cpu;
        cpu.gpr[2] = (int)SystemTimeManager.getSystemTime();
    }

    @HLEFunction(nid=667703280, version=150)
    public void sceKernelLibcTime(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int time_t_addr = cpu.gpr[4];
        int seconds = (int)(Calendar.getInstance().getTimeInMillis() / 1000L);
        if (Memory.isAddressGood(time_t_addr)) {
            mem.write32(time_t_addr, seconds);
        }
        Emulator.getProcessor().cpu.gpr[2] = seconds;
    }

    @HLEFunction(nid=1911308913, version=150)
    public void sceKernelLibcGettimeofday(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int tp = cpu.gpr[4];
        int tzp = cpu.gpr[5];
        if (Memory.isAddressGood(tp)) {
            Clock.TimeNanos currentTimeNano = Emulator.getClock().currentTimeNanos();
            int tv_sec = currentTimeNano.seconds;
            int tv_usec = currentTimeNano.millis * 1000 + currentTimeNano.micros;
            mem.write32(tp, tv_sec);
            mem.write32(tp + 4, tv_usec);
        }
        if (Memory.isAddressGood(tzp)) {
            int tz_minuteswest = 0;
            int tz_dsttime = 0;
            mem.write32(tzp, tz_minuteswest);
            mem.write32(tzp + 4, tz_dsttime);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=2043790330, version=150)
    public void sceKernelDcacheWritebackAll(Processor processor) {
        Modules.log.trace("IGNORING: sceKernelDcacheWritebackAll");
    }

    @HLEFunction(nid=-1271537979, version=150)
    public void sceKernelDcacheWritebackInvalidateAll(Processor processor) {
        Modules.log.trace("IGNORING: sceKernelDcacheWritebackInvalidateAll");
    }

    @HLEFunction(nid=1055066145, version=150)
    public void sceKernelDcacheWritebackRange(Processor processor) {
        CpuState cpu = processor.cpu;
        int addr = cpu.gpr[4];
        int size = cpu.gpr[5];
        Modules.log.trace("IGNORING: sceKernelDcacheWritebackRange addr=0x" + Integer.toHexString(addr) + ", size=" + size);
    }

    @HLEFunction(nid=884603550, version=150)
    public void sceKernelDcacheWritebackInvalidateRange(Processor processor) {
        CpuState cpu = processor.cpu;
        int addr = cpu.gpr[4];
        int size = cpu.gpr[5];
        Modules.log.trace("IGNORING: sceKernelDcacheWritebackInvalidateRange addr=0x" + Integer.toHexString(addr) + ", size=" + size);
    }

    @HLEFunction(nid=-2147476404, version=150)
    public void sceKernelDcacheProbe(Processor processor) {
        CpuState cpu = processor.cpu;
        int addr = cpu.gpr[4];
        Modules.log.trace("IGNORING: sceKernelDcacheProbe addr=0x" + Integer.toHexString(addr));
        cpu.gpr[2] = 1;
    }

    @HLEFunction(nid=375659888, version=150)
    public void sceKernelDcacheReadTag(Processor processor) {
        CpuState cpu = processor.cpu;
        Modules.log.trace("UNIMPLEMENTED: sceKernelDcacheReadTag");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1844506550, version=150)
    public void sceKernelIcacheInvalidateAll(Processor processor) {
        RuntimeContext.invalidateAll();
        log.info("sceKernelIcacheInvalidateAll");
    }

    @HLEFunction(nid=1339235485, version=150)
    public void sceKernelIcacheProbe(Processor processor) {
        CpuState cpu = processor.cpu;
        int addr = cpu.gpr[4];
        Modules.log.trace("IGNORING: sceKernelIcacheProbe addr=0x" + Integer.toHexString(addr));
        cpu.gpr[2] = 1;
    }

    @HLEFunction(nid=-83494192, version=150)
    public void sceKernelIcacheReadTag(Processor processor) {
        CpuState cpu = processor.cpu;
        Modules.log.trace("UNIMPLEMENTED: sceKernelIcacheReadTag");
        cpu.gpr[2] = -559038242;
    }

    private static class SceKernelUtilsSha1Context {
        private int part1 = 0;
        private int part2 = 0;
        private int part3 = 0;
        private int part4 = 0;
        private int part5 = 0;
        private short tmpBytesRemaining = 0;
        private short tmpBytesCalculated = 0;
        private long fullDataSize = 0L;
        private byte[] buf = new byte[64];
        private byte[] input;

        public void init(int ctx_addr) {
            Memory mem = Memory.getInstance();
            mem.write32(ctx_addr, this.part1);
            mem.write32(ctx_addr + 4, this.part2);
            mem.write32(ctx_addr + 8, this.part3);
            mem.write32(ctx_addr + 12, this.part4);
            mem.write32(ctx_addr + 16, this.part5);
            mem.write16(ctx_addr + 20, this.tmpBytesRemaining);
            mem.write16(ctx_addr + 22, this.tmpBytesCalculated);
            mem.write64(ctx_addr + 24, this.fullDataSize);
            for (int i = 0; i < 64; ++i) {
                mem.write8(ctx_addr + 32 + i, this.buf[i]);
            }
        }

        public void update(int ctx_addr, int data_addr, int data_size) {
            Memory mem = Memory.getInstance();
            this.input = new byte[data_size];
            if (Memory.isAddressGood(data_addr)) {
                for (int i = 0; i < data_size; ++i) {
                    this.input[i] = (byte)mem.read8(data_addr + i);
                }
            }
        }

        public void result(int ctx_addr, int result_addr) {
            Memory mem = Memory.getInstance();
            byte[] hash = null;
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                hash = md.digest(this.input);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (hash != null && Memory.isAddressGood(result_addr)) {
                for (int i = 0; i < 16; ++i) {
                    mem.write8(result_addr + i, hash[i]);
                }
            }
        }
    }

    private static class SceKernelUtilsMd5Context {
        private int part1 = 0;
        private int part2 = 0;
        private int part3 = 0;
        private int part4 = 0;
        private int padding = 0;
        private short tmpBytesRemaining = 0;
        private short tmpBytesCalculated = 0;
        private long fullDataSize = 0L;
        private byte[] buf = new byte[64];
        private byte[] input;

        public void init(int ctx_addr) {
            Memory mem = Memory.getInstance();
            mem.write32(ctx_addr, this.part1);
            mem.write32(ctx_addr + 4, this.part2);
            mem.write32(ctx_addr + 8, this.part3);
            mem.write32(ctx_addr + 12, this.part4);
            mem.write32(ctx_addr + 16, this.padding);
            mem.write16(ctx_addr + 20, this.tmpBytesRemaining);
            mem.write16(ctx_addr + 22, this.tmpBytesCalculated);
            mem.write64(ctx_addr + 24, this.fullDataSize);
            for (int i = 0; i < 64; ++i) {
                mem.write8(ctx_addr + 32 + i, this.buf[i]);
            }
        }

        public void update(int ctx_addr, int data_addr, int data_size) {
            Memory mem = Memory.getInstance();
            this.input = new byte[data_size];
            if (Memory.isAddressGood(data_addr)) {
                for (int i = 0; i < data_size; ++i) {
                    this.input[i] = (byte)mem.read8(data_addr + i);
                }
            }
        }

        public void result(int ctx_addr, int result_addr) {
            Memory mem = Memory.getInstance();
            byte[] hash = null;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                hash = md.digest(this.input);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (hash != null && Memory.isAddressGood(result_addr)) {
                for (int i = 0; i < 16; ++i) {
                    mem.write8(result_addr + i, hash[i]);
                }
            }
        }
    }

    private static class SceKernelUtilsMt19937Context {
        private Random r;

        public SceKernelUtilsMt19937Context(int seed) {
            this.r = new Random(seed);
        }
    }
}

