/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.util.LinkedList;
import java.util.List;
import jpcsp.Allegrex.CpuState;
import jpcsp.Controller;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.managers.SystemTimeManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.State;
import org.apache.log4j.Logger;

public class sceCtrl
extends HLEModule {
    private static Logger log = Modules.getLogger("sceCtrl");
    private int cycle;
    private int mode;
    private int uiMake;
    private int uiBreak;
    private int uiPress;
    private int uiRelease;
    private int TimeStamp;
    private byte Lx;
    private byte Ly;
    private int Buttons;
    private int idlereset;
    private int idleback;
    public static final int PSP_CTRL_SELECT = 1;
    public static final int PSP_CTRL_START = 8;
    public static final int PSP_CTRL_UP = 16;
    public static final int PSP_CTRL_RIGHT = 32;
    public static final int PSP_CTRL_DOWN = 64;
    public static final int PSP_CTRL_LEFT = 128;
    public static final int PSP_CTRL_LTRIGGER = 256;
    public static final int PSP_CTRL_RTRIGGER = 512;
    public static final int PSP_CTRL_TRIANGLE = 4096;
    public static final int PSP_CTRL_CIRCLE = 8192;
    public static final int PSP_CTRL_CROSS = 16384;
    public static final int PSP_CTRL_SQUARE = 32768;
    public static final int PSP_CTRL_HOME = 65536;
    public static final int PSP_CTRL_HOLD = 131072;
    public static final int PSP_CTRL_NOTE = 0x800000;
    public static final int PSP_CTRL_SCREEN = 0x400000;
    public static final int PSP_CTRL_VOLUP = 0x100000;
    public static final int PSP_CTRL_VOLDOWN = 0x200000;
    public static final int PSP_CTRL_WLAN_UP = 262144;
    public static final int PSP_CTRL_REMOTE = 524288;
    public static final int PSP_CTRL_DISC = 0x1000000;
    public static final int PSP_CTRL_MS = 0x2000000;
    public static final int PSP_CTRL_MODE_DIGITAL = 0;
    public static final int PSP_CTRL_MODE_ANALOG = 1;
    protected IAction sampleAction = null;
    protected Sample[] samples;
    protected int currentSamplingIndex;
    protected int currentReadingIndex;
    protected int latchSamplingCount;
    protected static final int SAMPLE_BUFFER_SIZE = 64;
    protected List<ThreadWaitingForSampling> threadsWaitingForSampling;

    public boolean isModeDigital() {
        return this.mode == 0;
    }

    private void setButtons(byte Lx, byte Ly, int Buttons) {
        int oldButtons = this.Buttons;
        this.TimeStamp = (int)SystemTimeManager.getSystemTime() & Integer.MAX_VALUE;
        this.Lx = Lx;
        this.Ly = Ly;
        this.Buttons = Buttons;
        if (this.isModeDigital()) {
            this.Lx = (byte)-128;
            this.Ly = (byte)-128;
        }
        int changed = oldButtons ^ Buttons;
        this.uiMake = Buttons & changed;
        this.uiBreak = oldButtons & changed;
        this.uiPress = Buttons;
        this.uiRelease = oldButtons - Buttons & changed;
    }

    @Override
    public String getName() {
        return "sceCtrl";
    }

    @Override
    public void start() {
        this.uiMake = 0;
        this.uiBreak = 0;
        this.uiPress = 0;
        this.uiRelease = ~this.uiPress;
        this.Lx = (byte)-128;
        this.Ly = (byte)-128;
        this.Buttons = 0;
        this.idlereset = -1;
        this.idleback = -1;
        this.mode = 0;
        this.cycle = 0;
        this.samples = new Sample[65];
        for (int i = 0; i < this.samples.length; ++i) {
            this.samples[i] = new Sample();
        }
        this.currentSamplingIndex = 0;
        this.currentReadingIndex = 0;
        this.latchSamplingCount = 0;
        this.threadsWaitingForSampling = new LinkedList<ThreadWaitingForSampling>();
        if (this.sampleAction == null) {
            this.sampleAction = new SamplingAction();
            Managers.intr.addVBlankAction(this.sampleAction);
        }
        super.start();
    }

    protected int incrementSampleIndex(int index, int count) {
        if ((index += count) >= this.samples.length) {
            index -= this.samples.length;
        } else if (index < 0) {
            index += this.samples.length;
        }
        return index;
    }

    protected int incrementSampleIndex(int index) {
        return this.incrementSampleIndex(index, 1);
    }

    protected int getNumberOfAvailableSamples() {
        int n = this.currentSamplingIndex - this.currentReadingIndex;
        if (n < 0) {
            n += this.samples.length;
        }
        return n;
    }

    protected void hleCtrlExecuteSampling() {
        if (log.isDebugEnabled()) {
            log.debug("hleCtrlExecuteSampling");
        }
        Controller controller = State.controller;
        controller.hleControllerPoll();
        this.setButtons(controller.getLx(), controller.getLy(), controller.getButtons());
        ++this.latchSamplingCount;
        Sample currentSampling = this.samples[this.currentSamplingIndex];
        currentSampling.TimeStamp = this.TimeStamp;
        currentSampling.Lx = this.Lx;
        currentSampling.Ly = this.Ly;
        currentSampling.Buttons = this.Buttons;
        this.currentSamplingIndex = this.incrementSampleIndex(this.currentSamplingIndex);
        if (this.currentSamplingIndex == this.currentReadingIndex) {
            this.currentReadingIndex = this.incrementSampleIndex(this.currentReadingIndex);
        }
        while (!this.threadsWaitingForSampling.isEmpty()) {
            ThreadWaitingForSampling wait = this.threadsWaitingForSampling.remove(0);
            if (Modules.ThreadManForUserModule.isThreadBlocked(wait.thread)) {
                if (log.isDebugEnabled()) {
                    log.debug("hleExecuteSampling waiting up thread " + wait.thread);
                }
                this.hleCtrlReadBufferImmediately(wait.thread.cpuContext, wait.readAddr, wait.readCount, wait.readPositive, false);
                Modules.ThreadManForUserModule.hleUnblockThread(wait.thread.uid);
                break;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("hleExecuteSampling thread " + wait.thread + " was no longer blocked");
        }
    }

    protected void hleCtrlReadBufferImmediately(CpuState cpu, int addr, int count, boolean positive, boolean peek) {
        int readIndex;
        Memory mem = Memory.getInstance();
        int available = this.getNumberOfAvailableSamples();
        if (available > count) {
            readIndex = this.incrementSampleIndex(this.currentSamplingIndex, -count);
        } else {
            count = available;
            readIndex = this.currentReadingIndex;
        }
        if (!peek) {
            this.currentReadingIndex = this.currentSamplingIndex;
        }
        for (int ctrlCount = 0; ctrlCount < count; ++ctrlCount) {
            addr = this.samples[readIndex].write(mem, addr, positive);
            readIndex = this.incrementSampleIndex(readIndex);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("hleCtrlReadBufferImmediately(positive=%b, peek=%b) returning %d", positive, peek, count));
        }
        cpu.gpr[2] = count;
    }

    protected void hleCtrlReadBuffer(int addr, int count, boolean positive) {
        if (this.getNumberOfAvailableSamples() > 0) {
            this.hleCtrlReadBufferImmediately(Emulator.getProcessor().cpu, addr, count, positive, false);
        } else {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            ThreadWaitingForSampling threadWaitingForSampling = new ThreadWaitingForSampling(currentThread, addr, count, positive);
            this.threadsWaitingForSampling.add(threadWaitingForSampling);
            threadMan.hleBlockCurrentThread();
            if (log.isDebugEnabled()) {
                log.debug("hleCtrlReadBuffer waiting for sample");
            }
        }
    }

    @HLEFunction(nid=1780970739, version=150, checkInsideInterrupt=true)
    public int sceCtrlSetSamplingCycle(int newCycle) {
        int oldCycle = this.cycle;
        this.cycle = newCycle;
        if (log.isDebugEnabled()) {
            log.debug("sceCtrlSetSamplingCycle(cycle=" + newCycle + ") returning " + oldCycle);
        }
        return oldCycle;
    }

    @HLEFunction(nid=45788561, version=150, checkInsideInterrupt=true)
    public int sceCtrlGetSamplingCycle(int cycleAddr) {
        Processor.memory.write32(cycleAddr, this.cycle);
        return 0;
    }

    @HLEFunction(nid=524292582, version=150, checkInsideInterrupt=true)
    public int sceCtrlSetSamplingMode(int newMode) {
        int oldMode = this.mode;
        this.mode = newMode;
        if (log.isDebugEnabled()) {
            log.debug("sceCtrlSetSamplingMode(mode=" + newMode + ") returning " + oldMode);
        }
        return oldMode;
    }

    @HLEFunction(nid=-630491487, version=150)
    public int sceCtrlGetSamplingMode(int modeAddr) {
        Processor.memory.write32(modeAddr, this.mode);
        return 0;
    }

    @HLEFunction(nid=979510608, version=150)
    public void sceCtrlPeekBufferPositive(Processor processor, int data_addr, int numBuf) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceCtrlPeekBufferPositive(0x%08X, %d)", data_addr, numBuf));
        }
        this.hleCtrlReadBufferImmediately(processor.cpu, data_addr, numBuf, true, true);
    }

    @HLEFunction(nid=-1051588598, version=150)
    public void sceCtrlPeekBufferNegative(Processor processor, int data_addr, int numBuf) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceCtrlPeekBufferNegative(0x%08X, %d)", data_addr, numBuf));
        }
        this.hleCtrlReadBufferImmediately(processor.cpu, data_addr, numBuf, false, true);
    }

    @HLEFunction(nid=528496952, version=150, checkInsideInterrupt=true)
    public void sceCtrlReadBufferPositive(int data_addr, int numBuf) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceCtrlReadBufferPositive(0x%08X, %d)", data_addr, numBuf));
        }
        this.hleCtrlReadBuffer(data_addr, numBuf, true);
    }

    @HLEFunction(nid=1622679430, version=150, checkInsideInterrupt=true)
    public void sceCtrlReadBufferNegative(int data_addr, int numBuf) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceCtrlReadBufferNegative(0x%08X, %d)", data_addr, numBuf));
        }
        this.hleCtrlReadBuffer(data_addr, numBuf, false);
    }

    @HLEFunction(nid=-1311709747, version=150)
    public int sceCtrlPeekLatch(int latch_addr) {
        Memory mem = Processor.memory;
        mem.write32(latch_addr, this.uiMake);
        mem.write32(latch_addr + 4, this.uiBreak);
        mem.write32(latch_addr + 8, this.uiPress);
        mem.write32(latch_addr + 12, this.uiRelease);
        return this.latchSamplingCount;
    }

    @HLEFunction(nid=190350593, version=150)
    public int sceCtrlReadLatch(int latch_addr) {
        Memory mem = Processor.memory;
        mem.write32(latch_addr, this.uiMake);
        mem.write32(latch_addr + 4, this.uiBreak);
        mem.write32(latch_addr + 8, this.uiPress);
        mem.write32(latch_addr + 12, this.uiRelease);
        int prevLatchSamplingCount = this.latchSamplingCount;
        this.latchSamplingCount = 0;
        return prevLatchSamplingCount;
    }

    @HLEFunction(nid=-1491843072, version=150)
    public int sceCtrlSetIdleCancelThreshold(int idlereset, int idleback) {
        this.idlereset = idlereset;
        this.idleback = idleback;
        log.debug("sceCtrlSetIdleCancelThreshold(idlereset=" + idlereset + ",idleback=" + idleback + ")");
        return 0;
    }

    @HLEFunction(nid=1752588538, version=150)
    public int sceCtrlGetIdleCancelThreshold(int idlereset_addr, int idleback_addr) {
        log.debug("sceCtrlGetIdleCancelThreshold(idlereset=0x" + Integer.toHexString(idlereset_addr) + ",idleback=0x" + Integer.toHexString(idleback_addr) + ")" + " returning idlereset=" + this.idlereset + " idleback=" + this.idleback);
        if (Memory.isAddressGood(idlereset_addr)) {
            Processor.memory.write32(idlereset_addr, this.idlereset);
        }
        if (Memory.isAddressGood(idleback_addr)) {
            Processor.memory.write32(idleback_addr, this.idleback);
        }
        return 0;
    }

    @HLEFunction(nid=881695188, version=150)
    @HLEUnimplemented
    public int sceCtrl_348D99D4() {
        return -559038242;
    }

    @HLEFunction(nid=-1353096973, version=150)
    @HLEUnimplemented
    public int sceCtrl_AF5960F3() {
        return -559038242;
    }

    @HLEFunction(nid=-1500523936, version=150)
    @HLEUnimplemented
    public int sceCtrlClearRapidFire() {
        return -559038242;
    }

    @HLEFunction(nid=1749138970, version=150)
    @HLEUnimplemented
    public int sceCtrlSetRapidFire() {
        return -559038242;
    }

    protected static class Sample {
        public int TimeStamp;
        public byte Lx;
        public byte Ly;
        public int Buttons;

        protected Sample() {
        }

        public int write(Memory mem, int addr, boolean positive) {
            mem.write32(addr, this.TimeStamp);
            mem.write32(addr + 4, positive ? this.Buttons : ~this.Buttons);
            mem.write8(addr + 8, this.Lx);
            mem.write8(addr + 9, this.Ly);
            return addr + 16;
        }

        public String toString() {
            return String.format("TimeStamp=%d,Lx=%d,Ly=%d,Buttons=%08X", this.TimeStamp, this.Lx, this.Ly, this.Buttons);
        }
    }

    protected static class ThreadWaitingForSampling {
        SceKernelThreadInfo thread;
        int readAddr;
        int readCount;
        boolean readPositive;

        public ThreadWaitingForSampling(SceKernelThreadInfo thread, int readAddr, int readCount, boolean readPositive) {
            this.thread = thread;
            this.readAddr = readAddr;
            this.readCount = readCount;
            this.readPositive = readPositive;
        }
    }

    protected class SamplingAction
    implements IAction {
        protected SamplingAction() {
        }

        @Override
        public void execute() {
            sceCtrl.this.hleCtrlExecuteSampling();
        }
    }
}

