/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import org.apache.log4j.Logger;

public class sceHprm
extends HLEModule {
    private static Logger log = Modules.getLogger("sceHprm");
    private boolean enableRemote = false;
    private boolean enableHeadphone = false;
    private boolean enableMicrophone = false;
    private boolean hprmWarningLogged;

    @Override
    public String getName() {
        return "sceHprm";
    }

    @Override
    public void start() {
        this.hprmWarningLogged = false;
        super.start();
    }

    @HLEFunction(nid=-954908362, version=150)
    public void sceHprmRegisterCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceHprmRegisterCallback [0xC7154136]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1146015927, version=150)
    public void sceHprmUnregisterCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceHprmUnregisterCallback [0x444ED0B7]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1907751783, version=150)
    public void sceHprmGetHpDetect(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceHprmGetHpDetect [0x71B5FB67]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=546156989, version=150)
    public void sceHprmIsRemoteExist(Processor processor) {
        CpuState cpu = processor.cpu;
        int result = this.enableRemote ? 1 : 0;
        log.debug("sceHprmIsRemoteExist ret:" + result);
        cpu.gpr[2] = result;
    }

    @HLEFunction(nid=2120871332, version=150)
    public void sceHprmIsHeadphoneExist(Processor processor) {
        CpuState cpu = processor.cpu;
        int result = this.enableHeadphone ? 1 : 0;
        log.debug("sceHprmIsHeadphoneExist ret:" + result);
        cpu.gpr[2] = result;
    }

    @HLEFunction(nid=563894513, version=150)
    public void sceHprmIsMicrophoneExist(Processor processor) {
        CpuState cpu = processor.cpu;
        int result = this.enableMicrophone ? 1 : 0;
        log.debug("sceHprmIsMicrophoneExist ret:" + result);
        cpu.gpr[2] = result;
    }

    @HLEFunction(nid=420524839, version=150)
    public void sceHprmPeekCurrentKey(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int key_addr = cpu.gpr[4];
        if (Memory.isAddressGood(key_addr)) {
            if (this.hprmWarningLogged) {
                if (log.isDebugEnabled()) {
                    log.debug("IGNORING: sceHprmPeekCurrentKey(key_addr=0x" + Integer.toHexString(key_addr) + ")");
                }
            } else {
                log.warn("IGNORING: sceHprmPeekCurrentKey(key_addr=0x" + Integer.toHexString(key_addr) + ") future calls will only appear in TRACE log");
                this.hprmWarningLogged = true;
            }
            mem.write32(key_addr, 0);
            cpu.gpr[2] = 0;
        } else {
            log.warn("sceHprmPeekCurrentKey(key_addr=0x" + Integer.toHexString(key_addr) + ") invalid address");
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=734971966, version=150)
    public void sceHprmPeekLatch(Processor processor) {
        CpuState cpu = processor.cpu;
        int latchAddr = cpu.gpr[4];
        if (this.hprmWarningLogged) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("IGNORING: sceHprmPeekLatch 0x%08X", latchAddr));
            }
        } else {
            log.warn(String.format("IGNORING: sceHprmPeekLatch 0x%08X", latchAddr));
            this.hprmWarningLogged = true;
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1087568368, version=150)
    public void sceHprmReadLatch(Processor processor) {
        CpuState cpu = processor.cpu;
        int latchAddr = cpu.gpr[4];
        if (this.hprmWarningLogged) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("IGNORING: sceHprmReadLatch 0x%08X", latchAddr));
            }
        } else {
            log.warn(String.format("IGNORING: sceHprmReadLatch 0x%08X", latchAddr));
            this.hprmWarningLogged = true;
        }
        cpu.gpr[2] = 0;
    }
}

